/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation;

import com.webobjects.foundation.NSMutableRange;
import com.webobjects.foundation._NSUtilities;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.ObjectStreamField;
import java.io.Serializable;

public class NSRange
implements Serializable,
Cloneable {
    public static final Class _CLASS = _NSUtilities._classWithFullySpecifiedName("com.webobjects.foundation.NSRange");
    static final long serialVersionUID = 850781217118960855L;
    private static final String SerializationLocationFieldKey = "location";
    private static final String SerializationLengthFieldKey = "length";
    public static final NSRange ZeroRange = new NSRange();
    protected int _location = 0;
    protected int _length = 0;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("location", Integer.TYPE), new ObjectStreamField("length", Integer.TYPE)};

    public static NSRange fromString(String string) {
        int index3;
        int index2;
        int index1;
        int count = string.length();
        if (count < 5) {
            throw new IllegalArgumentException("Improperly formatted string");
        }
        char[] chars = new char[count];
        string.getChars(0, count, chars, 0);
        for (index1 = 0; index1 < count && chars[index1] != '{'; ++index1) {
        }
        if (index1 == count) {
            throw new IllegalArgumentException("Improperly formatted string");
        }
        for (index2 = index1; index2 < count && chars[index2] != ','; ++index2) {
        }
        if (index2 == count) {
            throw new IllegalArgumentException("Improperly formatted string");
        }
        for (index3 = index2; index3 < count && chars[index3] != '}'; ++index3) {
        }
        if (index3 == count || index2 <= index1 + 1 || index3 <= index2 + 1) {
            throw new IllegalArgumentException("Improperly formatted string");
        }
        int location = new Integer(string.substring(index1 + 1, index2).trim());
        int length = new Integer(string.substring(index2 + 1, index3).trim());
        return new NSRange(location, length);
    }

    public NSRange() {
        this(0, 0, false);
    }

    private NSRange(int location, int length, boolean checkValues) {
        if (checkValues) {
            if (location < 0) {
                throw new IllegalArgumentException("Cannot create an" + this.getClass().getName() + " with negative location.");
            }
            if (length < 0) {
                throw new IllegalArgumentException("Cannot create an" + this.getClass().getName() + " with negative length.");
            }
            if (location - 1 > Integer.MAX_VALUE - length) {
                throw new IllegalArgumentException("Range endpoint greater than Integer.MAX_VALUE");
            }
        }
        this._location = location;
        this._length = length;
    }

    public NSRange(int location, int length) {
        this(location, length, true);
    }

    public NSRange(NSRange range) {
        this(range != null ? range.location() : 0, range != null ? range.length() : 0, false);
    }

    public int location() {
        return this._location;
    }

    public int length() {
        return this._length;
    }

    public NSRange rangeByUnioningRange(NSRange otherRange) {
        NSMutableRange range = new NSMutableRange(this);
        range.unionRange(otherRange);
        return range;
    }

    public NSRange rangeByIntersectingRange(NSRange otherRange) {
        NSMutableRange range = new NSMutableRange(this);
        range.intersectRange(otherRange);
        return range;
    }

    public void subtractRange(NSRange otherRange, NSMutableRange resultRange1, NSMutableRange resultRange2) {
        int location1;
        int length1;
        int location2;
        int length2;
        if (otherRange != null) {
            int location = this.location();
            int maxRange = this.maxRange();
            int otherLocation = otherRange.location();
            int otherMaxRange = otherRange.maxRange();
            if (otherMaxRange <= location || maxRange <= otherLocation) {
                length2 = 0;
                location2 = 0;
                length1 = 0;
                location1 = 0;
            } else if (otherLocation <= location) {
                location1 = otherMaxRange;
                length1 = maxRange <= otherMaxRange ? 0 : maxRange - otherMaxRange;
                length2 = 0;
                location2 = 0;
            } else if (maxRange <= otherMaxRange) {
                location1 = location;
                length1 = otherLocation - location;
                length2 = 0;
                location2 = 0;
            } else {
                location1 = location;
                length1 = otherLocation - location;
                location2 = otherMaxRange;
                length2 = maxRange - otherMaxRange;
            }
        } else {
            length2 = 0;
            location2 = 0;
            length1 = 0;
            location1 = 0;
        }
        if (resultRange1 != null) {
            resultRange1.setLocation(location1);
            resultRange1.setLength(length1);
        }
        if (resultRange2 != null) {
            resultRange2.setLocation(location2);
            resultRange2.setLength(length2);
        }
    }

    public int maxRange() {
        return this.location() + this.length();
    }

    public boolean isEmpty() {
        return this.length() == 0;
    }

    public boolean containsLocation(int location) {
        int compareLocation = this.location();
        return compareLocation <= location && location - this.length() < compareLocation;
    }

    public boolean locationInRange(int location) {
        return this.containsLocation(location);
    }

    public boolean intersectsRange(NSRange otherRange) {
        if (otherRange != null) {
            int location = this.location();
            int otherLocation = otherRange.location();
            return location - otherRange.length() < otherLocation && otherLocation - this.length() < location;
        }
        return false;
    }

    public boolean isSubrangeOfRange(NSRange otherRange) {
        if (otherRange != null) {
            int location = this.location();
            int otherLocation = otherRange.location();
            return otherLocation <= location && location - 1 + this.length() <= otherLocation - 1 + otherRange.length();
        }
        return false;
    }

    public boolean isEqualToRange(NSRange otherRange) {
        if (otherRange == null) {
            return false;
        }
        if (otherRange == this) {
            return true;
        }
        return this.location() == otherRange.location() && this.length() == otherRange.length();
    }

    public boolean equals(Object object) {
        return object instanceof NSRange ? this.isEqualToRange((NSRange)object) : false;
    }

    public int hashCode() {
        return this.location() ^ this.length();
    }

    public Object clone() {
        return this;
    }

    public String toString() {
        return "{" + this.location() + ", " + this.length() + "}";
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        ObjectOutputStream.PutField fields = s.putFields();
        fields.put(SerializationLocationFieldKey, this._location);
        fields.put(SerializationLengthFieldKey, this._length);
        s.writeFields();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = null;
        fields = s.readFields();
        this._location = fields.get(SerializationLocationFieldKey, 0);
        this._length = fields.get(SerializationLengthFieldKey, 0);
    }

    private Object readResolve() throws ObjectStreamException {
        if (this.getClass() == _CLASS && this.length() == 0 && this.location() == 0) {
            return ZeroRange;
        }
        return this;
    }
}

