/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation._NSUtilities;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.net.URL;

public final class _NSStringUtilities {
    public static final String UTF8_ENCODING = "UTF-8";
    public static final String UTF16_ENCODING = "UTF-16";
    public static final String ASCII_ENCODING = "US-ASCII";
    public static final String ISOLATIN1_ENCODING = "ISO-8859-1";
    private static final String WO_DEFAULT_ENCODING;
    private static String _encoding;
    private static final int _MatchState = 0;
    private static final int _MatchStarState = 1;
    private static final int Finished = 2;

    public static void setDefaultEncoding(String encoding) throws UnsupportedEncodingException {
        if (encoding == null) {
            _encoding = WO_DEFAULT_ENCODING;
        } else {
            String testText = "test";
            byte[] testBytes = testText.getBytes(encoding);
            _encoding = encoding;
        }
    }

    public static String defaultEncoding() {
        return _encoding;
    }

    public static int integerFromPlist(NSDictionary plist, String key, int defaultValue) {
        int result = defaultValue;
        Object num = plist.objectForKey(key);
        if (num != null) {
            result = num instanceof Number ? ((Number)num).intValue() : Integer.parseInt(num.toString());
        }
        return result;
    }

    public static String stringFromBuffer(StringBuffer buffer) {
        int len = buffer.length();
        if (len == 0) {
            return "";
        }
        char[] contents = new char[len];
        buffer.getChars(0, len, contents, 0);
        return new String(contents);
    }

    public static final String stringForBytes(byte[] data, int offset, int length, String encoding) {
        if (encoding == null) {
            encoding = _NSStringUtilities.defaultEncoding();
        }
        if (encoding == null) {
            return new String(data, offset, length);
        }
        try {
            return data != null ? new String(data, offset, length, encoding) : null;
        }
        catch (UnsupportedEncodingException e) {
            throw NSForwardException._runtimeExceptionForThrowable(e);
        }
    }

    public static final byte[] bytesForString(String text, String encoding) {
        if (encoding == null) {
            encoding = _NSStringUtilities.defaultEncoding();
        }
        if (encoding == null) {
            return text.getBytes();
        }
        try {
            return text != null ? text.getBytes(encoding) : null;
        }
        catch (UnsupportedEncodingException e) {
            throw NSForwardException._runtimeExceptionForThrowable(e);
        }
    }

    public static final String stringForBytes(byte[] data, String encoding) {
        return data != null ? _NSStringUtilities.stringForBytes(data, 0, data.length, encoding) : null;
    }

    public static final String stringForBytes(byte[] data) {
        return _NSStringUtilities.stringForBytes(data, _NSStringUtilities.defaultEncoding());
    }

    public static final byte[] bytesForString(String text) {
        return _NSStringUtilities.bytesForString(text, _NSStringUtilities.defaultEncoding());
    }

    public static final String asciiStringForBytes(byte[] data) {
        return _NSStringUtilities.stringForBytes(data, ASCII_ENCODING);
    }

    public static final byte[] bytesForAsciiString(String text) {
        return _NSStringUtilities.bytesForString(text, ASCII_ENCODING);
    }

    public static final String isolatinStringForBytes(byte[] data) {
        return _NSStringUtilities.stringForBytes(data, ISOLATIN1_ENCODING);
    }

    public static final byte[] bytesForIsolatinString(String text) {
        return _NSStringUtilities.bytesForString(text, ISOLATIN1_ENCODING);
    }

    public static final String dotifyPath(String path1, String path2) {
        return _NSStringUtilities.concat(path1, ".", path2);
    }

    public static final String concat(String s1, String s2) {
        return s1.concat(s2);
    }

    public static final String concat(String s1, String s2, String s3) {
        StringBuffer buffer = new StringBuffer(s1.length() + s2.length() + s3.length());
        return new String(buffer.append(s1).append(s2).append(s3));
    }

    public static final String concat(String s1, String s2, String s3, String s4) {
        StringBuffer buffer = new StringBuffer(s1.length() + s2.length() + s3.length() + s4.length());
        return new String(buffer.append(s1).append(s2).append(s3).append(s4));
    }

    public static final String concat(String s1, String s2, String s3, String s4, String s5) {
        StringBuffer buffer = new StringBuffer(s1.length() + s2.length() + s3.length() + s4.length() + s5.length());
        return new String(buffer.append(s1).append(s2).append(s3).append(s4).append(s5));
    }

    public static final String concat(String s1, String s2, String s3, String s4, String s5, String s6) {
        StringBuffer buffer = new StringBuffer(s1.length() + s2.length() + s3.length() + s4.length() + s5.length() + s6.length());
        return new String(buffer.append(s1).append(s2).append(s3).append(s4).append(s5).append(s6));
    }

    public static final String concat(String s1, String s2, String s3, String s4, String s5, String s6, String s7) {
        StringBuffer buffer = new StringBuffer(s1.length() + s2.length() + s3.length() + s4.length() + s5.length() + s6.length() + s7.length());
        return new String(buffer.append(s1).append(s2).append(s3).append(s4).append(s5).append(s6).append(s7));
    }

    public static final String concat(String s1, String s2, String s3, String s4, String s5, String s6, String s7, String s8) {
        StringBuffer buffer = new StringBuffer(s1.length() + s2.length() + s3.length() + s4.length() + s5.length() + s6.length() + s7.length() + s8.length());
        return new String(buffer.append(s1).append(s2).append(s3).append(s4).append(s5).append(s6).append(s7).append(s8));
    }

    public static final String concat(String s1, String s2, String s3, String s4, String s5, String s6, String s7, String s8, String s9) {
        StringBuffer buffer = new StringBuffer(s1.length() + s2.length() + s3.length() + s4.length() + s5.length() + s6.length() + s7.length() + s8.length() + s9.length());
        return new String(buffer.append(s1).append(s2).append(s3).append(s4).append(s5).append(s6).append(s7).append(s8).append(s9));
    }

    public static final String concat(String s1, String s2, String s3, String s4, String s5, String s6, String s7, String s8, String s9, String s10) {
        StringBuffer buffer = new StringBuffer(s1.length() + s2.length() + s3.length() + s4.length() + s5.length() + s6.length() + s7.length() + s8.length() + s9.length() + s10.length());
        return new String(buffer.append(s1).append(s2).append(s3).append(s4).append(s5).append(s6).append(s7).append(s8).append(s9).append(s10));
    }

    public static String stringMarkingUpcaseTransitionsWithDelimiter(String self, String delimiter) {
        int len = self.length();
        int sepLen = delimiter.length();
        int outlen = 0;
        boolean lastWasLower = false;
        char[] inbuf = new char[len + 1];
        char[] outbuf = new char[len * 2 + 1];
        self.getChars(0, len, inbuf, 0);
        for (int i = 0; i < len; ++i) {
            char c = inbuf[i];
            if (Character.isUpperCase(c)) {
                if (lastWasLower && i != 0) {
                    delimiter.getChars(0, sepLen, outbuf, outlen);
                    outlen += sepLen;
                }
                lastWasLower = false;
            } else {
                lastWasLower = true;
            }
            outbuf[outlen++] = c;
        }
        String result = new String(outbuf, 0, outlen);
        return result;
    }

    public static String stringRepeatedTimes(String string, int count) {
        StringBuffer buffer = new StringBuffer(string.length() * count);
        while (count-- != 0) {
            buffer.append(string);
        }
        return new String(buffer);
    }

    public static String quotedStringWithQuote(String string, char quoteCharacter) {
        char escapeCharacter = '\\';
        int count = string != null ? string.length() : 0;
        StringBuffer buffer = new StringBuffer(count + 8);
        buffer.append(quoteCharacter);
        for (int i = 0; i < count; ++i) {
            char character = string.charAt(i);
            if (character == quoteCharacter || character == escapeCharacter) {
                buffer.append(escapeCharacter);
            }
            buffer.append(character);
        }
        buffer.append(quoteCharacter);
        return new String(buffer);
    }

    public static String capitalizedStringAsWord(String string) {
        int iCount = string.length();
        if (iCount == 0) {
            return string;
        }
        char[] valueAsChar = string.toCharArray();
        valueAsChar[0] = Character.toUpperCase(valueAsChar[0]);
        for (int i = 1; i < iCount; ++i) {
            valueAsChar[i] = Character.toLowerCase(valueAsChar[i]);
        }
        return new String(valueAsChar);
    }

    public static String capitalizedString(String string) {
        char character;
        int length;
        if (string != null && (length = string.length()) > 0 && !Character.isUpperCase(character = string.charAt(0))) {
            StringBuffer buffer = new StringBuffer(string.length());
            buffer.append(Character.toUpperCase(character));
            if (length > 1) {
                buffer.append(string.substring(1));
            }
            string = new String(buffer);
        }
        return string;
    }

    public static String capitalizedStringWithPrefix(String string, String prefix) {
        if (string == null) {
            return prefix;
        }
        if (prefix == null) {
            return _NSStringUtilities.capitalizedString(string);
        }
        int length = string.length();
        StringBuffer buffer = new StringBuffer(prefix.length() + length);
        buffer.append(prefix);
        if (length > 0) {
            buffer.append(Character.toUpperCase(string.charAt(0)));
            if (length > 1) {
                buffer.append(string.substring(1));
            }
        }
        return new String(buffer);
    }

    public static String deleteAllInstancesOfString(String inString, String toBeDeleted) {
        return _NSStringUtilities.replaceAllInstancesOfString(inString, toBeDeleted, "");
    }

    public static String replaceAllInstancesOfString(String inString, String searchString, String replaceString) {
        char[] temp = null;
        StringBuffer result = null;
        int index = 0;
        int previous = 0;
        int increment = searchString.length();
        while ((index = inString.indexOf(searchString, index)) != -1) {
            if (result == null) {
                result = new StringBuffer(inString.length());
                temp = inString.toCharArray();
            }
            if (index > previous) {
                result.append(temp, previous, index - previous);
            }
            if (replaceString.length() > 0) {
                result.append(replaceString);
            }
            previous = index += increment;
        }
        if (result == null) {
            return inString;
        }
        if (temp.length > previous) {
            result.append(temp, previous, temp.length - previous);
        }
        return new String(result);
    }

    public static boolean isNumber(String string) {
        int length = string.length();
        if (length == 0) {
            return false;
        }
        boolean dot = false;
        int i = 0;
        char character = string.charAt(0);
        if (character == '-' || character == '+') {
            i = 1;
        } else if (character == '.') {
            i = 1;
            dot = true;
        }
        while (i < length) {
            if ((character = string.charAt(i++)) == '.') {
                if (dot) {
                    return false;
                }
                dot = true;
                continue;
            }
            if (Character.isDigit(character)) continue;
            return false;
        }
        return true;
    }

    public static String lastComponentInString(String text, char componentSeparator) {
        return _NSStringUtilities.lastComponentInString(text, componentSeparator, text);
    }

    public static String lastComponentInString(String string, char componentSeparator, String defaultString) {
        if (string != null) {
            int index = string.lastIndexOf(componentSeparator);
            if (index >= 0) {
                return index < string.length() - 1 ? string.substring(index + 1) : "";
            }
            return string;
        }
        return defaultString;
    }

    public static String stringByDeletingLastComponent(String string, char componentSeparator) {
        if (string != null) {
            int index = string.lastIndexOf(componentSeparator);
            return index >= 0 ? string.substring(0, index) : "";
        }
        return null;
    }

    public static boolean containsOnlyWhiteSpace(String string) {
        return string.trim().length() == 0;
    }

    public static void appendToFile(File file, String content) {
        RandomAccessFile target = null;
        try {
            target = new RandomAccessFile(file, "rw");
            long fileLength = target.length();
            target.seek(fileLength);
            byte[] newData = _NSStringUtilities.bytesForString(content);
            target.write(newData, 0, newData.length);
            target.close();
            target = null;
        }
        catch (IOException ex) {
            throw NSForwardException._runtimeExceptionForThrowable(ex);
        }
        finally {
            block11: {
                try {
                    if (target != null) {
                        target.close();
                    }
                }
                catch (Throwable t) {
                    if (!NSLog.debugLoggingAllowedForLevelAndGroups(2, 8192L)) break block11;
                    NSLog.debug.appendln("Exception while closing file output stream: " + t.getMessage());
                    NSLog.debug.appendln(t);
                }
            }
            target = null;
            Object newData = null;
        }
    }

    public static void writeToFile(File file, String content) {
        FileOutputStream s = null;
        try {
            s = new FileOutputStream(file);
            s.write(_NSStringUtilities.bytesForString(content));
            s.flush();
        }
        catch (IOException e) {
            throw NSForwardException._runtimeExceptionForThrowable(e);
        }
        finally {
            if (s != null) {
                block11: {
                    try {
                        s.close();
                    }
                    catch (IOException ex) {
                        if (!NSLog.debugLoggingAllowedForLevelAndGroups(2, 8192L)) break block11;
                        NSLog.debug.appendln("Exception while closing file output stream: " + ex.getMessage());
                        NSLog.debug.appendln(ex);
                    }
                }
                s = null;
            }
        }
    }

    public static String stringFromFile(String path) {
        return _NSStringUtilities.stringFromFile(path, null);
    }

    public static String stringFromFile(String path, String encoding) {
        File file = new File(path);
        return _NSStringUtilities.stringFromFile(file, encoding);
    }

    public static String stringFromFile(File f) {
        return _NSStringUtilities.stringFromFile(f, null);
    }

    public static String stringFromFile(File f, String encoding) {
        FileInputStream fis = null;
        byte[] data = null;
        if (f == null) {
            throw new IllegalArgumentException("Cannot open null file object.");
        }
        if (!f.exists()) {
            return null;
        }
        try {
            int size = (int)f.length();
            fis = new FileInputStream(f);
            data = new byte[size];
            for (int bytesRead = 0; bytesRead < size; bytesRead += fis.read(data, bytesRead, size - bytesRead)) {
            }
        }
        catch (IOException e) {
            throw NSForwardException._runtimeExceptionForThrowable(e);
        }
        finally {
            if (f != null) {
                block14: {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {
                        if (!NSLog.debugLoggingAllowedForLevelAndGroups(2, 8192L)) break block14;
                        NSLog.debug.appendln("Exception while closing file input stream: " + e.getMessage());
                        NSLog.debug.appendln(e);
                    }
                }
                f = null;
            }
        }
        return _NSStringUtilities.stringForBytes(data, encoding);
    }

    public static byte[] bytesFromInputStream(InputStream is) {
        byte[] ret = null;
        try {
            int bytesRead;
            int avail = is.available();
            if (avail <= 0) {
                avail = 4096;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream(avail);
            byte[] data = new byte[avail];
            while ((bytesRead = is.read(data)) > 0) {
                baos.write(data, 0, bytesRead);
            }
            ret = baos.toByteArray();
        }
        catch (IOException e) {
            throw NSForwardException._runtimeExceptionForThrowable(e);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ioe) {
                throw NSForwardException._runtimeExceptionForThrowable(ioe);
            }
        }
        return ret;
    }

    public static String stringFromInputStream(InputStream is) {
        return _NSStringUtilities.stringFromInputStream(is, null);
    }

    public static String stringFromInputStream(InputStream is, String encoding) {
        if (is == null) {
            return null;
        }
        try {
            return _NSStringUtilities.stringForBytes(_NSStringUtilities.bytesFromInputStream(is), encoding);
        }
        catch (Exception e) {
            throw NSForwardException._runtimeExceptionForThrowable(e);
        }
    }

    public static String stringFromPathURL(URL url) {
        return _NSStringUtilities.stringFromPathURL(url, null);
    }

    public static String stringFromPathURL(URL url, String encoding) {
        if (url == null) {
            return null;
        }
        try {
            return _NSStringUtilities.stringFromInputStream(url.openStream(), encoding);
        }
        catch (Exception e) {
            throw NSForwardException._runtimeExceptionForThrowable(e);
        }
    }

    public static String stringWithReplacements(String self, NSDictionary replacements) {
        NSMutableArray result = NSArray._mutableComponentsSeparatedByString(self, " ");
        int c = result.count();
        for (int a = 0; a < c; ++a) {
            String atom = (String)result.objectAtIndex(a);
            String replacement = (String)replacements.objectForKey(atom);
            if (replacement == null) continue;
            result.replaceObjectAtIndex(replacement, a);
        }
        return result.componentsJoinedByString(" ");
    }

    public static String replaceNSStringSlot(String string, NSArray args) {
        if (string == null || args == null || args.count() == 0) {
            return string;
        }
        StringBuffer buffer = new StringBuffer(string.length() + 64);
        int posSlot = 0;
        int prevPos = 0;
        int indexArg = 0;
        int count = args.count();
        do {
            if ((posSlot = string.indexOf("%@", prevPos)) >= 0) {
                buffer.append(string.substring(prevPos, posSlot));
                buffer.append(args.objectAtIndex(indexArg).toString());
                ++indexArg;
            }
            prevPos = posSlot + 2;
        } while (posSlot >= 0);
        return new String(buffer);
    }

    private static boolean _isMagicCharacter(char character) {
        return character == '*' || character == '?' || character == '[' || character == ']';
    }

    private static boolean _stringMatchesCharacter(String string, char character) {
        _StringAnalyzer analyzer = new _StringAnalyzer(string);
        char stringCharacter = analyzer.nextCharacter();
        while (stringCharacter != '\u0000') {
            if (stringCharacter == '-') {
                char stringCharacter1 = analyzer.nextCharacter();
                char stringCharacter2 = analyzer.nextCharacter();
                if (stringCharacter1 <= character && character <= stringCharacter2) {
                    return true;
                }
            } else if (stringCharacter == character) {
                return true;
            }
            stringCharacter = analyzer.nextCharacter();
        }
        return false;
    }

    private static String _bracketedStringFromPatternAnalyzer(_PatternAnalyzer patternAnalyzer) {
        char patternCharacter = patternAnalyzer.nextCharacter();
        boolean isMagic = _NSStringUtilities._isMagicCharacter(patternCharacter);
        int i = 0;
        StringBuffer buffer = new StringBuffer(128);
        while (!(patternCharacter == '\u0000' || patternCharacter == ']' && isMagic)) {
            buffer.append(patternCharacter);
            ++i;
            if (patternCharacter == '-') {
                buffer.append(buffer.charAt(i - 2));
                ++i;
            }
            patternCharacter = patternAnalyzer.nextCharacter();
            isMagic = _NSStringUtilities._isMagicCharacter(patternCharacter);
        }
        if (patternCharacter == '\u0000' || patternCharacter != ']') {
            throw new IllegalArgumentException("Bad pattern " + patternAnalyzer.string() + "for qualifier");
        }
        return new String(buffer);
    }

    public static boolean stringMatchesPattern(String string, String pattern, boolean caseInsensitive) {
        boolean stringMatchesPattern = false;
        if (string != null) {
            NSMutableArray patternStack = new NSMutableArray(16);
            NSMutableArray stringStack = new NSMutableArray(16);
            _PatternAnalyzer patternAnalyzer = new _PatternAnalyzer(pattern);
            _StringAnalyzer stringAnalyzer = new _StringAnalyzer(string);
            char patternCharacter = patternAnalyzer.nextCharacter();
            boolean isMagic = _NSStringUtilities._isMagicCharacter(patternCharacter);
            char stringCharacter = stringAnalyzer.nextCharacter();
            int state = 0;
            block4: while (state != 2) {
                switch (state) {
                    case 0: {
                        if (patternCharacter == '\u0000' && stringCharacter == '\u0000') {
                            state = 2;
                            stringMatchesPattern = true;
                            continue block4;
                        }
                        if (isMagic && patternCharacter == '*') {
                            while (patternCharacter == '*' && isMagic) {
                                patternCharacter = patternAnalyzer.nextCharacter();
                                isMagic = _NSStringUtilities._isMagicCharacter(patternCharacter);
                            }
                            state = 1;
                            continue block4;
                        }
                        if (isMagic && patternCharacter == '?' && stringCharacter != '\u0000') {
                            patternCharacter = patternAnalyzer.nextCharacter();
                            isMagic = _NSStringUtilities._isMagicCharacter(patternCharacter);
                            stringCharacter = stringAnalyzer.nextCharacter();
                            state = 0;
                            continue block4;
                        }
                        if (isMagic && patternCharacter == '[' && stringCharacter != '\u0000') {
                            String bracketedString = _NSStringUtilities._bracketedStringFromPatternAnalyzer(patternAnalyzer);
                            if (_NSStringUtilities._stringMatchesCharacter(bracketedString, stringCharacter)) {
                                state = 0;
                                patternCharacter = patternAnalyzer.nextCharacter();
                                isMagic = _NSStringUtilities._isMagicCharacter(patternCharacter);
                                stringCharacter = stringAnalyzer.nextCharacter();
                                continue block4;
                            }
                            stringMatchesPattern = false;
                            state = 2;
                            continue block4;
                        }
                        if (patternCharacter == stringCharacter || caseInsensitive && Character.toUpperCase(patternCharacter) == stringCharacter) {
                            patternCharacter = patternAnalyzer.nextCharacter();
                            isMagic = _NSStringUtilities._isMagicCharacter(patternCharacter);
                            stringCharacter = stringAnalyzer.nextCharacter();
                            state = 0;
                            continue block4;
                        }
                        if (stringStack.count() == 0) {
                            state = 2;
                            stringMatchesPattern = false;
                            continue block4;
                        }
                        stringAnalyzer.setLocation((Integer)stringStack.lastObject());
                        stringAnalyzer.refreshCurrentCharacter();
                        stringStack.removeLastObject();
                        patternAnalyzer.setLocation((Integer)patternStack.lastObject());
                        patternAnalyzer.refreshCurrentCharacter();
                        patternStack.removeLastObject();
                        patternCharacter = patternAnalyzer.nextCharacter();
                        isMagic = _NSStringUtilities._isMagicCharacter(patternCharacter);
                        stringCharacter = stringAnalyzer.nextCharacter();
                        state = 1;
                        continue block4;
                    }
                    case 1: {
                        if (patternCharacter != '?' || !isMagic) {
                            if (caseInsensitive) {
                                char uppercasePatternCharacter = Character.toUpperCase(patternCharacter);
                                while (stringCharacter != '\u0000' && patternCharacter != stringCharacter && uppercasePatternCharacter != stringCharacter) {
                                    stringCharacter = stringAnalyzer.nextCharacter();
                                }
                            } else {
                                while (stringCharacter != '\u0000' && patternCharacter != stringCharacter) {
                                    stringCharacter = stringAnalyzer.nextCharacter();
                                }
                            }
                        }
                        if (stringCharacter != '\u0000') {
                            stringStack.addObject(_NSUtilities.IntegerForInt(stringAnalyzer.location()));
                            patternStack.addObject(_NSUtilities.IntegerForInt(patternAnalyzer.location() - 1));
                        }
                        state = 0;
                        continue block4;
                    }
                }
            }
        }
        return stringMatchesPattern;
    }

    static {
        _encoding = WO_DEFAULT_ENCODING = null;
    }

    private static class _PatternAnalyzer
    extends _StringAnalyzer {
        public _PatternAnalyzer(String string) {
            super(string);
        }

        public char nextCharacter() {
            if (this.isAtEnd()) {
                return '\u0000';
            }
            char character = this._currentCharacter;
            if (character == '\\') {
                this.advance();
                character = this._currentCharacter;
            }
            this.advance();
            return character;
        }
    }

    private static class _StringAnalyzer {
        protected String _string;
        protected int _stringLength;
        protected int _location;
        protected char _currentCharacter;

        public _StringAnalyzer(String string) {
            this._string = string;
            this._stringLength = this._string.length();
            this._location = 0;
            this._currentCharacter = this._stringLength > 0 ? this._string.charAt(this._location) : (char)'\u0000';
        }

        public String string() {
            return this._string;
        }

        public boolean isAtEnd() {
            return this._location >= this._stringLength;
        }

        public void setLocation(int location) {
            this._location = location;
        }

        public int location() {
            return this._location;
        }

        public char currentCharacter() {
            return this._currentCharacter;
        }

        public void advance() {
            if (!this.isAtEnd()) {
                ++this._location;
                this._currentCharacter = this._location < this._stringLength ? this._string.charAt(this._location) : (char)'\u0000';
            }
        }

        public char nextCharacter() {
            if (!this.isAtEnd()) {
                char character = this._currentCharacter;
                this.advance();
                return character;
            }
            return '\u0000';
        }

        public void refreshCurrentCharacter() {
            if (!this.isAtEnd()) {
                this._currentCharacter = this._location < this._stringLength ? this._string.charAt(this._location) : (char)'\u0000';
            }
        }
    }
}

