/*
 * Decompiled with CFR 0.152.
 */
package org.openid4java;

public class OpenIDException
extends Exception {
    private int _errorCode;
    public static final int OPENID_ERROR = 0;
    public static final int MESSAGE_ERROR = 256;
    public static final int ASSOC_ERROR = 512;
    public static final int AUTH_ERROR = 768;
    public static final int AUTH_REALM_ERROR = 769;
    public static final int VERIFY_ERROR = 1024;
    public static final int DISCOVERY_ERROR = 1280;
    public static final int DISCOVERY_HTML_ERROR = 1536;
    public static final int DISCOVERY_HTML_GET_ERROR = 1537;
    public static final int DISCOVERY_HTML_NODATA_ERROR = 1538;
    public static final int DISCOVERY_HTML_PARSE_ERROR = 1539;
    public static final int YADIS_ERROR = 1792;
    public static final int YADIS_INVALID_URL = 1794;
    public static final int YADIS_INVALID_SCHEME = 1795;
    public static final int YADIS_HEAD_TRANSPORT_ERROR = 1796;
    public static final int YADIS_HEAD_INVALID_RESPONSE = 1797;
    public static final int YADIS_GET_ERROR = 1798;
    public static final int YADIS_GET_TRANSPORT_ERROR = 1799;
    public static final int YADIS_GET_INVALID_RESPONSE = 1800;
    public static final int YADIS_GET_NO_XRDS = 1801;
    public static final int YADIS_HTMLMETA_DOWNLOAD_ERROR = 1802;
    public static final int YADIS_HTMLMETA_INVALID_RESPONSE = 1803;
    public static final int YADIS_XRDS_DOWNLOAD_ERROR = 1804;
    public static final int YADIS_XRDS_PARSING_ERROR = 1805;
    public static final int YADIS_XRDS_SIZE_EXCEEDED = 1806;
    public static final int XRI_ERROR = 2048;
    public static final int SERVER_ERROR = 2304;
    public static final int CONSUMER_ERROR = 2560;
    public static final int INFOCARD_ERROR = 2816;
    public static final int EXTENSION_ERROR = 3072;
    public static final int AX_ERROR = 3088;
    public static final int SREG_ERROR = 3104;
    public static final int PAPE_ERROR = 3120;

    public OpenIDException(String message) {
        this(message, 0);
    }

    public OpenIDException(String message, int code) {
        super(message);
        this._errorCode = code;
    }

    public OpenIDException(String message, Throwable cause) {
        this(message, 0, cause);
    }

    public OpenIDException(String message, int code, Throwable cause) {
        super(message, cause);
        this._errorCode = code;
    }

    public OpenIDException(Throwable cause) {
        this(0, cause);
    }

    public OpenIDException(int code, Throwable cause) {
        super(cause);
        this._errorCode = code;
    }

    public int getErrorCode() {
        return this._errorCode;
    }

    public void setErrorCode(int errorCode) {
        this._errorCode = errorCode;
    }

    public String getMessage() {
        return "0x" + Integer.toHexString(this._errorCode) + ": " + super.getMessage();
    }
}

