/*
 * Decompiled with CFR 0.152.
 */
package org.openid4java.consumer;

import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openid4java.consumer.AbstractNonceVerifier;

public class InMemoryNonceVerifier
extends AbstractNonceVerifier {
    private static Log _log = LogFactory.getLog((Class)InMemoryNonceVerifier.class);
    private static final boolean DEBUG = _log.isDebugEnabled();
    private Map _opMap = new HashMap();

    public InMemoryNonceVerifier(int maxAge) {
        super(maxAge);
    }

    protected synchronized int seen(Date now, String opUrl, String nonce) {
        this.removeAged(now);
        HashSet<String> seenSet = (HashSet<String>)this._opMap.get(opUrl);
        if (seenSet == null) {
            seenSet = new HashSet<String>();
            this._opMap.put(opUrl, seenSet);
        }
        if (seenSet.contains(nonce)) {
            _log.error((Object)("Possible replay attack! Already seen nonce: " + nonce));
            return 1;
        }
        seenSet.add(nonce);
        if (DEBUG) {
            _log.debug((Object)("Nonce verified: " + nonce));
        }
        return 0;
    }

    private synchronized void removeAged(Date now) {
        String opUrl;
        HashSet<String> opToRemove = new HashSet<String>();
        Iterator<Object> opUrls = this._opMap.keySet().iterator();
        while (opUrls.hasNext()) {
            String nonce;
            opUrl = (String)opUrls.next();
            Set seenSet = (Set)this._opMap.get(opUrl);
            HashSet<String> nonceToRemove = new HashSet<String>();
            Iterator nonces = seenSet.iterator();
            while (nonces.hasNext()) {
                nonce = (String)nonces.next();
                try {
                    Date nonceDate = _dateFormat.parse(nonce);
                    if (!this.isTooOld(now, nonceDate)) continue;
                    nonceToRemove.add(nonce);
                }
                catch (ParseException e) {
                    nonceToRemove.add(nonce);
                }
            }
            nonces = nonceToRemove.iterator();
            while (nonces.hasNext()) {
                nonce = (String)nonces.next();
                if (DEBUG) {
                    _log.debug((Object)("Removing nonce: " + nonce + " from OP: " + opUrl));
                }
                seenSet.remove(nonce);
            }
            if (seenSet.size() != 0) continue;
            opToRemove.add(opUrl);
        }
        opUrls = opToRemove.iterator();
        while (opUrls.hasNext()) {
            opUrl = (String)opUrls.next();
            if (DEBUG) {
                _log.debug((Object)("Removed all nonces from OP: " + opUrl));
            }
            this._opMap.remove(opUrl);
        }
    }

    protected synchronized int size() {
        int total = 0;
        Iterator opUrls = this._opMap.keySet().iterator();
        while (opUrls.hasNext()) {
            String opUrl = (String)opUrls.next();
            Set seenSet = (Set)this._opMap.get(opUrl);
            total += seenSet.size();
        }
        return total;
    }
}

