/*
 * Decompiled with CFR 0.152.
 */
package org.openid4java.discovery;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openid4java.discovery.DiscoveryException;
import org.openid4java.discovery.DiscoveryInformation;
import org.openid4java.discovery.Identifier;
import org.openid4java.discovery.UrlIdentifier;
import org.openid4java.discovery.XriIdentifier;
import org.openid4java.discovery.html.HtmlResolver;
import org.openid4java.discovery.html.HtmlResult;
import org.openid4java.discovery.yadis.YadisException;
import org.openid4java.discovery.yadis.YadisResolver;
import org.openid4java.discovery.yadis.YadisResult;
import org.openid4java.util.HttpCache;
import org.openxri.resolve.Resolver;
import org.openxri.resolve.ResolverState;
import org.openxri.resolve.TrustType;
import org.openxri.resolve.exception.PartialResolutionException;
import org.openxri.xml.CanonicalID;
import org.openxri.xml.SEPType;
import org.openxri.xml.SEPUri;
import org.openxri.xml.Service;
import org.openxri.xml.XRD;
import org.openxri.xml.XRDS;
import org.w3c.dom.Element;

public class Discovery {
    private static Log _log = LogFactory.getLog((Class)Discovery.class);
    private static final boolean DEBUG = _log.isDebugEnabled();
    private static final Pattern URL_PATTERN = Pattern.compile("^https?://", 2);
    private static final Pattern XRI_PATTERN = Pattern.compile("^[!=@\\$\\+\\(]", 2);
    private static final String ROOT_DEF_EQ_URI = "http://equal.xri.net";
    private static final String ROOT_DEF_AT_URI = "http://at.xri.net";
    private static final String ROOT_DEF_BANG_URI = "http://bang.xri.net";
    private Resolver _xriResolver = new Resolver();
    private YadisResolver _yadisResolver = new YadisResolver();
    private HtmlResolver _htmlResolver = new HtmlResolver();

    public Discovery() {
        if (DEBUG) {
            _log.debug((Object)"Initializing Discovery object...");
        }
        String trustParam = ";trust=none";
        XRD eqRoot = new XRD();
        Service eqAuthService = new Service();
        eqAuthService.addMediaType("application/xrds+xml" + trustParam, "content", Boolean.FALSE);
        eqAuthService.addType("xri://$res*auth*($v*2.0)");
        eqAuthService.addURI(ROOT_DEF_EQ_URI);
        eqRoot.setProviderID("xri://=");
        eqRoot.addService(eqAuthService);
        XRD atRoot = new XRD();
        Service atAuthService = new Service();
        atAuthService.addMediaType("application/xrds+xml" + trustParam, "content", Boolean.FALSE);
        atAuthService.addType("xri://$res*auth*($v*2.0)");
        atAuthService.addURI(ROOT_DEF_AT_URI);
        atRoot.setProviderID("xri://@");
        atRoot.addService(atAuthService);
        XRD bangRoot = new XRD();
        Service bangAuthService = new Service();
        bangAuthService.addMediaType("application/xrds+xml" + trustParam, "content", Boolean.FALSE);
        bangAuthService.addType("xri://$res*auth*($v*2.0)");
        bangAuthService.addURI(ROOT_DEF_BANG_URI);
        bangRoot.setProviderID("xri://!");
        bangRoot.addService(bangAuthService);
        this._xriResolver.setAuthority("=", eqRoot);
        this._xriResolver.setAuthority("@", atRoot);
        this._xriResolver.setAuthority("!", bangRoot);
    }

    public void setXriResolver(Resolver xriResolver) {
        this._xriResolver = xriResolver;
    }

    public void setYadisResolver(YadisResolver yadisResolver) {
        this._yadisResolver = yadisResolver;
    }

    public void setHtmlResolver(HtmlResolver htmlResolver) {
        this._htmlResolver = htmlResolver;
    }

    public static Identifier parseIdentifier(String identifier) throws DiscoveryException {
        return Discovery.parseIdentifier(identifier, false);
    }

    public static Identifier parseIdentifier(String identifier, boolean removeFragment) throws DiscoveryException {
        try {
            if (identifier.toLowerCase().startsWith("xri://")) {
                if (DEBUG) {
                    _log.debug((Object)("Dropping xri:// prefix from identifier: " + identifier));
                }
                identifier = identifier.substring(6);
            }
            if (URL_PATTERN.matcher(identifier).find()) {
                if (DEBUG) {
                    _log.debug((Object)("Creating URL identifier for: " + identifier));
                }
                return new UrlIdentifier(identifier, removeFragment);
            }
            if (XRI_PATTERN.matcher(identifier).find()) {
                if (DEBUG) {
                    _log.debug((Object)("Creating XRI identifier for: " + identifier));
                }
                return new XriIdentifier(identifier);
            }
            if (DEBUG) {
                _log.debug((Object)("Creating URL identifier (http:// prepended) for: " + identifier));
            }
            return new UrlIdentifier("http://" + identifier, removeFragment);
        }
        catch (Exception e) {
            throw new DiscoveryException("Cannot parse identifier: " + identifier, (Throwable)e);
        }
    }

    public List discover(String identifier) throws DiscoveryException {
        return this.discover(Discovery.parseIdentifier(identifier, true));
    }

    public List discover(Identifier identifier) throws DiscoveryException {
        List result = new ArrayList();
        if (identifier instanceof XriIdentifier) {
            _log.info((Object)("Starting discovery on XRI identifier: " + identifier));
            XriIdentifier xriIdentifier = (XriIdentifier)identifier;
            try {
                TrustType trustAll = new TrustType("none");
                XRDS xrds = this._xriResolver.resolveAuthToXRDS(xriIdentifier.getXriIdentifier(), trustAll, true, new ResolverState());
                if (DEBUG) {
                    _log.debug((Object)("Retrieved XRDS:\n" + xrds.dump()));
                }
                XRD xrd = xrds.getFinalXRD();
                CanonicalID canonical = xrd.getCanonicalidAt(0);
                if (this.isProviderAuthoritative(xrd.getProviderID(), canonical)) {
                    _log.info((Object)("XRI resolution succeeded on " + identifier.toString()));
                    result = Discovery.extractDiscoveryInformation(xrds, (XriIdentifier)identifier, this._xriResolver);
                }
                _log.warn((Object)"ProviderID is not authoritative for the CanonicalID. Returning empty discovery result set.");
            }
            catch (Exception e) {
                throw new DiscoveryException("Cannot resolve XRI: " + identifier.toString(), (Throwable)e);
            }
        } else if (identifier instanceof UrlIdentifier) {
            _log.info((Object)("Starting discovery on URL identifier: " + identifier));
            UrlIdentifier urlId = (UrlIdentifier)identifier;
            HttpCache cache = new HttpCache();
            try {
                YadisResult yadis = this._yadisResolver.discover(urlId.toString(), cache);
                if (yadis.isSuccess()) {
                    _log.info((Object)("Using Yadis normalized URL as claimedID: " + yadis.getNormalizedUrl()));
                    result = Discovery.extractDiscoveryInformation(yadis.getXrds(), new UrlIdentifier(yadis.getNormalizedUrl()));
                }
            }
            catch (YadisException e) {
                _log.warn((Object)("Yadis discovery failed on " + urlId.toString() + " : " + e.getMessage()), e.getCause());
            }
            if (result.size() == 0) {
                _log.info((Object)"No OpenID service endpoints discovered through Yadis; attempting HTML discovery...");
                result = this.extractDiscoveryInformation(this._htmlResolver.discover(urlId, cache));
            }
        } else {
            throw new DiscoveryException("Unknown identifier type: " + identifier.toString());
        }
        _log.info((Object)("Discovered " + result.size() + " OpenID endpoints."));
        return result;
    }

    private List extractDiscoveryInformation(HtmlResult htmlResult) throws DiscoveryException {
        DiscoveryInformation extracted;
        ArrayList<DiscoveryInformation> htmlList = new ArrayList<DiscoveryInformation>();
        if (htmlResult.getOP2Endpoint() != null) {
            extracted = new DiscoveryInformation(htmlResult.getOP2Endpoint(), htmlResult.getClaimedId(), htmlResult.getDelegate2(), "http://specs.openid.net/auth/2.0/signon");
            if (DEBUG) {
                _log.debug((Object)("OpenID2-signon HTML discovery endpoint: " + extracted));
            }
            htmlList.add(extracted);
        }
        if (htmlResult.getOP1Endpoint() != null) {
            extracted = new DiscoveryInformation(htmlResult.getOP1Endpoint(), htmlResult.getClaimedId(), htmlResult.getDelegate1(), "http://openid.net/signon/1.1");
            if (DEBUG) {
                _log.debug((Object)("OpenID1-signon HTML discovery endpoint: " + extracted));
            }
            htmlList.add(extracted);
        }
        return htmlList;
    }

    protected static List extractDiscoveryInformation(XRDS xrds, Identifier identifier) throws DiscoveryException {
        ArrayList<DiscoveryInformation> opSelectList = new ArrayList<DiscoveryInformation>();
        ArrayList<DiscoveryInformation> signonList = new ArrayList<DiscoveryInformation>();
        ArrayList<DiscoveryInformation> openid1 = new ArrayList<DiscoveryInformation>();
        XRD xrd = xrds.getFinalXRD();
        Iterator iterS = xrd.getPrioritizedServices().iterator();
        while (iterS.hasNext()) {
            Service service = (Service)iterS.next();
            Iterator iter = service.getPrioritizedURIs().iterator();
            while (iter.hasNext()) {
                DiscoveryInformation extracted;
                URL opEndpointUrl;
                SEPUri sepUri = (SEPUri)iter.next();
                try {
                    opEndpointUrl = sepUri.getURI().toURL();
                }
                catch (MalformedURLException e) {
                    _log.warn((Object)("Ignoring malformed OP endpoint URL in XRDS file: " + sepUri.toString()), (Throwable)e);
                    continue;
                }
                catch (IllegalArgumentException ee) {
                    _log.warn((Object)("Ignoring invalid OP endpoint URL in XRDS file: " + sepUri.toString()), (Throwable)ee);
                    continue;
                }
                if (Discovery.matchType(service, "http://specs.openid.net/auth/2.0/server")) {
                    extracted = new DiscoveryInformation(opEndpointUrl);
                    if (DEBUG) {
                        _log.debug((Object)("OpenID2-server XRDS discovery result:\n" + extracted));
                    }
                    opSelectList.add(extracted);
                }
                if (Discovery.matchType(service, "http://specs.openid.net/auth/2.0/signon")) {
                    Identifier claimedIdentifier = identifier;
                    CanonicalID canonicalId = xrd.getCanonicalidAt(0);
                    String providerId = xrd.getProviderID();
                    if (identifier instanceof XriIdentifier) {
                        if (canonicalId == null) {
                            throw new DiscoveryException("No CanonicalID found after XRI resolution of: " + identifier.getIdentifier());
                        }
                        if (providerId == null || providerId.length() == 0) {
                            throw new DiscoveryException("No Provider ID found after XRI resolution of: " + identifier.getIdentifier());
                        }
                        claimedIdentifier = Discovery.parseIdentifier(canonicalId.getValue());
                    }
                    extracted = new DiscoveryInformation(opEndpointUrl, claimedIdentifier, Discovery.getDelegate(service, false), "http://specs.openid.net/auth/2.0/signon");
                    if (DEBUG) {
                        _log.debug((Object)("OpenID2-signon XRDS discovery result:\n" + extracted));
                    }
                    signonList.add(extracted);
                }
                if (!Discovery.matchType(service, "http://openid.net/signon/1.0") && !Discovery.matchType(service, "http://openid.net/signon/1.1")) continue;
                extracted = new DiscoveryInformation(opEndpointUrl, identifier, Discovery.getDelegate(service, true), "http://openid.net/signon/1.1");
                if (DEBUG) {
                    _log.debug((Object)("OpenID1-signon XRDS discovery result:\n" + extracted));
                }
                openid1.add(extracted);
            }
        }
        opSelectList.addAll(signonList);
        opSelectList.addAll(openid1);
        if (opSelectList.size() == 0) {
            _log.info((Object)"No OpenID service types found in the XRDS.");
        }
        return opSelectList;
    }

    protected static List extractDiscoveryInformation(XRDS xrds, XriIdentifier identifier, Resolver xriResolver) throws DiscoveryException {
        ArrayList endpoints = new ArrayList();
        XRD xrd = xrds.getFinalXRD();
        Discovery.extractDiscoveryInformationOpenID(xriResolver, endpoints, xrd, identifier, "http://specs.openid.net/auth/2.0/server", false);
        Discovery.extractDiscoveryInformationOpenID(xriResolver, endpoints, xrd, identifier, "http://specs.openid.net/auth/2.0/signon", true);
        Discovery.extractDiscoveryInformationOpenID(xriResolver, endpoints, xrd, identifier, "http://openid.net/signon/1.1", true);
        Discovery.extractDiscoveryInformationOpenID(xriResolver, endpoints, xrd, identifier, "http://openid.net/signon/1.0", true);
        if (endpoints.size() == 0) {
            _log.info((Object)"No OpenID service types found in the XRDS.");
        }
        return endpoints;
    }

    public static boolean extractDiscoveryInformationOpenID(Resolver xriResolver, ArrayList out, XRD baseXRD, XriIdentifier identifier, String srvType, boolean wantCID) {
        try {
            XRDS tmpXRDS = xriResolver.selectServiceFromXRD(baseXRD, identifier.getXriIdentifier(), new TrustType(), srvType, null, true, new ResolverState());
            Identifier claimedIdentifier = null;
            XRD tmpXRD = tmpXRDS.getFinalXRD();
            if (wantCID) {
                CanonicalID canonID = tmpXRD.getCanonicalidAt(0);
                if (canonID == null) {
                    _log.error((Object)("No CanonicalID found for " + srvType + " after XRI resolution of: " + identifier.getIdentifier()));
                    return false;
                }
                claimedIdentifier = Discovery.parseIdentifier(canonID.getValue());
                _log.info((Object)("Using canonicalID as claimedID: " + claimedIdentifier.getIdentifier() + " for " + srvType));
            }
            Iterator it = tmpXRD.getSelectedServices().getList().iterator();
            while (it.hasNext()) {
                Service srv = (Service)it.next();
                Iterator itURI = srv.getPrioritizedURIs().iterator();
                while (itURI.hasNext()) {
                    SEPUri sepURI = (SEPUri)itURI.next();
                    try {
                        String urlString = xriResolver.constructURI(sepURI.getURI(), sepURI.getAppend(), identifier.getXriIdentifier());
                        URL opEndpointUrl = new URL(urlString);
                        DiscoveryInformation extracted = new DiscoveryInformation(opEndpointUrl, wantCID ? claimedIdentifier : null, null, srvType);
                        _log.info((Object)("Added " + srvType + " endpoint: " + opEndpointUrl));
                        out.add(extracted);
                    }
                    catch (MalformedURLException mue) {
                        _log.warn((Object)("Ignoring malformed OP endpoint URL in XRDS file: " + sepURI.toString()), (Throwable)mue);
                    }
                    catch (IllegalArgumentException ee) {
                        _log.warn((Object)("Ignoring invalid OP endpoint URL in XRDS file: " + sepURI.toString()), (Throwable)ee);
                    }
                }
            }
            return true;
        }
        catch (PartialResolutionException e) {
            _log.error((Object)("XRI resolution failed for " + srvType), (Throwable)e);
        }
        catch (DiscoveryException de) {
            _log.error((Object)("XRDS discovery failed for " + srvType), (Throwable)de);
        }
        return false;
    }

    public static String getDelegate(Service service, boolean compatibility) {
        String nsPattern;
        String delegateTag;
        String delegate = null;
        if (compatibility) {
            delegateTag = "Delegate";
            nsPattern = "http://openid\\.net/xmlns/1\\.0";
        } else {
            delegateTag = "LocalID";
            nsPattern = "xri://\\$xrd\\*\\(\\$v\\*2\\.0\\)";
        }
        Vector delegateTags = service.getOtherTagValues(delegateTag);
        for (int i = 0; delegateTags != null && i < delegateTags.size(); ++i) {
            Element element = (Element)delegateTags.elementAt(i);
            if (!Pattern.matches(nsPattern, element.getNamespaceURI())) continue;
            delegate = element.getFirstChild().getNodeValue();
            if (!DEBUG) continue;
            _log.debug((Object)("Found delegate: " + delegate));
        }
        return delegate;
    }

    public static boolean matchType(Service service, String sVal) {
        for (int i = 0; i < service.getNumTypes(); ++i) {
            SEPType type = service.getTypeAt(i);
            if (!type.match(sVal)) continue;
            return true;
        }
        return false;
    }

    private boolean isProviderAuthoritative(String providerId, CanonicalID canonicalId) {
        if (canonicalId == null || canonicalId.getValue() == null) {
            return false;
        }
        String auth = canonicalId.getValue().substring(0, 1);
        XRD rootAuth = this._xriResolver.getAuthority(auth);
        if (!rootAuth.getProviderID().equals(providerId)) {
            return false;
        }
        int lastbang = canonicalId.getValue().lastIndexOf("!");
        String parent = lastbang > -1 ? canonicalId.getValue().substring(0, lastbang) : canonicalId.getValue();
        String parentNoPrefix = parent.startsWith("xri://") ? parent.substring(6) : parent;
        String providerIDNoPrefix = providerId.startsWith("xri://") ? providerId.substring(6) : providerId;
        return parentNoPrefix.equals(providerIDNoPrefix);
    }

    public static List rpDiscovery(String realm, YadisResolver yadisResolver) throws DiscoveryException {
        List result = new ArrayList();
        YadisResult rpDiscovery = yadisResolver.discover(realm, 0);
        if (rpDiscovery.isSuccess()) {
            result = Discovery.extractRpDiscoveryInformation(rpDiscovery.getXrds());
        }
        return result;
    }

    protected static List extractRpDiscoveryInformation(XRDS xrds) throws DiscoveryException {
        ArrayList<DiscoveryInformation> result = new ArrayList<DiscoveryInformation>();
        XRD xrd = xrds.getFinalXRD();
        Iterator iterS = xrd.getPrioritizedServices().iterator();
        while (iterS.hasNext()) {
            Service service = (Service)iterS.next();
            Iterator iter = service.getPrioritizedURIs().iterator();
            while (iter.hasNext()) {
                URL endpointUrl;
                SEPUri sepUri = (SEPUri)iter.next();
                try {
                    endpointUrl = sepUri.getURI().toURL();
                }
                catch (MalformedURLException e) {
                    _log.warn((Object)("Ignoring malformed OP endpoint URL in XRDS file: " + sepUri.toString()), (Throwable)e);
                    continue;
                }
                catch (IllegalArgumentException ee) {
                    _log.warn((Object)("Ignoring invalid OP endpoint URL in XRDS file: " + sepUri.toString()), (Throwable)ee);
                    continue;
                }
                if (!Discovery.matchType(service, "http://specs.openid.net/auth/2.0/return_to")) continue;
                DiscoveryInformation extracted = new DiscoveryInformation(endpointUrl, null, "http://specs.openid.net/auth/2.0/return_to");
                if (DEBUG) {
                    _log.debug((Object)("OpenID2-RP XRDS discovery result:\n" + extracted));
                }
                result.add(extracted);
            }
        }
        if (result.size() == 0) {
            _log.info((Object)"No OpenID service types found in the XRDS.");
        }
        return result;
    }
}

