/*
 * Decompiled with CFR 0.152.
 */
package org.openid4java.discovery.html;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.htmlparser.Node;
import org.htmlparser.NodeFilter;
import org.htmlparser.Parser;
import org.htmlparser.filters.TagNameFilter;
import org.htmlparser.nodes.TagNode;
import org.htmlparser.util.NodeList;
import org.htmlparser.util.ParserException;
import org.htmlparser.util.SimpleNodeIterator;
import org.openid4java.discovery.DiscoveryException;
import org.openid4java.discovery.UrlIdentifier;
import org.openid4java.discovery.html.HtmlResult;
import org.openid4java.util.HttpCache;
import org.openid4java.util.HttpRequestOptions;
import org.openid4java.util.HttpResponse;

public class HtmlResolver {
    private static Log _log = LogFactory.getLog((Class)HtmlResolver.class);
    private static final boolean DEBUG = _log.isDebugEnabled();
    private int _maxRedirects = 10;

    public int getMaxRedirects() {
        return this._maxRedirects;
    }

    public void setMaxRedirects(int maxRedirects) {
        this._maxRedirects = maxRedirects;
    }

    public HtmlResult discover(UrlIdentifier identifier) throws DiscoveryException {
        return this.discover(identifier, new HttpCache());
    }

    public HtmlResult discover(UrlIdentifier identifier, HttpCache cache) throws DiscoveryException {
        HtmlResult result = new HtmlResult();
        HttpRequestOptions requestOptions = cache.getRequestOptions();
        requestOptions.setContentType("text/html");
        try {
            HttpResponse resp = cache.get(identifier.toString(), requestOptions);
            if (200 != resp.getStatusCode()) {
                throw new DiscoveryException("GET failed on " + identifier.toString() + " Received status code: " + resp.getStatusCode(), 1537);
            }
            result.setClaimed(new UrlIdentifier(resp.getFinalUri()));
            if (resp.getBody() == null) {
                throw new DiscoveryException("No HTML data read from " + identifier.toString(), 1538);
            }
            this.parseHtml(resp.getBody(), result);
        }
        catch (IOException e) {
            throw new DiscoveryException("Fatal transport error: ", 1537, e);
        }
        _log.info((Object)("HTML discovery completed on: " + identifier));
        return result;
    }

    private void parseHtml(String htmlData, HtmlResult result) throws DiscoveryException {
        Object op1Endpoint = null;
        Object op2Endpoint = null;
        if (DEBUG) {
            _log.debug((Object)("Parsing HTML data:\n" + htmlData));
        }
        try {
            Parser parser = Parser.createParser((String)htmlData, null);
            NodeList heads = parser.parse((NodeFilter)new TagNameFilter("HEAD"));
            if (heads.size() != 1) {
                throw new DiscoveryException("HTML response must have exactly one HEAD element, found " + heads.size() + " : " + heads.toHtml(), 1539);
            }
            Node head = heads.elementAt(0);
            SimpleNodeIterator i = head.getChildren().elements();
            while (i.hasMoreNodes()) {
                List<String> relations;
                Node node = i.nextNode();
                if (!(node instanceof TagNode)) continue;
                TagNode link = (TagNode)node;
                String href = link.getAttribute("href");
                String rel = link.getAttribute("rel");
                if (rel == null || (relations = Arrays.asList(rel.split(" "))) == null) continue;
                if (relations.contains("openid.server")) {
                    if (result.getOP1Endpoint() != null) {
                        throw new DiscoveryException("More than one openid.server entries found", 1539);
                    }
                    if (DEBUG) {
                        _log.debug((Object)("Found OpenID1 endpoint: " + op1Endpoint));
                    }
                    result.setEndpoint1(href);
                }
                if (relations.contains("openid.delegate")) {
                    if (result.getDelegate1() != null) {
                        throw new DiscoveryException("More than one openid.delegate entries found", 1539);
                    }
                    if (DEBUG) {
                        _log.debug((Object)("Found OpenID1 delegate: " + href));
                    }
                    result.setDelegate1(href);
                }
                if (relations.contains("openid2.provider")) {
                    if (result.getOP2Endpoint() != null) {
                        throw new DiscoveryException("More than one openid.server entries found", 1539);
                    }
                    if (DEBUG) {
                        _log.debug((Object)("Found OpenID2 endpoint: " + op2Endpoint));
                    }
                    result.setEndpoint2(href);
                }
                if (!relations.contains("openid2.local_id")) continue;
                if (result.getDelegate2() != null) {
                    throw new DiscoveryException("More than one openid2.local_id entries found", 1539);
                }
                if (DEBUG) {
                    _log.debug((Object)("Found OpenID2 localID: " + href));
                }
                result.setDelegate2(href);
            }
            if (DEBUG) {
                _log.debug((Object)("HTML discovery result:\n" + result));
            }
        }
        catch (ParserException e) {
            throw new DiscoveryException("Error parsing HTML message", 1539, e);
        }
    }
}

