/*
 * Decompiled with CFR 0.152.
 */
package org.openid4java.discovery.yadis;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.htmlparser.Node;
import org.htmlparser.NodeFilter;
import org.htmlparser.Parser;
import org.htmlparser.filters.TagNameFilter;
import org.htmlparser.tags.MetaTag;
import org.htmlparser.util.NodeList;
import org.htmlparser.util.ParserException;
import org.htmlparser.util.SimpleNodeIterator;
import org.openid4java.discovery.yadis.YadisException;
import org.openid4java.discovery.yadis.YadisResult;
import org.openid4java.discovery.yadis.YadisUrl;
import org.openid4java.util.HttpCache;
import org.openid4java.util.HttpRequestOptions;
import org.openid4java.util.HttpResponse;
import org.openxri.xml.XRDS;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class YadisResolver {
    private static Log _log = LogFactory.getLog((Class)YadisResolver.class);
    private static final boolean DEBUG = _log.isDebugEnabled();
    private static final String YADIS_XRDS_LOCATION = "X-XRDS-Location";
    private static final String YADIS_CONTENT_TYPE = "application/xrds+xml";
    private static final String YADIS_ACCEPT_HEADER = "text/html; q=0.3, application/xhtml+xml; q=0.5, application/xrds+xml";
    private int _maxRedirects = 10;

    public int getMaxRedirects() {
        return this._maxRedirects;
    }

    public void setMaxRedirects(int maxRedirects) {
        this._maxRedirects = maxRedirects;
    }

    public YadisResult discover(String url) throws YadisException {
        return this.discover(url, this._maxRedirects, new HttpCache());
    }

    public YadisResult discover(String url, HttpCache cache) throws YadisException {
        return this.discover(url, this._maxRedirects, cache);
    }

    public YadisResult discover(String url, int maxRedirects) throws YadisException {
        return this.discover(url, maxRedirects, new HttpCache());
    }

    public YadisResult discover(String url, int maxRedirects, HttpCache cache) throws YadisException {
        YadisResult result = new YadisResult();
        YadisUrl yadisUrl = new YadisUrl(url);
        result.setYadisUrl(yadisUrl);
        this.headXrdsUrl(cache, maxRedirects, yadisUrl, result);
        this.getXrds(cache, maxRedirects, result, false);
        result.setSuccess(true);
        _log.info((Object)("Yadis discovery succeeded on " + url));
        return result;
    }

    private void getXrds(HttpCache cache, int maxRedirects, YadisResult result, boolean secondCall) throws YadisException {
        block13: {
            String getUrl = result.getXrdsLocation() != null ? result.getXrdsLocation().toString() : result.getYadisUrl().toString();
            HashMap<String, String> requestHeaders = new HashMap<String, String>();
            requestHeaders.put("Accept", YADIS_ACCEPT_HEADER);
            HttpRequestOptions requestOptions = cache.getRequestOptions();
            requestOptions.setRequestHeaders(requestHeaders);
            requestOptions.setMaxRedirects(maxRedirects);
            try {
                Header contentType;
                HttpResponse resp;
                if (DEBUG) {
                    _log.debug((Object)("Performing HTTP GET #" + (secondCall ? "2" : "1") + " on: " + getUrl + " ..."));
                }
                if ((resp = cache.get(getUrl, requestOptions)) == null || 200 != resp.getStatusCode()) {
                    throw new YadisException("GET failed on " + getUrl, 1798);
                }
                if (result.getNormalizedUrl() == null) {
                    result.setNormalizedUrl(resp.getFinalUri());
                }
                if ((contentType = resp.getResponseHeader("content-type")) != null && contentType.getValue() != null && contentType.getValue().split(";")[0].equalsIgnoreCase(YADIS_CONTENT_TYPE)) {
                    if (resp.isBodySizeExceeded()) {
                        throw new YadisException("More than " + requestOptions.getMaxBodySize() + " bytes in HTTP response body from " + getUrl, 1806);
                    }
                    XRDS xrds = this.parseXrds(resp.getBody());
                    result.setXrdsLocation(resp.getFinalUri(), 1800);
                    result.setContentType(YADIS_ACCEPT_HEADER);
                    result.setXrds(xrds);
                    if (DEBUG) {
                        _log.debug((Object)("Retrieved Yadis discovery result:\n" + result.dump()));
                    }
                    break block13;
                }
                if (!secondCall) {
                    if (resp.getResponseHeaders(YADIS_XRDS_LOCATION).length > 1) {
                        throw new YadisException("Found more than one X-XRDS-Location headers: " + resp.getResponseHeaders(YADIS_XRDS_LOCATION), 1800);
                    }
                    String xrdsLocation = null;
                    if (resp.getResponseHeader(YADIS_XRDS_LOCATION) != null) {
                        xrdsLocation = resp.getResponseHeader(YADIS_XRDS_LOCATION).getValue();
                        if (DEBUG) {
                            _log.debug((Object)"Found X-XRDS-Location header.");
                        }
                    }
                    if (xrdsLocation == null) {
                        xrdsLocation = this.getHtmlMeta(resp.getBody());
                    }
                    result.setXrdsLocation(xrdsLocation, 1800);
                    this.getXrds(cache, maxRedirects, result, true);
                    break block13;
                }
                throw new YadisException("Cannot retrieve XRDS for " + result.getYadisUrl().getUrl().toString(), 1801);
            }
            catch (IOException e) {
                throw new YadisException("Fatal transport error: ", 1799, e);
            }
        }
    }

    private String getHtmlMeta(String input) throws YadisException {
        String xrdsLocation = null;
        if (input == null) {
            throw new YadisException("Cannot download HTML message", 1802);
        }
        try {
            Parser parser = Parser.createParser((String)input, null);
            NodeList heads = parser.parse((NodeFilter)new TagNameFilter("HEAD"));
            if (heads.size() != 1) {
                throw new YadisException("HTML response must have exactly one HEAD element, found " + heads.size() + " : " + heads.toHtml(), 1803);
            }
            Node head = heads.elementAt(0);
            SimpleNodeIterator i = head.getChildren().elements();
            while (i.hasMoreNodes()) {
                MetaTag meta;
                Node node = i.nextNode();
                if (!(node instanceof MetaTag) || (meta = (MetaTag)node).getHttpEquiv() == null || !meta.getHttpEquiv().equalsIgnoreCase(YADIS_XRDS_LOCATION)) continue;
                if (xrdsLocation != null) {
                    throw new YadisException("More than one X-XRDS-LocationMETA tags found in HEAD: " + head.toHtml(), 1803);
                }
                xrdsLocation = meta.getMetaContent();
                if (!DEBUG) continue;
                _log.debug((Object)"Found X-XRDS-LocationMETA tags.");
            }
        }
        catch (ParserException pe) {
            throw new YadisException("Error parsing HTML message", 1803, pe);
        }
        return xrdsLocation;
    }

    private XRDS parseXrds(String input) throws YadisException {
        XRDS xrds;
        if (input == null) {
            throw new YadisException("Cannot read XML message", 1804);
        }
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(new ByteArrayInputStream(input.getBytes()));
            xrds = new XRDS(document.getDocumentElement(), false);
            if (DEBUG) {
                _log.debug((Object)("Retrieved Yadis / XRDS:\n" + xrds.dump()));
            }
        }
        catch (ParserConfigurationException e) {
            throw new YadisException("Parser configuration error", 1805, e);
        }
        catch (SAXException e) {
            throw new YadisException("Error parsing XML document", 1805, e);
        }
        catch (ParseException e) {
            throw new YadisException("Error parsing XML DATE field", 1805, e);
        }
        catch (URISyntaxException e) {
            throw new YadisException("Invalid URI specified in XRDS document", 1805, e);
        }
        catch (IOException e) {
            throw new YadisException("Error reading XRDS document", 1804, e);
        }
        return xrds;
    }

    private void headXrdsUrl(HttpCache cache, int maxRedirects, YadisUrl url, YadisResult result) throws YadisException {
        try {
            if (DEBUG) {
                _log.debug((Object)("Performing HTTP HEAD on: " + url + " ..."));
            }
            HttpRequestOptions requestOptions = new HttpRequestOptions();
            requestOptions.setMaxRedirects(maxRedirects);
            HttpResponse resp = cache.head(url.getUrl().toString(), requestOptions);
            if (200 != resp.getStatusCode()) {
                if (DEBUG) {
                    _log.debug((Object)("Cannot retrieve X-XRDS-Location using HEAD from " + url.getUrl().toString() + "; status=" + resp.getStatusLine()));
                }
                return;
            }
            if (resp.getResponseHeaders(YADIS_XRDS_LOCATION).length > 1) {
                throw new YadisException("Found more than one X-XRDS-Location headers: " + resp.getResponseHeaders(YADIS_XRDS_LOCATION), 1797);
            }
            Header xrdsLocation = resp.getResponseHeader(YADIS_XRDS_LOCATION);
            if (xrdsLocation != null) {
                result.setXrdsLocation(xrdsLocation.getValue(), 1797);
                result.setNormalizedUrl(resp.getFinalUri());
            }
        }
        catch (HttpException e) {
            throw new YadisException("HTTP error during HEAD request on: " + url, 1796, e);
        }
        catch (IOException e) {
            throw new YadisException("I/O transport error: ", 1796, e);
        }
    }
}

