/*
 * Decompiled with CFR 0.152.
 */
package org.openid4java.discovery.yadis;

import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openid4java.discovery.yadis.YadisException;
import org.openid4java.discovery.yadis.YadisUrl;
import org.openxri.xml.XRDS;

public class YadisResult {
    private static Log _log = LogFactory.getLog((Class)YadisResult.class);
    private static final boolean DEBUG = _log.isDebugEnabled();
    private XRDS _xrds;
    private String _contentType;
    private YadisUrl _yadisUrl;
    private String _normalizedUrl;
    private URL _xrdsLocation;
    private boolean _success = false;
    private Throwable _failureCause;

    public void setYadisUrl(YadisUrl url) {
        this._yadisUrl = url;
    }

    public YadisUrl getYadisUrl() {
        return this._yadisUrl;
    }

    public void setXrdsLocation(String xrdsLocation, int onFailError) throws YadisException {
        URL xrdsUrl = null;
        boolean validXrdsUrl = true;
        try {
            xrdsUrl = new URL(xrdsLocation);
        }
        catch (MalformedURLException e) {
            validXrdsUrl = false;
        }
        if (xrdsUrl == null || !validXrdsUrl || !xrdsUrl.getProtocol().equals("http") && !xrdsUrl.getProtocol().equals("https")) {
            throw new YadisException("A Yadis Resource Descriptor URL MUST be an absolute URL and it must be HTTP or HTTPS; found: " + xrdsLocation, onFailError);
        }
        if (DEBUG) {
            _log.debug((Object)("Setting X-XRDS-Location for yadis result: " + xrdsLocation));
        }
        this._xrdsLocation = xrdsUrl;
    }

    public URL getXrdsLocation() {
        return this._xrdsLocation;
    }

    public void setXrds(XRDS xrds) {
        this._xrds = xrds;
    }

    public XRDS getXrds() {
        return this._xrds;
    }

    public String getNormalizedUrl() {
        return this._normalizedUrl;
    }

    public void setNormalizedUrl(String _normalizedUrl) {
        this._normalizedUrl = _normalizedUrl;
    }

    public void setContentType(String type) {
        this._contentType = type;
    }

    public String getContentType() {
        return this._contentType;
    }

    public boolean isSuccess() {
        return this._success;
    }

    public void setSuccess(boolean status) {
        this._success = status;
    }

    public void setFailureCause(Throwable e) {
        this._failureCause = e;
    }

    public Throwable getFailureCause() {
        return this._failureCause;
    }

    public String dump() {
        StringBuffer dump = new StringBuffer();
        dump.append("YadisURL:").append(this._yadisUrl);
        dump.append("\nNormalizedURL:").append(this._normalizedUrl);
        dump.append("\nX-XRDS-Location:").append(this._xrdsLocation);
        dump.append("\nContent-type:").append(this._contentType);
        dump.append("\nXRDS:\n").append(this._xrds.dump());
        return dump.toString();
    }
}

