/*
 * Decompiled with CFR 0.152.
 */
package org.openid4java.infocard;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openid4java.OpenIDException;
import org.openid4java.infocard.InfocardException;
import org.openid4java.infocard.OpenIDTokenType;
import org.openid4java.message.Message;
import org.openid4java.message.ParameterList;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class OpenIDToken {
    private static Log _log = LogFactory.getLog((Class)OpenIDToken.class);
    private static final boolean DEBUG = _log.isDebugEnabled();
    private OpenIDTokenType _tokenType;
    private Message _openidMessage;

    public OpenIDToken(Message openidMessage) {
        this.setOpenIDMessage(openidMessage);
        if (DEBUG) {
            _log.debug((Object)("Created " + this._tokenType + " token"));
        }
    }

    public static OpenIDToken createFromXmlToken(String xmlToken) throws InfocardException {
        if (xmlToken == null) {
            throw new InfocardException("Error processing xmlToken: null value");
        }
        if (DEBUG) {
            _log.debug((Object)("Processing xmlToken: " + xmlToken));
        }
        try {
            String keyValueForm;
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(new ByteArrayInputStream(xmlToken.getBytes("utf-8")));
            try {
                keyValueForm = document.getElementsByTagNameNS("http://specs.openid.net/auth/2.0", "OpenIDToken").item(0).getFirstChild().getNodeValue();
            }
            catch (Exception e) {
                throw new InfocardException("Error extracting OpenID message from the xmlToken", (Throwable)e);
            }
            Message message = Message.createMessage(ParameterList.createFromKeyValueForm(keyValueForm));
            return new OpenIDToken(message);
        }
        catch (ParserConfigurationException e) {
            throw new InfocardException("Parser configuration error", (Throwable)e);
        }
        catch (SAXException e) {
            throw new InfocardException("Error parsing XML token document", (Throwable)e);
        }
        catch (IOException e) {
            throw new InfocardException("Error reading xmlToken document", (Throwable)e);
        }
        catch (OpenIDException e) {
            throw new InfocardException("Error building OpenID message from xmlToken", (Throwable)e);
        }
    }

    public Message getOpenIDMessage() {
        return this._openidMessage;
    }

    public ParameterList getOpenIDParams() {
        return new ParameterList(this._openidMessage.getParameterMap());
    }

    public void setOpenIDMessage(Message openidMessage) {
        this._openidMessage = openidMessage;
        this._tokenType = OpenIDTokenType.OPENID20_TOKEN.toString().equals(openidMessage.getParameterValue("openid.ns")) ? OpenIDTokenType.OPENID20_TOKEN : OpenIDTokenType.OPENID11_TOKEN;
    }

    public OpenIDTokenType getTokenType() {
        return this._tokenType;
    }

    public String getToken() {
        StringBuffer token = new StringBuffer();
        token.append("<openid:OpenIDToken xmlns:openid=\"http://specs.openid.net/auth/2.0\">");
        token.append(this._openidMessage.keyValueFormEncoding());
        token.append("</openid:OpenIDToken>");
        return token.toString();
    }
}

