/*
 * Decompiled with CFR 0.152.
 */
package org.openid4java.message;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openid4java.association.AssociationException;
import org.openid4java.association.AssociationSessionType;
import org.openid4java.association.DiffieHellmanSession;
import org.openid4java.message.Message;
import org.openid4java.message.MessageException;
import org.openid4java.message.ParameterList;

public class AssociationRequest
extends Message {
    private static Log _log = LogFactory.getLog((Class)AssociationRequest.class);
    private static final boolean DEBUG = _log.isDebugEnabled();
    public static final String MODE_ASSOC = "associate";
    protected static final List requiredFields = Arrays.asList("openid.mode", "openid.session_type");
    protected static final List optionalFields = Arrays.asList("openid.ns", "openid.assoc_type", "openid.dh_modulus", "openid.dh_gen", "openid.dh_consumer_public");
    private DiffieHellmanSession _dhSess;

    protected AssociationRequest(AssociationSessionType type) {
        this(type, null);
    }

    protected AssociationRequest(AssociationSessionType type, DiffieHellmanSession dhSess) {
        if (DEBUG) {
            _log.debug((Object)("Creating association request, type: " + type + "DH session: " + dhSess));
        }
        if (type.isVersion2()) {
            this.set("openid.ns", "http://specs.openid.net/auth/2.0");
        }
        this.set("openid.mode", MODE_ASSOC);
        this.set("openid.session_type", type.getSessionType());
        this.set("openid.assoc_type", type.getAssociationType());
        this._dhSess = dhSess;
        if (dhSess != null) {
            this.set("openid.dh_consumer_public", this._dhSess.getPublicKey());
            if (!"Ag==".equals(this._dhSess.getGenerator()) || !"ANz5OguIOXLsDhmYmsWizjEOHTdxfo2Vcbt2I3MYZuYe91ouJ4mLBX+YkcLiemOcPym2CBRYHNOyyjmG0mg3BVd9RcLn5S3IHHoXGHblzqdLFEi/368Ygo79JRnxTkXjgmY0rxlJ5bU1zIKaSDuKdiI+XUkKJX8Fvf8W8vsixYOr".equals(this._dhSess.getModulus())) {
                this.set("openid.dh_gen", this._dhSess.getGenerator());
                this.set("openid.dh_modulus", this._dhSess.getModulus());
            }
        }
    }

    protected AssociationRequest(ParameterList params) {
        super(params);
    }

    public static AssociationRequest createAssociationRequest(AssociationSessionType type) throws MessageException {
        return AssociationRequest.createAssociationRequest(type, null);
    }

    public static AssociationRequest createAssociationRequest(AssociationSessionType type, DiffieHellmanSession dhSess) throws MessageException {
        AssociationRequest req = new AssociationRequest(type, dhSess);
        if (type == null || dhSess == null && type.getHAlgorithm() != null || dhSess != null && !dhSess.getType().equals(type)) {
            throw new MessageException("Invalid association / session combination specified: " + type + "DH session: " + dhSess);
        }
        req.validate();
        if (DEBUG) {
            _log.debug((Object)("Created association request:\n" + req.keyValueFormEncoding()));
        }
        return req;
    }

    public static AssociationRequest createAssociationRequest(ParameterList params) throws MessageException {
        AssociationRequest req = new AssociationRequest(params);
        req.validate();
        if (DEBUG) {
            _log.debug((Object)("Created association request from message parameters:\n" + req.keyValueFormEncoding()));
        }
        return req;
    }

    public List getRequiredFields() {
        return requiredFields;
    }

    public boolean isVersion2() {
        return this.hasParameter("openid.ns") && "http://specs.openid.net/auth/2.0".equals(this.getParameterValue("openid.ns"));
    }

    private String getAssociationType() {
        return this.getParameterValue("openid.assoc_type");
    }

    private String getSessionType() {
        return this.getParameterValue("openid.session_type");
    }

    public AssociationSessionType getType() throws AssociationException {
        return AssociationSessionType.create(this.getSessionType(), this.getAssociationType(), !this.isVersion2());
    }

    public DiffieHellmanSession getDHSess() {
        return this._dhSess;
    }

    public String getDhModulus() {
        String modulus = this.getParameterValue("openid.dh_modulus");
        return modulus != null ? modulus : (this.hasParameter("openid.dh_consumer_public") ? "ANz5OguIOXLsDhmYmsWizjEOHTdxfo2Vcbt2I3MYZuYe91ouJ4mLBX+YkcLiemOcPym2CBRYHNOyyjmG0mg3BVd9RcLn5S3IHHoXGHblzqdLFEi/368Ygo79JRnxTkXjgmY0rxlJ5bU1zIKaSDuKdiI+XUkKJX8Fvf8W8vsixYOr" : null);
    }

    public String getDhGen() {
        String gen = this.getParameterValue("openid.dh_gen");
        return gen != null ? gen : (this.hasParameter("openid.dh_consumer_public") ? "Ag==" : null);
    }

    public String getDhPublicKey() {
        return this.getParameterValue("openid.dh_consumer_public");
    }

    public void validate() throws MessageException {
        AssociationSessionType type;
        super.validate();
        try {
            type = this.getType();
            if (type.isVersion2() != this.isVersion2()) {
                throw new MessageException("Protocol verison mismatch between association session type: " + type + " and AssociationRequest message type.", 512);
            }
        }
        catch (AssociationException e) {
            throw new MessageException("Error verifying association request validity.", 512, e);
        }
        if (!this.isVersion2() && this.getSessionType() == null) {
            throw new MessageException("sess_type cannot be omitted in OpenID1 association requests", 512);
        }
        if (type.getHAlgorithm() != null && this.getDhPublicKey() == null) {
            throw new MessageException("DH consumer public key not specified.", 512);
        }
        if (type.getHAlgorithm() == null && (this.getDhGen() != null || this.getDhModulus() != null || this.getDhPublicKey() != null)) {
            throw new MessageException("No-encryption session, but DH parameters specified.", 512);
        }
    }
}

