/*
 * Decompiled with CFR 0.152.
 */
package org.openid4java.message;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openid4java.association.Association;
import org.openid4java.association.AssociationException;
import org.openid4java.association.AssociationSessionType;
import org.openid4java.association.DiffieHellmanSession;
import org.openid4java.message.AssociationRequest;
import org.openid4java.message.Message;
import org.openid4java.message.MessageException;
import org.openid4java.message.ParameterList;

public class AssociationResponse
extends Message {
    private static Log _log = LogFactory.getLog((Class)AssociationResponse.class);
    private static final boolean DEBUG = _log.isDebugEnabled();
    protected static final List requiredFields = Arrays.asList("assoc_type", "assoc_handle", "expires_in");
    protected static final List optionalFields = Arrays.asList("ns", "session_type", "mac_key", "enc_mac_key", "dh_server_public");

    protected AssociationResponse(AssociationRequest assocReq, Association assoc) throws AssociationException {
        if (DEBUG) {
            _log.debug((Object)("Creating association response, type: " + assocReq.getType() + " association handle: " + assoc.getHandle()));
        }
        if (assocReq.isVersion2()) {
            this.set("ns", "http://specs.openid.net/auth/2.0");
        }
        AssociationSessionType type = assocReq.getType();
        this.setType(type);
        this.setAssocHandle(assoc.getHandle());
        Long expiryIn = new Long((assoc.getExpiry().getTime() - System.currentTimeMillis()) / 1000L);
        this.setExpire(expiryIn);
        if (type.getHAlgorithm() != null) {
            DiffieHellmanSession dhSess = DiffieHellmanSession.create(type, assocReq.getDhModulus(), assocReq.getDhGen());
            this.setPublicKey(dhSess.getPublicKey());
            this.setMacKeyEnc(dhSess.encryptMacKey(assoc.getMacKey().getEncoded(), assocReq.getDhPublicKey()));
        } else {
            this.setMacKey(new String(Base64.encodeBase64((byte[])assoc.getMacKey().getEncoded())));
        }
    }

    protected AssociationResponse(ParameterList params) {
        super(params);
    }

    public static AssociationResponse createAssociationResponse(AssociationRequest assocReq, Association assoc) throws MessageException, AssociationException {
        AssociationResponse resp = new AssociationResponse(assocReq, assoc);
        resp.validate();
        if (DEBUG) {
            _log.debug((Object)("Created association response:\n" + resp.keyValueFormEncoding()));
        }
        return resp;
    }

    public static AssociationResponse createAssociationResponse(ParameterList params) throws MessageException {
        AssociationResponse resp = new AssociationResponse(params);
        resp.validate();
        if (DEBUG) {
            _log.debug((Object)("Created association response from message parameters:\n" + resp.keyValueFormEncoding()));
        }
        return resp;
    }

    public List getRequiredFields() {
        return requiredFields;
    }

    public boolean isVersion2() {
        return this.hasParameter("ns") && "http://specs.openid.net/auth/2.0".equals(this.getParameterValue("ns"));
    }

    private String getAssociationType() {
        return this.getParameterValue("assoc_type");
    }

    private String getSessionType() {
        return this.getParameterValue("session_type");
    }

    public void setType(AssociationSessionType type) {
        this.set("session_type", type.getSessionType());
        this.set("assoc_type", type.getAssociationType());
    }

    public AssociationSessionType getType() throws AssociationException {
        return AssociationSessionType.create(this.getSessionType(), this.getAssociationType(), !this.isVersion2());
    }

    public void setAssocHandle(String handle) {
        this.set("assoc_handle", handle);
    }

    public void setExpire(Long seconds) {
        this.set("expires_in", seconds.toString());
    }

    public void setMacKey(String key) {
        this.set("mac_key", key);
    }

    public void setPublicKey(String key) {
        this.set("dh_server_public", key);
    }

    public void setMacKeyEnc(String key) {
        this.set("enc_mac_key", key);
    }

    public void validate() throws MessageException {
        String macKey;
        AssociationSessionType type;
        super.validate();
        try {
            type = this.getType();
            if (type.isVersion2() ^ this.isVersion2()) {
                throw new MessageException("Protocol verison mismatch between association session type: " + type + " and AssociationResponse message type.", 512);
            }
        }
        catch (AssociationException e) {
            throw new MessageException("Error verifying association response validity.", 512, e);
        }
        if (!this.isVersion2() && this.getAssociationType() == null) {
            throw new MessageException("assoc_type cannot be omitted in OpenID1 responses", 512);
        }
        if (type.getHAlgorithm() != null) {
            if (!this.hasParameter("dh_server_public") || !this.hasParameter("enc_mac_key")) {
                throw new MessageException("DH public key or encrypted MAC key missing.", 512);
            }
            macKey = this.getParameterValue("enc_mac_key");
        } else {
            if (!this.hasParameter("mac_key")) {
                throw new MessageException("Missing MAC key.", 512);
            }
            macKey = this.getParameterValue("mac_key");
        }
        int macSize = Base64.decodeBase64((byte[])macKey.getBytes()).length * 8;
        if (macSize != type.getKeySize()) {
            throw new MessageException("MAC key size: " + macSize + " doesn't match the association/session type: " + type, 512);
        }
    }

    public Association getAssociation(DiffieHellmanSession dhSess) throws AssociationException {
        Association assoc;
        byte[] macKey;
        if (DEBUG) {
            _log.debug((Object)"Retrieving MAC key from association response...");
        }
        String handle = this.getParameterValue("assoc_handle");
        int expiresIn = Integer.parseInt(this.getParameterValue("expires_in"));
        AssociationSessionType type = this.getType();
        if (type.getHAlgorithm() != null) {
            macKey = dhSess.decryptMacKey(this.getParameterValue("enc_mac_key"), this.getParameterValue("dh_server_public"));
            if (DEBUG) {
                _log.debug((Object)("Decrypted MAC key (base64): " + new String(Base64.encodeBase64((byte[])macKey))));
            }
        } else {
            macKey = Base64.decodeBase64((byte[])this.getParameterValue("mac_key").getBytes());
            if (DEBUG) {
                _log.debug((Object)("Unencrypted MAC key (base64): " + this.getParameterValue("mac_key")));
            }
        }
        if ("HMAC-SHA1".equals(type.getAssociationType())) {
            assoc = Association.createHmacSha1(handle, macKey, expiresIn);
        } else if ("HMAC-SHA256".equals(type.getAssociationType())) {
            assoc = Association.createHmacSha256(handle, macKey, expiresIn);
        } else {
            throw new AssociationException("Unknown association type: " + type);
        }
        if (DEBUG) {
            _log.debug((Object)("Created association for handle: " + handle));
        }
        return assoc;
    }
}

