/*
 * Decompiled with CFR 0.152.
 */
package org.openid4java.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openid4java.util.HttpClientFactory;
import org.openid4java.util.HttpRequestOptions;
import org.openid4java.util.HttpResponse;

public class HttpCache {
    private static Log _log = LogFactory.getLog((Class)HttpCache.class);
    private static final boolean DEBUG = _log.isDebugEnabled();
    private HttpClient _client;
    private HttpRequestOptions _defaultOptions = new HttpRequestOptions();
    private Map _getCache = new HashMap();
    private Map _headCache = new HashMap();

    public HttpCache() {
        this._client = HttpClientFactory.getInstance(this._defaultOptions.getMaxRedirects(), Boolean.TRUE, this._defaultOptions.getSocketTimeout(), this._defaultOptions.getConnTimeout(), "ignoreCookies");
    }

    public HttpRequestOptions getDefaultRequestOptions() {
        return this._defaultOptions;
    }

    public HttpRequestOptions getRequestOptions() {
        return new HttpRequestOptions(this._defaultOptions);
    }

    public void setDefaultRequestOptions(HttpRequestOptions defaultOptions) {
        this._defaultOptions = defaultOptions;
    }

    public void removeGet(String url) {
        if (this._getCache.keySet().contains(url)) {
            _log.info((Object)("Removing cached GET response for " + url));
            this._getCache.remove(url);
        } else {
            _log.info((Object)("NOT removing cached GET for " + url + " NOT FOUND."));
        }
    }

    public HttpResponse get(String url) throws IOException {
        return this.get(url, this._defaultOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpResponse get(String url, HttpRequestOptions requestOptions) throws IOException {
        HttpResponse resp = (HttpResponse)this._getCache.get(url);
        if (resp != null) {
            if (this.match(resp, requestOptions)) {
                _log.info((Object)("Returning cached GET response for " + url));
                return resp;
            }
            _log.info((Object)("Removing cached GET for " + url));
            this.removeGet(url);
        }
        GetMethod get = new GetMethod(url);
        try {
            get.setFollowRedirects(true);
            this._client.getParams().setParameter("http.protocol.max-redirects", (Object)new Integer(requestOptions.getMaxRedirects()));
            this._client.getParams().setSoTimeout(requestOptions.getSocketTimeout());
            this._client.getHttpConnectionManager().getParams().setConnectionTimeout(requestOptions.getConnTimeout());
            Map requestHeaders = requestOptions.getRequestHeaders();
            if (requestHeaders != null) {
                Iterator iter = requestHeaders.keySet().iterator();
                while (iter.hasNext()) {
                    String headerName = (String)iter.next();
                    get.setRequestHeader(headerName, (String)requestHeaders.get(headerName));
                }
            }
            int statusCode = this._client.executeMethod((HttpMethod)get);
            String statusLine = get.getStatusLine().toString();
            String httpBody = null;
            boolean bodySizeExceeded = false;
            int maxBodySize = requestOptions.getMaxBodySize();
            InputStream httpBodyInput = get.getResponseBodyAsStream();
            if (httpBodyInput != null) {
                int totalRead;
                int currentRead;
                byte[] data = new byte[maxBodySize];
                for (totalRead = 0; totalRead < maxBodySize && (currentRead = httpBodyInput.read(data, totalRead, maxBodySize - totalRead)) != -1; totalRead += currentRead) {
                }
                if (httpBodyInput.read() > 0) {
                    bodySizeExceeded = true;
                }
                httpBodyInput.close();
                if (DEBUG) {
                    _log.debug((Object)("Read " + totalRead + " bytes."));
                }
                httpBody = new String(data, 0, totalRead);
            }
            resp = new HttpResponse(statusCode, statusLine, requestOptions.getMaxRedirects(), get.getURI().toString(), get.getResponseHeaders(), httpBody);
            resp.setBodySizeExceeded(bodySizeExceeded);
            this._getCache.put(url, resp);
        }
        finally {
            get.releaseConnection();
        }
        return resp;
    }

    private boolean match(HttpResponse resp, HttpRequestOptions requestOptions) {
        Header responseContentType;
        if (resp != null && !requestOptions.isUseCache()) {
            _log.info((Object)"Explicit fresh GET requested; removing cached copy");
            return false;
        }
        String requiredContentType = requestOptions.getContentType();
        if (resp != null && requiredContentType != null && (responseContentType = resp.getResponseHeader("content-type")) != null && responseContentType.getValue() != null && !responseContentType.getValue().split(";")[0].equalsIgnoreCase(requiredContentType)) {
            _log.info((Object)"Cached GET response does not match the required content type, removing.");
            return false;
        }
        if (resp != null && resp.getMaxRedirectsFollowed() > requestOptions.getMaxRedirects()) {
            _log.info((Object)("Cached GET response used " + resp.getMaxRedirectsFollowed() + " max redirects; current requirement is: " + requestOptions.getMaxRedirects()));
            return false;
        }
        return true;
    }

    public HttpResponse head(String url) throws IOException {
        return this.head(url, this._defaultOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpResponse head(String url, HttpRequestOptions requestOptions) throws IOException {
        HttpResponse resp = (HttpResponse)this._headCache.get(url);
        if (resp != null) {
            if (this.match(resp, requestOptions)) {
                _log.info((Object)("Returning cached HEAD response for " + url));
                return resp;
            }
            _log.info((Object)("Removing cached HEAD for " + url));
            this.removeGet(url);
        }
        HeadMethod head = new HeadMethod(url);
        try {
            head.setFollowRedirects(true);
            this._client.getParams().setParameter("http.protocol.max-redirects", (Object)new Integer(requestOptions.getMaxRedirects()));
            this._client.getParams().setSoTimeout(requestOptions.getSocketTimeout());
            this._client.getHttpConnectionManager().getParams().setConnectionTimeout(requestOptions.getConnTimeout());
            int statusCode = this._client.executeMethod((HttpMethod)head);
            String statusLine = head.getStatusLine().toString();
            resp = new HttpResponse(statusCode, statusLine, requestOptions.getMaxRedirects(), head.getURI().toString(), head.getResponseHeaders(), null);
            this._headCache.put(url, resp);
        }
        finally {
            head.releaseConnection();
        }
        return resp;
    }
}

