/*
 * Decompiled with CFR 0.152.
 */
package com.gammastream.gammacore;

import com.gammastream.gammacore.GSDatedObjectWrapper;
import com.gammastream.gammacore.GSPingable;
import com.gammastream.gammacore.GSPinger;
import java.util.Enumeration;
import java.util.Hashtable;

public class GSVolatileHashtable
extends Hashtable
implements GSPingable {
    private long expireTime;
    private GSPinger cleaner;

    public GSVolatileHashtable(long expireTime) {
        this.expireTime = expireTime;
        this.cleaner = new GSPinger(this, (long)((double)expireTime * 0.75));
        this.cleaner.start();
    }

    public synchronized Object put(Object key, Object value) {
        GSDatedObjectWrapper obj = super.put(key, new GSDatedObjectWrapper(value));
        return obj;
    }

    public synchronized Object get(Object key) {
        GSDatedObjectWrapper wrap = (GSDatedObjectWrapper)super.get(key);
        if (wrap != null) {
            return wrap.getObject();
        }
        return null;
    }

    public synchronized void ping() {
        Enumeration e = super.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            GSDatedObjectWrapper wrap = (GSDatedObjectWrapper)super.get(key);
            if (wrap == null || wrap.getAge() <= this.expireTime) continue;
            this.remove(key);
        }
        System.gc();
    }
}

