/*
 * Decompiled with CFR 0.152.
 */
package com.gammastream.gammacore.gammatext;

import com.gammastream.gammacore.GSArrayUtilities;
import com.gammastream.gammacore.GSRange;
import com.gammastream.gammacore.gammatext.GSTextConstants;
import java.util.Vector;

public final class GSTextUtilities {
    private GSTextUtilities() {
    }

    public static String toUpperCase(String oldString) {
        return oldString.toUpperCase();
    }

    public static String toLowerCase(String oldString) {
        return oldString.toLowerCase();
    }

    public static String reverse(String oldString) {
        char[] chars = oldString.toCharArray();
        GSArrayUtilities.reverseCharArray(chars);
        return new String(chars);
    }

    public static int asciiValueOfChar(char aChar) {
        return aChar;
    }

    public static int asciiValue(String aString) {
        return aString.charAt(0);
    }

    public static String stringForAsciiValue(int aValue) {
        return (char)aValue + "";
    }

    public static boolean isAlphaNumeric(String aString) {
        char[] chars = aString.toCharArray();
        int i = 0;
        while (i < chars.length) {
            if (!Character.isLetterOrDigit(chars[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static final String stringStrippedOfHTML(String str) {
        StringBuffer s = new StringBuffer(100);
        Vector tag = null;
        Vector components = GSTextUtilities.split("<", str);
        int i = 0;
        while (i < components.size()) {
            tag = GSTextUtilities.split(">", (String)components.elementAt(i));
            if (tag.size() == 2) {
                s.append((String)tag.elementAt(1));
            } else {
                s.append((String)components.elementAt(0));
            }
            ++i;
        }
        return s.toString();
    }

    public static boolean isAlphabetic(String aString) {
        char[] chars = aString.toCharArray();
        int i = 0;
        while (i < chars.length) {
            if (!Character.isLetter(chars[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String replaceStringWithStringInString(String oldString, String newString, String inString) {
        int lastIndex = 0;
        int index = 0;
        int oldStringLength = oldString.length();
        int inStringLength = inString.length();
        StringBuffer sb = new StringBuffer(inStringLength);
        while ((index = inString.indexOf(oldString, index)) > -1) {
            sb.append(inString.substring(lastIndex, index));
            sb.append(newString);
            lastIndex = index += oldStringLength;
        }
        if (lastIndex < inStringLength) {
            sb.append(inString.substring(lastIndex, inStringLength));
        }
        return sb.toString();
    }

    public static String chop(String str, int length) {
        if (str.length() < length) {
            return str;
        }
        return str.substring(0, length);
    }

    public static String truncate(String str, int length) {
        int strLength = str.length();
        if (strLength < length) {
            return str;
        }
        String string = str.substring(0, length);
        String reverseString = GSTextUtilities.reverse(string);
        int space = reverseString.indexOf(GSTextConstants.SPACE_STRING);
        if (space != -1) {
            reverseString = reverseString.substring(space, length);
            return GSTextUtilities.reverse(reverseString);
        }
        return string;
    }

    public static Vector split(String token, String string) {
        Vector<String> v = new Vector<String>();
        int lastIndex = 0;
        int index = 0;
        int oldStringLength = token.length();
        int inStringLength = string.length();
        while ((index = string.indexOf(token, index)) > -1) {
            v.addElement(string.substring(lastIndex, index));
            lastIndex = index += oldStringLength;
        }
        if (lastIndex < inStringLength) {
            v.addElement(string.substring(lastIndex, inStringLength));
        }
        return v;
    }

    public static String join(String token, Vector strings) {
        StringBuffer sb = new StringBuffer();
        int len = strings.size() - 1;
        int x = 0;
        while (x < len) {
            sb.append((String)strings.elementAt(x));
            sb.append(token);
            ++x;
        }
        if (strings.size() > 0) {
            sb.append((String)strings.lastElement());
        }
        return sb.toString();
    }

    public static String extract(String string, Vector ranges) {
        char[] chars = string.toCharArray();
        StringBuffer buffer = new StringBuffer(chars.length);
        GSRange range = null;
        int i = 0;
        while (i < chars.length) {
            char currentChar = chars[i];
            int x = 0;
            while (x < ranges.size()) {
                range = (GSRange)ranges.elementAt(x);
                if (currentChar >= range.startIndex() && currentChar <= range.stopIndex()) {
                    buffer.append(chars[i]);
                }
                ++x;
            }
            ++i;
        }
        return buffer.toString();
    }

    public static boolean isStringEmpty(String str) {
        boolean returnValue = false;
        if (str == null) {
            returnValue = true;
        } else {
            Vector v = GSTextUtilities.split(GSTextConstants.SPACE_STRING, str);
            String str2 = GSTextUtilities.join("", v);
            if ("".equals(str2)) {
                returnValue = true;
            }
        }
        return returnValue;
    }

    public static final String escapeHTML(String s) {
        StringBuffer sb = new StringBuffer();
        int n = s.length();
        int i = 0;
        while (i < n) {
            char c = s.charAt(i);
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    break;
                }
                case '>': {
                    sb.append("&gt;");
                    break;
                }
                case '&': {
                    sb.append("&amp;");
                    break;
                }
                case '\"': {
                    sb.append("&quot;");
                    break;
                }
                case '\u00e0': {
                    sb.append("&agrave;");
                    break;
                }
                case '\u00c0': {
                    sb.append("&Agrave;");
                    break;
                }
                case '\u00e2': {
                    sb.append("&acirc;");
                    break;
                }
                case '\u00c2': {
                    sb.append("&Acirc;");
                    break;
                }
                case '\u00e4': {
                    sb.append("&auml;");
                    break;
                }
                case '\u00c4': {
                    sb.append("&Auml;");
                    break;
                }
                case '\u00e5': {
                    sb.append("&aring;");
                    break;
                }
                case '\u00c5': {
                    sb.append("&Aring;");
                    break;
                }
                case '\u00e6': {
                    sb.append("&aelig;");
                    break;
                }
                case '\u00c6': {
                    sb.append("&AElig;");
                    break;
                }
                case '\u00e7': {
                    sb.append("&ccedil;");
                    break;
                }
                case '\u00c7': {
                    sb.append("&Ccedil;");
                    break;
                }
                case '\u00e9': {
                    sb.append("&eacute;");
                    break;
                }
                case '\u00c9': {
                    sb.append("&Eacute;");
                    break;
                }
                case '\u00e8': {
                    sb.append("&egrave;");
                    break;
                }
                case '\u00c8': {
                    sb.append("&Egrave;");
                    break;
                }
                case '\u00ea': {
                    sb.append("&ecirc;");
                    break;
                }
                case '\u00ca': {
                    sb.append("&Ecirc;");
                    break;
                }
                case '\u00eb': {
                    sb.append("&euml;");
                    break;
                }
                case '\u00cb': {
                    sb.append("&Euml;");
                    break;
                }
                case '\u00ef': {
                    sb.append("&iuml;");
                    break;
                }
                case '\u00cf': {
                    sb.append("&Iuml;");
                    break;
                }
                case '\u00f4': {
                    sb.append("&ocirc;");
                    break;
                }
                case '\u00d4': {
                    sb.append("&Ocirc;");
                    break;
                }
                case '\u00f6': {
                    sb.append("&ouml;");
                    break;
                }
                case '\u00d6': {
                    sb.append("&Ouml;");
                    break;
                }
                case '\u00f8': {
                    sb.append("&oslash;");
                    break;
                }
                case '\u00d8': {
                    sb.append("&Oslash;");
                    break;
                }
                case '\u00df': {
                    sb.append("&szlig;");
                    break;
                }
                case '\u00f9': {
                    sb.append("&ugrave;");
                    break;
                }
                case '\u00d9': {
                    sb.append("&Ugrave;");
                    break;
                }
                case '\u00fb': {
                    sb.append("&ucirc;");
                    break;
                }
                case '\u00db': {
                    sb.append("&Ucirc;");
                    break;
                }
                case '\u00fc': {
                    sb.append("&uuml;");
                    break;
                }
                case '\u00dc': {
                    sb.append("&Uuml;");
                    break;
                }
                case '\u00ae': {
                    sb.append("&reg;");
                    break;
                }
                case '\u00a9': {
                    sb.append("&copy;");
                    break;
                }
                case '\u20ac': {
                    sb.append("&euro;");
                    break;
                }
                default: {
                    sb.append(c);
                }
            }
            ++i;
        }
        return sb.toString();
    }
}

