/*
 * Decompiled with CFR 0.152.
 */
package er.googlechart.util;

import er.googlechart.util.GCMappedEncoding;

public class GCExtendedEncoding
extends GCMappedEncoding {
    private static String EXTENDED_ENCODING = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-.";

    protected String encodingKey() {
        return "e";
    }

    protected int numberOfEncodingValues() {
        return 4096;
    }

    protected String missingValue() {
        return "__";
    }

    protected String encode(int value) {
        if (value < 0 || value >= this.numberOfEncodingValues()) {
            throw new IllegalArgumentException("The value " + value + " cannot be encoded with Extended Encoding.");
        }
        int numberOfRows = EXTENDED_ENCODING.length();
        int row = value / numberOfRows;
        int col = value % numberOfRows;
        return String.valueOf(EXTENDED_ENCODING.charAt(row)) + String.valueOf(EXTENDED_ENCODING.charAt(col));
    }
}

