/*
 * Decompiled with CFR 0.152.
 */
package er.googlechart.util;

import er.googlechart.util.GCAbstractEncoding;
import er.googlechart.util.GCEncoding;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GCMappedEncoding
extends GCAbstractEncoding {
    @Override
    public boolean canEncode(boolean normalize, List<List<Number>> dataSets) {
        int maxValue;
        boolean canEncode = true;
        boolean hasDecimals = GCEncoding.hasDecimalInLists(dataSets);
        canEncode = hasDecimals ? false : (maxValue = (int)GCEncoding.maxValueInLists(dataSets)) < this.numberOfEncodingValues();
        return canEncode;
    }

    @Override
    public boolean canEncode(Number maxValue, List<List<Number>> dataSets) {
        return this.canEncode(true, dataSets);
    }

    protected abstract String encode(int var1);

    protected abstract int numberOfEncodingValues();

    protected abstract String missingValue();

    @Override
    protected String separator() {
        return ",";
    }

    @Override
    protected String _encode(Number maxValue, List<Number> dataSet) {
        StringBuffer sb = new StringBuffer();
        if (dataSet != null) {
            int numberOfEncodingValues = this.numberOfEncodingValues();
            for (Number number : dataSet) {
                int value;
                if (number == null) {
                    sb.append(this.missingValue());
                    continue;
                }
                if (number.intValue() < 0) {
                    throw new IllegalArgumentException("The negative number " + number + " is not allowed in this encoding.");
                }
                if (maxValue == null || numberOfEncodingValues == Integer.MAX_VALUE) {
                    value = number.intValue();
                } else {
                    if (maxValue != null && number.intValue() > maxValue.intValue()) {
                        throw new IllegalArgumentException("The value " + number + " is greater than the provided max value " + maxValue + ".");
                    }
                    value = Math.round((float)(numberOfEncodingValues - 1) * number.floatValue() / maxValue.floatValue());
                }
                sb.append(this.encode(value));
            }
        }
        return sb.toString();
    }
}

