/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation.xml;

import com.webobjects.foundation.NSBundle;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSProperties;
import com.webobjects.foundation.xml._NSErrorHandler;
import com.webobjects.foundation.xml._NSTransformHandler;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.io.NotActiveException;
import java.io.ObjectInputStream;
import java.io.ObjectInputValidation;
import java.io.OptionalDataException;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public final class NSXMLInputStream
extends ObjectInputStream {
    private static final SAXParserFactory _FACTORY;
    private static final String _WOXML_SCHEMA_PATH;
    private static final String VALIDATION_FLAG = "NSXMLValidation";
    private XMLReader _reader;
    private _NSErrorHandler _errHandler;
    private ObjectInputStream _oi;

    private OutputStream initParser(InputStream in) throws IOException {
        try {
            this._reader = _FACTORY.newSAXParser().getXMLReader();
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e.getMessage());
        }
        catch (SAXException e) {
            throw new IOException(e.getMessage());
        }
        _NSTransformHandler handler = new _NSTransformHandler();
        try {
            this._reader.setProperty("http://xml.org/sax/properties/lexical-handler", handler);
            String value = NSProperties.getProperty(VALIDATION_FLAG, "false").toLowerCase();
            boolean validate = value.equals("true") || value.equals("yes");
            this._reader.setFeature("http://xml.org/sax/features/validation", validate);
            this._reader.setFeature("http://xml.org/sax/features/namespaces", validate);
            if (validate && _WOXML_SCHEMA_PATH != null) {
                this._reader.setProperty("http://apache.org/xml/properties/schema/external-schemaLocation", "http://www.apple.com/webobjects/XMLSerialization " + _WOXML_SCHEMA_PATH);
            }
            this._reader.setFeature("http://apache.org/xml/features/validation/schema", validate);
        }
        catch (SAXNotRecognizedException e) {
            throw new IOException(e.getMessage());
        }
        catch (SAXNotSupportedException e) {
            throw new IOException(e.getMessage());
        }
        this._reader.setContentHandler(handler);
        this._errHandler = new _NSErrorHandler(handler.transformedData());
        this._reader.setErrorHandler(this._errHandler);
        return handler.transformedData();
    }

    public NSXMLInputStream(InputStream in) throws IOException, StreamCorruptedException {
        ByteArrayOutputStream baos = (ByteArrayOutputStream)this.initParser(in);
        try {
            this._reader.parse(new InputSource(in));
        }
        catch (SAXException e) {
            throw new NSForwardException(e);
        }
        this._oi = new ObjectInputStream(new ByteArrayInputStream(baos.toByteArray()));
    }

    public void registerValidation(ObjectInputValidation obj, int prio) throws NotActiveException, InvalidObjectException {
        this._oi.registerValidation(obj, prio);
    }

    public void defaultReadObject() throws IOException, ClassNotFoundException {
        this._oi.defaultReadObject();
    }

    protected Object readObjectOverride() throws OptionalDataException, ClassNotFoundException, IOException {
        return this._oi.readObject();
    }

    public ObjectInputStream.GetField readFields() throws IOException, ClassNotFoundException {
        return this._oi.readFields();
    }

    public int read() throws IOException {
        return this._oi.read();
    }

    public int read(byte[] buf, int off, int len) throws IOException {
        return this._oi.read(buf, off, len);
    }

    public void readFully(byte[] buf) throws IOException {
        this._oi.readFully(buf);
    }

    public void readFully(byte[] buf, int off, int len) throws IOException {
        this._oi.readFully(buf, off, len);
    }

    public boolean readBoolean() throws IOException {
        return this._oi.readBoolean();
    }

    public byte readByte() throws IOException {
        return this._oi.readByte();
    }

    public int readUnsignedByte() throws IOException {
        return this._oi.readUnsignedByte();
    }

    public short readShort() throws IOException {
        return this._oi.readShort();
    }

    public char readChar() throws IOException {
        return this._oi.readChar();
    }

    public int readUnsignedShort() throws IOException {
        return this._oi.readUnsignedShort();
    }

    public int readInt() throws IOException {
        return this._oi.readInt();
    }

    public long readLong() throws IOException {
        return this._oi.readLong();
    }

    public float readFloat() throws IOException {
        return this._oi.readFloat();
    }

    public double readDouble() throws IOException {
        return this._oi.readDouble();
    }

    public int skipBytes(int len) throws IOException {
        return this._oi.skipBytes(len);
    }

    public String readLine() throws IOException {
        throw new IOException("This method is not implemented in this release as it has been deprecated as of JDK 1.3");
    }

    public String readUTF() throws IOException {
        return this._oi.readUTF();
    }

    public int available() throws IOException {
        return this._oi.available();
    }

    public void close() throws IOException {
        this._oi.close();
    }

    static {
        URL url;
        _FACTORY = SAXParserFactory.newInstance();
        String schemaPath = null;
        NSBundle foundation = NSBundle.bundleForName("JavaFoundation");
        if (foundation != null && (url = foundation.pathURLForResourcePath(foundation.resourcePathForLocalizedResourceNamed("woxml.xsd", ""))) != null) {
            schemaPath = url.toString();
        }
        _WOXML_SCHEMA_PATH = schemaPath;
    }
}

