/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation.xml;

import com.webobjects.foundation._NSBase64;
import com.webobjects.foundation._NSUtilities;
import com.webobjects.foundation.xml.NSXMLObjectStreamConstants;
import com.webobjects.foundation.xml._NSFieldTxr;
import com.webobjects.foundation.xml._NSTagTransformer;
import com.webobjects.foundation.xml._NSTransformHandler;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.StreamCorruptedException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import org.xml.sax.Attributes;

final class _NSArrayTxr
extends _NSTagTransformer
implements NSXMLObjectStreamConstants {
    private static WeakHashMap suidMap = new WeakHashMap();
    private static final String DELIMITER = " \r\n";
    private String _idRef;
    private _NSTagTransformer.CharArray _EDBs;
    private int _len;
    private char[] _typeCode = new char[1];
    private _NSTagTransformer.CharArray _typeCodes;
    private int _stackLevel;
    private boolean _isPrimitive;

    private static long computeArraySUID(String typeName) {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            DataOutputStream dout = new DataOutputStream(bout);
            dout.writeUTF(typeName);
            Class cl = _NSUtilities._ObjectArrayClass;
            int classMods = cl.getModifiers() & 0x611;
            dout.writeInt(classMods);
            MessageDigest md = MessageDigest.getInstance("SHA");
            byte[] hashBytes = md.digest(bout.toByteArray());
            long hash = 0L;
            for (int i = Math.min(hashBytes.length, 8) - 1; i >= 0; --i) {
                hash = hash << 8 | (long)(hashBytes[i] & 0xFF);
            }
            return hash;
        }
        catch (IOException ex) {
            throw new InternalError();
        }
        catch (NoSuchAlgorithmException ex) {
            throw new SecurityException(ex.getMessage());
        }
    }

    public _NSArrayTxr(_NSTransformHandler handler) {
        super(handler);
        int stackLevel = 5;
        this._typeCodes = new _NSTagTransformer.CharArray(5);
        this._EDBs = new _NSTagTransformer.CharArray(5);
    }

    protected boolean isFullObject(Attributes attributes) throws IOException {
        this._idRef = attributes.getValue("idRef");
        if (this._idRef != null) {
            this.handler._bdos.setBlockDataMode(false);
            this.handler.writeReference(this._idRef);
            return false;
        }
        String id = attributes.getValue("id");
        this._isPrimitive = id == null;
        try {
            this._len = Integer.parseInt(attributes.getValue("length"));
        }
        catch (NumberFormatException e) {
            if (id == null) {
                this.handler._bdos.setBlockDataMode(false);
                this.handler.write((byte)112);
                return false;
            }
            throw new StreamCorruptedException(e.getMessage());
        }
        return true;
    }

    public void handleStart(String tag, Attributes attributes) throws IOException {
        this.getNumEndDataBlock(attributes);
        this._EDBs.put(this._stackLevel, (char)this.numEDB);
        if (!this.isFullObject(attributes)) {
            ++this._stackLevel;
            return;
        }
        String type = attributes.getValue("type");
        String typeName = _NSFieldTxr.arrayClassSignature(type, this._typeCode);
        this._typeCodes.put(this._stackLevel++, this._typeCode[0]);
        if (this._isPrimitive) {
            this.handler._bdos.setBlockDataMode(true);
            return;
        }
        this.handler._bdos.setBlockDataMode(false);
        this.handler.write((byte)117);
        this.handler.write((byte)114);
        this.handler.write(typeName);
        Long Suid = (Long)suidMap.get(typeName);
        if (Suid != null) {
            this.handler.write(Suid);
        } else {
            long suid = _NSArrayTxr.computeArraySUID(typeName);
            suidMap.put(typeName, new Long(suid));
            this.handler.write(suid);
        }
        this.handler.write((byte)2);
        this.handler.write((short)0);
        this.handler.write((byte)120);
        this.handler.write((byte)112);
        this.handler.write(this._len);
    }

    public void handleEnd(String tag, String data) throws IOException {
        --this._stackLevel;
        if (this._idRef == null) {
            this._typeCode[0] = this._typeCodes.get(this._stackLevel);
            if (this._typeCode[0] != 'L') {
                StringTokenizer tokenizer = new StringTokenizer(data, DELIMITER);
                try {
                    switch (this._typeCode[0]) {
                        case 'Z': {
                            byte[] b = new byte[this._len];
                            int i = 0;
                            while (tokenizer.hasMoreElements()) {
                                b[i++] = ((String)tokenizer.nextElement()).equals("true") ? (byte)1 : 0;
                            }
                            this.handler.write(b);
                            break;
                        }
                        case 'B': {
                            byte[] b = new byte[this._len];
                            int i = 0;
                            while (tokenizer.hasMoreElements()) {
                                b[i++] = Byte.parseByte((String)tokenizer.nextElement());
                            }
                            if (!this._isPrimitive) {
                                this.handler.write(b);
                                break;
                            }
                            this.handler._bdos.write(b);
                            break;
                        }
                        case '6': {
                            byte[] b = data.getBytes("US-ASCII");
                            if (!this._isPrimitive) {
                                this.handler.write(_NSBase64.decode(b));
                                break;
                            }
                            this.handler._bdos.write(_NSBase64.decode(b));
                            break;
                        }
                        case 'S': {
                            while (tokenizer.hasMoreElements()) {
                                this.handler.write(Short.parseShort((String)tokenizer.nextElement()));
                            }
                            break;
                        }
                        case 'C': {
                            while (tokenizer.hasMoreElements()) {
                                String str = (String)tokenizer.nextElement();
                                char ch = str.charAt(0);
                                if (str.length() > 1) {
                                    ch = (char)Integer.parseInt(str.substring(2), 16);
                                }
                                if (!this._isPrimitive) {
                                    this.handler.write(ch);
                                    continue;
                                }
                                this.handler._bdos.writeChar(ch);
                            }
                            break;
                        }
                        case 'I': {
                            while (tokenizer.hasMoreElements()) {
                                this.handler.write(Integer.parseInt((String)tokenizer.nextElement()));
                            }
                            break;
                        }
                        case 'J': {
                            while (tokenizer.hasMoreElements()) {
                                this.handler.write(Long.parseLong((String)tokenizer.nextElement()));
                            }
                            break;
                        }
                        case 'F': {
                            while (tokenizer.hasMoreElements()) {
                                this.handler.write(Float.parseFloat((String)tokenizer.nextElement()));
                            }
                            break;
                        }
                        case 'D': {
                            while (tokenizer.hasMoreElements()) {
                                this.handler.write(Double.parseDouble((String)tokenizer.nextElement()));
                            }
                            break;
                        }
                    }
                }
                catch (NumberFormatException e) {
                    throw new StreamCorruptedException(e.getMessage());
                }
            }
        }
        if (!this._isPrimitive) {
            this.handler._bdos.setBlockDataMode(true);
        }
        this.writeEndDataBlock(this._EDBs.get(this._stackLevel));
    }
}

