/*
 * Decompiled with CFR 0.152.
 */
package er.changenotification;

import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSNotification;
import er.changenotification.ERCNNotificationCoordinator;
import er.changenotification.ERCNSnapshot;
import java.io.Serializable;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;

class ERCNPublisher {
    private ERCNNotificationCoordinator _coordinator;

    ERCNPublisher(ERCNNotificationCoordinator coordinator) {
        this._coordinator = coordinator;
    }

    public void publishChange(NSNotification notification) {
        if (!this._coordinator.isConnected()) {
            return;
        }
        ERCNSnapshot snapshot = new ERCNSnapshot(notification);
        if (snapshot.shouldPostChange()) {
            boolean deliveryMode = true;
            int priority = 4;
            long timeToLive = 3780000L;
            try {
                TopicSession topicSession = this._topicSession();
                if (topicSession != null) {
                    ObjectMessage message = topicSession.createObjectMessage((Serializable)snapshot);
                    Topic topic = this._coordinator.topic();
                    this._topicPublisher(topic, topicSession).publish(topic, (Message)message, 1, 4, 3780000L);
                    if (NSLog.debug.isEnabled()) {
                        NSLog.debug.appendln((Object)("ERChangeNotification: Posted a message with snapshot: " + snapshot));
                    }
                }
            }
            catch (JMSException ex) {
                NSLog.err.appendln((Object)("ERChangeNotification: Failed to poste a snapshot: " + ex.getMessage()));
            }
        }
    }

    private TopicSession _topicSession() {
        TopicSession topicSession = null;
        try {
            TopicConnection connection = this._coordinator.connection();
            topicSession = connection.createTopicSession(false, 2);
        }
        catch (JMSException ex) {
            NSLog.err.appendln((Object)("ERChangeNotification: Failed to create a JMS topic session: " + ex.getMessage()));
        }
        return topicSession;
    }

    private TopicPublisher _topicPublisher(Topic topic, TopicSession topicSession) {
        TopicPublisher topicPublisher = null;
        try {
            topicPublisher = topicSession.createPublisher(topic);
        }
        catch (JMSException ex) {
            NSLog.err.appendln((Object)("ERChangeNotification: Failed to create a JMS topic publisher: " + ex.getMessage()));
        }
        return topicPublisher;
    }

    synchronized void terminate() {
    }
}

