/*
 * Decompiled with CFR 0.152.
 */
package org.openid4java.message;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openid4java.message.Message;
import org.openid4java.message.MessageException;
import org.openid4java.message.ParameterList;

public class AuthFailure
extends Message {
    private static Log _log = LogFactory.getLog((Class)AuthFailure.class);
    private static final boolean DEBUG = _log.isDebugEnabled();
    protected static final List requiredFields = Arrays.asList("openid.mode");
    protected static final List optionalFields = Arrays.asList("openid.ns");

    public AuthFailure(boolean compatibility, String returnTo) {
        this.set("openid.mode", "cancel");
        if (!compatibility) {
            this.set("openid.ns", "http://specs.openid.net/auth/2.0");
        }
        this._destinationUrl = returnTo;
    }

    protected AuthFailure(ParameterList params) {
        super(params);
    }

    public static AuthFailure createAuthFailure(ParameterList params) throws MessageException {
        AuthFailure fail = new AuthFailure(params);
        fail.validate();
        if (DEBUG) {
            _log.debug((Object)("Retrieved auth failure from message parameters:\n" + fail.keyValueFormEncoding()));
        }
        return fail;
    }

    public List getRequiredFields() {
        return requiredFields;
    }

    public boolean isVersion2() {
        return this.hasParameter("openid.ns") && "http://specs.openid.net/auth/2.0".equals(this.getParameterValue("openid.ns"));
    }

    public void validate() throws MessageException {
        super.validate();
        String mode = this.getParameterValue("openid.mode");
        if (!"cancel".equals(mode)) {
            throw new MessageException("Invalid openid.mode; expected cancel found: " + mode, 768);
        }
    }
}

