/*
 * Decompiled with CFR 0.152.
 */
package org.openid4java.message.pape;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openid4java.message.MessageException;
import org.openid4java.message.MessageExtension;
import org.openid4java.message.MessageExtensionFactory;
import org.openid4java.message.Parameter;
import org.openid4java.message.ParameterList;
import org.openid4java.message.pape.PapeRequest;
import org.openid4java.message.pape.PapeResponse;

public class PapeMessage
implements MessageExtension,
MessageExtensionFactory {
    private static Log _log = LogFactory.getLog((Class)PapeMessage.class);
    private static final boolean DEBUG = _log.isDebugEnabled();
    public static final String PAPE_POLICY_PHISHING_RESISTANT = "http://schemas.openid.net/pape/policies/2007/06/phishing-resistant";
    public static final String PAPE_POLICY_MULTI_FACTOR = "http://schemas.openid.net/pape/policies/2007/06/multi-factor";
    public static final String PAPE_POLICY_MULTI_FACTOR_PHYSICAL = "http://schemas.openid.net/pape/policies/2007/06/multi-factor-physical";
    public static final String OPENID_NS_PAPE = "http://specs.openid.net/extensions/pape/1.0";
    protected ParameterList _parameters;

    public PapeMessage() {
        this._parameters = new ParameterList();
        if (DEBUG) {
            _log.debug((Object)"Created empty PapeMessage.");
        }
    }

    public PapeMessage(ParameterList params) {
        this._parameters = params;
        if (DEBUG) {
            _log.debug((Object)("Created PapeMessage from parameter list:\n" + params));
        }
    }

    public String getTypeUri() {
        return OPENID_NS_PAPE;
    }

    public ParameterList getParameters() {
        return this._parameters;
    }

    public void setParameters(ParameterList params) {
        this._parameters = params;
    }

    public boolean hasParameter(String name) {
        return this._parameters.hasParameter(name);
    }

    protected void set(String name, String value) {
        this._parameters.set(new Parameter(name, value));
    }

    protected Parameter getParameter(String name) {
        return this._parameters.getParameter(name);
    }

    public String getParameterValue(String name) {
        return this._parameters.getParameterValue(name);
    }

    public boolean providesIdentifier() {
        return false;
    }

    public boolean signRequired() {
        return true;
    }

    public MessageExtension getExtension(ParameterList parameterList, boolean isRequest) throws MessageException {
        if (parameterList.hasParameter("preferred_auth_policies") || parameterList.hasParameter("max_auth_age")) {
            return PapeRequest.createPapeRequest(parameterList);
        }
        if (parameterList.hasParameter("auth_policies") || parameterList.hasParameter("auth_time")) {
            return PapeResponse.createPapeResponse(parameterList);
        }
        throw new MessageException("Invalid parameters for a PAPE message.");
    }
}

