/*
 * Decompiled with CFR 0.152.
 */
package org.openid4java.server;

import java.util.Date;
import java.util.Map;
import java.util.Random;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openid4java.association.Association;
import org.openid4java.association.AssociationException;
import org.openid4java.server.ServerAssociationStore;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.support.JdbcDaoSupport;

public class JdbcServerAssociationStore
extends JdbcDaoSupport
implements ServerAssociationStore {
    private static Log _log = LogFactory.getLog((Class)JdbcServerAssociationStore.class);
    private static final boolean DEBUG = _log.isDebugEnabled();
    private static Random _random = new Random(System.currentTimeMillis());
    private String _tableName;

    public JdbcServerAssociationStore() {
    }

    public JdbcServerAssociationStore(String tableName) {
        this._tableName = tableName;
    }

    public String getTableName() {
        return this._tableName;
    }

    public void setTableName(String tableName) {
        this._tableName = tableName;
    }

    public Association generate(String type, int expiryIn) throws AssociationException {
        String sql = "INSERT INTO " + this._tableName + " (handle, type, mackey, expdate) VALUES (?,?,?,?)";
        JdbcTemplate jdbcTemplate = this.getJdbcTemplate();
        for (int attemptsLeft = 5; attemptsLeft > 0; --attemptsLeft) {
            try {
                String handle = Long.toHexString(_random.nextLong());
                Association association = Association.generate(type, handle, expiryIn);
                int cnt = jdbcTemplate.update(sql, new Object[]{association.getHandle(), association.getType(), new String(Base64.encodeBase64((byte[])association.getMacKey().getEncoded())), association.getExpiry()});
                if (cnt != 1) continue;
                if (DEBUG) {
                    _log.debug((Object)("Generated association, handle: " + handle + " type: " + type + " expires in: " + expiryIn + " seconds."));
                }
                return association;
            }
            catch (DataAccessException e) {
                _log.error((Object)("Error generating association; attempts left: " + (attemptsLeft - 1)), (Throwable)e);
            }
        }
        throw new AssociationException("JDBCServerAssociationStore: Error generating association.");
    }

    public Association load(String handle) {
        try {
            Association assoc;
            String sql = "SELECT type,mackey,expdate FROM " + this._tableName + " WHERE handle=?";
            JdbcTemplate jdbcTemplate = this.getJdbcTemplate();
            Map res = jdbcTemplate.queryForMap(sql, new Object[]{handle});
            String type = (String)res.get("type");
            String macKey = (String)res.get("mackey");
            Date expDate = (Date)res.get("expdate");
            if (type == null || macKey == null || expDate == null) {
                throw new AssociationException("Invalid association data retrived from database; cannot create Association object for handle: " + handle);
            }
            if ("HMAC-SHA1".equals(type)) {
                assoc = Association.createHmacSha1(handle, Base64.decodeBase64((byte[])macKey.getBytes()), expDate);
            } else if ("HMAC-SHA256".equals(type)) {
                assoc = Association.createHmacSha256(handle, Base64.decodeBase64((byte[])macKey.getBytes()), expDate);
            } else {
                throw new AssociationException("Invalid association type retrieved from database: " + type);
            }
            if (DEBUG) {
                _log.debug((Object)("Retrieved association for handle: " + handle + " from table: " + this._tableName));
            }
            return assoc;
        }
        catch (AssociationException ase) {
            _log.error((Object)("Error retrieving association from table: " + this._tableName), (Throwable)ase);
            return null;
        }
        catch (IncorrectResultSizeDataAccessException rse) {
            _log.warn((Object)("Association not found for handle: " + handle + " in the table: " + this._tableName));
            return null;
        }
        catch (DataAccessException dae) {
            _log.error((Object)("Error retrieving association for handle: " + handle + "from table: " + this._tableName), (Throwable)dae);
            return null;
        }
    }

    public void remove(String handle) {
        try {
            String sql = "DELETE FROM " + this._tableName + " WHERE handle=?";
            JdbcTemplate jdbcTemplate = this.getJdbcTemplate();
            int cnt = jdbcTemplate.update(sql, new Object[]{handle});
            if (cnt == 1 && DEBUG) {
                _log.debug((Object)("Removed association, handle: " + handle + " from table: " + this._tableName));
            }
            if (cnt != 1) {
                _log.warn((Object)("Trying to remove handle: " + handle + " from table: " + this._tableName + "; affected entries: " + cnt));
            }
        }
        catch (Exception e) {
            _log.error((Object)("Error removing association from table: " + this._tableName), (Throwable)e);
        }
    }
}

