/*
 * Decompiled with CFR 0.152.
 */
package org.openid4java.server;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openid4java.message.AuthRequest;
import org.openid4java.message.DirectError;
import org.openid4java.message.Message;
import org.openid4java.message.MessageExtension;
import org.openid4java.message.ParameterList;
import org.openid4java.message.ax.FetchRequest;
import org.openid4java.message.ax.FetchResponse;
import org.openid4java.message.sreg.SRegRequest;
import org.openid4java.message.sreg.SRegResponse;
import org.openid4java.server.ServerException;
import org.openid4java.server.ServerManager;

public class SampleServer {
    public ServerManager manager = new ServerManager();

    public SampleServer() {
        this("http://my.openidprovider.com/server");
    }

    public SampleServer(String endPointUrl) {
        this.manager.setOPEndpointUrl(endPointUrl);
        this.manager.getRealmVerifier().setEnforceRpId(false);
    }

    public String processRequest(HttpServletRequest httpReq, HttpServletResponse httpResp) throws Exception {
        String responseText;
        String mode;
        ParameterList request = new ParameterList(httpReq.getParameterMap());
        String string = mode = request.hasParameter("openid.mode") ? request.getParameterValue("openid.mode") : null;
        if ("associate".equals(mode)) {
            Message response = this.manager.associationResponse(request);
            responseText = response.keyValueFormEncoding();
        } else {
            if ("checkid_setup".equals(mode) || "checkid_immediate".equals(mode)) {
                Object required;
                MessageExtension ext;
                Message response;
                List userData = this.userInteraction(request);
                String userSelectedClaimedId = (String)userData.get(0);
                Boolean authenticatedAndApproved = (Boolean)userData.get(1);
                String email = (String)userData.get(2);
                AuthRequest authReq = AuthRequest.createAuthRequest(request, this.manager.getRealmVerifier());
                String opLocalId = null;
                if (userSelectedClaimedId == null || userSelectedClaimedId.equals(authReq.getClaimed())) {
                    // empty if block
                }
                if ((response = this.manager.authResponse(request, opLocalId, userSelectedClaimedId, (boolean)authenticatedAndApproved)) instanceof DirectError) {
                    return this.directResponse(httpResp, response.keyValueFormEncoding());
                }
                if (authReq.hasExtension("http://openid.net/srv/ax/1.0")) {
                    ext = authReq.getExtension("http://openid.net/srv/ax/1.0");
                    if (ext instanceof FetchRequest) {
                        FetchRequest fetchReq = (FetchRequest)ext;
                        required = fetchReq.getAttributes(true);
                        if (required.containsKey("email")) {
                            HashMap userDataExt = new HashMap();
                            FetchResponse fetchResp = FetchResponse.createFetchResponse(fetchReq, userDataExt);
                            fetchResp.addAttribute("email", "http://schema.openid.net/contact/email", email);
                            response.addExtension(fetchResp);
                        }
                    } else {
                        throw new UnsupportedOperationException("TODO");
                    }
                }
                if (authReq.hasExtension("http://openid.net/sreg/1.0")) {
                    ext = authReq.getExtension("http://openid.net/sreg/1.0");
                    if (ext instanceof SRegRequest) {
                        SRegRequest sregReq = (SRegRequest)ext;
                        required = sregReq.getAttributes(true);
                        if (required.contains("email")) {
                            HashMap userDataSReg = new HashMap();
                            SRegResponse sregResp = SRegResponse.createSRegResponse(sregReq, userDataSReg);
                            sregResp.addAttribute("email", email);
                            response.addExtension(sregResp);
                        }
                    } else {
                        throw new UnsupportedOperationException("TODO");
                    }
                }
                return response.getDestinationUrl(true);
            }
            if ("check_authentication".equals(mode)) {
                Message response = this.manager.verify(request);
                responseText = response.keyValueFormEncoding();
            } else {
                DirectError response = DirectError.createDirectError("Unknown request");
                responseText = response.keyValueFormEncoding();
            }
        }
        return responseText;
    }

    protected List userInteraction(ParameterList request) throws ServerException {
        throw new ServerException("User-interaction not implemented.");
    }

    private String directResponse(HttpServletResponse httpResp, String response) throws IOException {
        ServletOutputStream os = httpResp.getOutputStream();
        os.write(response.getBytes());
        os.close();
        return null;
    }
}

