/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects._ideservices;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSPathUtilities;
import com.webobjects.foundation.NSPropertyListSerialization;
import com.webobjects.foundation._NSStringUtilities;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Enumeration;
import org.apache.log4j.Logger;

public class _PBXProjectWatcher {
    private static Logger log = Logger.getLogger(_PBXProjectWatcher.class);
    private static Logger fileLog = Logger.getLogger((String)(_PBXProjectWatcher.class.getName() + ".Files"));
    private static NSMutableArray _nsProjectSearchPaths;
    private static NSMutableDictionary _pbxArchivesByPath;
    private static NSMutableDictionary _pathsByName;
    private static int _PBPort;
    private static String _PBHostname;
    private static volatile boolean _printRapidTurnaroundMessage;
    private static boolean _communicationDisabled;

    private static NSArray nsProjectSearchPaths() {
        if (_nsProjectSearchPaths == null) {
            String searchPathsAsString = System.getProperty("NSProjectSearchPath");
            NSArray searchPaths = (NSArray)NSPropertyListSerialization.propertyListFromString((String)searchPathsAsString);
            _nsProjectSearchPaths = new NSMutableArray();
            if (searchPaths != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Found NSProjectSearchPath: " + searchPaths));
                }
                Enumeration e = searchPaths.objectEnumerator();
                while (e.hasMoreElements()) {
                    _nsProjectSearchPaths.addObject(new File((String)e.nextElement()));
                }
            }
        }
        return _nsProjectSearchPaths;
    }

    private static boolean hasSearchPaths() {
        return _PBXProjectWatcher.nsProjectSearchPaths().count() > 0;
    }

    private static final PBXArchive pbxArchiveAtPath(String path) throws IOException {
        PBXArchive result = (PBXArchive)_pbxArchivesByPath.objectForKey(path);
        if (result == null) {
            result = new PBXArchive(path);
            _pbxArchivesByPath.setObjectForKey(result, path);
        }
        return result;
    }

    private static final NSArray pathsForProjectNamed(final String name) {
        NSArray<String> result = (NSArray<String>)_pathsByName.objectForKey(name);
        if (result == null) {
            result = NSArray.EmptyArray;
            Enumeration e = _PBXProjectWatcher.nsProjectSearchPaths().objectEnumerator();
            while (e.hasMoreElements()) {
                File[] files;
                File path = (File)e.nextElement();
                if (!path.exists() || !path.isDirectory() || (files = path.listFiles(new FilenameFilter(){

                    public boolean accept(File dir, String otherName) {
                        return _PBXProjectWatcher.safeEquals(otherName, name);
                    }
                })).length <= 0) continue;
                File parent = files[0];
                File project = new File(parent.getPath() + File.separator + name + ".xcodeproj");
                if (!project.exists()) {
                    project = new File(parent.getPath() + File.separator + name + ".pbproj");
                }
                if (!project.exists()) continue;
                result = new NSArray<String>(project.getPath());
                break;
            }
            if (result.count() > 0) {
                log.info((Object)("Found " + name + " in " + result));
                _pathsByName.setObjectForKey(result, name);
            }
        }
        return result;
    }

    public static NSArray openProjectsAppropriateForFile(String path) {
        NSArray<String> result = NSArray.EmptyArray;
        if (!_PBXProjectWatcher.hasSearchPaths()) {
            String last;
            StringBuffer sb = new StringBuffer(4096);
            sb.append("<openProjectsAppropriateForFile>");
            sb.append("<path>" + path + "</path>");
            sb.append("</openProjectsAppropriateForFile>");
            String reply = _PBXProjectWatcher._sendXMLToPB(new String(sb));
            if (reply.length() > 0 && (result = (NSArray)NSPropertyListSerialization.propertyListFromString((String)reply)).count() == 0 && ((last = _NSStringUtilities.lastComponentInString((String)path, (char)'/')).indexOf(".woa") > 0 || last.indexOf(".framework") > 0)) {
                String what = _NSStringUtilities.stringByDeletingLastComponent((String)last, (char)'.');
                String key = "projects." + what;
                String source = System.getProperty(key);
                if (source != null) {
                    result = new NSArray<String>(source);
                }
            }
        } else {
            try {
                String last = _NSStringUtilities.lastComponentInString((String)path, (char)'/');
                if (last.indexOf(".woa") > 0 || last.indexOf(".framework") > 0) {
                    String what = _NSStringUtilities.stringByDeletingLastComponent((String)last, (char)'.');
                    result = _PBXProjectWatcher.pathsForProjectNamed(what);
                    if (fileLog.isDebugEnabled()) {
                        fileLog.debug((Object)("openProjectsAppropriateForFile " + path + ": " + result));
                    }
                }
            }
            catch (Throwable e) {
                log.error((Object)("While trying to compute openProjectsAppropriateForFile for " + path + ", caught " + e + "\n\n"), e);
            }
        }
        return result;
    }

    public static NSArray targetsInProject(String path) {
        NSArray<Object> result = null;
        if (!_PBXProjectWatcher.hasSearchPaths()) {
            StringBuffer sb = new StringBuffer(4096);
            sb.append("<targetsInProject>");
            sb.append("<cookie>" + path + "</cookie>");
            sb.append("</targetsInProject>");
            String reply = _PBXProjectWatcher._sendXMLToPB(sb.toString());
            if (reply.length() > 16 && reply.lastIndexOf("</string>") > 0) {
                reply = reply.substring(16, reply.lastIndexOf("</string>"));
                result = NSArray.componentsSeparatedByString(reply, "</string>\n<string>");
            } else {
                result = new NSArray();
            }
        } else {
            try {
                PBXArchive p = _PBXProjectWatcher.pbxArchiveAtPath(path);
                result = p == null ? null : p.targetIDs();
            }
            catch (Throwable e) {
                log.error((Object)e, e);
            }
        }
        return result;
    }

    public static NSArray filesOfTypesInTargetOfProject(NSArray types, String target, String path) {
        NSArray result = null;
        if (!_PBXProjectWatcher.hasSearchPaths()) {
            StringBuffer sb = new StringBuffer(4096);
            sb.append("<filesOfTypesInTargetOfProject>");
            sb.append("<cookie>" + path + "</cookie>");
            sb.append("<target>" + target + "</target>");
            sb.append("<typesArray>" + _PBXProjectWatcher._xmlStringArray(types) + "</typesArray>");
            sb.append("</filesOfTypesInTargetOfProject>");
            String reply = _PBXProjectWatcher._sendXMLToPB(sb.toString());
            result = reply.length() > 0 ? (NSArray)NSPropertyListSerialization.propertyListFromString((String)reply) : NSArray.EmptyArray;
        } else {
            try {
                PBXArchive p = _PBXProjectWatcher.pbxArchiveAtPath(path);
                NSArray nSArray = result = p == null ? null : p.filesOfTypeInTargetWithID(types, target);
                if (fileLog.isDebugEnabled() && result.toString().indexOf("d2w") > 0) {
                    fileLog.debug((Object)("filesOfTypesInTargetOfProject " + types + ", " + target + ", " + path));
                    fileLog.debug((Object)("=" + result));
                }
            }
            catch (Throwable e) {
                log.error((Object)e, e);
            }
        }
        return result;
    }

    public static String nameOfTargetInProject(String targetID, String path) {
        String result = null;
        if (!_PBXProjectWatcher.hasSearchPaths()) {
            StringBuffer sb = new StringBuffer(4096);
            sb.append("<nameOfTarget>");
            sb.append("<targetCookie>" + targetID + "</targetCookie >");
            sb.append("<projectCookie>" + path + "</projectCookie >");
            sb.append("</nameOfTarget>");
            result = _PBXProjectWatcher._sendXMLToPB(new String(sb));
        } else {
            try {
                PBXArchive p = _PBXProjectWatcher.pbxArchiveAtPath(path);
                if (p != null) {
                    result = p.nameForTargetWithID(targetID);
                }
            }
            catch (Throwable e) {
                log.error((Object)e, e);
            }
        }
        return result;
    }

    public static NSArray targetsInProjectContainingFile(String project, String file) {
        StringBuffer sb = new StringBuffer(4096);
        sb.append("<targetsInProjectContainingFile>");
        sb.append("<cookie>" + project + "</cookie>");
        sb.append("<path>" + file + "</path>");
        sb.append("</targetsInProjectContainingFile>");
        String reply = _PBXProjectWatcher._sendXMLToPB(new String(sb));
        NSArray result = reply.length() > 0 ? (NSArray)NSPropertyListSerialization.propertyListFromString((String)reply) : new NSArray();
        return result;
    }

    public static String nameOfProject(String project) {
        if (!_PBXProjectWatcher.hasSearchPaths()) {
            StringBuffer sb = new StringBuffer(4096);
            sb.append("<nameOfProject>");
            sb.append("<projectCookie>" + project + "</projectCookie>");
            sb.append("</nameOfProject>");
            String reply = _PBXProjectWatcher._sendXMLToPB(new String(sb));
            return reply;
        }
        String name = NSPathUtilities.lastPathComponent((String)project);
        int lastDotIndex = name.lastIndexOf(46);
        return name.substring(0, lastDotIndex);
    }

    public static void addFilesToProjectNearFilePreferredInsertionGroupNameAddToTargetsCopyIntoGroupFolderCreateGroupsRecursively(NSArray files, String project, String file, String groupName, NSArray targets, boolean copyIntoGroupFolder, boolean createGroupsRecursively) {
        StringBuffer sb = new StringBuffer(4096);
        sb.append("<addFilesToProject>");
        sb.append("<addFiles>" + _PBXProjectWatcher._xmlStringArray(files) + "</addFiles>");
        sb.append("<toProject>" + project + "</toProject>");
        sb.append("<nearFile>" + file + "</nearFile>");
        sb.append("<preferredInsertionGroupName>" + groupName + "</preferredInsertionGroupName>");
        sb.append("<addToTargets>" + _PBXProjectWatcher._xmlStringArray(targets) + "</addToTargets>");
        sb.append("<copyIntoGroupFolder>" + _PBXProjectWatcher._xmlBoolean(copyIntoGroupFolder) + "</copyIntoGroupFolder>");
        sb.append("<createGroupsRecursively>" + _PBXProjectWatcher._xmlBoolean(createGroupsRecursively) + "</createGroupsRecursively>");
        sb.append("</addFilesToProject>");
        String reply = _PBXProjectWatcher._sendXMLToPB(new String(sb));
    }

    public static void openFile(String file, int line, String message) {
        StringBuffer sb = new StringBuffer(4096);
        sb.append("<OpenFile><filename>");
        sb.append(file);
        sb.append("</filename><linenumber>");
        sb.append(line);
        sb.append("</linenumber><message>");
        sb.append(message);
        sb.append("</message></OpenFile>");
        String reply = _PBXProjectWatcher._sendXMLToPB(sb.toString());
    }

    public static void addGroup(String name, String path, String project, String nearFile) {
        StringBuffer sb = new StringBuffer(4096);
        sb.append("<addGroup>");
        sb.append("<name>" + name + "</name >");
        if (path != null) {
            sb.append("<path>" + path + "</path >");
        }
        sb.append("<projectCookie>" + project + "</projectCookie >");
        if (nearFile != null) {
            sb.append("<nearFile>" + nearFile + "</nearFile >");
        }
        sb.append("</addGroup>");
        String reply = _PBXProjectWatcher._sendXMLToPB(sb.toString());
    }

    public static void addGroupToPreferredInsertionGroup(String group, String path, String project, String nearFile, String preferredInsertionGroup) {
        StringBuffer sb = new StringBuffer(4096);
        sb.append("<addGroupToPreferredInsertionGroup>");
        sb.append("<name>" + group + "</name >");
        if (path != null) {
            sb.append("<path>" + path + "</path >");
        }
        sb.append("<projectCookie>" + project + "</projectCookie >");
        if (nearFile != null) {
            sb.append("<nearFile>" + nearFile + "</nearFile >");
        }
        if (preferredInsertionGroup != null) {
            sb.append("<preferredInsertionGroup>" + preferredInsertionGroup + "</preferredInsertionGroup >");
        }
        sb.append("</addGroupToPreferredInsertionGroup>");
        String reply = _PBXProjectWatcher._sendXMLToPB(sb.toString());
    }

    private static final String _xmlStringArray(NSArray nsarray) {
        StringBuffer sb = new StringBuffer(4096);
        sb.append("<array>");
        for (int i = 0; i < nsarray.count(); ++i) {
            String string = (String)nsarray.objectAtIndex(i);
            sb.append("<string>" + string + "</string>");
        }
        sb.append("</array>");
        return sb.toString();
    }

    private static final String _xmlBoolean(boolean bool) {
        if (bool) {
            return "YES";
        }
        return "NO";
    }

    private static final String _sendXMLToPB(String string) {
        String reply = "";
        if (_communicationDisabled) {
            return "";
        }
        try {
            Socket socket = new Socket(_PBHostname, _PBPort);
            if (socket == null) {
                return "Cound not create socket to PB";
            }
            OutputStream os = socket.getOutputStream();
            os.write(string.getBytes());
            os.flush();
            try {
                int tries;
                int buffSize = 7000;
                byte[] buffer = new byte[buffSize];
                InputStream is = socket.getInputStream();
                int maxTries = 50;
                for (tries = 0; is.available() == 0 && tries < maxTries; ++tries) {
                    Thread.sleep(0L);
                }
                if (tries == maxTries) {
                    _communicationDisabled = true;
                    log.error((Object)("Couldn't contact ProjectBuilder to send XML command " + string), (Throwable)new RuntimeException());
                }
                while (is.available() > 0) {
                    int readBytes = is.read(buffer, 0, buffSize >= is.available() ? is.available() : buffSize);
                    reply = reply + new String(buffer, 0, readBytes);
                }
            }
            catch (Exception ex) {
                _communicationDisabled = true;
                log.error((Object)("Error sending xml command to ProjectBuilder. XML: " + string), (Throwable)ex);
                reply = "";
            }
            socket.close();
        }
        catch (Exception ex) {
            if (System.getProperty("os.name").startsWith("Mac") && _printRapidTurnaroundMessage) {
                _printRapidTurnaroundMessage = false;
                log.error((Object)"Cannot use rapid turnaround.  Please start Project Builder and open the project for this application.");
            }
            reply = "";
        }
        return reply;
    }

    private static boolean safeEquals(Object v1, Object v2) {
        return v1 == v2 || v1 != null && v2 != null && v1.equals(v2);
    }

    private static byte[] bytesFromFile(File f) throws IOException {
        if (f == null) {
            throw new IllegalArgumentException("null file");
        }
        return _PBXProjectWatcher.bytesFromFile(f, (int)f.length());
    }

    private static byte[] bytesFromFile(File f, int n) throws IOException {
        if (f == null) {
            throw new IllegalArgumentException("null file");
        }
        FileInputStream fis = new FileInputStream(f);
        byte[] data = new byte[n];
        for (int bytesRead = 0; bytesRead < n; bytesRead += fis.read(data, bytesRead, n - bytesRead)) {
        }
        fis.close();
        return data;
    }

    private static String stringWithContentsOfFile(File file) {
        if (file != null) {
            try {
                return new String(_PBXProjectWatcher.bytesFromFile(file));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    static {
        _pbxArchivesByPath = new NSMutableDictionary();
        _pathsByName = new NSMutableDictionary();
        _printRapidTurnaroundMessage = true;
        _communicationDisabled = false;
        log.debug((Object)"Installed NSProjectSearchPath fix");
    }

    private static class PBXArchive {
        private static Logger log = Logger.getLogger(PBXArchive.class);
        private NSArray _targets;
        private NSDictionary _objects;
        private String _path;
        private NSMutableDictionary _filesPerTarget = new NSMutableDictionary();

        public PBXArchive(String path) throws IOException {
            log.debug((Object)("Loading: " + path));
            String contents = _PBXProjectWatcher.stringWithContentsOfFile(new File(path, "project.pbxproj"));
            try {
                this._objects = (NSDictionary)NSPropertyListSerialization.propertyListFromString((String)contents);
                this._objects = (NSDictionary)this._objects.objectForKey("objects");
                NSDictionary project = this.objectOfTypeInPBXArchive("PBXProject", this._objects);
                this._targets = (NSArray)project.objectForKey("targets");
                this._path = NSPathUtilities.stringByDeletingLastPathComponent((String)path);
            }
            catch (Exception ex) {
                throw NSForwardException._runtimeExceptionForThrowable((Throwable)ex);
            }
        }

        public NSArray objectsOfTypeInPBXArchive(String type, NSDictionary objects) {
            NSMutableArray<NSDictionary> result = new NSMutableArray<NSDictionary>();
            Enumeration e = objects.objectEnumerator();
            while (e.hasMoreElements()) {
                NSDictionary o = (NSDictionary)e.nextElement();
                String isA = (String)o.objectForKey("isa");
                if (!_PBXProjectWatcher.safeEquals(type, isA)) continue;
                result.addObject(o);
            }
            return result;
        }

        public NSDictionary objectOfTypeInPBXArchive(String type, NSDictionary objects) {
            NSDictionary result = null;
            Enumeration e = objects.objectEnumerator();
            while (e.hasMoreElements()) {
                NSDictionary o = (NSDictionary)e.nextElement();
                String isA = (String)o.objectForKey("isa");
                if (!_PBXProjectWatcher.safeEquals(type, isA)) continue;
                result = o;
                break;
            }
            return result;
        }

        public NSArray targetIDs() {
            return this._targets;
        }

        public NSDictionary objectWithID(String ID) {
            NSDictionary result = (NSDictionary)this._objects.objectForKey(ID);
            return result;
        }

        public String nameForTargetWithID(String ID) {
            NSDictionary target = (NSDictionary)this._objects.objectForKey(ID);
            return target == null ? null : target.objectForKey("name");
        }

        public void addPathsForChildrenWithIDToArray(NSArray IDs, NSMutableArray array) {
            if (IDs != null) {
                Enumeration e = IDs.objectEnumerator();
                while (e.hasMoreElements()) {
                    NSDictionary child = this.objectWithID((String)e.nextElement());
                    if (child == null) continue;
                    String path = (String)child.objectForKey("path");
                    if (path != null && path.length() > 0) {
                        array.addObject(path);
                    }
                    this.addPathsForChildrenWithIDToArray((NSArray)child.objectForKey("children"), array);
                }
            }
        }

        public NSArray filesInTargetWithID(String targetID) {
            NSMutableArray result = (NSMutableArray)this._filesPerTarget.objectForKey(targetID);
            if (result == null) {
                NSDictionary target = (NSDictionary)this._objects.objectForKey(targetID);
                if (target != null) {
                    result = new NSMutableArray();
                    NSArray buildPhasesID = (NSArray)target.objectForKey("buildPhases");
                    if (buildPhasesID != null) {
                        Enumeration e = buildPhasesID.objectEnumerator();
                        while (e.hasMoreElements()) {
                            NSDictionary buildPhase = this.objectWithID((String)e.nextElement());
                            NSArray files = (NSArray)buildPhase.objectForKey("files");
                            if (files == null) continue;
                            Enumeration e2 = files.objectEnumerator();
                            while (e2.hasMoreElements()) {
                                NSDictionary buildFile = this.objectWithID((String)e2.nextElement());
                                NSArray<String> ids = new NSArray<String>((String)buildFile.objectForKey("fileRef"));
                                this.addPathsForChildrenWithIDToArray(ids, result);
                            }
                        }
                    }
                }
                this._filesPerTarget.setObjectForKey(result, targetID);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("filesInTargetWithID " + targetID + "=" + result));
                }
            }
            return result;
        }

        public NSArray filesOfTypeInTargetWithID(NSArray types, String targetID) {
            NSMutableArray<String> result = new NSMutableArray<String>();
            Enumeration e = this.filesInTargetWithID(targetID).objectEnumerator();
            while (e.hasMoreElements()) {
                String file = (String)e.nextElement();
                int lastDotIndex = file.lastIndexOf(46);
                if (lastDotIndex == -1 || file.length() < lastDotIndex || !types.containsObject(file.substring(lastDotIndex + 1))) continue;
                result.addObject(NSPathUtilities.stringByAppendingPathComponent((String)this._path, (String)file));
            }
            return result;
        }
    }
}

