/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.eoaccess;

import com.webobjects.eoaccess.EOAdaptor;
import com.webobjects.eoaccess.EOAttribute;
import com.webobjects.eoaccess.EOEntity;
import com.webobjects.eoaccess.EOModel;
import com.webobjects.eoaccess.EOModelGroup;
import com.webobjects.eoaccess.ERXEntity;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSRecursiveLock;
import com.webobjects.jdbcadaptor.JDBCAdaptor;
import er.extensions.eof.ERXEOAccessUtilities;
import er.extensions.eof.ERXKey;
import er.extensions.eof.ERXModelGroup;
import er.extensions.foundation.ERXProperties;
import java.net.URL;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERXModel
extends EOModel {
    public static Object _ERXGlobalModelLock;
    private static final Logger log;

    private static void addAttributesToPrototypesCache(EOModel model, EOEntity prototypesEntity) {
        if (model != null && prototypesEntity != null) {
            ERXModel.addAttributesToPrototypesCache(model, ERXModel.attributesFromEntity(prototypesEntity));
        }
    }

    private static void addAttributesToPrototypesCache(EOModel model, NSArray<? extends EOAttribute> prototypeAttributes) {
        if (model != null && prototypeAttributes.count() != 0) {
            NSArray<String> keys = ERXModel.namesForAttributes(prototypeAttributes);
            NSDictionary<String, ? extends EOAttribute> temp = new NSDictionary<String, EOAttribute>(prototypeAttributes, keys);
            model._prototypesByName.addEntriesFromDictionary(temp);
        }
    }

    private static NSArray<EOAttribute> attributesFromEntity(EOEntity entity) {
        NSArray result = NSArray.emptyArray();
        if (entity != null) {
            result = entity.attributes();
            log.debug((Object)("Attributes from " + entity.name() + ": " + result));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createPrototypes(EOModel model) {
        NSMutableDictionary<String, String> dict = model.connectionDictionary().mutableClone();
        if (dict.objectForKey("password") != null) {
            dict.setObjectForKey("<deleted for log>", "password");
        }
        log.info((Object)("Creating prototypes for model: " + model.name() + "->" + dict));
        NSRecursiveLock nSRecursiveLock = _EOGlobalModelLock;
        synchronized (nSRecursiveLock) {
            StringBuilder debugInfo = null;
            if (log.isDebugEnabled()) {
                debugInfo = new StringBuilder();
                debugInfo.append("Model = " + model.name());
            }
            model._prototypesByName = new NSMutableDictionary();
            String name = model.name();
            NSArray adaptorPrototypes = NSArray.EmptyArray;
            EOAdaptor adaptor = EOAdaptor.adaptorWithModel((EOModel)model);
            try {
                adaptorPrototypes = adaptor.prototypeAttributes();
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
            }
            ERXModel.addAttributesToPrototypesCache(model, adaptorPrototypes);
            NSArray<EOAttribute> prototypesToHide = ERXModel.attributesFromEntity(model._group.entityNamed("EOPrototypesToHide"));
            model._prototypesByName.removeObjectsForKeys(ERXModel.namesForAttributes(prototypesToHide));
            String plugin = null;
            if (adaptor instanceof JDBCAdaptor && !model.name().equalsIgnoreCase("erprototypes")) {
                plugin = (String)model.connectionDictionary().objectForKey("plugin");
                if (plugin == null) {
                    plugin = ERXEOAccessUtilities.guessPluginName(model);
                }
                if (plugin != null && plugin.toLowerCase().endsWith("plugin")) {
                    plugin = plugin.substring(0, plugin.length() - "plugin".length());
                }
                if (log.isDebugEnabled()) {
                    debugInfo.append("; plugin = " + plugin);
                }
            }
            ERXModel.addAttributesToPrototypesCache(model, model._group.entityNamed("EOPrototypes"));
            ERXModel.addAttributesToPrototypesCache(model, model._group.entityNamed("EO" + model.adaptorName() + "Prototypes"));
            if (log.isDebugEnabled()) {
                debugInfo.append("; Prototype Entities Searched = EOPrototypes, EO" + model.adaptorName() + "Prototypes");
            }
            if (plugin != null) {
                ERXModel.addAttributesToPrototypesCache(model, model._group.entityNamed("EOJDBC" + plugin + "Prototypes"));
                if (log.isDebugEnabled()) {
                    debugInfo.append(", EOJDBC" + plugin + "Prototypes");
                }
            }
            ERXModel.addAttributesToPrototypesCache(model, model._group.entityNamed("EOCustomPrototypes"));
            ERXModel.addAttributesToPrototypesCache(model, model._group.entityNamed("EO" + model.adaptorName() + "CustomPrototypes"));
            if (log.isDebugEnabled()) {
                debugInfo.append(", EOCustomPrototypes, EO" + model.adaptorName() + "CustomPrototypes");
            }
            if (plugin != null) {
                ERXModel.addAttributesToPrototypesCache(model, model._group.entityNamed("EOJDBC" + plugin + "CustomPrototypes"));
                if (log.isDebugEnabled()) {
                    debugInfo.append(", EOJDBC" + plugin + "CustomPrototypes");
                }
            }
            ERXModel.addAttributesToPrototypesCache(model, model._group.entityNamed("EO" + name + "Prototypes"));
            ERXModel.addAttributesToPrototypesCache(model, model._group.entityNamed("EO" + model.adaptorName() + name + "Prototypes"));
            if (log.isDebugEnabled()) {
                debugInfo.append(", EO" + name + "Prototypes" + ", " + "EO" + model.adaptorName() + name + "Prototypes");
            }
            if (plugin != null) {
                ERXModel.addAttributesToPrototypesCache(model, model._group.entityNamed("EOJDBC" + plugin + name + "Prototypes"));
                if (log.isDebugEnabled()) {
                    debugInfo.append(", EOJDBC" + plugin + name + "Prototypes");
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)debugInfo.toString());
            }
        }
    }

    private static NSArray<String> namesForAttributes(NSArray<? extends EOAttribute> attributes) {
        return new ERXKey("name").arrayValueInObject(attributes);
    }

    public static boolean isUseExtendedPrototypesEnabled() {
        return ERXProperties.booleanForKeyWithDefault("er.extensions.ERXModel.useExtendedPrototypes", false);
    }

    public ERXModel() {
    }

    public ERXModel(URL url) {
        super(url);
    }

    public ERXModel(NSDictionary propertyList, String path) {
        super(propertyList, path);
    }

    public ERXModel(NSDictionary propertyList, URL url) {
        super(propertyList, url);
    }

    public Object _addEntityWithPropertyList(Object propertyList) throws InstantiationException, IllegalAccessException {
        NSMutableDictionary<String, String> list = ((NSDictionary)propertyList).mutableClone();
        if (list.objectForKey("entityClass") == null) {
            String eoEntityClassName = ERXProperties.stringForKey("er.extensions.ERXModel.defaultEOEntityClassName");
            if (eoEntityClassName == null) {
                eoEntityClassName = ERXEntity.class.getName();
            }
            list.setObjectForKey(eoEntityClassName, "entityClass");
        }
        return super._addEntityWithPropertyList(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NSArray availablePrototypeAttributeNames() {
        NSRecursiveLock nSRecursiveLock = _EOGlobalModelLock;
        synchronized (nSRecursiveLock) {
            if (this._prototypesByName == null && this.useExtendedPrototypes()) {
                ERXModel.createPrototypes(this);
            }
        }
        return super.availablePrototypeAttributeNames();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EOAttribute prototypeAttributeNamed(String name) {
        NSRecursiveLock nSRecursiveLock = _EOGlobalModelLock;
        synchronized (nSRecursiveLock) {
            if (this._prototypesByName == null && this.useExtendedPrototypes()) {
                ERXModel.createPrototypes(this);
            }
        }
        return super.prototypeAttributeNamed(name);
    }

    public void setModelGroup(EOModelGroup modelGroup) {
        super.setModelGroup(modelGroup);
        if (modelGroup instanceof ERXModelGroup) {
            ((ERXModelGroup)modelGroup).resetConnectionDictionaryInModel(this);
        }
    }

    protected boolean useExtendedPrototypes() {
        return ERXModel.isUseExtendedPrototypesEnabled();
    }

    static {
        log = Logger.getLogger(ERXModel.class);
        try {
            _ERXGlobalModelLock = EOModel._EOGlobalModelLock;
        }
        catch (NoSuchFieldError e) {
            try {
                String eomodelLockClassName = EOModel.class.getDeclaredField("_EOGlobalModelLock").getType().getSimpleName();
                if ("ReentrantLock".equals(eomodelLockClassName)) {
                    throw new RuntimeException("You're using WebObjects 5.4 with the WebObjects 5.3 version of Project Wonder. You need to download the 5.4 version of Project Wonder for your application to work properly.");
                }
                if ("NSRecursiveLock".equals(eomodelLockClassName)) {
                    throw new RuntimeException("You're using WebObjects 5.3 with the WebObjects 5.4 version of Project Wonder. You need to download the 5.3 version of Project Wonder for your application to work properly.");
                }
                throw new RuntimeException("You have the wrong version of Project Wonder for the version of WebObjects that you're using. You need to download the appropriate version of Project Wonder for your application to work properly.");
            }
            catch (NoSuchFieldException e2) {
                throw e;
            }
        }
    }
}

