/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSSet;
import com.webobjects.foundation._NSCollectionPrimitives;
import com.webobjects.foundation._NSUtilities;
import java.util.Collection;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NSMutableSet<E>
extends NSSet<E> {
    public static final Class _CLASS = _NSUtilities._classWithFullySpecifiedName((String)"com.webobjects.foundation.NSMutableSet");
    static final long serialVersionUID = -6054074706096120227L;

    public NSMutableSet() {
    }

    public NSMutableSet(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("Capacity cannot be less than 0");
        }
        this._ensureCapacity(capacity);
    }

    public NSMutableSet(Collection<? extends E> collection) {
        super(collection);
    }

    public NSMutableSet(E object) {
        super(object);
    }

    public NSMutableSet(E[] objects) {
        super(objects);
    }

    public NSMutableSet(E object, E ... objects) {
        super(object, objects);
    }

    public NSMutableSet(NSArray<? extends E> objects) {
        super(objects);
    }

    public NSMutableSet(NSSet<? extends E> otherSet) {
        super(otherSet);
    }

    public NSMutableSet(Set<? extends E> set, boolean ignoreNull) {
        super(set, ignoreNull);
    }

    public void addObject(E object) {
        if (object == null) {
            throw new IllegalArgumentException("Attempt to insert null into an  " + this.getClass().getName() + ".");
        }
        int capacity = this._capacity;
        int count = this._count;
        if (++count > capacity) {
            this._ensureCapacity(count);
        }
        if (_NSCollectionPrimitives.addValueToSet(object, (Object[])this._objects, (byte[])this._flags)) {
            this._count = count;
            this._objectsCache = null;
        }
    }

    public E removeObject(Object object) {
        Object result = null;
        if (object != null && this._count != 0 && (result = _NSCollectionPrimitives.removeValueInHashTable((Object)object, (Object[])this._objects, (Object[])this._objects, (byte[])this._flags)) != null) {
            --this._count;
            --this._deletionLimit;
            if (this._count == 0 || this._deletionLimit == 0) {
                this._clearDeletionsAndCollisions();
            }
            this._objectsCache = null;
        }
        return (E)result;
    }

    public void removeAllObjects() {
        if (this._count != 0) {
            this._objects = new Object[this._hashtableBuckets];
            this._flags = new byte[this._hashtableBuckets];
            this._count = 0;
            this._objectsCache = null;
            this._deletionLimit = _NSCollectionPrimitives.deletionLimitForTableBuckets((int)this._hashtableBuckets);
        }
    }

    public void setSet(NSSet<? extends E> otherSet) {
        if (otherSet != this) {
            this.removeAllObjects();
            if (otherSet != null) {
                Object[] objects = otherSet.objectsNoCopy();
                for (int i = 0; i < objects.length; ++i) {
                    this.addObject(objects[i]);
                }
            }
        }
    }

    public void addObjectsFromArray(NSArray<? extends E> array) {
        if (array != null) {
            Object[] objects = array.objectsNoCopy();
            for (int i = 0; i < objects.length; ++i) {
                this.addObject(objects[i]);
            }
        }
    }

    public void intersectSet(NSSet<?> otherSet) {
        if (otherSet != this) {
            if (otherSet == null || otherSet.count() == 0) {
                this.removeAllObjects();
                return;
            }
            Object[] objects = this.objectsNoCopy();
            for (int i = 0; i < objects.length; ++i) {
                if (otherSet.member(objects[i]) != null) continue;
                this.removeObject(objects[i]);
            }
        }
    }

    public void subtractSet(NSSet<?> otherSet) {
        if (otherSet == null || otherSet.count() == 0) {
            return;
        }
        if (otherSet == this) {
            this.removeAllObjects();
            return;
        }
        Object[] objects = otherSet.objectsNoCopy();
        for (int i = 0; i < objects.length; ++i) {
            if (this.member(objects[i]) == null) continue;
            this.removeObject(objects[i]);
        }
    }

    public void unionSet(NSSet<? extends E> otherSet) {
        if (otherSet == null || otherSet.count() == 0 || otherSet == this) {
            return;
        }
        Object[] objects = otherSet.objectsNoCopy();
        for (int i = 0; i < objects.length; ++i) {
            this.addObject(objects[i]);
        }
    }

    @Override
    public Object clone() {
        return new NSMutableSet<E>(this);
    }

    @Override
    public NSSet<E> immutableClone() {
        return new NSSet<NSMutableSet>(this);
    }

    @Override
    public NSMutableSet<E> mutableClone() {
        return (NSMutableSet)this.clone();
    }

    @Override
    public boolean add(E o) {
        if (this.contains(o)) {
            return false;
        }
        this.addObject(o);
        return true;
    }

    @Override
    public boolean remove(Object o) {
        return this.removeObject(o) != null;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean updated = false;
        for (E t : c) {
            if (this.contains(t)) continue;
            this.add(t);
            updated = true;
        }
        return updated;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        NSMutableSet s = new NSMutableSet();
        boolean updated = false;
        for (Object o : c) {
            s.add(o);
            if (this.contains(o)) continue;
            updated = true;
        }
        this.intersectSet(s);
        return updated;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        NSMutableSet s = new NSMutableSet();
        boolean updated = false;
        for (Object o : c) {
            s.add(o);
            if (this.contains(o)) continue;
            updated = true;
        }
        this.subtractSet(s);
        return updated;
    }

    @Override
    public void clear() {
        this.removeAllObjects();
    }
}

