/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.appserver;

import com.webobjects.appserver.WOAction;
import com.webobjects.appserver.WOActionResults;
import com.webobjects.appserver.WOApplication;
import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WOMessage;
import com.webobjects.appserver.WORedirect;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WORequestHandler;
import com.webobjects.appserver.WOResourceManager;
import com.webobjects.appserver.WOResponse;
import com.webobjects.appserver.WOSession;
import com.webobjects.appserver.WOTimer;
import com.webobjects.appserver._private.WOComponentDefinition;
import com.webobjects.appserver._private.WOProperties;
import com.webobjects.appserver._private.WOURLEncoder;
import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOTemporaryGlobalID;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSBundle;
import com.webobjects.foundation.NSData;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation.NSKeyValueCodingAdditions;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSMutableSet;
import com.webobjects.foundation.NSNotification;
import com.webobjects.foundation.NSNotificationCenter;
import com.webobjects.foundation.NSProperties;
import com.webobjects.foundation.NSPropertyListSerialization;
import com.webobjects.foundation.NSRange;
import com.webobjects.foundation.NSSelector;
import com.webobjects.foundation.NSSet;
import com.webobjects.foundation.NSTimestamp;
import er.extensions.ERXExtensions;
import er.extensions.ERXFrameworkPrincipal;
import er.extensions.appserver.ERXComponentActionRedirector;
import er.extensions.appserver.ERXDelayedRequestHandler;
import er.extensions.appserver.ERXDirectAction;
import er.extensions.appserver.ERXDirectActionRequestHandler;
import er.extensions.appserver.ERXMessageEncoding;
import er.extensions.appserver.ERXRequest;
import er.extensions.appserver.ERXResourceManager;
import er.extensions.appserver.ERXResponse;
import er.extensions.appserver.ERXSecureDefaultAdaptor;
import er.extensions.appserver.ERXSession;
import er.extensions.appserver.ERXStaticResourceRequestHandler;
import er.extensions.appserver.ERXWOContext;
import er.extensions.appserver.ERXWOServletContext;
import er.extensions.appserver.ajax.ERXAjaxApplication;
import er.extensions.components.ERXAnyField;
import er.extensions.components.ERXGracefulShutdown;
import er.extensions.components._private.ERXActiveImage;
import er.extensions.components._private.ERXWOForm;
import er.extensions.components._private.ERXWORepetition;
import er.extensions.components._private.ERXWOString;
import er.extensions.components._private.ERXWOText;
import er.extensions.components._private.ERXWOTextField;
import er.extensions.eof.ERXConstant;
import er.extensions.eof.ERXDatabaseContextDelegate;
import er.extensions.eof.ERXEC;
import er.extensions.formatters.ERXFormatterFactory;
import er.extensions.foundation.ERXArrayUtilities;
import er.extensions.foundation.ERXCompressionUtilities;
import er.extensions.foundation.ERXConfigurationManager;
import er.extensions.foundation.ERXPatcher;
import er.extensions.foundation.ERXProperties;
import er.extensions.foundation.ERXRuntimeUtilities;
import er.extensions.foundation.ERXThreadStorage;
import er.extensions.foundation.ERXTimestampUtility;
import er.extensions.localization.ERXLocalizer;
import er.extensions.migration.ERXMigrator;
import er.extensions.statistics.ERXStats;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ERXApplication
extends ERXAjaxApplication
implements ERXGracefulShutdown.GracefulApplication {
    private static Boolean isWO54 = null;
    public static final Logger log = Logger.getLogger(ERXApplication.class);
    public static final Logger requestHandlingLog = Logger.getLogger((String)"er.extensions.ERXApplication.RequestHandling");
    public static final Logger statsLog = Logger.getLogger((String)"er.extensions.ERXApplication.Statistics");
    public static final Logger startupLog = Logger.getLogger((String)"er.extensions.ERXApplication.Startup");
    private static boolean wasERXApplicationMainInvoked = false;
    public static final String LowMemoryNotification = "LowMemoryNotification";
    public static final String LowMemoryResolvedNotification = "LowMemoryResolvedNotification";
    public static final String StarvedMemoryNotification = "StarvedMemoryNotification";
    public static final String StarvedMemoryResolvedNotification = "StarvedMemoryResolvedNotification";
    public static final String ApplicationWillTerminateNotification = "ApplicationWillTerminateNotification";
    private static byte[] lowMemBuffer;
    private static int lowMemBufferSize;
    public static final String AppShouldExitOnOutOfMemoryError = "er.extensions.AppShouldExitOnOutOfMemoryError";
    public static final String AllBundlesLoadedNotification = "NSBundleAllBundlesLoaded";
    public static final String ApplicationDidCreateNotification = "NSApplicationDidCreateNotification";
    public static final String ApplicationDidFinishInitializationNotification = "NSApplicationDidFinishInitializationNotification";
    private static ThreadLocal<Boolean> isInRequest;
    protected static NSDictionary propertiesFromArgv;
    private long _lastGC = 0L;
    protected BigDecimal _memoryStarvedThreshold;
    protected BigDecimal _memoryLowThreshold;
    protected String _replaceApplicationPathPattern;
    protected String _replaceApplicationPathReplace;
    protected String _sslHost;
    protected Integer _sslPort;
    protected boolean _initializedAdaptors = false;
    private static Loader _loader;
    protected WOTimer _killTimer;
    private boolean _isMemoryLow = false;
    private boolean _isMemoryStarved = false;
    private String _nameSuffix;
    private boolean _nameSuffixLookedUp = false;
    private String _userDefaultName;
    protected Boolean useComponentActionRedirection;
    protected NSMutableArray<String> _streamingRequestHandlerKeys = new NSMutableArray<String>(this.streamActionRequestHandlerKey());
    protected Boolean _useSessionStoreDeadlockDetection;
    private Map<String, SessionInfo> _sessions = new HashMap<String, SessionInfo>();
    protected static final ERXFormatterFactory _formatterFactory;
    protected Boolean _responseCompressionEnabled;
    protected NSSet<String> _responseCompressionTypes;
    private NSMutableSet<String> _debugComponents = new NSMutableSet();

    private static void insertCommandLineArguments() {
        NSArray keys = propertiesFromArgv.allKeys();
        int count = keys.count();
        for (int i = 0; i < count; ++i) {
            Object key = keys.objectAtIndex(i);
            Object value = propertiesFromArgv.objectForKey(key);
            NSProperties._setProperty((String)((String)key), (String)((String)value));
        }
    }

    public static void main(String[] argv, Class applicationClass) {
        ERXApplication.setup(argv);
        WOApplication.main((String[])argv, (Class)applicationClass);
    }

    public static void setup(String[] argv) {
        _loader = new Loader(argv);
        if (System.getProperty("_DisableClasspathReorder") == null) {
            ClassLoader loader = AppClassLoader.getAppClassLoader();
            Thread.currentThread().setContextClassLoader(loader);
        }
        if (!ERXApplication.isWO54()) {
            Class<NSMutableArray> arrayClass = NSMutableArray.class;
            try {
                Field f = arrayClass.getField("ERX_MARKER");
            }
            catch (NoSuchFieldException e) {
                System.err.println("No ERX_MARKER field in NSMutableArray found. \nThis means your class path is incorrect. Adjust it so that ERExtensions come before JavaFoundation.");
                System.exit(1);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        ERXConfigurationManager.defaultManager().setCommandLineArguments(argv);
        ERXFrameworkPrincipal.setUpFrameworkPrincipalClass(ERXExtensions.class);
        ERXStats.initStatisticsIfNecessary();
    }

    public void installPatches() {
        ERXPatcher.installPatches();
        if (this.contextClassName().equals("WOContext")) {
            if (ERXApplication.isWO54()) {
                this.setContextClassName("ERXWOContext54");
            } else {
                this.setContextClassName(ERXWOContext.class.getName());
            }
        }
        if (this.contextClassName().equals("WOServletContext") || this.contextClassName().equals("com.webobjects.jspservlet.WOServletContext")) {
            if (ERXApplication.isWO54()) {
                this.setContextClassName("ERXWOServletContext54");
            } else {
                this.setContextClassName(ERXWOServletContext.class.getName());
            }
        }
        ERXPatcher.setClassForName(ERXWOForm.class, "WOForm");
        try {
            ERXPatcher.setClassForName(ERXAnyField.class, "WOAnyField");
        }
        catch (NoClassDefFoundError e) {
            log.info((Object)"JavaWOExtensions is not loaded, so WOAnyField will not be patched.");
        }
        ERXPatcher.setClassForName(ERXWORepetition.class, "WORepetition");
        ERXPatcher.setClassForName(ERXActiveImage.class, "WOActiveImage");
        if (ERXLocalizer.isLocalizationEnabled()) {
            ERXPatcher.setClassForName(ERXWOString.class, "WOString");
            ERXPatcher.setClassForName(ERXWOTextField.class, "WOTextField");
        }
        WOURLEncoder.WO_URL_ENCODING = "UTF-8";
        if (ERXProperties.webObjectsVersionAsDouble() < 5.2) {
            ERXPatcher.setClassForName(ERXWOText.class, "WOText");
        }
    }

    public WOResourceManager createResourceManager() {
        return new ERXResourceManager();
    }

    public ERXApplication() {
        Boolean traceOpenLocks;
        String defaultMessageEncoding;
        String defaultEncoding;
        this.frameworksBaseURL();
        this.applicationBaseURL();
        if (System.getProperty("WOFrameworksBaseURL") != null) {
            this.setFrameworksBaseURL(System.getProperty("WOFrameworksBaseURL"));
        }
        if (System.getProperty("WOApplicationBaseURL") != null) {
            this.setApplicationBaseURL(System.getProperty("WOApplicationBaseURL"));
        }
        if (!(ERXConfigurationManager.defaultManager().isDeployedAsServlet() || wasERXApplicationMainInvoked && _loader != null)) {
            this._displayMainMethodWarning();
        }
        if (_loader == null) {
            System.out.println("No loader: " + System.getProperty("java.class.path"));
        } else if (!_loader.didLoad()) {
            throw new RuntimeException("ERXExtensions have not been initialized. Please report the classpath and the rest of the bundles to the Wonder mailing list: \nRemaining frameworks: " + (_loader == null ? "none" : _loader.allFrameworks) + "\nClasspath: " + System.getProperty("java.class.path"));
        }
        if ("JavaFoundation".equals(NSBundle.mainBundle().name())) {
            throw new RuntimeException("Your main bundle is \"JavaFoundation\".  You are not launching this WO application properly.  If you are using Eclipse, most likely you launched your WOA as a \"Java Application\" instead of a \"WO Application\".");
        }
        Enumeration e = Logger.getRootLogger().getAllAppenders();
        while (e.hasMoreElements()) {
            Appender appender = (Appender)e.nextElement();
            if (!(appender instanceof ConsoleAppender)) continue;
            ConsoleAppender app = (ConsoleAppender)appender;
            app.activateOptions();
        }
        if (_loader != null) {
            _loader._checker.reportErrors();
        }
        NSNotificationCenter.defaultCenter().postNotification(new NSNotification(ApplicationDidCreateNotification, (Object)this));
        this.installPatches();
        lowMemBufferSize = ERXProperties.intForKeyWithDefault("er.extensions.ERXApplication.lowMemBufferSize", 0);
        if (lowMemBufferSize > 0) {
            lowMemBuffer = new byte[lowMemBufferSize];
        }
        this.registerRequestHandler((WORequestHandler)new ERXDirectActionRequestHandler(), this.directActionRequestHandlerKey());
        if (this._rapidTurnaroundActiveForAnyProject() && this.isDirectConnectEnabled()) {
            this.registerRequestHandler(new ERXStaticResourceRequestHandler(), "_wr_");
        }
        this.registerRequestHandler((WORequestHandler)new ERXDirectActionRequestHandler(ERXDirectAction.class.getName(), "stats", false), "erxadm");
        Long timestampLag = Long.getLong("EOEditingContextDefaultFetchTimestampLag");
        if (timestampLag != null) {
            EOEditingContext.setDefaultFetchTimestampLag((long)timestampLag);
        }
        if ((defaultEncoding = System.getProperty("er.extensions.ERXApplication.DefaultEncoding")) != null) {
            log.debug((Object)("Setting default encoding to \"" + defaultEncoding + "\""));
            this.setDefaultEncoding(defaultEncoding);
        }
        if ((defaultMessageEncoding = System.getProperty("er.extensions.ERXApplication.DefaultMessageEncoding")) != null) {
            log.debug((Object)("Setting WOMessage default encoding to \"" + defaultMessageEncoding + "\""));
            WOMessage.setDefaultEncoding((String)defaultMessageEncoding);
        }
        this.configureStatisticsLogging();
        NSNotificationCenter.defaultCenter().addObserver((Object)this, new NSSelector("finishInitialization", ERXConstant.NotificationClassArray), "ApplicationWillFinishLaunchingNotification", null);
        NSNotificationCenter.defaultCenter().addObserver((Object)this, new NSSelector("didFinishLaunching", ERXConstant.NotificationClassArray), "ApplicationDidFinishLaunchingNotification", null);
        Boolean useUnlocker = this.useEditingContextUnlocker();
        if (useUnlocker != null) {
            ERXEC.setUseUnlocker(useUnlocker);
        }
        if ((traceOpenLocks = this.traceOpenEditingContextLocks()) != null) {
            ERXEC.setTraceOpenLocks(traceOpenLocks);
        }
        if (ERXGracefulShutdown.isEnabled()) {
            ERXGracefulShutdown.installHandler();
        }
        EOTemporaryGlobalID._setProcessIdentificationBytesFromInt((int)this.port().intValue());
        this._memoryStarvedThreshold = ERXProperties.bigDecimalForKey("er.extensions.ERXApplication.memoryThreshold");
        this._memoryStarvedThreshold = ERXProperties.bigDecimalForKeyWithDefault("er.extensions.ERXApplication.memoryStarvedThreshold", this._memoryStarvedThreshold);
        this._memoryLowThreshold = ERXProperties.bigDecimalForKeyWithDefault("er.extensions.ERXApplication.memoryLowThreshold", this._memoryLowThreshold);
        this._replaceApplicationPathPattern = ERXProperties.stringForKey("er.extensions.ERXApplication.replaceApplicationPath.pattern");
        if (this._replaceApplicationPathPattern != null && this._replaceApplicationPathPattern.length() == 0) {
            this._replaceApplicationPathPattern = null;
        }
        this._replaceApplicationPathReplace = ERXProperties.stringForKey("er.extensions.ERXApplication.replaceApplicationPath.replace");
        if (this._replaceApplicationPathPattern == null && this.rewriteDirectConnectURL()) {
            this._replaceApplicationPathPattern = "/cgi-bin/WebObjects/" + this.name() + ".woa";
            if (this._replaceApplicationPathReplace == null) {
                this._replaceApplicationPathReplace = "";
            }
        }
    }

    public String _newLocationForRequest(WORequest aRequest) {
        return this._rewriteURL(super._newLocationForRequest(aRequest));
    }

    public Boolean useEditingContextUnlocker() {
        Boolean useUnlocker = null;
        if (ERXProperties.stringForKey("er.extensions.ERXApplication.useEditingContextUnlocker") != null) {
            useUnlocker = ERXProperties.booleanForKeyWithDefault("er.extensions.ERXApplication.useEditingContextUnlocker", false);
        }
        return useUnlocker;
    }

    public Boolean traceOpenEditingContextLocks() {
        Boolean traceOpenLocks = null;
        if (ERXProperties.stringForKey("er.extensions.ERXApplication.traceOpenEditingContextLocks") != null) {
            traceOpenLocks = ERXProperties.booleanForKeyWithDefault("er.extensions.ERXApplication.traceOpenEditingContextLocks", false);
        }
        return traceOpenLocks;
    }

    public void configureStatisticsLogging() {
        String statisticsBasePath = System.getProperty("er.extensions.ERXApplication.StatisticsBaseLogPath");
        if (statisticsBasePath != null) {
            int rotationFrequency = ERXProperties.intForKeyWithDefault("er.extensions.ERXApplication.StatisticsLogRotationFrequency", 86400000);
            String logPath = statisticsBasePath + File.separator + this.name() + "-" + ERXConfigurationManager.defaultManager().hostName() + "-" + this.port() + ".log";
            if (log.isDebugEnabled()) {
                log.debug((Object)("Configured statistics logging to file path \"" + logPath + "\" with rotation frequency: " + rotationFrequency));
            }
            this.statisticsStore().setLogFile(logPath, (long)rotationFrequency);
        }
    }

    public final void finishInitialization(NSNotification n) {
        this.finishInitialization();
        if (ERXMigrator.shouldMigrateAtStartup()) {
            ERXMigrator migrator = this.migrator();
            this.migrationsWillRun(migrator);
            migrator.migrateToLatest();
            this.migrationsDidRun(migrator);
        }
        NSNotificationCenter.defaultCenter().postNotification(new NSNotification(ApplicationDidFinishInitializationNotification, (Object)this));
    }

    protected void migrationsWillRun(ERXMigrator migrator) {
    }

    protected void migrationsDidRun(ERXMigrator migrator) {
    }

    public final void didFinishLaunching(NSNotification n) {
        this.didFinishLaunching();
        ERXStats.logStatisticsForOperation(statsLog, "sum");
        if (this.isDevelopmentMode() && !this.autoOpenInBrowser()) {
            log.warn((Object)"You are running in development mode with WOAutoOpenInBrowser = false.  No browser will open and it will look like the application is hung, but it's not.  There's just not a browser opening automatically.");
        }
    }

    public void finishInitialization() {
    }

    public void didFinishLaunching() {
    }

    public static ERXApplication erxApplication() {
        return (ERXApplication)WOApplication.application();
    }

    public void run() {
        try {
            int timeToDie;
            int timeToLive = ERXProperties.intForKey("ERTimeToLive");
            if (timeToLive > 0) {
                log.info((Object)("Instance will live " + timeToLive + " seconds."));
                NSLog.out.appendln((Object)("Instance will live " + timeToLive + " seconds."));
                timeToLive = (int)((double)timeToLive + Math.random() * 600.0);
                NSTimestamp exitDate = new NSTimestamp().timestampByAddingGregorianUnits(0, 0, 0, 0, 0, timeToLive);
                WOTimer t = new WOTimer(exitDate, 0L, (Object)this, "killInstance", null, null, false);
                t.schedule();
            }
            if ((timeToDie = ERXProperties.intForKey("ERTimeToDie")) > 0) {
                log.info((Object)("Instance will not live past " + timeToDie + ":00."));
                NSLog.out.appendln((Object)("Instance will not live past " + timeToDie + ":00."));
                NSTimestamp now = new NSTimestamp();
                int s = (timeToDie - ERXTimestampUtility.hourOfDay(now)) * 3600 - ERXTimestampUtility.minuteOfHour(now) * 60;
                if (s < 0) {
                    s += 86400;
                }
                s = (int)((double)s + Math.random() * 3600.0);
                NSTimestamp stopDate = now.timestampByAddingGregorianUnits(0, 0, 0, 0, 0, s);
                WOTimer t = new WOTimer(stopDate, 0L, (Object)this, "startRefusingSessions", null, null, false);
                t.schedule();
            }
            super.run();
        }
        catch (RuntimeException t) {
            if (_wasMainInvoked) {
                log.error((Object)(this.name() + " failed to start."), (Throwable)t);
            }
            throw t;
        }
    }

    public WORequest createRequest(String aMethod, String aURL, String anHTTPVersion, NSDictionary someHeaders, NSData aContent, NSDictionary someInfo) {
        return this._createRequest(aMethod, aURL, anHTTPVersion, someHeaders, aContent, someInfo);
    }

    public WORequest createRequest(String method, String aurl, String anHTTPVersion, Map<String, ? extends List<String>> someHeaders, NSData content, Map<String, Object> someInfo) {
        return this._createRequest(method, aurl, anHTTPVersion, someHeaders != null ? new NSDictionary<String, List<String>>(someHeaders, true) : null, content, someInfo != null ? new NSDictionary<String, Object>(someInfo, true) : null);
    }

    protected WORequest _createRequest(String aMethod, String aURL, String anHTTPVersion, NSDictionary someHeaders, NSData aContent, NSDictionary someInfo) {
        if (anHTTPVersion == null || anHTTPVersion.startsWith("INCLUDED")) {
            anHTTPVersion = "HTTP/1.0";
        }
        if ("GET".equalsIgnoreCase(aMethod) && someHeaders != null && someHeaders.objectForKey("content-type") != null) {
            someHeaders = ((NSDictionary)someHeaders).mutableClone();
            someHeaders.removeObjectForKey("content-type");
        }
        if (this.rewriteDirectConnectURL()) {
            aURL = "/cgi-bin/WebObjects/" + this.name() + ".woa" + aURL;
        }
        ERXRequest worequest = new ERXRequest(aMethod, aURL, anHTTPVersion, someHeaders, aContent, someInfo);
        return worequest;
    }

    public static WOComponent instantiatePage(String pageName) {
        WOContext context = ERXWOContext.newContext();
        return ERXApplication.application().pageWithName(pageName, context);
    }

    public void startRefusingSessions() {
        log.info((Object)"Refusing new sessions");
        NSLog.out.appendln((Object)"Refusing new sessions");
        this.refuseNewSessions(true);
    }

    public WOComponentDefinition _componentDefinition(String s, NSArray nsarray) {
        if (ERXProperties.booleanForKeyWithDefault("er.extensions.ERXApplication.fixCachingEnabled", true)) {
            return super._componentDefinition(s, nsarray != null ? nsarray.arrayByAddingObjectsFromArray(this._expectedLanguages()) : this._expectedLanguages());
        }
        return super._componentDefinition(s, nsarray);
    }

    protected void checkMemory() {
        boolean memoryStarved;
        boolean memoryLow = this.checkMemory(this._memoryLowThreshold, false);
        if (memoryLow != this._isMemoryLow) {
            if (!memoryLow) {
                log.warn((Object)"App is no longer low on memory");
                NSNotificationCenter.defaultCenter().postNotification(new NSNotification(LowMemoryResolvedNotification, (Object)this));
            } else {
                log.error((Object)"App is low on memory");
                NSNotificationCenter.defaultCenter().postNotification(new NSNotification(LowMemoryNotification, (Object)this));
            }
            this._isMemoryLow = memoryLow;
        }
        if ((memoryStarved = this.checkMemory(this._memoryStarvedThreshold, true)) != this._isMemoryStarved) {
            if (!memoryStarved) {
                log.warn((Object)"App is no longer starved, handling new sessions again");
                NSNotificationCenter.defaultCenter().postNotification(new NSNotification(StarvedMemoryResolvedNotification, (Object)this));
            } else {
                log.error((Object)"App is starved, starting to refuse new sessions");
                NSNotificationCenter.defaultCenter().postNotification(new NSNotification(StarvedMemoryNotification, (Object)this));
            }
            this._isMemoryStarved = memoryStarved;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean checkMemory(BigDecimal memoryThreshold, boolean attemptGC) {
        boolean pastThreshold = false;
        if (memoryThreshold != null) {
            long max = Runtime.getRuntime().maxMemory();
            long total = Runtime.getRuntime().totalMemory();
            long free = Runtime.getRuntime().freeMemory() + (max - total);
            long used = max - free;
            long starvedThreshold = (long)(memoryThreshold.doubleValue() < 1.0 ? memoryThreshold.doubleValue() * (double)max : (double)max - memoryThreshold.doubleValue() * 1024.0 * 1024.0);
            ERXApplication eRXApplication = this;
            synchronized (eRXApplication) {
                long time = System.currentTimeMillis();
                if (attemptGC && used > starvedThreshold && time > this._lastGC + 60000L) {
                    this._lastGC = time;
                    Runtime.getRuntime().gc();
                    max = Runtime.getRuntime().maxMemory();
                    total = Runtime.getRuntime().totalMemory();
                    free = Runtime.getRuntime().freeMemory() + (max - total);
                    used = max - free;
                }
                pastThreshold = used > starvedThreshold;
            }
        }
        return pastThreshold;
    }

    protected boolean refuseSessionsOnStarvedMemory() {
        return true;
    }

    public boolean isRefusingNewSessions() {
        return super.isRefusingNewSessions() || this.refuseSessionsOnStarvedMemory() && this._isMemoryStarved;
    }

    public synchronized void refuseNewSessions(boolean value) {
        boolean success = false;
        try {
            Field f = WOApplication.class.getDeclaredField("_refusingNewClients");
            f.setAccessible(true);
            f.set(this, value);
            success = true;
        }
        catch (SecurityException e) {
            log.error((Object)e, (Throwable)e);
        }
        catch (NoSuchFieldException e) {
            log.error((Object)e, (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            log.error((Object)e, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            log.error((Object)e, (Throwable)e);
        }
        if (!success) {
            super.refuseNewSessions(value);
        }
        if (value && this.activeSessionsCount() <= this.minimumActiveSessionsCount()) {
            log.info((Object)"Refusing new clients and below min active session threshold, about to terminate...");
            this.terminate();
        }
        this.resetKillTimer(this.isRefusingNewSessions());
    }

    private void resetKillTimer(boolean install) {
        int timeToKill;
        if (this._killTimer != null) {
            this._killTimer.invalidate();
            this._killTimer = null;
        }
        if (install && (timeToKill = ERXProperties.intForKey("ERTimeToKill")) > 0) {
            log.warn((Object)("Registering kill timer in " + timeToKill + "seconds"));
            NSTimestamp exitDate = new NSTimestamp().timestampByAddingGregorianUnits(0, 0, 0, 0, 0, timeToKill);
            this._killTimer = new WOTimer(exitDate, 0L, (Object)this, "killInstance", null, null, false);
            this._killTimer.schedule();
        }
    }

    public void killInstance() {
        log.info((Object)"Forcing exit");
        NSLog.out.appendln((Object)"Forcing exit");
        System.exit(1);
    }

    public String nameSuffix() {
        if (!this._nameSuffixLookedUp) {
            this._nameSuffix = System.getProperty("ERApplicationNameSuffix");
            this._nameSuffix = this._nameSuffix == null ? "" : this._nameSuffix;
            this._nameSuffixLookedUp = true;
        }
        return this._nameSuffix;
    }

    public String name() {
        if (this._userDefaultName == null) {
            String suffix;
            this._userDefaultName = System.getProperty("ERApplicationName");
            if (this._userDefaultName == null) {
                this._userDefaultName = super.name();
            }
            if (this._userDefaultName != null && (suffix = this.nameSuffix()) != null && suffix.length() > 0) {
                this._userDefaultName = this._userDefaultName + suffix;
            }
        }
        return this._userDefaultName;
    }

    public String rawName() {
        return super.name();
    }

    public NSMutableDictionary extraInformationForExceptionInContext(Exception e, WOContext context) {
        NSMutableDictionary<String, Object> extraInfo = ERXRuntimeUtilities.informationForException(e);
        extraInfo.addEntriesFromDictionary(ERXRuntimeUtilities.informationForContext(context));
        extraInfo.addEntriesFromDictionary(ERXRuntimeUtilities.informationForBundles());
        return extraInfo;
    }

    public WOResponse reportException(Throwable exception, WOContext context, NSDictionary extraInfo) {
        log.error((Object)("Exception caught: " + exception.getMessage() + "\nExtra info: " + NSPropertyListSerialization.stringFromPropertyList((Object)extraInfo) + "\n"), exception);
        return null;
    }

    public WOResponse handleActionRequestError(WORequest aRequest, Exception exception, String reason, WORequestHandler aHandler, String actionClassName, String actionName, Class actionClass, WOAction actionInstance) {
        WOContext context = actionInstance != null ? actionInstance.context() : null;
        boolean didCreateContext = false;
        if (context == null) {
            context = this.createContextForRequest(aRequest);
            didCreateContext = true;
        }
        WOResponse response = this.handleException(exception, context);
        if (didCreateContext) {
            context._putAwakeComponentsToSleep();
            this.saveSessionForContext(context);
        } else if (context.hasSession() && ("InstantiationError".equals(reason) || "InvocationError".equals(reason))) {
            context._putAwakeComponentsToSleep();
            this.saveSessionForContext(context);
        }
        return response;
    }

    public WOResponse handleException(Exception exception, WOContext context) {
        String retryKey;
        if (ERXProperties.booleanForKey("er.extensions.ERXApplication.redirectOnMissingObjects") && exception instanceof ERXDatabaseContextDelegate.ObjectNotAvailableException && context != null && (retryKey = context.request().stringFormValueForKey("ERXRetry")) == null) {
            WORedirect page = new WORedirect(context);
            page.setUrl(context.request().uri() + "?ERXRetry=1");
            return page.generateResponse();
        }
        this.handlePotentiallyFatalException(exception);
        NSMutableDictionary extraInfo = this.extraInformationForExceptionInContext(exception, context);
        WOResponse response = this.reportException(exception, context, extraInfo);
        if (response == null) {
            response = super.handleException(exception, context);
        }
        return response;
    }

    public WOResponse genericHandleException(Exception exception, WOContext context) {
        return super.handleException(exception, context);
    }

    public void handlePotentiallyFatalException(Exception exception) {
        Throwable throwable = ERXRuntimeUtilities.originalThrowable(exception);
        if (throwable instanceof Error) {
            boolean shouldQuit = false;
            if (throwable instanceof OutOfMemoryError) {
                boolean shouldExitOnOOMError;
                shouldQuit = shouldExitOnOOMError = ERXProperties.booleanForKeyWithDefault(AppShouldExitOnOutOfMemoryError, true);
                if (lowMemBuffer != null) {
                    Runtime.getRuntime().freeMemory();
                    try {
                        lowMemBuffer = null;
                        System.gc();
                        log.error((Object)"Ran out of memory, sending notification to clear caches");
                        log.error((Object)"Ran out of memory, sending notification to clear caches", throwable);
                        NSNotificationCenter.defaultCenter().postNotification(new NSNotification(LowMemoryNotification, (Object)this));
                        shouldQuit = false;
                        lowMemBuffer = new byte[lowMemBufferSize * 2];
                        lowMemBuffer = new byte[lowMemBufferSize];
                    }
                    catch (Throwable ex) {
                        shouldQuit = shouldExitOnOOMError;
                    }
                }
                if (shouldQuit) {
                    NSLog.err.appendln((Object)"Ran out of memory, killing this instance");
                    log.fatal((Object)"Ran out of memory, killing this instance");
                    log.fatal((Object)"Ran out of memory, killing this instance", throwable);
                }
            } else {
                NSLog.err.appendln((Object)("java.lang.Error \"" + throwable.getClass().getName() + "\" occured."));
                log.error((Object)("java.lang.Error \"" + throwable.getClass().getName() + "\" occured."), throwable);
            }
            if (shouldQuit) {
                Runtime.getRuntime().exit(1);
            }
        }
    }

    public boolean useComponentActionRedirection() {
        if (this.useComponentActionRedirection == null) {
            this.useComponentActionRedirection = ERXProperties.booleanForKey("er.extensions.ERXComponentActionRedirector.enabled") ? Boolean.TRUE : Boolean.FALSE;
        }
        return this.useComponentActionRedirection;
    }

    @Override
    public WOActionResults invokeAction(WORequest request, WOContext context) {
        WOActionResults results = super.invokeAction(request, context);
        if (this.useComponentActionRedirection()) {
            ERXComponentActionRedirector.createRedirector(results);
        }
        return results;
    }

    public void appendToResponse(WOResponse response, WOContext context) {
        ERXComponentActionRedirector redirector;
        super.appendToResponse(response, context);
        if (this.useComponentActionRedirection() && (redirector = ERXComponentActionRedirector.currentRedirector()) != null) {
            redirector.setOriginalResponse(response);
        }
    }

    public static void _startRequest() {
        isInRequest.set(Boolean.TRUE);
    }

    public static void _endRequest() {
        isInRequest.remove();
        ERXThreadStorage.reset();
        ERXEC.unlockAllContextsForCurrentThread();
        ERXRuntimeUtilities.clearThreadInterrupt(Thread.currentThread());
    }

    public static boolean isInRequest() {
        return isInRequest.get() != null;
    }

    public ERXDelayedRequestHandler delayedRequestHandler() {
        return (ERXDelayedRequestHandler)this.requestHandlerForKey(ERXDelayedRequestHandler.KEY);
    }

    public WOResponse dispatchRequest(WORequest request) {
        WOResponse response = null;
        ERXDelayedRequestHandler delayedRequestHandler = this.delayedRequestHandler();
        response = delayedRequestHandler == null ? this.dispatchRequestImmediately(request) : delayedRequestHandler.handleRequest(request);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WOResponse dispatchRequestImmediately(WORequest request) {
        WOResponse response;
        if (requestHandlingLog.isDebugEnabled()) {
            requestHandlingLog.debug((Object)request);
        }
        try {
            ERXApplication._startRequest();
            ERXStats.initStatisticsIfNecessary();
            this.checkMemory();
            if (this.useComponentActionRedirection()) {
                ERXComponentActionRedirector redirector = ERXComponentActionRedirector.redirectorForRequest(request);
                if (redirector == null) {
                    response = super.dispatchRequest(request);
                    redirector = ERXComponentActionRedirector.currentRedirector();
                    if (redirector != null) {
                        response = redirector.redirectionResponse();
                    }
                } else {
                    response = redirector.originalResponse();
                }
            } else {
                response = super.dispatchRequest(request);
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            ERXStats.logStatisticsForOperation(statsLog, "key");
            ERXApplication._endRequest();
            throw throwable;
        }
        ERXStats.logStatisticsForOperation(statsLog, "key");
        ERXApplication._endRequest();
        if (requestHandlingLog.isDebugEnabled()) {
            requestHandlingLog.debug((Object)("Returning, encoding: " + response.contentEncoding() + " response: " + response));
        }
        if (this.responseCompressionEnabled()) {
            String acceptEncoding;
            String contentType = response.headerForKey((Object)"content-type");
            if (!"gzip".equals(response.headerForKey((Object)"content-encoding")) && contentType != null && (contentType.startsWith("text/") || this.responseCompressionTypes().containsObject(contentType)) && (acceptEncoding = request.headerForKey((Object)"accept-encoding")) != null && acceptEncoding.toLowerCase().indexOf("gzip") != -1) {
                byte[] compressedData;
                long inputBytesLength;
                long start = System.currentTimeMillis();
                InputStream contentInputStream = response.contentInputStream();
                if (contentInputStream != null) {
                    inputBytesLength = response.contentInputStreamLength();
                    NSData compressedNSData = ERXCompressionUtilities.gzipInputStreamAsNSData(contentInputStream, (int)inputBytesLength);
                    compressedData = compressedNSData._bytesNoCopy();
                    response.setContentStream(null, 0, 0);
                } else {
                    NSData input = response.content();
                    inputBytesLength = input.length();
                    byte[] byArray = compressedData = inputBytesLength > 0L ? ERXCompressionUtilities.gzipByteArray(input._bytesNoCopy()) : null;
                }
                if (inputBytesLength > 0L && compressedData != null) {
                    response.setContent(new NSData(compressedData, new NSRange(0, compressedData.length), true));
                    response.setHeader(String.valueOf(compressedData.length), "content-length");
                    response.setHeader("gzip", "content-encoding");
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("before: " + inputBytesLength + ", after " + compressedData.length + ", time: " + (System.currentTimeMillis() - start)));
                    }
                }
            }
        }
        return response;
    }

    public WOContext createContextForRequest(WORequest request) {
        WOContext context = super.createContextForRequest(request);
        if (ERXWOContext.currentContext() == null) {
            ERXWOContext.setCurrentContext(context);
        }
        return context;
    }

    public WOResponse createResponseInContext(WOContext context) {
        ERXResponse response = new ERXResponse(context);
        return response;
    }

    @Override
    public void gracefulTerminate() {
        this.terminate();
    }

    private void _displayMainMethodWarning() {
        log.warn((Object)("\n\nIt seems that your application class " + ERXApplication.application().getClass().getName() + " did not call " + ERXApplication.class.getName() + ".main(argv[], applicationClass) method. " + "Please modify your Application.java as the followings so that " + ERXConfigurationManager.class.getName() + " can provide its " + "rapid turnaround feature completely. \n\n" + "Please change Application.java like this: \n" + "public static void main(String argv[]) { \n" + "    ERXApplication.main(argv, Application.class); \n" + "}\n\n"));
    }

    public void registerStreamingRequestHandlerKey(String s) {
        if (!this._streamingRequestHandlerKeys.containsObject(s)) {
            this._streamingRequestHandlerKeys.addObject(s);
        }
    }

    public boolean isStreamingRequestHandlerKey(String s) {
        return this._streamingRequestHandlerKeys.containsObject(s);
    }

    public boolean useSessionStoreDeadlockDetection() {
        if (this._useSessionStoreDeadlockDetection == null) {
            Boolean bl = this._useSessionStoreDeadlockDetection = ERXProperties.booleanForKey("er.extensions.ERXApplication.useSessionStoreDeadlockDetection") ? Boolean.TRUE : Boolean.FALSE;
            if (this.isConcurrentRequestHandlingEnabled() && this._useSessionStoreDeadlockDetection.booleanValue()) {
                log.error((Object)"Sorry, useSessionStoreDeadlockDetection does not work with concurrent request handling enabled.");
                this._useSessionStoreDeadlockDetection = Boolean.FALSE;
            }
        }
        return this._useSessionStoreDeadlockDetection;
    }

    public static boolean isWO54() {
        if (isWO54 == null) {
            try {
                Method getWebObjectsVersionMethod = WOApplication.class.getMethod("getWebObjectsVersion", new Class[0]);
                isWO54 = Boolean.TRUE;
            }
            catch (Exception e) {
                isWO54 = Boolean.FALSE;
            }
        }
        return isWO54;
    }

    public static boolean isDevelopmentModeSafe() {
        boolean developmentMode;
        WOApplication application = WOApplication.application();
        if (application instanceof ERXApplication) {
            ERXApplication erxApplication = (ERXApplication)application;
            developmentMode = erxApplication.isDevelopmentMode();
        } else {
            developmentMode = ERXApplication._defaultIsDevelopmentMode();
        }
        return developmentMode;
    }

    protected static boolean _defaultIsDevelopmentMode() {
        boolean developmentMode = false;
        if (ERXProperties.stringForKey("er.extensions.ERXApplication.developmentMode") != null) {
            developmentMode = ERXProperties.booleanForKey("er.extensions.ERXApplication.developmentMode");
        } else {
            String ide = ERXProperties.stringForKey("WOIDE");
            if ("WOLips".equals(ide) || "Xcode".equals(ide)) {
                developmentMode = true;
            }
            if (!developmentMode) {
                developmentMode = ERXProperties.booleanForKey("NSProjectBundleEnabled");
            }
        }
        return developmentMode;
    }

    public boolean isDevelopmentMode() {
        return ERXApplication._defaultIsDevelopmentMode();
    }

    public WOSession createSessionForRequest(WORequest worequest) {
        WOSession wosession = super.createSessionForRequest(worequest);
        if (wosession != null && this.useSessionStoreDeadlockDetection()) {
            this._sessions.put(wosession.sessionID(), new SessionInfo(null));
        }
        return wosession;
    }

    public void saveSessionForContext(WOContext wocontext) {
        WOSession wosession;
        if (this.useSessionStoreDeadlockDetection() && (wosession = wocontext._session()) != null) {
            String sessionID = wosession.sessionID();
            SessionInfo sessionInfo = this._sessions.get(sessionID);
            if (sessionInfo == null) {
                log.error((Object)("Check-In of session that was not checked out, most likely diue to an exception in session.awake(): " + sessionID));
            } else {
                this._sessions.remove(sessionID);
            }
        }
        super.saveSessionForContext(wocontext);
    }

    public WOSession restoreSessionWithID(String sessionID, WOContext wocontext) {
        if (sessionID != null && ERXSession.session() != null && sessionID.equals(ERXSession.session().sessionID())) {
            throw new IllegalStateException("Trying to check out a session twice in one RR loop: " + sessionID);
        }
        WOSession session = null;
        if (this.useSessionStoreDeadlockDetection()) {
            SessionInfo sessionInfo = this._sessions.get(sessionID);
            if (sessionInfo != null) {
                throw new IllegalStateException(sessionInfo.exceptionMessageForCheckout(wocontext));
            }
            session = super.restoreSessionWithID(sessionID, wocontext);
            if (session != null) {
                this._sessions.put(session.sessionID(), new SessionInfo(wocontext));
            }
        } else {
            session = super.restoreSessionWithID(sessionID, wocontext);
        }
        return session;
    }

    public Number sessionTimeOutInMinutes() {
        return new Integer(this.sessionTimeOut().intValue() / 60);
    }

    public ERXFormatterFactory formatterFactory() {
        return _formatterFactory;
    }

    public boolean responseCompressionEnabled() {
        if (this._responseCompressionEnabled == null) {
            this._responseCompressionEnabled = ERXProperties.booleanForKeyWithDefault("er.extensions.ERXApplication.responseCompressionEnabled", false) ? Boolean.TRUE : Boolean.FALSE;
        }
        return this._responseCompressionEnabled;
    }

    public NSSet<String> responseCompressionTypes() {
        if (this._responseCompressionTypes == null) {
            this._responseCompressionTypes = new NSSet<NSArray>(ERXProperties.arrayForKeyWithDefault("er.extensions.ERXApplication.responseCompressionTypes", new NSArray<String>("application/x-javascript")));
        }
        return this._responseCompressionTypes;
    }

    public ERXMigrator migrator() {
        return new ERXMigrator(this.name() + "-" + this.host() + ":" + this.port());
    }

    public String _rewriteURL(String url) {
        String processedURL = url;
        if (url != null && this._replaceApplicationPathPattern != null && this._replaceApplicationPathReplace != null) {
            processedURL = processedURL.replaceFirst(this._replaceApplicationPathPattern, this._replaceApplicationPathReplace);
        }
        return processedURL;
    }

    public boolean rewriteDirectConnectURL() {
        return this.isDirectConnectEnabled() && !this.isCachingEnabled() && this.isDevelopmentMode() && ERXProperties.booleanForKeyWithDefault("er.extensions.ERXApplication.rewriteDirectConnect", false);
    }

    public String directConnectURL() {
        String directConnectURL = super.directConnectURL();
        if (this.rewriteDirectConnectURL()) {
            directConnectURL = this._rewriteURL(directConnectURL);
        }
        return directConnectURL;
    }

    public void setDefaultEncoding(String encoding) {
        WOMessage.setDefaultEncoding((String)encoding);
        WOMessage.setDefaultURLEncoding((String)encoding);
        ERXMessageEncoding.setDefaultEncoding(encoding);
        ERXMessageEncoding.setDefaultEncodingForAllLanguages(encoding);
    }

    public <T extends WOComponent> T pageWithName(Class<T> componentClass, WOContext context) {
        return (T)super.pageWithName(componentClass.getName(), context);
    }

    public <T extends WOComponent> T pageWithName(Class<T> componentClass) {
        return (T)this.pageWithName(componentClass.getName(), ERXWOContext.currentContext());
    }

    public NSKeyValueCodingAdditions constants() {
        return new NSKeyValueCodingAdditions(){

            public void takeValueForKey(Object value, String key) {
                throw new IllegalArgumentException("Can't set constant");
            }

            public Object valueForKey(String key) {
                return ERXConstant.constantsForClassName(key);
            }

            public void takeValueForKeyPath(Object value, String keyPath) {
                throw new IllegalArgumentException("Can't set constant");
            }

            public Object valueForKeyPath(String keyPath) {
                return this.valueForKey(keyPath);
            }
        };
    }

    public boolean sslEnabled() {
        return ERXProperties.booleanForKey("er.extensions.ERXApplication.ssl.enabled");
    }

    public String sslHost() {
        String sslHost = this._sslHost;
        if (sslHost == null) {
            sslHost = ERXProperties.stringForKeyWithDefault("er.extensions.ERXApplication.ssl.host", this.host());
        }
        return sslHost;
    }

    public void _setSslHost(String sslHost) {
        this._sslHost = sslHost;
    }

    public int sslPort() {
        int sslPort = this._sslPort != null ? this._sslPort : ERXProperties.intForKeyWithDefault("er.extensions.ERXApplication.ssl.port", 443);
        return sslPort;
    }

    public void _setSslPort(int sslPort) {
        this._sslPort = sslPort;
    }

    protected void _addAdditionalAdaptors(NSMutableArray<NSDictionary<String, Object>> additionalAdaptors) {
        if (this.sslEnabled()) {
            boolean sslAdaptorConfigured = false;
            for (NSDictionary<String, Object> adaptor : additionalAdaptors) {
                if (!ERXSecureDefaultAdaptor.class.getName().equals(adaptor.objectForKey(WOProperties._AdaptorKey))) continue;
                sslAdaptorConfigured = true;
            }
            ERXSecureDefaultAdaptor.checkSSLConfig();
            if (!sslAdaptorConfigured) {
                NSMutableDictionary<String, Object> sslAdaptor = new NSMutableDictionary<String, Object>();
                sslAdaptor.setObjectForKey(ERXSecureDefaultAdaptor.class.getName(), WOProperties._AdaptorKey);
                String sslHost = this.sslHost();
                if (sslHost != null) {
                    sslAdaptor.setObjectForKey(sslHost, WOProperties._HostKey);
                }
                sslAdaptor.setObjectForKey(this.sslPort(), WOProperties._PortKey);
                additionalAdaptors.addObject(sslAdaptor);
            }
        }
    }

    public NSArray<NSDictionary<String, Object>> additionalAdaptors() {
        NSMutableArray<NSDictionary<String, Object>> additionalAdaptors = super.additionalAdaptors();
        if (!this._initializedAdaptors) {
            NSMutableArray<NSDictionary<String, Object>> mutableAdditionalAdaptors = ((NSArray)additionalAdaptors).mutableClone();
            this._addAdditionalAdaptors(mutableAdditionalAdaptors);
            this._initializedAdaptors = true;
            additionalAdaptors = mutableAdditionalAdaptors;
            this.setAdditionalAdaptors(mutableAdditionalAdaptors);
        }
        return additionalAdaptors;
    }

    protected void _debugValueForDeclarationNamed(WOComponent component, String verb, String aDeclarationName, String aDeclarationType, String aBindingName, String anAssociationDescription, Object aValue) {
        String valueStr;
        if (aValue instanceof String) {
            StringBuffer stringbuffer = new StringBuffer(((String)aValue).length() + 2);
            stringbuffer.append('\"');
            stringbuffer.append(aValue);
            stringbuffer.append('\"');
            aValue = stringbuffer;
        }
        if (aDeclarationName.startsWith("_")) {
            aDeclarationName = "[inline]";
        }
        StringBuffer sb = new StringBuffer();
        String lastComponentName = component.name().replaceFirst(".*\\.", "");
        sb.append(lastComponentName);
        sb.append(verb);
        if (!aDeclarationName.startsWith("_")) {
            sb.append(aDeclarationName);
            sb.append(":");
        }
        sb.append(aDeclarationType);
        sb.append(" { ");
        sb.append(aBindingName);
        sb.append("=");
        String string = valueStr = aValue != null ? aValue.toString() : "null";
        if (anAssociationDescription.startsWith("class ")) {
            sb.append(valueStr);
            sb.append("; }");
        } else {
            sb.append(anAssociationDescription);
            sb.append("; } value ");
            sb.append(valueStr);
        }
        NSLog.debug.appendln((Object)sb.toString());
    }

    public void logTakeValueForDeclarationNamed(String aDeclarationName, String aDeclarationType, String aBindingName, String anAssociationDescription, Object aValue) {
        WOComponent component = ERXWOContext.currentContext().component();
        if (component.parent() != null) {
            component = component.parent();
        }
        this._debugValueForDeclarationNamed(component, " ==> ", aDeclarationName, aDeclarationType, aBindingName, anAssociationDescription, aValue);
    }

    public void logSetValueForDeclarationNamed(String aDeclarationName, String aDeclarationType, String aBindingName, String anAssociationDescription, Object aValue) {
        WOComponent component = ERXWOContext.currentContext().component();
        if (component.parent() != null) {
            component = component.parent();
        }
        this._debugValueForDeclarationNamed(component, " <== ", aDeclarationName, aDeclarationType, aBindingName, anAssociationDescription, aValue);
    }

    public void setDebugEnabledForComponent(boolean debugEnabled, String componentName) {
        if (debugEnabled) {
            this._debugComponents.addObject(componentName);
        } else {
            this._debugComponents.removeObject(componentName);
        }
    }

    public boolean debugEnabledForComponent(String componentName) {
        return this._debugComponents.containsObject(componentName);
    }

    public void clearDebugEnabledForAllComponents() {
        this._debugComponents.removeAllObjects();
    }

    public static String erAjaxRequestHandlerKey() {
        return ERXApplication.isWO54() ? "ja" : "ajax";
    }

    public void terminate() {
        NSNotificationCenter.defaultCenter().postNotification(ApplicationWillTerminateNotification, (Object)this);
        super.terminate();
    }

    static {
        lowMemBufferSize = 0;
        isInRequest = new ThreadLocal();
        _formatterFactory = new ERXFormatterFactory();
    }

    private class SessionInfo {
        Exception _trace = new Exception();
        WOContext _context;

        public SessionInfo(WOContext wocontext) {
            this._context = wocontext;
        }

        public Exception trace() {
            return this._trace;
        }

        public WOContext context() {
            return this._context;
        }

        public String exceptionMessageForCheckout(WOContext wocontext) {
            String contextDescription = null;
            contextDescription = this._context != null ? "contextId: " + this._context.contextID() + " request: " + this._context.request() : "<NULL>";
            log.error((Object)("There is an error in the session check-out: old context: " + contextDescription), (Throwable)this.trace());
            if (this._context == null) {
                return "Original context was null";
            }
            if (this._context.equals(wocontext)) {
                return "Same context did check out twice";
            }
            return "Context with id '" + wocontext.contextID() + "' did check out again";
        }
    }

    public static class JarChecker {
        private static final Logger log = Logger.getLogger(JarChecker.class);
        private static NSMutableDictionary<String, NSMutableArray<String>> packages = new NSMutableDictionary();
        private static NSMutableDictionary<String, NSMutableSet<Entry>> classes = new NSMutableDictionary();

        private void processJar(String jar) {
            try {
                File jarFile = new File(jar);
                if (!jarFile.exists() || jarFile.isDirectory()) {
                    return;
                }
                JarFile f = new JarFile(jar);
                Enumeration<JarEntry> enumerator = f.entries();
                while (enumerator.hasMoreElements()) {
                    JarEntry entry = enumerator.nextElement();
                    String name = entry.getName();
                    if (entry.getName().endsWith("/") && !name.matches("^\\w+/$") && !name.startsWith("META-INF")) {
                        NSMutableArray<String> bundles = (NSMutableArray<String>)packages.objectForKey(name);
                        if (bundles == null) {
                            bundles = new NSMutableArray<String>();
                            packages.setObjectForKey(bundles, name);
                        }
                        bundles.addObject(jar);
                        continue;
                    }
                    if (name.startsWith("src") || name.startsWith("META-INF")) continue;
                    Entry e = new Entry(entry.getSize(), jar);
                    NSMutableSet<Entry> set = (NSMutableSet<Entry>)classes.objectForKey(name);
                    if (set == null) {
                        set = new NSMutableSet<Entry>();
                        classes.setObjectForKey(set, name);
                    }
                    set.addObject(e);
                }
            }
            catch (IOException e) {
                startupLog.error((Object)("Error in processing jar: " + jar), (Throwable)e);
            }
        }

        private void reportErrors() {
            StringBuffer sb = new StringBuffer();
            String message = null;
            NSArray keys = ERXArrayUtilities.sortedArraySortedWithKey(packages.allKeys(), "toString");
            Enumeration enumerator = keys.objectEnumerator();
            while (enumerator.hasMoreElements()) {
                String packageName = (String)enumerator.nextElement();
                NSMutableArray bundles = (NSMutableArray)packages.objectForKey(packageName);
                if (bundles.count() <= 1) continue;
                sb.append("\t").append(packageName).append("->").append(bundles).append("\n");
            }
            message = sb.toString();
            if (message.length() > 0) {
                startupLog.debug((Object)("The following packages appear multiple times:\n" + message));
            }
            sb = new StringBuffer();
            NSMutableSet<String> classPackages = new NSMutableSet<String>();
            keys = ERXArrayUtilities.sortedArraySortedWithKey(classes.allKeys(), "toString");
            Enumeration enumerator2 = keys.objectEnumerator();
            while (enumerator2.hasMoreElements()) {
                String className = (String)enumerator2.nextElement();
                String packageName = className.replaceAll("/[^/]+?$", "");
                NSMutableSet bundles = (NSMutableSet)classes.objectForKey(className);
                if (bundles.count() <= 1 || classPackages.containsObject(packageName)) continue;
                sb.append("\t").append(packageName).append("->").append(bundles).append("\n");
                classPackages.addObject(packageName);
            }
            message = sb.toString();
            if (message.length() > 0) {
                startupLog.debug((Object)("The following packages have different versions, you should remove the version you don't want:\n" + message));
            }
        }

        private static class Entry {
            long _size;
            String _jar;

            public Entry(long aL, String jar) {
                this._size = aL;
                this._jar = jar;
            }

            public long size() {
                return this._size;
            }

            public String jar() {
                return this._jar;
            }

            public boolean equals(Object other) {
                return ((Entry)other).size() == this.size();
            }

            public int hashCode() {
                return (int)this._size;
            }

            public String toString() {
                return this.size() + "->" + this.jar();
            }
        }
    }

    public static class Loader {
        private JarChecker _checker;
        private Set<String> allFrameworks;
        private Properties allBundleProps;
        private Properties defaultProperties;
        private List<URL> allBundlePropURLs = new ArrayList<URL>();
        private List<URL> urls = new ArrayList<URL>();
        private Properties mainProps;
        private Properties mainUserProps;

        private Properties readProperties(File file) {
            if (!file.exists()) {
                return null;
            }
            try {
                URL url = file.toURI().toURL();
                return this.readProperties(url);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
                return null;
            }
        }

        private Properties readProperties(URL url) {
            if (url == null) {
                return null;
            }
            try {
                Properties result = new Properties();
                result.load(url.openStream());
                this.urls.add(url);
                return result;
            }
            catch (MalformedURLException exception) {
                exception.printStackTrace();
                return null;
            }
            catch (IOException exception) {
                return null;
            }
        }

        private Properties readProperties(NSBundle bundle, String name) {
            if (bundle == null) {
                return null;
            }
            if (name == null) {
                URL url = bundle.pathURLForResourcePath("Properties");
                if (url != null) {
                    this.urls.add(url);
                }
                return bundle.properties();
            }
            try {
                InputStream inputStream = bundle.inputStreamForResourcePath(name);
                if (inputStream == null) {
                    return null;
                }
                Properties result = new Properties();
                result.load(inputStream);
                this.urls.add(bundle.pathURLForResourcePath(name));
                return result;
            }
            catch (MalformedURLException exception) {
                exception.printStackTrace();
                return null;
            }
            catch (IOException exception) {
                return null;
            }
        }

        public Loader(String[] argv) {
            wasERXApplicationMainInvoked = true;
            String[] cps = new String[]{"java.class.path", "com.webobjects.classpath"};
            propertiesFromArgv = NSProperties.valuesFromArgv((String[])argv);
            this.defaultProperties = (Properties)NSProperties._getProperties().clone();
            this.allFrameworks = new HashSet<String>();
            this._checker = new JarChecker();
            for (int var = 0; var < cps.length; ++var) {
                String cpName = cps[var];
                String cp = System.getProperty(cpName);
                if (cp == null) continue;
                String[] parts = cp.split(File.pathSeparator);
                String normalLibs = "";
                String systemLibs = "";
                String jarLibs = "";
                String frameworkPattern = ".*?/(\\w+)\\.framework/Resources/Java/\\1.jar".toLowerCase();
                String appPattern = ".*?/(\\w+)\\.woa/Contents/Resources/Java/\\1.jar".toLowerCase();
                String folderPattern = ".*?/Resources/Java/?$".toLowerCase();
                String projectPattern = ".*?/(\\w+)/bin$".toLowerCase();
                block3: for (int i = 0; i < parts.length; ++i) {
                    String info;
                    String jar = parts[i];
                    String fixedJar = jar.replace(File.separatorChar, '/').toLowerCase();
                    this.debugMsg("Checking: " + jar);
                    if (this.isSystemJar(jar)) {
                        systemLibs = systemLibs + jar + File.pathSeparator;
                    } else if (fixedJar.matches(frameworkPattern) || fixedJar.matches(appPattern) || fixedJar.matches(folderPattern)) {
                        normalLibs = normalLibs + jar + File.pathSeparator;
                    } else if (fixedJar.matches(projectPattern) || fixedJar.matches(".*?/ERFoundation.jar") || fixedJar.matches(".*?/ERWebObjects.jar")) {
                        normalLibs = normalLibs + jar + File.pathSeparator;
                    } else {
                        jarLibs = jarLibs + jar + File.pathSeparator;
                    }
                    String bundle = jar.replaceAll(".*?[/\\\\](\\w+)\\.framework.*", "$1");
                    String excludes = "(JavaVM)";
                    if (ERXApplication.isWO54()) {
                        excludes = "(JavaVM|JavaWebServicesSupport|JavaEODistribution|JavaWebServicesGeneration|JavaWebServicesClient)";
                    }
                    if (bundle.matches("^\\w+$") && !bundle.matches(excludes)) {
                        info = jar.replaceAll("(.*?[/\\\\]\\w+\\.framework/Resources/).*", "$1Info.plist");
                        if (new File(info).exists()) {
                            this.allFrameworks.add(bundle);
                            this.debugMsg("Added Real Bundle: " + bundle);
                            continue;
                        }
                        this.debugMsg("Omitted: " + info);
                        continue;
                    }
                    if (jar.endsWith(".jar")) {
                        info = this.stringFromJar(jar, "Resources/Info.plist");
                        if (info == null) continue;
                        NSDictionary dict = (NSDictionary)NSPropertyListSerialization.propertyListFromString((String)info);
                        bundle = (String)dict.objectForKey("CFBundleExecutable");
                        this.allFrameworks.add(bundle);
                        this.debugMsg("Added Jar bundle: " + bundle);
                        continue;
                    }
                    if (!jar.endsWith("/bin") || !new File(new File(jar).getParentFile(), ".project").exists()) continue;
                    this.debugMsg("Plain bundle: " + jar);
                    for (File classpathFolder = new File(bundle); classpathFolder != null && classpathFolder.exists(); classpathFolder = classpathFolder.getParentFile()) {
                        File projectFile = new File(classpathFolder, ".project");
                        if (projectFile.exists()) {
                            try {
                                boolean isBundle = false;
                                Document projectDocument = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(projectFile);
                                projectDocument.normalize();
                                NodeList natureNodeList = projectDocument.getElementsByTagName("nature");
                                for (int natureNodeNum = 0; !isBundle && natureNodeNum < natureNodeList.getLength(); ++natureNodeNum) {
                                    Element natureContainerNode = (Element)natureNodeList.item(natureNodeNum);
                                    Node natureNode = natureContainerNode.getFirstChild();
                                    String nodeValue = natureNode.getNodeValue();
                                    if (nodeValue == null || !nodeValue.startsWith("org.objectstyle.wolips.") || nodeValue.contains("application")) continue;
                                    isBundle = true;
                                }
                                if (isBundle) {
                                    System.setProperty("NSProjectBundleEnabled", "true");
                                    this.allFrameworks.add(classpathFolder.getName());
                                    this.debugMsg("Added Binary Bundle: " + this.allFrameworks);
                                    continue block3;
                                }
                                this.debugMsg("Skipping binary bundle: " + jar);
                            }
                            catch (Throwable t) {
                                System.err.println("Skipping '" + projectFile + "': " + t);
                            }
                            continue block3;
                        }
                        this.debugMsg("Skipping, no project: " + projectFile);
                    }
                }
                String newCP = "";
                if (normalLibs.length() > 1) {
                    normalLibs = normalLibs.substring(0, normalLibs.length() - 1);
                    newCP = newCP + normalLibs;
                }
                if (systemLibs.length() > 1) {
                    systemLibs = systemLibs.substring(0, systemLibs.length() - 1);
                    newCP = newCP + (newCP.length() > 0 ? File.pathSeparator : "") + systemLibs;
                }
                if (jarLibs.length() > 1) {
                    jarLibs = jarLibs.substring(0, jarLibs.length() - 1);
                    newCP = newCP + (newCP.length() > 0 ? File.pathSeparator : "") + jarLibs;
                }
                String[] jars = newCP.split(File.pathSeparator);
                for (int i = 0; i < jars.length; ++i) {
                    String jar = jars[i];
                    this._checker.processJar(jar);
                }
                if (System.getProperty("_DisableClasspathReorder") != null) continue;
                System.setProperty(cpName, newCP);
            }
            NSNotificationCenter.defaultCenter().addObserver((Object)this, new NSSelector("bundleDidLoad", new Class[]{NSNotification.class}), "NSBundleDidLoadNotification", null);
        }

        private void debugMsg(String msg) {
        }

        public boolean didLoad() {
            return this.allFrameworks != null && this.allFrameworks.size() == 0;
        }

        private NSBundle mainBundle() {
            NSBundle mainBundle = null;
            String mainBundleName = NSProperties._mainBundleName();
            if (mainBundleName != null) {
                mainBundle = NSBundle.bundleForName((String)mainBundleName);
            }
            if (mainBundle == null) {
                mainBundle = NSBundle.mainBundle();
            }
            if (mainBundle == null) {
                try {
                    Field ClassPath = NSBundle.class.getDeclaredField("ClassPath");
                    ClassPath.setAccessible(true);
                    if (ClassPath.get(NSBundle.class) != null) {
                        Method init = NSBundle.class.getDeclaredMethod("InitMainBundle", new Class[0]);
                        init.setAccessible(true);
                        init.invoke(NSBundle.class, new Object[0]);
                    }
                }
                catch (Exception e) {
                    System.err.println(e);
                    e.printStackTrace();
                    System.exit(1);
                }
                mainBundle = NSBundle.mainBundle();
            }
            return mainBundle;
        }

        public void bundleDidLoad(NSNotification n) {
            NSBundle bundle = (NSBundle)n.object();
            this.allFrameworks.remove(bundle.name());
            if (this.allBundleProps == null) {
                this.allBundleProps = new Properties();
            }
            String userName = this.propertyFromCommandLineFirst("user.name");
            this.applyIfUnset(this.readProperties(bundle, "Properties." + userName));
            this.applyIfUnset(this.readProperties(bundle, null));
            if (this.allFrameworks.size() == 0) {
                this.mainProps = null;
                this.mainUserProps = null;
                this.collectMainProps(userName);
                this.allBundleProps.putAll((Map<?, ?>)this.mainProps);
                if (this.mainUserProps != null) {
                    this.allBundleProps.putAll((Map<?, ?>)this.mainUserProps);
                }
                String userHome = this.propertyFromCommandLineFirst("user.home");
                Properties userHomeProps = null;
                if (userHome != null && userHome.length() > 0) {
                    userHomeProps = this.readProperties(new File(userHome, "WebObjects.properties"));
                }
                if (userHomeProps != null) {
                    this.allBundleProps.putAll((Map<?, ?>)userHomeProps);
                }
                Properties props = NSProperties._getProperties();
                props.putAll((Map<?, ?>)this.allBundleProps);
                NSProperties._setProperties((Properties)props);
                ERXApplication.insertCommandLineArguments();
                if (userHomeProps != null) {
                    this.urls.add(0, this.urls.remove(this.urls.size() - 1));
                }
                if (this.mainUserProps != null) {
                    this.urls.add(0, this.urls.remove(this.urls.size() - 1));
                }
                this.urls.add(0, this.urls.remove(this.urls.size() - 1));
                NSNotificationCenter.defaultCenter().postNotification(new NSNotification(ERXApplication.AllBundlesLoadedNotification, (Object)NSKeyValueCoding.NullValue));
            }
        }

        private String propertyFromCommandLineFirst(String key) {
            String result = (String)propertiesFromArgv.valueForKey(key);
            if (result == null) {
                result = NSProperties.getProperty((String)key);
            }
            return result;
        }

        private void collectMainProps(String userName) {
            NSBundle mainBundle = this.mainBundle();
            if (mainBundle != null) {
                this.mainUserProps = this.readProperties(mainBundle, "Properties." + userName);
                this.mainProps = this.readProperties(mainBundle, null);
            }
            if (this.mainProps == null) {
                String woUserDir = NSProperties.getProperty((String)"webobjects.user.dir");
                if (woUserDir == null) {
                    woUserDir = System.getProperty("user.dir");
                }
                this.mainUserProps = this.readProperties(new File(woUserDir, "Contents" + File.separator + "Resources" + File.separator + "Properties." + userName));
                this.mainProps = this.readProperties(new File(woUserDir, "Contents" + File.separator + "Resources" + File.separator + "Properties"));
            }
            if (this.mainProps == null) {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                try {
                    Enumeration<URL> jarBundles = classLoader.getResources("Resources/Properties");
                    URL propertiesPath = null;
                    URL userPropertiesPath = null;
                    String mainBundleName = NSProperties._mainBundleName();
                    while (jarBundles.hasMoreElements()) {
                        URL url = jarBundles.nextElement();
                        String urlAsString = url.toString();
                        if (!urlAsString.contains(mainBundleName + ".jar")) continue;
                        try {
                            propertiesPath = new URL(URLDecoder.decode(urlAsString, "UTF-8"));
                            userPropertiesPath = new URL(propertiesPath.toExternalForm() + userName);
                        }
                        catch (MalformedURLException exception) {
                            exception.printStackTrace();
                        }
                        catch (UnsupportedEncodingException exception) {
                            exception.printStackTrace();
                        }
                        break;
                    }
                    this.mainProps = this.readProperties(propertiesPath);
                    this.mainUserProps = this.readProperties(userPropertiesPath);
                }
                catch (IOException exception) {
                    exception.printStackTrace();
                }
            }
            if (this.mainProps == null) {
                throw new IllegalStateException("Main bundle 'Properties' file can't be read.  Did you run as a Java Application instead of a WOApplication in WOLips?\nPlease post your deployment configuration in the Wonder mailing list.");
            }
        }

        private void applyIfUnset(Properties bundleProps) {
            if (bundleProps == null) {
                return;
            }
            for (Map.Entry<Object, Object> entry : bundleProps.entrySet()) {
                if (this.allBundleProps.containsKey(entry.getKey())) continue;
                this.allBundleProps.setProperty((String)entry.getKey(), (String)entry.getValue());
            }
        }

        private boolean isSystemJar(String jar) {
            String systemRoot = System.getProperty("WORootDirectory");
            if (systemRoot != null && jar.startsWith(systemRoot)) {
                return true;
            }
            if (jar.indexOf("webobjects" + File.separator + "apple") > 0) {
                return true;
            }
            if (jar.indexOf("System" + File.separator + "Library") > 0) {
                return true;
            }
            if (jar.indexOf("Apple" + File.separator + "Library") > 0) {
                return true;
            }
            return jar.matches("Frameworks[/\\\\]Java(Foundation|EOControl|EOAccess|WebObjects).*");
        }

        private String stringFromJar(String jar, String path) {
            try {
                if (!new File(jar).exists()) {
                    log.warn((Object)("Will not process jar '" + jar + "' because it cannot be found ..."));
                    return null;
                }
                JarFile f = new JarFile(jar);
                JarEntry e = (JarEntry)f.getEntry(path);
                if (e != null) {
                    InputStream is = f.getInputStream(e);
                    ByteArrayOutputStream bout = new ByteArrayOutputStream();
                    int read = -1;
                    byte[] buf = new byte[51200];
                    while ((read = is.read(buf)) != -1) {
                        bout.write(buf, 0, read);
                    }
                    String content = new String(bout.toByteArray(), "UTF-8");
                    return content;
                }
                return null;
            }
            catch (FileNotFoundException e1) {
                return null;
            }
            catch (IOException e1) {
                throw NSForwardException._runtimeExceptionForThrowable((Throwable)e1);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class AppClassLoader
    extends URLClassLoader {
        public static ClassLoader getAppClassLoader() {
            String classPath = System.getProperty("java.class.path");
            if (System.getProperty("com.webobjects.classpath") != null) {
                classPath = classPath + File.pathSeparator + System.getProperty("com.webobjects.classpath");
            }
            String[] files = classPath.split(File.pathSeparator);
            URL[] urls = new URL[files.length];
            for (int i = 0; i < files.length; ++i) {
                String string = files[i];
                try {
                    urls[i] = new File(string).toURL();
                    continue;
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
            }
            return new AppClassLoader(urls, Thread.currentThread().getContextClassLoader());
        }

        @Override
        public synchronized Class<?> loadClass(String s, boolean flag) throws ClassNotFoundException {
            SecurityManager securitymanager = System.getSecurityManager();
            if (securitymanager != null) {
                int j;
                int i;
                String s1 = s.replace('/', '.');
                if (s1.startsWith("[") && (i = s1.lastIndexOf(91) + 2) > 1 && i < s1.length()) {
                    s1 = s1.substring(i);
                }
                if ((j = s1.lastIndexOf(46)) != -1) {
                    securitymanager.checkPackageAccess(s1.substring(0, j));
                }
            }
            return super.loadClass(s, flag);
        }

        AppClassLoader(URL[] aurl, ClassLoader classloader) {
            super(aurl, classloader);
        }
    }
}

