/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.appserver;

import com.webobjects.appserver.WOApplication;
import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WOMessage;
import com.webobjects.appserver.WOResponse;
import com.webobjects.appserver.WOSession;
import com.webobjects.foundation.NSDictionary;
import er.extensions.appserver.ERXRequest;
import er.extensions.appserver.ERXWOContext;
import er.extensions.appserver.ajax.ERXAjaxApplication;
import er.extensions.foundation.ERXMutableURL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERXRedirect
extends WOComponent {
    private String _url;
    private String _requestHandlerKey;
    private String _requestHandlerPath;
    private Boolean _secure;
    private String _directActionClass;
    private String _directActionName;
    private WOComponent _originalComponent;
    private WOComponent _component;
    private NSDictionary<String, ? extends Object> _queryParameters;

    public ERXRedirect(WOContext context) {
        super(context);
        this._originalComponent = context.page();
    }

    public void setSecure(boolean secure) {
        this._secure = secure;
    }

    public void setRequestHandlerKey(String requestHandlerKey) {
        this._requestHandlerKey = requestHandlerKey;
    }

    public void setRequestHandlerPath(String requestHandlerPath) {
        this._requestHandlerPath = requestHandlerPath;
    }

    public void setDirectActionClass(String directActionClass) {
        this._directActionClass = directActionClass;
    }

    public void setDirectActionName(String directActionName) {
        this._directActionName = directActionName;
    }

    public void setUrl(String url) {
        this._url = url;
    }

    public void setComponentToPage() {
        this._component = this._originalComponent;
    }

    public void setComponent(WOComponent component) {
        this._component = component;
    }

    public void setQueryParameters(NSDictionary<String, ? extends Object> queryParameters) {
        this._queryParameters = queryParameters;
    }

    protected String queryParametersString() {
        String queryParametersString = null;
        if (this._queryParameters != null && this._queryParameters.count() > 0) {
            ERXMutableURL u = new ERXMutableURL();
            u.setQueryParameters(this._queryParameters);
            queryParametersString = u.toExternalForm();
        }
        return queryParametersString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendToResponse(WOResponse response, WOContext context) {
        boolean generateCompleteURLs;
        boolean secure = this._secure == null ? ERXRequest.isRequestSecure(context.request()) : this._secure;
        boolean generatingCompleteURLs = ((ERXWOContext)context)._generatingCompleteURLs();
        boolean bl = generateCompleteURLs = secure != ERXRequest.isRequestSecure(context.request());
        if (generateCompleteURLs) {
            context._generateCompleteURLs();
        }
        try {
            String url;
            WOComponent component = this._component;
            if (component != null) {
                WOSession aSession = this.session();
                String aContextId = context.contextID();
                StringBuffer requestHandlerPath = new StringBuffer();
                if (WOApplication.application().pageCacheSize() == 0) {
                    if (aSession.storesIDsInURLs()) {
                        requestHandlerPath.append(component.name());
                        requestHandlerPath.append('/');
                        requestHandlerPath.append(aSession.sessionID());
                        requestHandlerPath.append('/');
                        requestHandlerPath.append(aContextId);
                        requestHandlerPath.append(".0");
                    } else {
                        requestHandlerPath.append(component.name());
                        requestHandlerPath.append('/');
                        requestHandlerPath.append(aContextId);
                        requestHandlerPath.append(".0");
                    }
                } else if (aSession.storesIDsInURLs()) {
                    requestHandlerPath.append(aSession.sessionID());
                    requestHandlerPath.append('/');
                    requestHandlerPath.append(aContextId);
                    requestHandlerPath.append(".0");
                } else {
                    requestHandlerPath.append(aContextId);
                    requestHandlerPath.append(".0");
                }
                url = context._urlWithRequestHandlerKey(WOApplication.application().componentRequestHandlerKey(), requestHandlerPath.toString(), this.queryParametersString(), secure);
                context._setPageComponent(component);
            } else if (this._url != null) {
                if (this._secure != null) {
                    throw new IllegalArgumentException("You specified a value for 'url' and for 'secure', which is not supported.");
                }
                url = this._url;
            } else if (this._requestHandlerKey != null) {
                url = context._urlWithRequestHandlerKey(this._requestHandlerKey, this._requestHandlerPath, this.queryParametersString(), secure);
            } else if (this._directActionName != null) {
                String requestHandlerPath = this._directActionClass != null ? this._directActionClass + "/" + this._directActionName : this._directActionName;
                url = context._urlWithRequestHandlerKey(WOApplication.application().directActionRequestHandlerKey(), requestHandlerPath, this.queryParametersString(), secure);
            } else {
                throw new IllegalStateException("You must provide a component, url, requestHandlerKey, or directActionName to this ERXRedirect.");
            }
            if (ERXAjaxApplication.isAjaxRequest(context.request())) {
                boolean hasUpdateContainer;
                boolean bl2 = hasUpdateContainer = context.request().stringFormValueForKey("_u") != null;
                if (hasUpdateContainer) {
                    response.appendContentString("<script type=\"text/javascript\">");
                } else {
                    response.setHeader("text/javascript", "Content-Type");
                }
                response.appendContentString("document.location.href='" + url + "';");
                if (hasUpdateContainer) {
                    response.appendContentString("</script>");
                }
            } else {
                response.setHeader(url, "location");
                response.setStatus(302);
            }
            if (component != null) {
                ERXAjaxApplication.setForceStorePage((WOMessage)response);
            }
        }
        finally {
            if (generatingCompleteURLs) {
                context._generateCompleteURLs();
            } else {
                context._generateRelativeURLs();
            }
        }
    }
}

