/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.appserver;

import com.webobjects.appserver.WOApplication;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WOCookie;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WOResponse;
import com.webobjects.appserver.WOSession;
import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSKeyValueCodingAdditions;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSNotification;
import com.webobjects.foundation.NSNotificationCenter;
import com.webobjects.foundation.NSPathUtilities;
import com.webobjects.foundation.NSSelector;
import com.webobjects.foundation.NSTimestamp;
import er.extensions.appserver.ERXApplication;
import er.extensions.appserver.ERXBrowser;
import er.extensions.appserver.ERXBrowserFactory;
import er.extensions.appserver.ERXMessageEncoding;
import er.extensions.appserver.ERXRequest;
import er.extensions.appserver.ajax.ERXAjaxSession;
import er.extensions.eof.ERXConstant;
import er.extensions.eof.ERXEC;
import er.extensions.foundation.ERXArrayUtilities;
import er.extensions.foundation.ERXProperties;
import er.extensions.foundation.ERXStringUtilities;
import er.extensions.foundation.ERXThreadStorage;
import er.extensions.foundation.ERXValueUtilities;
import er.extensions.localization.ERXLocalizer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.TimeZone;
import org.apache.log4j.Logger;

public class ERXSession
extends ERXAjaxSession
implements Serializable {
    public static final Logger log = Logger.getLogger(ERXSession.class);
    public static final String SessionWillAwakeNotification = "SessionWillAwakeNotification";
    public static final String SessionWillSleepNotification = "SessionWillSleepNotification";
    public static final String JAVASCRIPT_ENABLED_COOKIE_NAME = "js";
    private transient ERXLocalizer _localizer;
    private String _serializableLanguageName;
    private ERXMessageEncoding _messageEncoding;
    private transient ERXBrowser _browser;
    protected Boolean _javaScriptEnabled;
    protected NSMutableDictionary _debuggingStore;
    private transient Observer _observer;
    private TimeZone _timeZone = TimeZone.getDefault();
    public String _originalThreadName;
    private boolean _editingContextWasCreated = false;
    protected Boolean _didBacktrack = null;
    public boolean lastActionWasDA = false;
    private NSKeyValueCodingAdditions _objectStore;
    private static Boolean autoAdjustTimeZone;

    public ERXSession() {
    }

    public ERXSession(String sessionID) {
        super(sessionID);
    }

    public Observer observer() {
        if (this._observer == null) {
            this._observer = new Observer(this);
        }
        return this._observer;
    }

    public ERXLocalizer localizer() {
        if (this._localizer == null) {
            this._localizer = ERXLocalizer.localizerForLanguages(this.languages());
            if (!WOApplication.application().isCachingEnabled()) {
                this.observer().registerForLocalizationDidResetNotification();
            }
        }
        return this._localizer;
    }

    public String language() {
        return this.localizer().language();
    }

    public void setLanguage(String language) {
        ERXLocalizer newLocalizer = ERXLocalizer.localizerForLanguage(language);
        if (!newLocalizer.equals(this._localizer)) {
            NSMutableArray<String> languageList;
            if (this._localizer == null && !WOApplication.application().isCachingEnabled()) {
                this.observer().registerForLocalizationDidResetNotification();
            }
            this._localizer = newLocalizer;
            ERXLocalizer.setCurrentLocalizer(this._localizer);
            if (this.browser() != null) {
                this._messageEncoding = this.browser().messageEncodingForLanguage(this._localizer.language());
            }
            if (!(languageList = new NSMutableArray<String>(this._localizer.language())).containsObject("Nonlocalized")) {
                languageList.addObject("Nonlocalized");
            }
            this.setLanguages(languageList);
        }
    }

    public void setLanguages(NSArray languageList) {
        super.setLanguages(languageList);
        ERXLocalizer newLocalizer = ERXLocalizer.localizerForLanguages(languageList);
        if (!newLocalizer.equals(this._localizer)) {
            if (this._localizer == null && !WOApplication.application().isCachingEnabled()) {
                this.observer().registerForLocalizationDidResetNotification();
            }
            this._localizer = newLocalizer;
            ERXLocalizer.setCurrentLocalizer(this._localizer);
            if (this.browser() != null) {
                this._messageEncoding = this.browser().messageEncodingForLanguage(this._localizer.language());
            }
        }
    }

    public NSArray availableLanguagesForTheApplication() {
        return ERXLocalizer.availableLanguages();
    }

    public NSArray availableLanguagesForThisSession() {
        NSArray browserLanguages = null;
        if (this.context() != null && this.context().request() != null) {
            browserLanguages = this.context().request().browserLanguages();
        }
        return ERXArrayUtilities.intersectingElements(browserLanguages, ERXLocalizer.availableLanguages());
    }

    public ERXMessageEncoding messageEncoding() {
        if (this._messageEncoding == null && this.browser() != null) {
            this._messageEncoding = this.browser().messageEncodingForLanguage(this.language());
        }
        return this._messageEncoding;
    }

    public ERXBrowser browser() {
        WORequest request;
        if (this._browser == null && this.context() != null && (request = this.context().request()) != null) {
            ERXBrowserFactory browserFactory = ERXBrowserFactory.factory();
            this._browser = request instanceof ERXRequest ? ((ERXRequest)request).browser() : browserFactory.browserMatchingRequest(request);
            browserFactory.retainBrowser(this._browser);
        }
        return this._browser;
    }

    public NSMutableDictionary debuggingStore() {
        if (this._debuggingStore == null) {
            this._debuggingStore = new NSMutableDictionary();
        }
        return this._debuggingStore;
    }

    public EOEditingContext defaultEditingContext() {
        if (!this._editingContextWasCreated) {
            this.setDefaultEditingContext(this.newDefaultEditingContext());
            this._editingContextWasCreated = true;
        }
        return super.defaultEditingContext();
    }

    public void setDefaultEditingContext(EOEditingContext ec) {
        this._editingContextWasCreated = true;
        super.setDefaultEditingContext(ec);
    }

    public boolean javaScriptEnabled() {
        WORequest request;
        WORequest wORequest = request = this.context() != null ? this.context().request() : null;
        if (this._javaScriptEnabled == null && request != null) {
            String js = request.stringFormValueForKey("javaScript");
            if (js != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Received javascript form value " + js));
                }
            } else {
                try {
                    js = request.cookieValueForKey(JAVASCRIPT_ENABLED_COOKIE_NAME);
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    // empty catch block
                }
            }
            if (js != null) {
                this._javaScriptEnabled = ERXValueUtilities.booleanValue(js) && (this.browser().browserName().equals("Unknown Browser") || this.browser().isMozilla40Compatible() || this.browser().isMozilla50Compatible()) ? Boolean.TRUE : Boolean.FALSE;
            }
        }
        return this._javaScriptEnabled == null ? true : this._javaScriptEnabled;
    }

    public void setJavaScriptEnabled(boolean newValue) {
        this._javaScriptEnabled = newValue ? Boolean.TRUE : Boolean.FALSE;
    }

    public void awake() {
        WORequest request;
        super.awake();
        ERXSession.setSession(this);
        ERXLocalizer.setCurrentLocalizer(this.localizer());
        NSNotificationCenter.defaultCenter().postNotification(SessionWillAwakeNotification, (Object)this);
        WORequest wORequest = request = this.context() != null ? this.context().request() : null;
        if (request != null && log.isDebugEnabled() && request.headerForKey((Object)"content-type") != null) {
            if (request.headerForKey((Object)"content-type").toLowerCase().indexOf("multipart/form-data") == -1) {
                log.debug((Object)("Form values " + request.formValues()));
            } else {
                log.debug((Object)"Multipart Form values found");
            }
        }
        this._originalThreadName = Thread.currentThread().getName();
        Thread.currentThread().setName(this.threadName());
    }

    public void sleep() {
        NSNotificationCenter.defaultCenter().postNotification(SessionWillSleepNotification, (Object)this);
        super.sleep();
        ERXLocalizer.setCurrentLocalizer(null);
        ERXSession.setSession(null);
        this._didBacktrack = null;
        Thread.currentThread().setName(this._originalThreadName);
        this.removeObjectForKey("ERXActionLogging");
    }

    public String threadName() {
        return Thread.currentThread().getName();
    }

    public String requestsContextID(WORequest aRequest) {
        String uri = aRequest.uri();
        int idx = uri.indexOf(63);
        if (idx != -1) {
            uri = uri.substring(0, idx);
        }
        String eID = NSPathUtilities.lastPathComponent((String)uri);
        NSArray<String> eIDs = NSArray.componentsSeparatedByString(eID, ".");
        String reqCID = "1";
        if (eIDs.count() > 0) {
            reqCID = eIDs.objectAtIndex(0);
        }
        return reqCID;
    }

    public boolean didBacktrack() {
        if (this._didBacktrack == null) {
            this._didBacktrack = Boolean.FALSE;
            if (!this.context().request().requestHandlerKey().equals(WOApplication.application().directActionRequestHandlerKey())) {
                int reqCID = Integer.parseInt(this.requestsContextID(this.context().request()));
                int cid = Integer.parseInt(this.context().contextID());
                int delta = cid - reqCID;
                if (delta > 2) {
                    this._didBacktrack = Boolean.TRUE;
                } else if (delta > 1 && !this.lastActionWasDA) {
                    this._didBacktrack = Boolean.TRUE;
                }
            }
            this.lastActionWasDA = false;
        }
        return this._didBacktrack;
    }

    public void takeValuesFromRequest(WORequest aRequest, WOContext aContext) {
        this.messageEncoding().setDefaultFormValueEncodingToRequest(aRequest);
        super.takeValuesFromRequest(aRequest, aContext);
    }

    public void appendToResponse(WOResponse aResponse, WOContext aContext) {
        this.messageEncoding().setEncodingToResponse(aResponse);
        super.appendToResponse(aResponse, aContext);
    }

    public ERXApplication application() {
        return ERXApplication.erxApplication();
    }

    public void terminate() {
        if (this._observer != null) {
            NSNotificationCenter.defaultCenter().removeObserver((Object)this._observer);
            this._observer = null;
        }
        if (this._browser != null) {
            ERXBrowserFactory.factory().releaseBrowser(this._browser);
            this._browser = null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will terminate, sessionId is " + this.sessionID()));
        }
        super.terminate();
    }

    public NSKeyValueCodingAdditions objectStore() {
        if (this._objectStore == null) {
            this._objectStore = new NSKeyValueCodingAdditions(){

                public void takeValueForKey(Object arg0, String arg1) {
                    if (arg0 == null) {
                        ERXSession.this.removeObjectForKey(arg1);
                    } else {
                        ERXSession.this.setObjectForKey(arg0, arg1);
                    }
                }

                public Object valueForKey(String arg0) {
                    return ERXSession.this.objectForKey(arg0);
                }

                public void takeValueForKeyPath(Object arg0, String arg1) {
                    if (arg0 == null) {
                        ERXSession.this.removeObjectForKey(arg1);
                    } else {
                        ERXSession.this.setObjectForKey(arg0, arg1);
                    }
                }

                public Object valueForKeyPath(String arg0) {
                    Object theObject = ERXSession.this.objectForKey(arg0);
                    if (theObject == null && arg0.indexOf(".") > -1) {
                        String key = "";
                        String oriKey = arg0;
                        do {
                            key = key + oriKey.substring(0, oriKey.indexOf("."));
                            oriKey = oriKey.substring(oriKey.indexOf(".") + 1);
                            theObject = ERXSession.this.objectForKey(key);
                            key = key + ".";
                        } while (theObject == null && oriKey.indexOf(".") > -1);
                        if (theObject != null && !ERXStringUtilities.stringIsNullOrEmpty(oriKey)) {
                            theObject = NSKeyValueCodingAdditions.Utility.valueForKeyPath((Object)theObject, (String)oriKey);
                        }
                    }
                    return theObject;
                }
            };
        }
        return this._objectStore;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        this._serializableLanguageName = this._localizer == null ? null : this.language();
        stream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        if (this._serializableLanguageName != null) {
            this.setLanguage(this._serializableLanguageName);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Session has been deserialized: " + this.toString()));
        }
    }

    public NSTimestamp _birthDate() {
        return super._birthDate();
    }

    public String toString() {
        String superString = super.toString();
        String thisString = " localizer=" + (this._localizer == null ? "null" : this._localizer.toString()) + " messageEncoding=" + (this._messageEncoding == null ? "null" : this._messageEncoding.toString()) + " browser=" + (this._browser == null ? "null" : this._browser.toString());
        int lastIndex = superString.lastIndexOf(">");
        String toStr = lastIndex > 0 ? superString.substring(0, lastIndex - 1) + thisString + ">" : superString + thisString;
        return toStr;
    }

    public EOEditingContext newDefaultEditingContext() {
        return ERXEC.newEditingContext();
    }

    public static WOSession anySession() {
        return (WOSession)ERXThreadStorage.valueForKey("session");
    }

    public static ERXSession session() {
        return (ERXSession)ERXThreadStorage.valueForKey("session");
    }

    public static String currentSessionID() {
        return (String)ERXThreadStorage.valueForKey("ERXSession.sessionID");
    }

    public static void setSession(ERXSession session) {
        ERXThreadStorage.takeValueForKey(session, "session");
        ERXThreadStorage.takeValueForKey(session == null ? null : session.sessionID(), "ERXSession.sessionID");
    }

    public boolean useSecureSessionCookies() {
        return ERXProperties.booleanForKeyWithDefault("er.extensions.ERXSession.useSecureSessionCookies", false);
    }

    protected void _convertSessionCookiesToSecure(WOResponse response) {
        if (this.storesIDsInCookies() && !ERXRequest._isSecureDisabled()) {
            for (WOCookie cookie : response.cookies()) {
                String cookieName;
                String instanceIdKey;
                String sessionIdKey;
                if (ERXApplication.isWO54()) {
                    try {
                        sessionIdKey = (String)WOApplication.class.getMethod("sessionIdKey", new Class[0]).invoke((Object)WOApplication.application(), new Object[0]);
                        instanceIdKey = (String)WOApplication.class.getMethod("instanceIdKey", new Class[0]).invoke((Object)WOApplication.application(), new Object[0]);
                    }
                    catch (Throwable e) {
                        throw new NSForwardException(e);
                    }
                } else {
                    sessionIdKey = "wosid";
                    instanceIdKey = "woinst";
                }
                if (!sessionIdKey.equals(cookieName = cookie.name()) && !instanceIdKey.equals(cookieName)) continue;
                cookie.setIsSecure(true);
            }
        }
    }

    public void _appendCookieToResponse(WOResponse response) {
        super._appendCookieToResponse(response);
        if (this.useSecureSessionCookies()) {
            this._convertSessionCookiesToSecure(response);
        }
    }

    public void _clearCookieFromResponse(WOResponse response) {
        super._clearCookieFromResponse(response);
        if (this.useSecureSessionCookies()) {
            this._convertSessionCookiesToSecure(response);
        }
    }

    public TimeZone timeZone() {
        return this._timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        if (timeZone == null) {
            throw new NullPointerException("timeZone must not be set to null");
        }
        this._timeZone = timeZone;
    }

    public static boolean autoAdjustTimeZone() {
        if (autoAdjustTimeZone == null) {
            autoAdjustTimeZone = ERXProperties.booleanForKeyWithDefault("er.extensions.ERXSession.autoAdjustTimeZone", false);
        }
        return autoAdjustTimeZone;
    }

    public static class Observer {
        protected transient ERXSession session;

        private Observer() {
        }

        public Observer(ERXSession session) {
            this.session = session;
        }

        public void localizationDidReset(NSNotification n) {
            if (this.session._localizer == null) {
                return;
            }
            String currentLanguage = this.session._localizer.language();
            this.session._localizer = ERXLocalizer.localizerForLanguage(currentLanguage);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Detected changes in the localizers. Reset reference to " + currentLanguage + " localizer for session " + this.session.sessionID()));
            }
        }

        private void registerForLocalizationDidResetNotification() {
            NSNotificationCenter.defaultCenter().addObserver((Object)this, new NSSelector("localizationDidReset", ERXConstant.NotificationClassArray), "LocalizationDidReset", null);
        }
    }
}

