/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.appserver;

import com.webobjects.appserver.xml.WOXMLCoder;
import com.webobjects.appserver.xml.WOXMLDecoder;
import com.webobjects.appserver.xml.WOXMLException;
import com.webobjects.appserver.xml._private._MappingModel;
import com.webobjects.eocontrol.EOEnterpriseObject;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSData;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSKeyValueCodingAdditions;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSTimestamp;
import er.extensions.foundation.ERXArrayUtilities;
import er.extensions.foundation.ERXStringUtilities;
import java.io.UnsupportedEncodingException;
import java.sql.Date;
import java.util.Enumeration;

public class ERXWOXMLCoder
extends WOXMLCoder {
    private _MappingModel _mappingModel;

    public ERXWOXMLCoder(String s) {
        this._mappingModel = _MappingModel.mappingModelWithXMLFile(s);
    }

    public String xmlTagForClassNamed(String className) {
        return this._mappingModel.xmlTagForClassNamed(className);
    }

    public String xmlTagForPropertyKey(String key, String className) {
        return this._mappingModel.xmlTagForPropertyKey(key, className);
    }

    protected void _encodeEO(EOEnterpriseObject eoenterpriseobject) {
        NSArray arr = this.sortedArray(eoenterpriseobject.attributeKeys());
        Enumeration e = arr.objectEnumerator();
        while (e.hasMoreElements()) {
            String s = (String)e.nextElement();
            this.encodeObjectForKey(eoenterpriseobject.valueForKey(s), s);
            if (!e.hasMoreElements()) continue;
            this.cr();
        }
    }

    protected Enumeration sortedEnumeration(Enumeration e) {
        if (e != null) {
            NSMutableArray<String> arr = new NSMutableArray<String>();
            while (e.hasMoreElements()) {
                String element = (String)e.nextElement();
                arr.addObject(element);
            }
            e = this.sortedArray(arr).objectEnumerator();
        }
        return e;
    }

    protected NSArray sortedArray(NSArray arr) {
        if (arr != null) {
            arr = ERXArrayUtilities.sortedArraySortedWithKey(arr, "toString");
        }
        return arr;
    }

    protected void encodeDictionaryWithXMLTag(NSDictionary dict, String tag) {
        NSArray nsarray = this.sortedArray(dict.allKeys());
        Enumeration e = nsarray.objectEnumerator();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String tagForKey = this._mappingModel.xmlTagForPropertyKeyInXMLTag(key, tag);
            this.encodeObjectWithXMLTag(dict.objectForKey(key), tagForKey, false, 2);
            if (!e.hasMoreElements()) continue;
            this.cr();
        }
    }

    protected void encodeArrayWithXMLTag(NSArray arr, String tag, boolean codeBasedOnClass, int outputTags) {
        Enumeration e = arr.objectEnumerator();
        while (e.hasMoreElements()) {
            this.encodeObjectWithXMLTag(e.nextElement(), tag, codeBasedOnClass, outputTags);
            if (!e.hasMoreElements()) continue;
            this.cr();
        }
    }

    public void encodeObjectForKey(Object obj, String key) {
        String tag = this._mappingModel.xmlTagForPropertyKey(key, this.encodedClassName());
        this.encodeObjectWithXMLTag(obj, tag, false, 2);
    }

    public void encodeObjectWithXMLTag(Object obj, String baseTag, boolean codeBasedOnClass, int outputTags) {
        if (obj instanceof NSArray) {
            this.encodeArrayWithXMLTag((NSArray)obj, baseTag, codeBasedOnClass, outputTags);
        } else {
            boolean isBaseType = obj instanceof String || obj instanceof Boolean || obj instanceof Date || obj instanceof Number;
            String className = obj == null ? null : obj.getClass().getName();
            String tagForClassName = className == null ? "" : this.xmlTagForClassNamed(className);
            String tag = null;
            if (!(outputTags == 0 || isBaseType && outputTags == 1)) {
                String string = tag = (outputTags & 1) == 0 || isBaseType ? baseTag : tagForClassName;
                if (outputTags == 3) {
                    this._buffer.append('<');
                    this._buffer.append(baseTag);
                    this._buffer.append('>');
                }
                this._buffer.append('<');
                this._buffer.append(tag);
                if (obj != null) {
                    Enumeration attributes = codeBasedOnClass ? this._mappingModel.attributeKeysForClassNamed(className) : this._mappingModel.attributeKeysForXMLTag(baseTag);
                    if ((attributes = this.sortedEnumeration(attributes)) != null) {
                        while (attributes.hasMoreElements()) {
                            String key = (String)attributes.nextElement();
                            this._buffer.append(' ');
                            this._buffer.append(codeBasedOnClass ? this.xmlTagForPropertyKey(key, className) : this._mappingModel.xmlTagForPropertyKeyInXMLTag(key, baseTag));
                            this._buffer.append('=');
                            this._buffer.append('\"');
                            Object value = NSKeyValueCodingAdditions.Utility.valueForKeyPath((Object)obj, (String)key);
                            this._buffer.append(value == null ? "" : this.escapeString(value.toString()));
                            this._buffer.append('\"');
                        }
                    }
                }
                this._buffer.append('>');
            }
            if (obj != null) {
                if (obj instanceof String) {
                    this._buffer.append(this.escapeString((String)obj));
                } else if (obj instanceof NSTimestamp) {
                    this._buffer.append((NSTimestamp)obj);
                } else if (obj instanceof Boolean) {
                    this._buffer.append((Boolean)obj);
                } else if (obj instanceof Number) {
                    this._buffer.append((Number)obj);
                } else if (codeBasedOnClass || this._mappingModel.hasMappingForXMLTag(baseTag)) {
                    Enumeration contentKeys = codeBasedOnClass ? this._mappingModel.contentsKeysForClassNamed(className) : this._mappingModel.contentsKeysForXMLTag(baseTag);
                    if ((contentKeys = this.sortedEnumeration(contentKeys)) != null) {
                        this._encodedClasses.push(className);
                        boolean hadContent = false;
                        while (contentKeys.hasMoreElements()) {
                            this.cr();
                            hadContent = true;
                            String key = (String)contentKeys.nextElement();
                            Object value = NSKeyValueCodingAdditions.Utility.valueForKeyPath((Object)obj, (String)key);
                            String propertyTag = codeBasedOnClass ? this.xmlTagForPropertyKey(key, className) : this._mappingModel.xmlTagForPropertyKeyInXMLTag(key, baseTag);
                            boolean codeBasedOnClassForPropertyKey = this._mappingModel.codeBasedOnClassForPropertyKey(key, className);
                            int outputTagsForPropertyKey = this._mappingModel.outputTagsForPropertyKey(key, className);
                            this.encodeObjectWithXMLTag(value, propertyTag, codeBasedOnClassForPropertyKey, outputTagsForPropertyKey);
                        }
                        this._encodedClasses.pop();
                        if (hadContent) {
                            this.cr();
                        }
                    }
                } else if (obj instanceof NSDictionary) {
                    this.encodeDictionaryWithXMLTag((NSDictionary)obj, baseTag);
                } else if (obj instanceof EOEnterpriseObject) {
                    this._encodeEO((EOEnterpriseObject)obj);
                } else {
                    throw new WOXMLException("Unable to encode in XML objects of class " + className);
                }
            }
            if (!(outputTags == 0 || isBaseType && outputTags == 1)) {
                this._buffer.append('<');
                this._buffer.append('/');
                this._buffer.append(tag);
                this._buffer.append('>');
                if (outputTags == 3 && !isBaseType) {
                    this._buffer.append('<');
                    this._buffer.append('/');
                    this._buffer.append(baseTag);
                    this._buffer.append('>');
                }
            }
        }
    }

    public void encodeBooleanForKey(boolean flag, String s) {
        this.encodeStringInTag(flag ? "True" : "False", this.xmlTagForPropertyKey(s, this.encodedClassName()), "boolean");
    }

    public void encodeIntForKey(int i, String s) {
        this.encodeStringInTag(Integer.toString(i), this.xmlTagForPropertyKey(s, this.encodedClassName()), "int");
    }

    public void encodeFloatForKey(float f, String s) {
        this.encodeStringInTag(Float.toString(f), this.xmlTagForPropertyKey(s, this.encodedClassName()), "float");
    }

    public void encodeDoubleForKey(double d, String s) {
        this.encodeStringInTag(Double.toString(d), this.xmlTagForPropertyKey(s, this.encodedClassName()), "double");
    }

    protected void _encodeNullForKey(String s) {
        this.encodeStringInTag("null", s, "?");
    }

    public synchronized String encodeRootObjectForKey(Object obj, String s) {
        if (obj != null) {
            this._buffer = new StringBuffer(1024);
            this._buffer.append(this.xmlDeclaration);
            this.encodeObjectWithXMLTag(obj, "ignored", true, 1);
            return this._buffer.toString();
        }
        return null;
    }

    public static class XMLData
    extends NSMutableDictionary {
        public void completeDecoding() {
        }

        public void prepareForCoding() {
        }

        protected void takeValueForKeyPathIfNotPresent(Object object, String key) {
            if (this.valueForKeyPath(key) == null) {
                this.takeValueForKeyPath(object, key);
            }
        }

        protected void clearEmptyValueForKeyPath(String key) {
            if (this.valueForKeyPath(key) != null && ((String)this.valueForKeyPath(key)).length() == 0) {
                this.takeValueForKeyPath(null, key);
            }
        }

        protected void clearParentOnEmptyValueForKeyPath(String key) {
            if (this.valueForKeyPath(key) != null && ((String)this.valueForKeyPath(key)).length() == 0) {
                this.takeValueForKeyPath(null, ERXStringUtilities.keyPathWithoutLastProperty(key));
            }
        }

        public void takeValueForKey(Object aValue, String aKey) {
            if (aValue instanceof NSDictionary && ((NSDictionary)aValue).count() == 0 && aValue.getClass() == NSMutableDictionary.class) {
                aValue = null;
            }
            super.takeValueForKey(aValue, aKey);
        }

        public static String stringForData(XMLData data, String rootTag, String mappingUrl) {
            data.prepareForCoding();
            ERXWOXMLCoder coder = new ERXWOXMLCoder(mappingUrl);
            String result = coder.encodeRootObjectForKey(data, rootTag);
            data.completeDecoding();
            return result;
        }

        public static XMLData dataForString(String string, String mappingUrl) {
            XMLData data;
            WOXMLDecoder decoder = WOXMLDecoder.decoderWithMapping((String)mappingUrl);
            try {
                data = (XMLData)decoder.decodeRootObject(new NSData(string.getBytes("UTF-8")));
            }
            catch (UnsupportedEncodingException e) {
                throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
            }
            data.completeDecoding();
            return data;
        }
    }
}

