/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.appserver.ajax;

import com.webobjects.appserver.WOApplication;
import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WOResponse;
import com.webobjects.appserver.WOSession;
import com.webobjects.appserver._private._PermanentCacheSingleton;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import er.extensions.appserver.ajax.ERXAjaxApplication;
import er.extensions.foundation.ERXKeyValueCodingUtilities;
import er.extensions.foundation.ERXProperties;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class ERXAjaxSession
extends WOSession {
    public static final String DONT_STORE_PAGE = "erxsession.dont_store_page";
    public static final String FORCE_STORE_PAGE = "erxsession.force_store_page";
    public static final String PAGE_REPLACEMENT_CACHE_LOOKUP_KEY = "page_cache_key";
    private static final String ORIGINAL_CONTEXT_ID_KEY = "original_context_id";
    private static final String PAGE_REPLACEMENT_CACHE_KEY = "page_replacement_cache";
    private static int MAX_PAGE_REPLACEMENT_CACHE_SIZE = Integer.parseInt(System.getProperty("er.extensions.maxPageReplacementCacheSize", "30"));
    private static boolean overridePrivateCache = ERXProperties.booleanForKey("er.extensions.overridePrivateCache");
    private Logger logger = Logger.getLogger((String)ERXAjaxSession.class.getName());
    protected NSMutableDictionary _permanentPageCache;
    protected NSMutableArray _permanentContextIDArray;

    public ERXAjaxSession() {
    }

    public ERXAjaxSession(String sessionID) {
        super(sessionID);
    }

    public void savePage(WOComponent page) {
        WOContext context = this.context();
        if (ERXAjaxApplication.shouldNotStorePage(context)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Considering pageReplacementCache for " + context.request().uri() + " with contextID " + context.contextID()));
            }
            WORequest request = context.request();
            WOResponse response = context.response();
            String pageCacheKey = null;
            if (response != null) {
                pageCacheKey = response.headerForKey((Object)PAGE_REPLACEMENT_CACHE_LOOKUP_KEY);
            }
            if (pageCacheKey == null && request != null) {
                pageCacheKey = request.headerForKey((Object)PAGE_REPLACEMENT_CACHE_LOOKUP_KEY);
            }
            if (pageCacheKey != null) {
                boolean removedCacheEntry;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Will use pageCacheKey " + pageCacheKey));
                }
                String originalContextID = context.request().headerForKey((Object)ORIGINAL_CONTEXT_ID_KEY);
                pageCacheKey = originalContextID + "_" + pageCacheKey;
                LinkedHashMap<String, TransactionRecord> pageReplacementCache = (LinkedHashMap<String, TransactionRecord>)this.objectForKey(PAGE_REPLACEMENT_CACHE_KEY);
                if (pageReplacementCache == null) {
                    pageReplacementCache = new LinkedHashMap<String, TransactionRecord>();
                    this.setObjectForKey(pageReplacementCache, PAGE_REPLACEMENT_CACHE_KEY);
                }
                if (!(removedCacheEntry = this.cleanPageReplacementCacheIfNecessary(pageCacheKey)) && pageReplacementCache.size() >= MAX_PAGE_REPLACEMENT_CACHE_SIZE * 2) {
                    Iterator entryIterator = pageReplacementCache.entrySet().iterator();
                    Map.Entry oldestEntry = entryIterator.next();
                    entryIterator.remove();
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)(pageCacheKey + "pageReplacementCache too large, removing oldest entry = " + ((TransactionRecord)oldestEntry.getValue()).key()));
                    }
                }
                TransactionRecord pageRecord = new TransactionRecord(page, context, pageCacheKey);
                pageReplacementCache.put(context.contextID(), pageRecord);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)(pageCacheKey + " new context = " + context.contextID()));
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)(pageCacheKey + " = " + pageReplacementCache.keySet()));
                }
                ERXAjaxApplication.cleanUpHeaders(response);
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Not caching as no pageCacheKey found");
            }
        } else {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Calling super.savePage for contextID " + context.contextID()));
            }
            super.savePage(page);
        }
    }

    protected void cleanPageReplacementCacheIfNecessary() {
        this.cleanPageReplacementCacheIfNecessary(null);
    }

    protected boolean cleanPageReplacementCacheIfNecessary(String _cacheKeyToAge) {
        boolean removedCacheEntry = false;
        LinkedHashMap pageReplacementCache = (LinkedHashMap)this.objectForKey(PAGE_REPLACEMENT_CACHE_KEY);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("keys in pageReplacementCache: " + pageReplacementCache.keySet()));
        }
        if (pageReplacementCache != null) {
            Iterator transactionRecordsEnum = pageReplacementCache.entrySet().iterator();
            while (transactionRecordsEnum.hasNext()) {
                String transactionRecordKey;
                Map.Entry pageRecordEntry = transactionRecordsEnum.next();
                TransactionRecord tempPageRecord = (TransactionRecord)pageRecordEntry.getValue();
                if (tempPageRecord.isExpired()) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("deleting expired page record " + tempPageRecord));
                    }
                    transactionRecordsEnum.remove();
                    removedCacheEntry = true;
                    continue;
                }
                if (_cacheKeyToAge == null || !_cacheKeyToAge.equals(transactionRecordKey = tempPageRecord.key())) continue;
                if (tempPageRecord.isOldPage()) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)(_cacheKeyToAge + " removing old page " + tempPageRecord));
                    }
                    transactionRecordsEnum.remove();
                    removedCacheEntry = true;
                    continue;
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)(_cacheKeyToAge + " marking as old page"));
                }
                tempPageRecord.setOldPage(true);
            }
            if (_cacheKeyToAge == null && pageReplacementCache.isEmpty()) {
                this.removeObjectForKey(PAGE_REPLACEMENT_CACHE_KEY);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)"Removing empty page cache");
                }
            }
        }
        return removedCacheEntry;
    }

    protected NSMutableDictionary _permanentPageCache() {
        if (this._permanentPageCache == null) {
            this._permanentPageCache = new NSMutableDictionary(64);
            this._permanentContextIDArray = new NSMutableArray<int>(64);
        }
        return this._permanentPageCache;
    }

    protected WOComponent _permanentPageWithContextID(String contextID) {
        WOComponent wocomponent = null;
        if (this._permanentPageCache != null) {
            wocomponent = (WOComponent)this._permanentPageCache.objectForKey(contextID);
        }
        return wocomponent;
    }

    public void _saveCurrentPage() {
        if (overridePrivateCache) {
            WOContext _currentContext = this.context();
            if (_currentContext != null) {
                WOComponent currentPage;
                String contextID = this.context().contextID();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Saving page for contextID: " + contextID));
                }
                if ((currentPage = _currentContext._pageComponent()) != null && currentPage._isPage()) {
                    WOComponent permanentSenderPage = this._permanentPageWithContextID(_currentContext._requestContextID());
                    WOComponent permanentCurrentPage = this._permanentPageWithContextID(contextID);
                    if (permanentCurrentPage == null && this._permanentPageCache().containsValue(currentPage)) {
                        this._permanentPageCache.setObjectForKey(currentPage, contextID);
                    } else if (permanentCurrentPage != currentPage) {
                        WOApplication woapplication = WOApplication.application();
                        if (permanentSenderPage == currentPage && woapplication.permanentPageCacheSize() != 0) {
                            if (this._shouldPutInPermanentCache(currentPage)) {
                                this.savePageInPermanentCache(currentPage);
                            }
                        } else if (woapplication.pageCacheSize() != 0) {
                            this.savePage(currentPage);
                        }
                    }
                }
            }
        } else {
            super._saveCurrentPage();
        }
    }

    protected boolean _shouldPutInPermanentCache(WOComponent wocomponent) {
        boolean flag = true;
        if (_PermanentCacheSingleton.class.isInstance(wocomponent)) {
            flag = false;
        } else {
            NSArray nsarray = (NSArray)ERXKeyValueCodingUtilities.privateValueForKey(wocomponent, "_subcomponents");
            if (nsarray != null && nsarray != NSArray.EmptyArray) {
                Enumeration enumeration = nsarray.objectEnumerator();
                while (flag && enumeration.hasMoreElements()) {
                    if (this._shouldPutInPermanentCache((WOComponent)enumeration.nextElement())) continue;
                    flag = false;
                }
            }
        }
        return flag;
    }

    public void savePageInPermanentCache(WOComponent wocomponent) {
        if (overridePrivateCache) {
            WOContext wocontext = this.context();
            String contextID = wocontext.contextID();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Saving page for contextID: " + contextID));
            }
            NSMutableDictionary permanentPageCache = this._permanentPageCache();
            int i = WOApplication.application().permanentPageCacheSize();
            while (this._permanentContextIDArray.count() >= i) {
                String s1 = (String)this._permanentContextIDArray.objectAtIndex(0);
                WOComponent page = (WOComponent)permanentPageCache.removeObjectForKey(s1);
                this._permanentContextIDArray.removeObjectAtIndex(0);
            }
            permanentPageCache.setObjectForKey(wocomponent, contextID);
            this._permanentContextIDArray.addObject(contextID);
        } else {
            super.savePageInPermanentCache(wocomponent);
        }
    }

    public WOComponent restorePageForContextID(String contextID) {
        WOContext context;
        WORequest request;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Restoring page for contextID: " + contextID));
        }
        LinkedHashMap pageReplacementCache = (LinkedHashMap)this.objectForKey(PAGE_REPLACEMENT_CACHE_KEY);
        WOComponent page = null;
        if (pageReplacementCache != null) {
            TransactionRecord pageRecord = (TransactionRecord)pageReplacementCache.get(contextID);
            if (pageRecord != null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Restoring page for contextID: " + contextID + " pageRecord = " + pageRecord));
                }
                page = pageRecord.page();
            } else {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("No page in pageReplacementCache for contextID: " + contextID));
                }
                this.cleanPageReplacementCacheIfNecessary();
            }
        }
        if (page == null && overridePrivateCache && (page = this._permanentPageWithContextID(contextID)) != null) {
            page._awakeInContext(this.context());
        }
        if (page == null) {
            page = super.restorePageForContextID(contextID);
        }
        if (page != null && (request = (context = page.context()).request()) != null) {
            request.setHeader(contextID, ORIGINAL_CONTEXT_ID_KEY);
        }
        return page;
    }

    static class TransactionRecord {
        private WOContext _context;
        private WOComponent _page;
        private String _key;
        private boolean _oldPage;
        private long _lastModified;

        public TransactionRecord(WOComponent page, WOContext context, String key) {
            this._page = page;
            this._context = context;
            this._key = key;
            this.touch();
        }

        public void touch() {
            this._lastModified = System.currentTimeMillis();
        }

        public int hashCode() {
            return this._key.hashCode();
        }

        public boolean equals(Object _obj) {
            return _obj instanceof TransactionRecord && ((TransactionRecord)_obj)._key.equals(this._key);
        }

        public WOComponent page() {
            return this._page;
        }

        public WOContext context() {
            return this._context;
        }

        public boolean isExpired() {
            boolean expired = this._oldPage && System.currentTimeMillis() - this._lastModified > 300000L;
            return expired;
        }

        public String key() {
            return this._key;
        }

        public void setOldPage(boolean oldPage) {
            this._oldPage = oldPage;
            this.touch();
        }

        public boolean isOldPage() {
            return this._oldPage;
        }

        public String toString() {
            return "[TransactionRecord: page = " + this._page.name() + "; context = " + this._context.contextID() + "; key = " + this._key + "; oldPage? " + this._oldPage + "]";
        }
    }
}

