/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.appserver.navigation;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSRange;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class ERXNavigation {
    public static final Logger log = Logger.getLogger((String)"er.navigation.extensions.ERXNavigation");
    protected NSArray _additionalNavigationState;
    protected NSArray _navigationState;
    protected boolean isDisabled;
    protected boolean _shouldDisplayHeaderTitle;

    public NSArray navigationState() {
        NSArray navigationState;
        NSArray nSArray = navigationState = this._navigationState == null ? new NSArray() : this._navigationState;
        if (this._additionalNavigationState != null) {
            NSMutableArray combinedNavigationState = new NSMutableArray(this._navigationState);
            combinedNavigationState.addObjectsFromArray(this._additionalNavigationState);
            navigationState = combinedNavigationState;
        }
        return navigationState;
    }

    public void setAdditionalNavigationState(NSArray value) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Setting additional navigation state: " + value));
        }
        this._additionalNavigationState = value;
    }

    public String sectionTitleString(int currentNavigationLevel) {
        int navCount;
        String sectionTitle = "";
        int n = navCount = this.navigationState() != null ? this.navigationState().count() : 0;
        if (navCount > 0 && navCount <= currentNavigationLevel) {
            sectionTitle = (String)this.navigationState().lastObject();
        } else if (navCount != 0 && currentNavigationLevel < navCount) {
            NSRange range = new NSRange(currentNavigationLevel - 1, navCount - currentNavigationLevel + 1);
            sectionTitle = this.navigationState().subarrayWithRange(range).componentsJoinedByString(" > ");
        }
        return sectionTitle;
    }

    public NSArray navigationItemsToBeShownForLevel(int currentNavigationLevel) {
        int navCount;
        NSArray itmesToBeShown = null;
        int n = navCount = this.navigationState() != null ? this.navigationState().count() : 0;
        if (currentNavigationLevel == 0) {
            itmesToBeShown = this.navigationState();
        } else if (navCount != 0 && navCount <= currentNavigationLevel) {
            itmesToBeShown = new NSArray(this.navigationState().lastObject());
        } else if (navCount != 0 && currentNavigationLevel < navCount) {
            int index = currentNavigationLevel - 1;
            int length = navCount - currentNavigationLevel + 1;
            NSRange range = new NSRange(index, length);
            log.debug((Object)("Range: " + range + " current: " + currentNavigationLevel + " navCount: " + navCount));
            itmesToBeShown = this.navigationState().subarrayWithRange(range);
        }
        log.debug((Object)("Nav state: " + this.navigationState() + " current nav level: " + currentNavigationLevel + " items: " + itmesToBeShown));
        return itmesToBeShown != null ? itmesToBeShown : NSArray.EmptyArray;
    }

    public void setNavigationState(NSArray navigationState) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Setting Navigation State: " + navigationState));
        }
        this._navigationState = navigationState;
        this._additionalNavigationState = null;
    }

    public void setNavigationStateWithString(String navigationStateString) {
        if (navigationStateString != null) {
            NSMutableArray<String> navigationState = new NSMutableArray<String>();
            StringTokenizer navigationStateTokenizer = new StringTokenizer(navigationStateString, ".");
            while (navigationStateTokenizer.hasMoreTokens()) {
                navigationState.addObject(navigationStateTokenizer.nextToken());
            }
            this.setNavigationState(navigationState);
        }
    }

    public String navigationStateString() {
        if (this.navigationState() != null) {
            return this.navigationState().componentsJoinedByString(".");
        }
        return null;
    }

    public void disableAllComponents() {
        this.setIsDisabled(true);
    }

    public void enableAllComponents() {
        this.setIsDisabled(false);
    }

    public boolean isDisabled() {
        return this.isDisabled;
    }

    public void setIsDisabled(boolean newIsDisabled) {
        this.isDisabled = newIsDisabled;
    }

    public boolean shouldDisplayHeaderTitle() {
        return this._shouldDisplayHeaderTitle;
    }

    public void setShouldDisplayHeaderTitle(boolean newShouldDisplayHeaderTitle) {
        this._shouldDisplayHeaderTitle = newShouldDisplayHeaderTitle;
    }

    public String firstLevel() {
        return this.level(0);
    }

    public String secondLevel() {
        return this.level(1);
    }

    public String thirdLevel() {
        return this.level(2);
    }

    public void setNavigationLevel(int level, String state) {
        if (level > 0) {
            NSMutableArray<String> navTemp = new NSMutableArray<String>(this.navigationState());
            if (navTemp.count() >= level) {
                navTemp.replaceObjectAtIndex(state, level - 1);
            } else {
                navTemp.addObject(state);
            }
            this.setNavigationState(navTemp);
        }
    }

    public String level(int i) {
        return this.navigationState() != null && i < this.navigationState().count() ? (String)this.navigationState().objectAtIndex(i) : "";
    }
}

