/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.appserver.navigation;

import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WORedirect;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableDictionary;
import er.extensions.appserver.ERXDirectAction;
import er.extensions.appserver.navigation.ERXNavigationItem;
import er.extensions.appserver.navigation.ERXNavigationManager;
import er.extensions.appserver.navigation.ERXNavigationState;
import er.extensions.components.ERXStatelessComponent;
import er.extensions.foundation.ERXProperties;
import er.extensions.foundation.ERXStringUtilities;
import er.extensions.foundation.ERXValueUtilities;
import er.extensions.localization.ERXLocalizer;
import org.apache.log4j.Logger;

public class ERXNavigationMenuItem
extends ERXStatelessComponent {
    public static final Logger log = Logger.getLogger(ERXNavigationMenuItem.class);
    protected ERXNavigationItem _navigationItem;
    protected ERXNavigationState _navigationState;
    protected boolean _linkDirectlyToDirectActions = true;
    protected int _level = -1;
    protected Boolean _isDisabled;
    protected Boolean _meetsDisplayConditions;
    protected Boolean _isSelected;
    protected Boolean _hasActivity;
    protected Boolean _omitLabelSpanTag;
    protected WOComponent _redirect;
    private static final String[] COLOR = new String[]{"", "#EEEEEE", "#111111", "#EEEEEE", "#111111"};
    private static final String[] TD_BGCOLOR = new String[]{"", "#003366", "#d0d0d0", "#ff6600", "#ff6600"};
    private static final String[] DISABLED_TD_BGCOLOR = new String[]{"", "#003366", "#EFEFEF", "#ff9966", "#ff9966"};

    public ERXNavigationMenuItem(WOContext context) {
        super(context);
    }

    public String navigationItemWidth() {
        if (this.navigationItem().width() > 0) {
            return "" + this.navigationItem().width();
        }
        return null;
    }

    public String navigationItemID() {
        if (this.navigationItem().uniqueID() != null) {
            return this.navigationItem().uniqueID();
        }
        return null;
    }

    public void reset() {
        this._navigationItem = null;
        this._navigationState = null;
        this._meetsDisplayConditions = null;
        this._level = -1;
        this._hasActivity = null;
        this._isDisabled = null;
        this._isSelected = null;
        this._omitLabelSpanTag = null;
        super.reset();
    }

    public ERXNavigationState navigationState() {
        if (this._navigationState == null) {
            this._navigationState = ERXNavigationManager.manager().navigationStateForSession(this.session());
        }
        return this._navigationState;
    }

    public WOComponent directActionRedirect() {
        WOComponent page = this.pageWithName("WORedirect");
        String url = this.context().directActionURLForActionNamed(this.navigationItem().directActionName(), this.navigationItem().queryBindings());
        ((WORedirect)page).setUrl(url);
        return page;
    }

    public String contextComponentActionURL() {
        if (this.navigationState().isDisabled() || !this.meetsDisplayConditions()) {
            return null;
        }
        if (this.navigationItem().href() != null && !"".equals(this.navigationItem().href().trim())) {
            return this.navigationItem().href();
        }
        if (this.navigationItem().action() != null || this.navigationItem().pageName() != null) {
            return this.context().componentActionURL();
        }
        if (this.navigationItem().directActionName() != null) {
            if (this._linkDirectlyToDirectActions) {
                NSMutableDictionary<String, String> bindings = this.navigationItem().queryBindings().mutableClone();
                bindings.setObjectForKey(this.context().contextID(), "__cid");
                return this.context().directActionURLForActionNamed(this.navigationItem().directActionName(), bindings);
            }
            return this.context().componentActionURL();
        }
        if (this.canGetValueForBinding("javascriptFunction")) {
            String theFunction = (String)this.valueForBinding("javascriptFunction");
            return ERXStringUtilities.replaceStringByStringInString("\"", "'", theFunction);
        }
        return null;
    }

    public WOComponent menuItemSelected() {
        WOComponent anActionResult = null;
        if (this.navigationItem().action() != null && this.navigationItem().action() != "") {
            anActionResult = (WOComponent)this.valueForKeyPath(this.navigationItem().action());
        } else if (this.navigationItem().pageName() != null && this.navigationItem().pageName() != "") {
            anActionResult = this.pageWithName(this.navigationItem().pageName());
        } else if (this.navigationItem().directActionName() != null && this.navigationItem().directActionName() != "") {
            if (this._linkDirectlyToDirectActions) {
                ERXDirectAction da = new ERXDirectAction(this.context().request());
                anActionResult = (WOComponent)da.performActionNamed(this.navigationItem().directActionName());
            } else {
                anActionResult = (WOComponent)this.valueForKeyPath("directActionRedirect");
            }
        }
        return anActionResult;
    }

    public boolean meetsDisplayConditions() {
        if (this._meetsDisplayConditions == null) {
            this._meetsDisplayConditions = this.navigationItem() != null ? (this.navigationItem().meetsDisplayConditionsInComponent(this) ? Boolean.TRUE : Boolean.FALSE) : Boolean.FALSE;
        }
        return this._meetsDisplayConditions;
    }

    public ERXNavigationItem navigationItem() {
        if (this._navigationItem == null) {
            this._navigationItem = (ERXNavigationItem)this.valueForBinding("navigationItem");
            if (this._navigationItem == null) {
                String name = (String)this.valueForBinding("navigationItemName");
                if (name != null) {
                    this._navigationItem = ERXNavigationManager.manager().navigationItemForName(name);
                } else {
                    log.warn((Object)("Navigation unset: " + name));
                    this._navigationItem = ERXNavigationManager.manager().newNavigationItem(new NSDictionary<String, String>(name, "name"));
                }
            }
        }
        return this._navigationItem;
    }

    public boolean isDisabled() {
        if (this._isDisabled == null) {
            this._isDisabled = this.navigationState().isDisabled() || !this.meetsDisplayConditions() ? Boolean.TRUE : Boolean.FALSE;
        }
        return this._isDisabled;
    }

    public boolean isSelected() {
        if (this._isSelected == null) {
            NSArray navigationState = this.navigationState().state();
            this._isSelected = !this.isDisabled() && navigationState != null && navigationState.containsObject(this.navigationItem().name()) ? Boolean.TRUE : Boolean.FALSE;
        }
        return this._isSelected;
    }

    public int level() {
        if (this._level == -1) {
            Integer l = (Integer)this.valueForBinding("level");
            this._level = l != null ? l : 0;
        }
        return this._level;
    }

    public String linkClass() {
        if (this.level() == 0) {
            return "";
        }
        return "Nav" + this.level() + (this.isSelected() ? "Selected" : (this.isDisabled() ? "Disabled" : ""));
    }

    public String tdColor() {
        return !this.isDisabled() ? TD_BGCOLOR[this.level() + (this.isSelected() ? 1 : 0)] : DISABLED_TD_BGCOLOR[this.level()];
    }

    public Object resolveValue(String key) {
        if (key != null && key.startsWith("^")) {
            return this.valueForKeyPath(key.substring(1));
        }
        return key;
    }

    public boolean hasActivity() {
        if (this._hasActivity == null) {
            this._hasActivity = ERXValueUtilities.booleanValue(this.resolveValue(this.navigationItem().hasActivity())) ? Boolean.TRUE : Boolean.FALSE;
        }
        return this._hasActivity;
    }

    public boolean hasActivityAndIsEnabled() {
        return this.hasActivity() && !this.isDisabled();
    }

    public String displayName() {
        String name = (String)this.resolveValue(this.navigationItem().displayName());
        if (name != null && ERXProperties.booleanForKey("er.extensions.ERXNavigationManager.localizeDisplayKeys")) {
            String localizerKey = "Nav." + name;
            String localizedValue = ERXLocalizer.currentLocalizer().localizedStringForKey(localizerKey);
            if (localizedValue == null) {
                localizedValue = ERXLocalizer.currentLocalizer().localizedStringForKey(name);
                if (localizedValue != null) {
                    log.info((Object)("Found old-style entry: " + localizerKey + "->" + localizedValue));
                    ERXLocalizer.currentLocalizer().takeValueForKey(localizedValue, localizerKey);
                    name = localizedValue;
                }
            } else {
                name = localizedValue;
            }
        }
        return name;
    }

    public boolean omitLabelSpanTag() {
        if (this._omitLabelSpanTag == null) {
            this._omitLabelSpanTag = new Boolean(!ERXProperties.booleanForKeyWithDefault("er.extensions.ERXNavigationManager.includeLabelSpanTag", false));
        }
        return this._omitLabelSpanTag;
    }
}

