/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.components;

import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver._private.WOKeyValueAssociation;
import com.webobjects.eoaccess.EODatabaseDataSource;
import com.webobjects.eoaccess.EOEntity;
import com.webobjects.eoaccess.EORelationship;
import com.webobjects.eocontrol.EOArrayDataSource;
import com.webobjects.eocontrol.EODataSource;
import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOEnterpriseObject;
import com.webobjects.eocontrol.EOQualifier;
import com.webobjects.eocontrol.EOSortOrdering;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSKeyValueCodingAdditions;
import com.webobjects.foundation.NSSelector;
import com.webobjects.foundation.NSValidation;
import er.extensions.appserver.ERXApplication;
import er.extensions.components.ERXStatelessComponent;
import er.extensions.eof.ERXEOAccessUtilities;
import er.extensions.eof.ERXEOControlUtilities;
import er.extensions.foundation.ERXArrayUtilities;
import er.extensions.foundation.ERXProperties;
import er.extensions.foundation.ERXStringUtilities;
import er.extensions.foundation.ERXUtilities;
import org.apache.log4j.Logger;

public abstract class ERXArrayChooser
extends ERXStatelessComponent {
    public static final Logger log = Logger.getLogger(ERXArrayChooser.class);
    public static boolean localizeDisplayKeysDefault = ERXProperties.booleanForKeyWithDefault("er.extensions.ERXArrayChooser.localizeDisplayKeysDefault", false);
    public static boolean includeUnmatchedValuesDefault = ERXProperties.booleanForKeyWithDefault("er.extensions.ERXArrayChooser.includeUnmatchedValuesDefault", false);
    public static boolean sortCaseInsensitiveDefault = ERXProperties.booleanForKeyWithDefault("er.extensions.ERXArrayChooser.sortCaseInsensitive", false);
    protected static final String NO_SELECTION_STRING = "ERXArrayChooser.NoSelectionString";
    protected static final String NO_SORT_STRING = "WONoSorting";
    protected Boolean _localizeDisplayKeys;
    protected Boolean _includeUnmatchedValues;
    protected Boolean _sortCaseInsensitive;
    protected String _sourceEntityName;
    protected String _destinationEntityName;
    protected String _relationshipKey;
    protected Object _sourceObject;
    protected String _destinationDisplayKey;
    protected EODataSource _dataSource;
    protected String _uiStyle;
    protected Boolean _isMandatory;
    protected NSArray _list;
    protected NSArray _unmatchedValues;
    protected String _destinationSortKey;
    protected String _noneString;
    protected Object theCurrentItem;

    public ERXArrayChooser(WOContext aContext) {
        super(aContext);
    }

    protected abstract boolean isSingleSelection();

    public void reset() {
        super.reset();
        this._sourceEntityName = null;
        this._destinationEntityName = null;
        this._relationshipKey = null;
        this._sourceObject = null;
        this._destinationDisplayKey = null;
        this._dataSource = null;
        this._uiStyle = null;
        this._isMandatory = null;
        this._list = null;
        this._destinationSortKey = null;
        this._noneString = null;
        this._localizeDisplayKeys = null;
        this._sortCaseInsensitive = null;
        this._includeUnmatchedValues = null;
        this._unmatchedValues = null;
    }

    public String noneString() {
        if (this._noneString == null) {
            this._noneString = (String)this.valueForBinding("noSelectionString");
            if (this._noneString == null) {
                this._noneString = "ERXArrayChooser.noneString";
            }
            if (this._noneString != null) {
                this._noneString = this.localizer().localizedStringForKeyWithDefault(this._noneString);
            }
        }
        return this._noneString;
    }

    public boolean sortCaseInsensitive() {
        if (this._sortCaseInsensitive == null) {
            this._sortCaseInsensitive = this.booleanValueForBinding("sortCaseInsensitive", false) ? Boolean.TRUE : Boolean.FALSE;
        }
        return this._sortCaseInsensitive;
    }

    public boolean localizeDisplayKeys() {
        if (this._localizeDisplayKeys == null) {
            this._localizeDisplayKeys = this.booleanValueForBinding("localizeDisplayKeys", localizeDisplayKeysDefault) ? Boolean.TRUE : Boolean.FALSE;
        }
        return this._localizeDisplayKeys;
    }

    public boolean includeUnmatchedValues() {
        if (this._includeUnmatchedValues == null) {
            this._includeUnmatchedValues = this.booleanValueForBinding("includeUnmatchedValues", includeUnmatchedValuesDefault) ? Boolean.TRUE : Boolean.FALSE;
        }
        return this._includeUnmatchedValues;
    }

    public String sourceEntityName() {
        if (this._sourceEntityName == null) {
            this._sourceEntityName = (String)this.valueForBinding("sourceEntityName");
            if (this._sourceEntityName == null) {
                this.loadBindingsFromSelection();
            }
        }
        return this._sourceEntityName;
    }

    public String destinationSortKey() {
        if (this._destinationSortKey == null) {
            this._destinationSortKey = (String)this.valueForBinding("destinationSortKey");
            if (this._destinationSortKey == null || this._destinationSortKey.length() == 0) {
                this._destinationSortKey = this.destinationDisplayKey();
            } else if (NO_SORT_STRING.equals(this._destinationSortKey)) {
                this._destinationSortKey = null;
            }
        }
        return this._destinationSortKey;
    }

    public NSArray unmatchedValues() {
        return this._unmatchedValues;
    }

    protected NSArray destinationSortKeys() {
        String destinationSortKey = this.destinationSortKey();
        NSArray<String> destinationSortKeys = destinationSortKey != null ? NSArray.componentsSeparatedByString(destinationSortKey, ",") : NSArray.EmptyArray;
        return destinationSortKeys;
    }

    public EOEditingContext editingContext() {
        EOEditingContext ec = null;
        if (this.sourceObject() instanceof EOEnterpriseObject) {
            ec = ((EOEnterpriseObject)this.sourceObject()).editingContext();
        } else {
            ec = (EOEditingContext)this.valueForBinding("editingContext");
            if (ec == null) {
                ec = this.session().defaultEditingContext();
            }
        }
        return ec;
    }

    protected void loadBindingsFromSelection() {
        WOKeyValueAssociation selectionAssociation = (WOKeyValueAssociation)this._associationWithName("selection");
        if (selectionAssociation != null) {
            String selectionKeyPath = selectionAssociation.keyPath();
            WOComponent parent = this.parent();
            int lastDotIndex = selectionKeyPath.lastIndexOf(46);
            if (lastDotIndex == -1) {
                this._sourceObject = parent;
                this._relationshipKey = selectionKeyPath;
            } else {
                String sourceObjectKeyPath = selectionKeyPath.substring(0, lastDotIndex);
                this._sourceObject = parent.valueForKeyPath(sourceObjectKeyPath);
                this._relationshipKey = selectionKeyPath.substring(lastDotIndex + 1);
                if (this._sourceObject instanceof EOEnterpriseObject) {
                    this._sourceEntityName = ((EOEnterpriseObject)this._sourceObject).entityName();
                }
            }
        }
    }

    protected EOEntity destinationEntity() {
        return ERXEOAccessUtilities.entityNamed(this.editingContext(), this.destinationEntityName());
    }

    public String destinationEntityName() {
        return this._destinationEntityName(true);
    }

    public String _destinationEntityName(boolean throwExceptionIfMissing) {
        if (this._destinationEntityName == null) {
            this._destinationEntityName = (String)this.valueForBinding("destinationEntityName");
            if (this._destinationEntityName == null) {
                Object _source = this.sourceObject();
                EOEditingContext ec = this.editingContext();
                EOEntity destinationEntity = null;
                if (_source instanceof EOEnterpriseObject) {
                    EORelationship relationship = ERXUtilities.relationshipWithObjectAndKeyPath((EOEnterpriseObject)_source, this.relationshipKey());
                    destinationEntity = relationship != null ? relationship.destinationEntity() : null;
                } else {
                    String anEntityName = this.sourceEntityName();
                    if (anEntityName != null) {
                        EOEntity anEntity = ERXEOAccessUtilities.entityNamed(ec, anEntityName);
                        if (anEntity == null) {
                            throw new IllegalStateException("<" + ((Object)((Object)this)).getClass().getName() + " could not find entity named " + anEntityName + ">");
                        }
                        destinationEntity = ERXEOAccessUtilities.destinationEntityForKeyPath(anEntity, this.relationshipKey());
                    } else {
                        destinationEntity = ERXEOAccessUtilities.entityNamed(ec, anEntityName);
                    }
                }
                if (destinationEntity == null && throwExceptionIfMissing) {
                    throw new IllegalStateException("Destination entity could not be retrieved from EO of bindings. Either set the \"sourceObject\" to an EO, provide the \"sourceEntityName\" and \"relationshipKey\", the \"destinationEntityName\" or the \"possibleChoices\" binding.");
                }
                if (destinationEntity != null) {
                    this._destinationEntityName = destinationEntity.name();
                }
            }
        }
        return this._destinationEntityName;
    }

    public String relationshipKey() {
        if (this._relationshipKey == null) {
            this._relationshipKey = (String)this.valueForBinding("relationshipKey");
            if (this._relationshipKey == null) {
                this.loadBindingsFromSelection();
            }
        }
        return this._relationshipKey;
    }

    public Object sourceObject() {
        if (this._sourceObject == null) {
            this._sourceObject = this.valueForBinding("sourceObject");
            if (this._sourceObject == null) {
                this.loadBindingsFromSelection();
                if (this._sourceObject == null) {
                    throw new IllegalStateException("sourceObject is a required binding.");
                }
            }
        }
        return this._sourceObject;
    }

    public String destinationDisplayKey() {
        if (this._destinationDisplayKey == null) {
            this._destinationDisplayKey = (String)this.valueForBinding("destinationDisplayKey");
            if (this._destinationDisplayKey == null && this._destinationEntityName(false) != null) {
                this._destinationDisplayKey = "userPresentableDescription";
            }
        }
        return this._destinationDisplayKey;
    }

    public EOQualifier qualifier() {
        return (EOQualifier)this.valueForBinding("qualifier");
    }

    public EODataSource dataSource() {
        if (this._dataSource == null) {
            this._dataSource = (EODataSource)this.valueForBinding("dataSource");
            EOQualifier qualifier = this.qualifier();
            if (this._dataSource == null) {
                String destinationEntityName = this.destinationEntityName();
                EOEditingContext editingContext = this.editingContext();
                if (ERXEOAccessUtilities.entityWithNamedIsShared(this.editingContext(), destinationEntityName)) {
                    EOArrayDataSource arrayDataSource = new EOArrayDataSource(this.destinationEntity().classDescriptionForInstances(), editingContext);
                    NSArray sharedEOs = ERXEOControlUtilities.sharedObjectsForEntityNamed(destinationEntityName);
                    if (sharedEOs == null) {
                        sharedEOs = NSArray.EmptyArray;
                    } else if (qualifier != null) {
                        sharedEOs = EOQualifier.filteredArrayWithQualifier((NSArray)sharedEOs, (EOQualifier)qualifier);
                    }
                    arrayDataSource.setArray(sharedEOs);
                    this._dataSource = arrayDataSource;
                } else {
                    this._dataSource = new EODatabaseDataSource(editingContext, destinationEntityName);
                    if (qualifier != null) {
                        ((EODatabaseDataSource)this._dataSource).setAuxiliaryQualifier(qualifier);
                    }
                }
            } else if (qualifier != null) {
                throw new IllegalArgumentException("You specified a dataSource binding and a qualifier, which is not currently supported.");
            }
        }
        return this._dataSource;
    }

    public String uiStyle() {
        if (this._uiStyle == null) {
            this._uiStyle = (String)this.valueForBinding("uiStyle");
            if (this._uiStyle == null) {
                int aSize = this.theList().count();
                if (this.isSingleSelection()) {
                    if (aSize <= 5) {
                        this._uiStyle = "radio";
                    }
                    if (aSize >= 5 && aSize < 20) {
                        this._uiStyle = "popup";
                    }
                    if (aSize >= 20) {
                        this._uiStyle = "browser";
                    }
                } else {
                    if (aSize <= 5) {
                        this._uiStyle = "checkbox";
                    }
                    if (aSize > 5) {
                        this._uiStyle = "browser";
                    }
                }
            }
        }
        return this._uiStyle;
    }

    public boolean isMandatory() {
        if (this._isMandatory == null) {
            this._isMandatory = this.booleanValueForBinding("isMandatory") ? Boolean.TRUE : Boolean.FALSE;
        }
        return this._isMandatory;
    }

    public boolean isCheckBox() {
        return this.uiStyle().equals("checkbox");
    }

    public boolean isRadio() {
        return this.uiStyle().equals("radio");
    }

    public boolean isPopup() {
        return this.uiStyle().equals("popup");
    }

    public boolean isBrowser() {
        return this.uiStyle().equals("browser");
    }

    public Object theCurrentItem() {
        return this.theCurrentItem;
    }

    public void setTheCurrentItem(Object aValue) {
        this.theCurrentItem = aValue;
        if (this.hasBinding("item")) {
            this.setValueForBinding(this.theCurrentItem, "item");
        }
    }

    public abstract NSArray currentValues();

    public NSArray theList() {
        if (this._list == null) {
            NSSelector sorting;
            if (this.hasBinding("possibleChoices")) {
                this._list = (NSArray)this.valueForBinding("possibleChoices");
                if (this._list != null && this._list.lastObject() instanceof EOEnterpriseObject) {
                    this._list = ERXEOControlUtilities.localInstancesOfObjects(this.editingContext(), this._list);
                }
            }
            if (this._list == null) {
                EODataSource ds = this.dataSource();
                if (ds.editingContext() != null) {
                    this._list = ds.fetchObjects();
                    if (ds.editingContext() != this.editingContext()) {
                        this._list = ERXEOControlUtilities.localInstancesOfObjects(this.editingContext(), this._list);
                    }
                } else {
                    log.error((Object)("EC of datasource is null, possible resubmit: " + ERXApplication.erxApplication().extraInformationForExceptionInContext(null, this.context())));
                    this._list = NSArray.EmptyArray;
                }
            }
            NSArray destinationSortKeys = this.destinationSortKeys();
            NSSelector nSSelector = sorting = this.sortCaseInsensitive() ? EOSortOrdering.CompareAscending : EOSortOrdering.CompareCaseInsensitiveAscending;
            if (destinationSortKeys != null && destinationSortKeys.count() > 0) {
                this._list = ERXArrayUtilities.sortedArraySortedWithKeys(this._list, destinationSortKeys, sorting);
            }
            if (this.includeUnmatchedValues()) {
                NSArray currentValues = this.currentValues();
                if (currentValues.count() > 0) {
                    this._unmatchedValues = ERXArrayUtilities.arrayMinusArray(this.currentValues(), this._list);
                    if (this._unmatchedValues.count() > 0) {
                        this._unmatchedValues = ERXArrayUtilities.arrayMinusArray(this._unmatchedValues, new NSArray<String>(NO_SELECTION_STRING));
                        if (this._unmatchedValues.lastObject() instanceof EOEnterpriseObject) {
                            this._unmatchedValues = ERXEOControlUtilities.localInstancesOfObjects(this.editingContext(), this._unmatchedValues);
                        }
                        if (destinationSortKeys != null && destinationSortKeys.count() > 0) {
                            this._unmatchedValues = ERXArrayUtilities.sortedArraySortedWithKeys(this._unmatchedValues, destinationSortKeys, sorting);
                        }
                        this._list = this._list.arrayByAddingObjectsFromArray(this._unmatchedValues);
                    }
                } else {
                    this._unmatchedValues = NSArray.EmptyArray;
                }
            }
        }
        return this._list;
    }

    public Object theCurrentValue() {
        Object currentValue = this.theCurrentItem == NO_SELECTION_STRING ? this.noneString() : (this.hasBinding("displayString") ? this.valueForBinding("displayString") : NSKeyValueCodingAdditions.Utility.valueForKeyPath((Object)this.theCurrentItem, (String)this.destinationDisplayKey()));
        if (this.localizeDisplayKeys() && currentValue != null && this.theCurrentItem != NO_SELECTION_STRING) {
            currentValue = this.localizer().localizedStringForKeyWithDefault(currentValue.toString());
        }
        if (this.includeUnmatchedValues() && this.theCurrentItem != NO_SELECTION_STRING && this.unmatchedValues().containsObject(this.theCurrentItem)) {
            currentValue = "[" + currentValue + "]";
        }
        return currentValue;
    }

    public void takeValuesFromRequest(WORequest r, WOContext c) {
        Object realSource;
        super.takeValuesFromRequest(r, c);
        if (c._wasFormSubmitted() && (realSource = this.realSourceObject()) instanceof EOEnterpriseObject) {
            EOEnterpriseObject localObject = (EOEnterpriseObject)realSource;
            String realRelationshipKey = this.realRelationshipKey();
            Object value = localObject.valueForKeyPath(realRelationshipKey);
            try {
                localObject.validateValueForKey(value, realRelationshipKey);
            }
            catch (NSValidation.ValidationException eov) {
                this.parent().validationFailedWithException((Throwable)eov, value, this.relationshipKey());
            }
        }
    }

    protected Object realSourceObject() {
        String masterKey;
        Object realSourceObject = this.sourceObject();
        if (realSourceObject instanceof EOEnterpriseObject && (masterKey = this.relationshipKey()).indexOf(46) != -1) {
            String partialPath = ERXStringUtilities.keyPathWithoutLastProperty(masterKey);
            realSourceObject = NSKeyValueCodingAdditions.Utility.valueForKeyPath((Object)realSourceObject, (String)partialPath);
        }
        return realSourceObject;
    }

    protected String realRelationshipKey() {
        if (this.sourceObject() instanceof EOEnterpriseObject) {
            return ERXStringUtilities.lastPropertyKeyInKeyPath(this.relationshipKey());
        }
        return this.relationshipKey();
    }
}

