/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.components;

import com.webobjects.appserver.WOContext;
import er.extensions.components.ERXStatelessComponent;
import java.util.StringTokenizer;

public class ERXFixedLengthString
extends ERXStatelessComponent {
    protected boolean valueWasTrimmed = false;
    protected String _fixedLengthString;

    public ERXFixedLengthString(WOContext context) {
        super(context);
    }

    public int length() {
        int i = this.intValueForBinding("length", 0);
        return i;
    }

    public void reset() {
        super.reset();
        this.valueWasTrimmed = false;
        this._fixedLengthString = null;
    }

    public String value() {
        if (this._fixedLengthString == null) {
            int sl;
            String result = this.escapeHTML() ? (String)this.valueForBinding("value") : this.strippedValue();
            int l = this.length();
            if (l != 0 && result != null && (sl = result.length()) != l) {
                if (sl < l) {
                    StringBuffer sb = new StringBuffer(result);
                    if (this.booleanValueForBinding("shouldPadToLength", true)) {
                        for (int i = sl; i < l; ++i) {
                            sb.append(' ');
                        }
                    }
                    result = sb.toString();
                } else {
                    this.valueWasTrimmed = true;
                    result = result.substring(0, l - 1);
                }
            }
            this._fixedLengthString = result;
        }
        return this._fixedLengthString;
    }

    public String strippedValue() {
        String value = (String)this.valueForBinding("value");
        if (value == null || value.length() < 1) {
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(value, "<", false);
        int token = value.charAt(0) == '<' ? 0 : 1;
        String nextPart = null;
        StringBuffer result = new StringBuffer();
        int l = this.length();
        int currentLength = result.length();
        while (tokenizer.hasMoreTokens() && currentLength < l && currentLength < value.length()) {
            if (token == 0) {
                nextPart = tokenizer.nextToken(">");
            } else {
                nextPart = tokenizer.nextToken("<");
                if (nextPart.length() > 0 && nextPart.charAt(0) == '>') {
                    nextPart = nextPart.substring(1);
                }
            }
            if (nextPart != null && token != 0) {
                result.append(nextPart);
                currentLength += nextPart.length();
            }
            token = 1 - token;
        }
        return result.toString();
    }

    public String suffixWhenTrimmed() {
        this.value();
        String result = null;
        if (this.value() != null && this.valueWasTrimmed) {
            result = (String)this.objectValueForBinding("suffixWhenTrimmed");
        }
        return result;
    }

    public boolean escapeHTML() {
        return this.booleanValueForBinding("escapeHTML", true);
    }
}

