/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.components;

import com.webobjects.appserver.WOHTTPConnection;
import com.webobjects.appserver.WORequest;
import com.webobjects.foundation.NSDictionary;
import er.extensions.foundation.ERXProperties;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class ERXGMapUtilities {
    public static final String KEY_LONGITUDE = "longitude";
    public static final String KEY_LATITUDE = "latitude";
    public static final String KEY_ACCURACY = "accuracy";
    public static final String KEY_STATUS = "status";
    public static final String[] GEOCODER_RESPONSE_KEYS = new String[]{"status", "accuracy", "latitude", "longitude"};

    public static String apiKey() {
        return ERXProperties.stringForKey("ajax.google.maps.apiKey");
    }

    public static void setApiKey(String apiKey) {
        ERXProperties.setStringForKey(apiKey, "ajax.google.maps.apiKey");
    }

    public static NSDictionary resolveAddress(String address) {
        NSDictionary<String, String> result = null;
        WOHTTPConnection connection = new WOHTTPConnection("maps.google.com", 80);
        String encodedAddress = "";
        try {
            encodedAddress = URLEncoder.encode(address, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        String url = "/maps/geo?q=" + encodedAddress + "&output=csv&key=" + ERXGMapUtilities.apiKey();
        WORequest request = new WORequest("GET", url, "HTTP/1.0", null, null, null);
        boolean success = connection.sendRequest(request);
        if (success) {
            String responseText = connection.readResponse().contentString();
            result = new NSDictionary<String, String>(responseText.split(","), GEOCODER_RESPONSE_KEYS);
        }
        return result;
    }

    public static Coordinate coordinateForAddress(String address) {
        Coordinate result = null;
        if (address != null) {
            try {
                NSDictionary dictionary = ERXGMapUtilities.resolveAddress(address);
                if ("200".equals(dictionary.valueForKey(KEY_STATUS))) {
                    result = new Coordinate(Double.parseDouble((String)dictionary.valueForKey(KEY_LATITUDE)), Double.parseDouble((String)dictionary.valueForKey(KEY_LONGITUDE)));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public static class Coordinate {
        public static final char UNIT_STATUTE_MILES = 'M';
        public static final char UNIT_NAUTICAL_MILES = 'N';
        public static final char UNIT_KILOMETERS = 'K';
        private double latitude;
        private double longitude;

        public Coordinate(double latitude, double longitude) {
            this.latitude = latitude;
            this.longitude = longitude;
        }

        public double latitude() {
            return this.latitude;
        }

        public double longitude() {
            return this.longitude;
        }

        public String toString() {
            return "(longitude: " + this.longitude + ", latitude: " + this.latitude + ")";
        }

        public double distanceTo(Coordinate other, char unit) {
            if (other == null) {
                throw new IllegalArgumentException("Other coordinate must not be null.");
            }
            return Coordinate.distance(this.latitude(), this.longitude(), other.latitude(), other.longitude(), unit);
        }

        public static double distance(double lat1, double lon1, double lat2, double lon2, char unit) {
            double theta = lon1 - lon2;
            double dist = Math.sin(Coordinate.deg2rad(lat1)) * Math.sin(Coordinate.deg2rad(lat2)) + Math.cos(Coordinate.deg2rad(lat1)) * Math.cos(Coordinate.deg2rad(lat2)) * Math.cos(Coordinate.deg2rad(theta));
            dist = Math.acos(dist);
            dist = Coordinate.rad2deg(dist);
            dist = dist * 60.0 * 1.1515;
            if (unit == 'K') {
                dist *= 1.609344;
            } else if (unit == 'N') {
                dist *= 0.8684;
            }
            return dist;
        }

        private static double deg2rad(double deg) {
            return deg * Math.PI / 180.0;
        }

        private static double rad2deg(double rad) {
            return rad * 180.0 / Math.PI;
        }
    }
}

