/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.components.javascript;

import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WOResponse;
import com.webobjects.eocontrol.EOEnterpriseObject;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import er.extensions.components.ERXNonSynchronizingComponent;
import er.extensions.foundation.ERXArrayUtilities;
import er.extensions.foundation.ERXEqualator;
import er.extensions.foundation.ERXStringUtilities;
import java.util.Enumeration;
import org.apache.log4j.Logger;

public class ERXJSToManyRelationshipEditor
extends ERXNonSynchronizingComponent {
    public static final Logger log = Logger.getLogger(ERXJSToManyRelationshipEditor.class);
    protected NSArray _list;
    protected NSArray _selections;
    protected Object currentItem;
    private String _selectionsString;
    private NSDictionary _cachedPossibleValuesDict;
    private String _editorContextID;

    public ERXJSToManyRelationshipEditor(WOContext context) {
        super(context);
    }

    public boolean isStateless() {
        return true;
    }

    public void reset() {
        this.invalidateCaches();
    }

    public Object currentItem() {
        this.setValueForBinding(this.currentItem, "item");
        return this.currentItem;
    }

    public void setCurrentItem(Object anItem) {
        this.currentItem = anItem;
        this.setValueForBinding(this.currentItem, "item");
    }

    public NSArray list() {
        if (null == this._list) {
            this._list = this.listFromBindings();
        }
        return this._list;
    }

    public NSArray selections() {
        if (null == this._selections) {
            NSMutableArray selections = new NSMutableArray();
            Enumeration selectionsEnum = this.selectionsFromBindings().objectEnumerator();
            while (selectionsEnum.hasMoreElements()) {
                Object aSelection = selectionsEnum.nextElement();
                if (!this.maybeSortedList().containsObject(aSelection)) continue;
                selections.addObject(aSelection);
            }
            this._selections = selections.immutableClone();
        }
        return this._selections;
    }

    public String displayString() {
        return this.stringValueForBinding("displayString");
    }

    public void invalidateCaches() {
        this._list = null;
        this._selections = null;
        this.currentItem = null;
        this._selectionsString = null;
        this._cachedPossibleValuesDict = null;
        this._editorContextID = null;
    }

    public void sleep() {
        this.invalidateCaches();
    }

    public void appendToResponse(WOResponse aResponse, WOContext aContext) {
        this.invalidateCaches();
        super.appendToResponse(aResponse, aContext);
    }

    public NSArray maybeSortedList() {
        String sortKey;
        if (this.hasBinding("sortKey") && (sortKey = (String)this.valueForBinding("sortKey")) != null && sortKey.length() > 0) {
            NSMutableArray sortedList = new NSMutableArray(this.listFromBindings());
            ERXArrayUtilities.sortArrayWithKey(sortedList, sortKey);
            return sortedList;
        }
        return this.listFromBindings();
    }

    public boolean isListEmpty() {
        NSArray anItemList = this.listFromBindings();
        return anItemList == null || anItemList.count() == 0;
    }

    public int itemIndex() {
        Object item = this.objectValueForBinding("item");
        if (null == item) {
            return -1;
        }
        return this.indexOfObjectInArrayUsingERXEOControlUtilitiesEOEquals(item, this.listFromBindings());
    }

    private int indexOfObjectInArrayUsingERXEOControlUtilitiesEOEquals(Object anObject, NSArray anArray) {
        if (anObject instanceof EOEnterpriseObject) {
            return ERXArrayUtilities.indexOfObjectUsingEqualator(anArray, anObject, ERXEqualator.EOEqualsEqualator);
        }
        return anArray.indexOfObject(anObject);
    }

    public String selectionsString() {
        if (null == this._selectionsString) {
            NSArray list = this.listFromBindings();
            NSArray selections = this.selectionsFromBindings();
            NSMutableArray<Integer> indexes = new NSMutableArray<Integer>();
            Enumeration selectionsEnum = selections.objectEnumerator();
            while (selectionsEnum.hasMoreElements()) {
                Object aSelection = selectionsEnum.nextElement();
                int index = list.indexOfObject(aSelection);
                if (index < 0) continue;
                indexes.addObject(index);
            }
            this._selectionsString = indexes.componentsJoinedByString(", ");
        }
        return this._selectionsString;
    }

    public void setSelectionsString(String value) {
        this._selectionsString = value;
        if (this._selectionsString != null && this._selectionsString.trim().length() > 0) {
            NSArray list = this.list();
            NSMutableArray selections = new NSMutableArray();
            NSArray<String> itemOffsets = NSArray.componentsSeparatedByString(this._selectionsString, ", ");
            Enumeration<String> offsetsEnum = itemOffsets.objectEnumerator();
            while (offsetsEnum.hasMoreElements()) {
                String offsetString = offsetsEnum.nextElement();
                int offset = ERXStringUtilities.integerWithString(offsetString);
                if (offset < 0 || offset >= list.count()) continue;
                selections.addObject(list.objectAtIndex(offset));
            }
            this._selections = selections;
            this.pushSelectionsBinding(selections);
        } else {
            this.pushSelectionsBinding(NSArray.EmptyArray);
        }
    }

    private void pushSelectionsBinding(NSArray selections) {
        if (this.canSetValueForBinding("selections")) {
            this.setValueForBinding(selections, "selections");
        }
    }

    private NSArray selectionsFromBindings() {
        NSArray result;
        if (this.canGetValueForBinding("selections") && (result = (NSArray)this.valueForBinding("selections")) != null) {
            return result;
        }
        return NSArray.EmptyArray;
    }

    private NSArray listFromBindings() {
        NSArray result;
        if (this.canGetValueForBinding("list") && (result = (NSArray)this.valueForBinding("list")) != null) {
            return result;
        }
        return NSArray.EmptyArray;
    }

    public String editorContextID() {
        if (null == this._editorContextID) {
            this._editorContextID = ERXStringUtilities.safeIdentifierName(this.context().elementID());
        }
        return this._editorContextID;
    }

    public String editorName() {
        return "ERXJSToManyRelationshipEditor_" + this.editorContextID();
    }

    public String hiddenFieldName() {
        return "ERXJSToManyRelationshipEditor_SelectedValues_" + this.editorContextID();
    }

    public String selectedValuesTableName() {
        return "ERXJSToManyRelationshipEditor_SelectedValuesTable_" + this.editorContextID();
    }

    public String javascriptForThisEditorInstance() {
        String safeElementID = ERXStringUtilities.safeIdentifierName(this.context().elementID());
        String editorName = this.editorName();
        StringBuilder sb = new StringBuilder();
        sb.append("var ").append(this.editorName()).append(" = new ERXJSToManyRelationshipEditor();\n");
        sb.append(editorName).append(".elementID = '").append(safeElementID).append("';\n");
        sb.append(editorName).append(".possibleValues = ").append(this.possibleValuesHashForScript()).append(";\n");
        sb.append(editorName).append(".selectedValues = ").append(this.selectedValuesArrayForScript()).append(";");
        return sb.toString();
    }

    private String possibleValuesHashForScript() {
        NSDictionary valuesDict = this.cachedPossibleValues();
        NSMutableArray<String> jsHashValues = new NSMutableArray<String>();
        for (int i = 0; i < valuesDict.count(); ++i) {
            String displayString = (String)valuesDict.objectForKey(i);
            if (displayString != null) {
                displayString = displayString.replaceAll("'", "\\\\'");
            }
            jsHashValues.addObject(i + " : '" + displayString + "'");
        }
        return "{ " + jsHashValues.componentsJoinedByString(", ") + " }";
    }

    private String selectedValuesArrayForScript() {
        NSMutableArray<Integer> offsets = new NSMutableArray<Integer>();
        NSArray sortedList = this.maybeSortedList();
        Enumeration selectionsEnum = this.selections().objectEnumerator();
        while (selectionsEnum.hasMoreElements()) {
            Object obj = selectionsEnum.nextElement();
            int offset = this.indexOfObjectInArrayUsingERXEOControlUtilitiesEOEquals(obj, sortedList);
            if (offset < 0) continue;
            offsets.addObject(offset);
        }
        return "[" + offsets.componentsJoinedByString(", ") + "]";
    }

    private NSDictionary cachedPossibleValues() {
        if (null == this._cachedPossibleValuesDict) {
            NSMutableDictionary<Integer, String> result = new NSMutableDictionary<Integer, String>();
            NSArray allValues = this.maybeSortedList();
            for (int i = 0; i < allValues.count(); ++i) {
                Object item = allValues.objectAtIndex(i);
                this.setCurrentItem(item);
                String displayString = this.stringValueForBinding("displayString");
                String value = displayString != null ? displayString : item.toString();
                result.setObjectForKey(value, i);
            }
            this._cachedPossibleValuesDict = result;
        }
        return this._cachedPossibleValuesDict;
    }

    public String removeItemScript() {
        return this.editorName() + ".removeFromSelectedValues(this, " + this.indexOfObjectInArrayUsingERXEOControlUtilitiesEOEquals(this.currentItem, this.maybeSortedList()) + "); return false;";
    }

    public String addItemScript() {
        return this.editorName() + ".addToSelectedValues(); return false;";
    }

    public String availableValuesPopupMenu() {
        String selectTagName = "ERXJSToManyRelationshipEditor_SelectedValuesPopup_" + this.editorContextID();
        StringBuilder sb = new StringBuilder();
        sb.append("<select id=\"").append(selectTagName).append("\" name=\"").append(selectTagName).append("\">\n");
        NSDictionary allValuesDict = this.cachedPossibleValues();
        NSArray sortedValues = this.maybeSortedList();
        NSArray selections = this.selections();
        Enumeration keysEnum = allValuesDict.allKeys().objectEnumerator();
        while (keysEnum.hasMoreElements()) {
            Integer key = (Integer)keysEnum.nextElement();
            String displayName = (String)allValuesDict.objectForKey(key);
            Object currentObject = sortedValues.objectAtIndex(key);
            if (selections.containsObject(currentObject)) continue;
            sb.append("\t<option value=\"").append(key).append("\">").append(displayName).append("</option>\n");
        }
        sb.append("</select>");
        return sb.toString();
    }

    public static interface Keys {
        public static final String DisplayString = "displayString";
        public static final String Item = "item";
        public static final String List = "list";
        public static final String Selections = "selections";
        public static final String SortKey = "sortKey";
    }
}

