/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.components.javascript;

import com.webobjects.appserver.WOActionResults;
import com.webobjects.appserver.WOApplication;
import com.webobjects.appserver.WOAssociation;
import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WODirectAction;
import com.webobjects.appserver.WOElement;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WOResponse;
import com.webobjects.appserver.WOSession;
import com.webobjects.appserver._private.WODynamicElementCreationException;
import com.webobjects.appserver._private.WOHTMLDynamicElement;
import com.webobjects.appserver._private.WOStaticURLUtilities;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation._NSStringUtilities;
import er.extensions.appserver.ERXApplication;
import er.extensions.appserver.ERXResourceManager;
import er.extensions.appserver.ERXResponseRewriter;
import er.extensions.foundation.ERXExpiringCache;
import java.net.URL;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERXJavaScript
extends WOHTMLDynamicElement {
    public static final Logger log = Logger.getLogger(ERXJavaScript.class);
    WOAssociation _framework;
    WOAssociation _scriptFramework;
    WOAssociation _filename;
    WOAssociation _scriptFile;
    WOAssociation _scriptString;
    WOAssociation _scriptSource;
    WOAssociation _scriptKey;
    WOAssociation _hideInComment;
    WOAssociation _language;

    private static ERXExpiringCache<Object, WOResponse> cache(WOSession session) {
        ERXExpiringCache cache = (ERXExpiringCache)session.objectForKey("ERXJavaScript.cache");
        if (cache == null) {
            cache = new ERXExpiringCache(60L);
            session.setObjectForKey(cache, "ERXJavaScript.cache");
        }
        return cache;
    }

    public ERXJavaScript(String s, NSDictionary nsdictionary, WOElement woelement) {
        super("script", nsdictionary, woelement);
        this._scriptFile = (WOAssociation)this._associations.removeObjectForKey("scriptFile");
        this._scriptString = (WOAssociation)this._associations.removeObjectForKey("scriptString");
        this._scriptSource = (WOAssociation)this._associations.removeObjectForKey("scriptSource");
        this._filename = (WOAssociation)this._associations.removeObjectForKey("filename");
        this._language = (WOAssociation)this._associations.removeObjectForKey("language");
        this._scriptKey = (WOAssociation)this._associations.removeObjectForKey("scriptKey");
        this._hideInComment = (WOAssociation)this._associations.removeObjectForKey("hideInComment");
        this._scriptFramework = (WOAssociation)this._associations.removeObjectForKey("scriptFramework");
        this._framework = (WOAssociation)this._associations.removeObjectForKey("framework");
        if (this._scriptFile != null && this._scriptString != null || this._scriptFile != null && (this._scriptSource != null || this._filename != null) || this._scriptString != null && (this._scriptSource != null || this._filename != null)) {
            throw new WODynamicElementCreationException("<" + ((Object)((Object)this)).getClass().getName() + "> Only one of 'scriptFile' or 'scriptString' or 'scriptSource/filename' attributes can be specified.");
        }
        if (this._scriptFramework != null && this._framework != null) {
            throw new WODynamicElementCreationException("<" + ((Object)((Object)this)).getClass().getName() + "> Only one of 'scriptFramework' or 'framework' can be specified.");
        }
        if (this._scriptSource != null && this._filename != null) {
            throw new WODynamicElementCreationException("<" + ((Object)((Object)this)).getClass().getName() + "> Only one of 'scriptFile' or 'filename' can be specified.");
        }
    }

    public void appendAttributesToResponse(WOResponse woresponse, WOContext wocontext) {
        String srcFromBindings;
        WOComponent wocomponent = wocontext.component();
        woresponse._appendContentAsciiString(" type=\"text/javascript\"");
        String framework = null;
        String scriptName = null;
        String src = null;
        if ((this._scriptSource != null || this._filename != null) && (srcFromBindings = this._scriptSource != null ? (String)this._scriptSource.valueInComponent(wocomponent) : (String)this._filename.valueInComponent(wocomponent)) != null) {
            if (!WOStaticURLUtilities.isRelativeURL((String)srcFromBindings)) {
                src = srcFromBindings;
            } else if (!WOStaticURLUtilities.isFragmentURL((String)srcFromBindings)) {
                if (this._scriptFramework != null) {
                    framework = (String)this._scriptFramework.valueInComponent(wocomponent);
                } else if (this._framework != null) {
                    framework = (String)this._framework.valueInComponent(wocomponent);
                }
                scriptName = srcFromBindings;
                src = wocontext._urlForResourceNamed(srcFromBindings, framework, true);
                if (src == null) {
                    src = wocomponent.baseURL() + "/" + srcFromBindings;
                } else if (ERXResourceManager._shouldGenerateCompleteResourceURL(wocontext)) {
                    src = ERXResourceManager._completeURLForResource(src, null, wocontext);
                }
            } else {
                log.warn((Object)("relative fragment URL" + srcFromBindings));
            }
        }
        Object key = null;
        if (src == null && this._scriptKey != null && (key = this._scriptKey.valueInComponent(wocomponent)) != null) {
            ERXExpiringCache<Object, WOResponse> cache = ERXJavaScript.cache(wocontext.session());
            boolean render = cache.isStale(key);
            if (render |= ERXApplication.isDevelopmentModeSafe()) {
                WOResponse newresponse = new WOResponse();
                super.appendChildrenToResponse(newresponse, wocontext);
                newresponse.setHeader("application/x-javascript", "content-type");
                cache.setObjectForKey(newresponse, key);
            }
            src = wocontext.directActionURLForActionNamed(Script.class.getName() + "/" + key, null);
        }
        if (src != null) {
            woresponse._appendContentAsciiString(" src=\"");
            woresponse.appendContentString(src);
            woresponse.appendContentCharacter('\"');
        }
        super.appendAttributesToResponse(woresponse, wocontext);
        if (scriptName != null) {
            ERXResponseRewriter.resourceAddedToHead(wocontext, framework, scriptName);
        }
    }

    public void appendChildrenToResponse(WOResponse woresponse, WOContext wocontext) {
        String script = "";
        boolean hideInComment = true;
        WOComponent wocomponent = wocontext.component();
        if (this._hideInComment != null) {
            hideInComment = this._hideInComment.booleanValueInComponent(wocomponent);
        }
        if (hideInComment) {
            woresponse._appendContentAsciiString("<!--");
        }
        woresponse.appendContentCharacter('\n');
        if (this._scriptFile != null) {
            String filename = (String)this._scriptFile.valueInComponent(wocomponent);
            if (filename != null) {
                String framework = null;
                if (this._scriptFramework != null) {
                    framework = (String)this._scriptFramework.valueInComponent(wocomponent);
                } else if (this._framework != null) {
                    framework = (String)this._framework.valueInComponent(wocomponent);
                }
                URL url = WOApplication.application().resourceManager().pathURLForResourceNamed(filename, framework, wocontext._languages());
                if (url == null) {
                    url = wocontext.component()._componentDefinition().pathURLForResourceNamed(filename, framework, wocontext._languages());
                }
                if (url == null) {
                    throw new WODynamicElementCreationException("<" + ((Object)((Object)this)).getClass().getName() + "> : cannot find script file '" + filename + "'");
                }
                script = _NSStringUtilities.stringFromPathURL((URL)url);
                if (ERXResourceManager._shouldGenerateCompleteResourceURL(wocontext)) {
                    script = ERXResourceManager._completeURLForResource(script, null, wocontext);
                }
            }
            woresponse.appendContentString(script);
        } else if (this._scriptString != null) {
            Object obj1 = this._scriptString.valueInComponent(wocomponent);
            if (obj1 != null) {
                script = obj1.toString();
            }
            woresponse.appendContentString(script);
        } else {
            super.appendChildrenToResponse(woresponse, wocontext);
        }
        woresponse.appendContentCharacter('\n');
        if (hideInComment) {
            woresponse._appendContentAsciiString("//-->");
        }
    }

    public void appendToResponse(WOResponse woresponse, WOContext wocontext) {
        if (wocontext == null || woresponse == null) {
            return;
        }
        String s = this.elementName();
        if (s != null) {
            this._appendOpenTagToResponse(woresponse, wocontext);
        }
        if (this._scriptSource == null && this._filename == null && this.hasChildrenElements() && this._scriptKey == null) {
            this.appendChildrenToResponse(woresponse, wocontext);
        }
        if (s != null) {
            this._appendCloseTagToResponse(woresponse, wocontext);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("<");
        sb.append(((Object)((Object)this)).getClass().getName());
        sb.append(" scriptFile=" + this._scriptFile);
        sb.append(" scriptString=" + this._scriptString);
        sb.append(" scriptFramework=" + this._scriptFramework);
        sb.append(" framework=" + this._framework);
        sb.append(" scriptSource=" + this._scriptSource);
        sb.append(" filename=" + this._filename);
        sb.append(" hideInComment=" + this._hideInComment);
        sb.append(" language=" + this._language);
        sb.append(">");
        return sb.toString();
    }

    public static class Script
    extends WODirectAction {
        public Script(WORequest worequest) {
            super(worequest);
        }

        public WOActionResults performActionNamed(String name) {
            WOResponse response = (WOResponse)ERXJavaScript.cache(this.session()).objectForKey(name);
            return response;
        }
    }
}

