/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.concurrency;

import er.extensions.foundation.ERXConfigurationManager;
import er.extensions.foundation.ERXProperties;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Hashtable;
import org.apache.log4j.Logger;

public class ERXJobLoadBalancer {
    private static final String SHARED_ROOT_LOCATION = "er.extensions.ERXJobLoadBalancer.RootLocation";
    private static final Logger log = Logger.getLogger(ERXJobLoadBalancer.class);
    private static final String DEFAULT_DEAD_TIMEOUT_MILLIS = "er.extensions.ERXJobLoadBalancer.DefaultDeadTimeoutMillis";
    private static ERXJobLoadBalancer _instance;
    private String _sharedRootLocation;
    private File _sharedRoot;
    private Hashtable _ttlsPerType = new Hashtable();

    public static ERXJobLoadBalancer jobLoadBalancer() {
        if (_instance == null) {
            _instance = new ERXJobLoadBalancer();
        }
        return _instance;
    }

    public String sharedRootLocation() {
        if (this._sharedRootLocation == null) {
            this._sharedRootLocation = ERXProperties.stringForKeyWithDefault(SHARED_ROOT_LOCATION, ERXProperties.stringForKeyWithDefault("java.io.tmpdir", "/tmp") + "/ERXJobLoadBalancer");
        }
        return this._sharedRootLocation;
    }

    protected File sharedRoot() {
        if (this._sharedRoot == null) {
            this._sharedRoot = new File(this.sharedRootLocation());
        }
        return this._sharedRoot;
    }

    public long ttlForWorkerType(String type) {
        Long result = (Long)this._ttlsPerType.get(type);
        if (result == null) {
            result = new Long(ERXProperties.longForKeyWithDefault(DEFAULT_DEAD_TIMEOUT_MILLIS, 60000L));
            this._ttlsPerType.put(type, result);
        }
        return result;
    }

    public void setTtlForWorkerType(String type, long ttl) {
        this._ttlsPerType.put(type, new Long(ttl));
    }

    protected String pathForWorkerIdentification(WorkerIdentification workerId) {
        return this.sharedRootLocation() + "/" + workerId.type() + "-" + workerId.id();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void heartbeat(WorkerIdentification workerId) {
        String pathForEntry = this.pathForWorkerIdentification(workerId);
        File entryFile = new File(pathForEntry);
        File tempFile = new File(pathForEntry + "." + System.currentTimeMillis());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Writing Entry at " + tempFile.getPath() + ": " + workerId));
        }
        ObjectOutputStream out = null;
        File parentDir = tempFile.getParentFile();
        if (!parentDir.exists()) {
            parentDir.mkdirs();
        }
        out = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(tempFile)));
        long now = System.currentTimeMillis();
        out.writeLong(now);
        out.writeUTF(workerId.id());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Wrote to " + tempFile.getPath()));
        }
        out.close();
        out = null;
        tempFile.renameTo(entryFile);
        Object var10_10 = null;
        if (out == null) return;
        try {
            out.close();
            return;
        }
        catch (IOException e22) {}
        return;
        {
            catch (FileNotFoundException e) {
                log.error((Object)("Writing to " + tempFile.getPath() + " caught:" + e));
                Object var10_11 = null;
                if (out == null) return;
                try {
                    out.close();
                    return;
                }
                catch (IOException e22) {}
                return;
            }
            catch (IOException e2) {
                log.error((Object)("Writing to " + tempFile.getPath() + " caught:" + e2));
                Object var10_12 = null;
                if (out == null) return;
                try {
                    out.close();
                    return;
                }
                catch (IOException e22) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            if (out == null) throw throwable;
            try {
                out.close();
                throw throwable;
            }
            catch (IOException e22) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public JobSet idSpace(final WorkerIdentification workerId) {
        ERXJobLoadBalancer.jobLoadBalancer().heartbeat(workerId);
        FilenameFilter friendsFilter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.indexOf(workerId.type()) == 0;
            }
        };
        File[] friends = this.sharedRoot().listFiles(friendsFilter);
        int aliveFriendsCount = 0;
        int aliveFriendsWithLowerIdFound = 0;
        long now = System.currentTimeMillis();
        long ttl = this.ttlForWorkerType(workerId.type());
        for (int i = 0; i < friends.length; ++i) {
            ObjectInputStream in;
            block15: {
                File friend = friends[i];
                in = null;
                in = new ObjectInputStream(new FileInputStream(friend));
                long entryCreationTime = in.readLong();
                String friendId = in.readUTF();
                if (now - entryCreationTime < ttl) {
                    ++aliveFriendsCount;
                    if (friendId.compareTo(workerId.id()) < 0) {
                        ++aliveFriendsWithLowerIdFound;
                    }
                    break block15;
                }
                if (friend.delete()) break block15;
                log.info((Object)("Could not delete dead worker entry: " + friend.getAbsolutePath()));
            }
            Object var17_15 = null;
            if (in == null) continue;
            try {
                in.close();
            }
            catch (IOException e22) {}
            continue;
            {
                catch (FileNotFoundException e) {
                    var17_15 = null;
                    if (in == null) continue;
                    try {
                        in.close();
                    }
                    catch (IOException e22) {}
                    continue;
                }
                catch (IOException e2) {
                    var17_15 = null;
                    if (in == null) continue;
                    try {
                        in.close();
                    }
                    catch (IOException e22) {}
                    continue;
                }
            }
            catch (Throwable throwable) {
                var17_15 = null;
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e22) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        if (aliveFriendsCount == 0) {
            aliveFriendsCount = 1;
            aliveFriendsWithLowerIdFound = 0;
        }
        return new JobSet(aliveFriendsWithLowerIdFound, aliveFriendsCount);
    }

    public String workerInstanceIdentification() {
        return ERXConfigurationManager.defaultManager().hostName() + "-" + System.getProperty("com.webobjects.pid");
    }

    public static void main(String[] args) {
        String arg1;
        if (args.length < 2) {
            ERXJobLoadBalancer.usage();
            System.exit(1);
        }
        if ((arg1 = args[0]).equals("-createJobs")) {
            ERXJobLoadBalancer.createJobs(args[1], Integer.parseInt(args[2]));
        } else if (arg1.equals("-processJobs")) {
            ERXJobLoadBalancer.processJobs(args[1], Integer.parseInt(args[2]));
        } else {
            System.out.println("Unrecognized: " + arg1);
            ERXJobLoadBalancer.usage();
        }
    }

    public static void usage() {
        System.out.println("Usage -createJobs <workerType> <numberOfJobs> | -processJobs <workerType> <workerNumber>");
    }

    public static void createJobs(String workerType, int n) {
        System.out.println("Creating " + n + " jobs for " + workerType);
        ERXJobLoadBalancer.jobLoadBalancer().sharedRoot().mkdirs();
        try {
            for (int i = 0; i < n; ++i) {
                File f = new File(ERXJobLoadBalancer.jobLoadBalancer().sharedRootLocation(), "Job-" + i);
                f.createNewFile();
            }
        }
        catch (IOException e) {
            System.out.println("Could not create jobs: " + e);
        }
    }

    public static void processJobs(String workerType, int workerNumber) {
        WorkerIdentification wid = new WorkerIdentification(workerType, "" + workerNumber);
        ERXJobLoadBalancer.jobLoadBalancer().setTtlForWorkerType(workerType, 20000L);
        while (true) {
            ERXJobLoadBalancer.jobLoadBalancer().heartbeat(wid);
            System.out.println("Worker number " + workerNumber + " processing jobs #" + ERXJobLoadBalancer.jobLoadBalancer().idSpace(wid));
            try {
                Thread.sleep(5000L);
                continue;
            }
            catch (Exception e) {
                System.out.println("ERXJobLoadBalancer.processJobs: " + e);
                continue;
            }
            break;
        }
    }

    public static class WorkerIdentification {
        String _type;
        String _id;

        public WorkerIdentification(String t, String i) {
            this._type = t;
            this._id = i;
        }

        public String toString() {
            return this.type() + "-" + this.id();
        }

        public String id() {
            return this._id;
        }

        public String type() {
            return this._type;
        }
    }

    public static class JobSet {
        public int _index;
        public int _modulo;

        public JobSet(int i, int m) {
            this._index = i;
            this._modulo = m;
        }

        public String toString() {
            return this.index() + " mod " + this.modulo();
        }

        public int index() {
            return this._index;
        }

        public int modulo() {
            return this._modulo;
        }
    }
}

