/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.concurrency;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSMutableArray;
import er.extensions.concurrency.ERXTaskInfo;
import er.extensions.foundation.ERXStopWatch;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERXTaskThread
extends Thread {
    private static final Logger log = Logger.getLogger(ERXTaskThread.class);
    private Runnable _task;
    private ERXStopWatch _stopWatch;

    public ERXTaskThread(Runnable target) {
        super(target);
    }

    public Runnable task() {
        return this._task;
    }

    public void setTask(Runnable task) {
        this._task = task;
    }

    public static NSArray tasks() {
        NSMutableArray<Runnable> tasks = new NSMutableArray<Runnable>();
        Thread[] threads = new Thread[Thread.activeCount()];
        Thread.enumerate(threads);
        for (int i = 0; i < threads.length; ++i) {
            Runnable task;
            Thread thread = threads[i];
            if (!(thread instanceof ERXTaskThread) || (task = ((ERXTaskThread)thread).task()) == null) continue;
            tasks.add(task);
        }
        return tasks.immutableClone();
    }

    public static NSArray taskInfos() {
        NSMutableArray<ERXTaskInfo> taskInfos = new NSMutableArray<ERXTaskInfo>();
        Thread[] threads = new Thread[Thread.activeCount()];
        Thread.enumerate(threads);
        for (int i = 0; i < threads.length; ++i) {
            Runnable task;
            Thread thread = threads[i];
            if (!(thread instanceof ERXTaskThread) || (task = ((ERXTaskThread)thread).task()) == null) continue;
            String elapsedTime = ((ERXTaskThread)thread).elapsedTime();
            ERXTaskInfo info = new ERXTaskInfo(task, elapsedTime);
            taskInfos.add(info);
        }
        return taskInfos.immutableClone();
    }

    public static <T> NSArray<T> taskForTaskClass(Class<T> clazz) {
        NSArray taskInfos = ERXTaskThread.taskInfos();
        NSMutableArray<Runnable> tasks = new NSMutableArray<Runnable>();
        for (ERXTaskInfo taskInfo : taskInfos) {
            Runnable r = taskInfo.task();
            log.debug((Object)("ERXTaskThread.taskForTaskClass(): r = " + r.toString()));
            if (!clazz.isInstance(r)) continue;
            tasks.add(r);
        }
        return tasks.immutableClone();
    }

    public void startStopWatch() {
        this._stopWatch = new ERXStopWatch();
        this._stopWatch.start();
    }

    public String elapsedTime() {
        return this._stopWatch == null ? null : this._stopWatch.toString();
    }

    public void stopStopWatch() {
        if (this._stopWatch != null) {
            this._stopWatch.stop();
        }
    }
}

