/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.crypting;

import com.webobjects.foundation.NSForwardException;
import er.extensions.crypting.ERXCrypterInterface;
import er.extensions.crypting.ERXCrypto;
import er.extensions.foundation.ERXCompressionUtilities;
import er.extensions.foundation.ERXFileUtilities;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import org.apache.log4j.Logger;

public class ERXDESCrypter
implements ERXCrypterInterface {
    public static final Logger log = Logger.getLogger(ERXCrypto.class);
    private Key _secretDESKey;
    private String _secretKeyPathFramework;
    private String _secretKeyPath;

    public ERXDESCrypter() {
    }

    public ERXDESCrypter(String secretKeyPathFramework, String secretKeyPath) {
        this._secretKeyPathFramework = secretKeyPathFramework;
        this._secretKeyPath = secretKeyPath;
    }

    public void setSecretKeyPathFramework(String secretKeyPathFramework) {
        this._secretKeyPathFramework = secretKeyPathFramework;
    }

    public void setSecretKeyPath(String secretKeyPath) {
        this._secretKeyPath = secretKeyPath;
    }

    protected Key defaultSecretKey() {
        if (this._secretDESKey == null) {
            InputStream is = null;
            if (this._secretKeyPath != null) {
                try {
                    is = new FileInputStream(new File(this._secretKeyPath));
                }
                catch (FileNotFoundException e) {
                    log.warn((Object)"Couldn't recover Secret key file, generating new");
                    try {
                        KeyGenerator gen = KeyGenerator.getInstance("DES");
                        gen.init(new SecureRandom());
                        this._secretDESKey = gen.generateKey();
                        ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(new File(this._secretKeyPath)));
                        out.writeObject(this._secretDESKey);
                        out.close();
                        is = new FileInputStream(new File(this._secretKeyPath));
                    }
                    catch (NoSuchAlgorithmException ex) {
                        throw new NSForwardException((Throwable)ex, "Couldn't find the DES algorithm; perhaps you do not have the SunJCE security provider installed properly?");
                    }
                    catch (Exception ex) {
                        throw NSForwardException._runtimeExceptionForThrowable((Throwable)ex);
                    }
                }
            } else {
                String fn = "SecretKey.ser";
                is = ERXFileUtilities.inputStreamForResourceNamed(fn, this._secretKeyPathFramework, null);
            }
            if (is != null) {
                log.debug((Object)"About to try to recover key");
                try {
                    ObjectInputStream in = new ObjectInputStream(is);
                    this._secretDESKey = (Key)in.readObject();
                    in.close();
                }
                catch (Exception e) {
                    throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
                }
            } else {
                throw new RuntimeException("No secret key found. You should add a 'SecretKey.ser' file into your app's resources or use setSecretKeyPath(String aPath)");
            }
        }
        return this._secretDESKey;
    }

    public String decrypt(String cryptedText) {
        return this.decrypt(cryptedText, this.defaultSecretKey());
    }

    public String decrypt(String cryptedText, Key secretKey) {
        if (cryptedText == null) {
            return cryptedText;
        }
        try {
            Cipher cipher = Cipher.getInstance("DES/ECB/PKCS5Padding");
            cipher.init(2, secretKey);
            byte[] raw = ERXCrypto.base64Decode(cryptedText);
            byte[] stringBytes = cipher.doFinal(raw);
            stringBytes = ERXCompressionUtilities.inflateByteArray(stringBytes);
            String decString = new String(stringBytes, "UTF8");
            return decString;
        }
        catch (NoSuchAlgorithmException ex) {
            throw new NSForwardException((Throwable)ex, "Couldn't find the DES algorithm; perhaps you do not have the SunJCE security provider installed properly?");
        }
        catch (Exception ex) {
            throw new NSForwardException((Throwable)ex);
        }
    }

    public String encrypt(String clearText) {
        return this.encrypt(clearText, this.defaultSecretKey());
    }

    public String encrypt(String clearText, Key secretKey) {
        if (clearText == null) {
            return clearText;
        }
        try {
            Cipher cipher = Cipher.getInstance("DES/ECB/PKCS5Padding");
            cipher.init(1, secretKey);
            byte[] stringBytes = clearText.getBytes("UTF-8");
            stringBytes = ERXCompressionUtilities.deflateByteArray(stringBytes);
            byte[] raw = cipher.doFinal(stringBytes);
            String encBase64String = ERXCrypto.base64Encode(raw);
            return encBase64String;
        }
        catch (NoSuchAlgorithmException ex) {
            throw new NSForwardException((Throwable)ex, "Couldn't find the DES algorithm; perhaps you do not have the SunJCE security provider installed properly?");
        }
        catch (Exception ex) {
            throw new NSForwardException((Throwable)ex);
        }
    }
}

