/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.eof;

import com.webobjects.eoaccess.EOAccessArrayFaultHandler;
import com.webobjects.eoaccess.EOAdaptor;
import com.webobjects.eoaccess.EOAdaptorChannel;
import com.webobjects.eoaccess.EOAdaptorOperation;
import com.webobjects.eoaccess.EOAttribute;
import com.webobjects.eoaccess.EODatabaseChannel;
import com.webobjects.eoaccess.EODatabaseContext;
import com.webobjects.eoaccess.EOEntity;
import com.webobjects.eoaccess.EOEntityClassDescription;
import com.webobjects.eoaccess.EOGeneralAdaptorException;
import com.webobjects.eoaccess.EOModel;
import com.webobjects.eoaccess.EOObjectNotAvailableException;
import com.webobjects.eoaccess.EORelationship;
import com.webobjects.eoaccess.EOSQLExpression;
import com.webobjects.eoaccess.EOSQLExpressionFactory;
import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOEnterpriseObject;
import com.webobjects.eocontrol.EOFaultHandler;
import com.webobjects.eocontrol.EOFetchSpecification;
import com.webobjects.eocontrol.EOGlobalID;
import com.webobjects.eocontrol.EOKeyGlobalID;
import com.webobjects.eocontrol.EOSharedEditingContext;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSMutableSet;
import com.webobjects.foundation.NSNotificationCenter;
import er.extensions.eof.ERXArrayFaultCache;
import er.extensions.eof.ERXConstant;
import er.extensions.eof.ERXEOAccessUtilities;
import er.extensions.eof.ERXFetchResultCache;
import er.extensions.eof.ERXGeneratesPrimaryKeyInterface;
import er.extensions.foundation.ERXArrayUtilities;
import er.extensions.foundation.ERXProperties;
import er.extensions.foundation.ERXThreadStorage;
import er.extensions.foundation.ERXUtilities;
import er.extensions.jdbc.ERXJDBCConnectionAnalyzer;
import er.extensions.jdbc.ERXSQLHelper;
import er.extensions.statistics.ERXStats;
import java.util.Enumeration;
import org.apache.log4j.Logger;

public class ERXDatabaseContextDelegate {
    public static final String DatabaseContextFailedToFetchObject = "DatabaseContextFailedToFetchObject";
    public static final Logger log = Logger.getLogger(ERXDatabaseContextDelegate.class);
    public static final Logger dbLog = Logger.getLogger((String)"er.transaction.adaptor.FaultFiring");
    public static final Logger exLog = Logger.getLogger((String)"er.transaction.adaptor.Exceptions");
    public static final Logger batchLog = Logger.getLogger((String)"er.transaction.adaptor.Batching");
    private static ERXDatabaseContextDelegate _defaultDelegate = new ERXDatabaseContextDelegate();
    private ERXArrayFaultCache _arrayFaultCache = null;
    private ERXFetchResultCache _fetchResultCache = null;
    private ReentranceProtector reportingError = new ReentranceProtector();
    private ReentranceProtector fetchingToMany = new ReentranceProtector();
    private ReentranceProtector fetchingToOne = new ReentranceProtector();
    public static int autoBatchFetchSize = -1;
    public static final String THREAD_KEY = "ERXBatching";
    private BatchHandler DEFAULT;
    private BatchHandler _handler = this.DEFAULT = new BatchHandler(){

        public int batchSizeForRelationship(EOEditingContext ec, EORelationship relationship) {
            return ERXDatabaseContextDelegate.autoBatchFetchSize();
        }
    };

    public static ERXDatabaseContextDelegate defaultDelegate() {
        return _defaultDelegate;
    }

    public static void setDefaultDelegate(ERXDatabaseContextDelegate delegate) {
        _defaultDelegate = delegate;
    }

    public ERXArrayFaultCache arrayFaultCache() {
        return this._arrayFaultCache;
    }

    public void setArrayFaultCache(ERXArrayFaultCache value) {
        this._arrayFaultCache = value;
    }

    public ERXFetchResultCache fetchResultCache() {
        return this._fetchResultCache;
    }

    public void setFetchResultCache(ERXFetchResultCache value) {
        this._fetchResultCache = value;
    }

    public NSArray databaseContextShouldFetchObjects(EODatabaseContext dbc, EOFetchSpecification fs, EOEditingContext ec) {
        NSArray<? extends EOEnterpriseObject> result = null;
        ERXFetchResultCache fetchResultCache = this.fetchResultCache();
        if (fetchResultCache != null) {
            result = fetchResultCache.objectsForFetchSpecification(dbc, ec, fs);
        }
        return result;
    }

    public void databaseContextDidFetchObjects(EODatabaseContext dbc, NSArray eos, EOFetchSpecification fs, EOEditingContext ec) {
        ERXFetchResultCache fetchResultCache = this.fetchResultCache();
        if (fetchResultCache != null) {
            fetchResultCache.setObjectsForFetchSpecification(dbc, ec, eos, fs);
        }
        if (ERXDatabaseContextDelegate.autoBatchFetchSize() > 0 && eos.count() > 0) {
            this.freshenFetchTimestamps(eos, ec.fetchTimestamp());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean databaseContextShouldHandleDatabaseException(EODatabaseContext databaseContext, Throwable throwable) {
        if (!this.reportingError.canEnter(databaseContext)) {
            return true;
        }
        try {
            if (exLog.isDebugEnabled()) {
                exLog.debug((Object)("Database Exception occured: " + throwable), throwable);
            } else if (exLog.isInfoEnabled()) {
                exLog.info((Object)("Database Exception occured: " + throwable));
            }
            boolean handled = ERXSQLHelper.newSQLHelper(databaseContext).handleDatabaseException(databaseContext, throwable);
            if (!handled && throwable.getMessage() != null && throwable.getMessage().indexOf("_obtainOpenChannel") != -1) {
                NSArray models = databaseContext.database().models();
                Enumeration e = models.objectEnumerator();
                while (e.hasMoreElements()) {
                    EOModel model = (EOModel)e.nextElement();
                    NSMutableDictionary<String, String> connectionDictionary = model.connectionDictionary();
                    if (connectionDictionary != null) {
                        NSMutableDictionary<String, String> mutableConnectionDictionary = ((NSDictionary)connectionDictionary).mutableClone();
                        mutableConnectionDictionary.setObjectForKey("<password deleted for log>", "password");
                        connectionDictionary = mutableConnectionDictionary;
                    }
                    log.info((Object)(model.name() + ": " + (connectionDictionary == null ? "No connection dictionary!" : connectionDictionary.toString())));
                }
                if ("JDBC".equals(databaseContext.adaptorContext().adaptor().name())) {
                    new ERXJDBCConnectionAnalyzer(databaseContext.database().adaptor().connectionDictionary());
                }
            }
            boolean bl = !handled;
            Object var10_10 = null;
            this.reportingError.leave(databaseContext);
            return bl;
        }
        catch (Throwable throwable2) {
            Object var10_11 = null;
            this.reportingError.leave(databaseContext);
            throw throwable2;
        }
    }

    public NSDictionary databaseContextNewPrimaryKey(EODatabaseContext databaseContext, Object object, EOEntity entity) {
        return object instanceof ERXGeneratesPrimaryKeyInterface ? ((ERXGeneratesPrimaryKeyInterface)object).primaryKeyDictionary(true) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean databaseContextShouldHandleDatabaseException(EODatabaseContext dbc, Exception e) throws Throwable {
        if (!this.reportingError.canEnter(dbc)) {
            return true;
        }
        try {
            EOAdaptor adaptor = dbc.adaptorContext().adaptor();
            boolean shouldHandleConnection = false;
            if (e instanceof EOGeneralAdaptorException) {
                log.error((Object)((EOGeneralAdaptorException)((Object)e)).userInfo());
            } else {
                log.error((Object)e);
            }
            if (adaptor.isDroppedConnectionException(e)) {
                shouldHandleConnection = true;
            } else if (e.toString().indexOf("ORA-01041") != -1) {
                log.error((Object)"ORA-01041 detecting -- forcing reconnect");
                dbc.database().handleDroppedConnection();
                shouldHandleConnection = false;
            } else {
                if (e instanceof EOGeneralAdaptorException) {
                    log.info((Object)((EOGeneralAdaptorException)((Object)e)).userInfo());
                }
                throw e;
            }
            boolean bl = shouldHandleConnection;
            Object var7_6 = null;
            this.reportingError.leave(dbc);
            return bl;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.reportingError.leave(dbc);
            throw throwable;
        }
    }

    public boolean databaseContextFailedToFetchObject(EODatabaseContext context, Object object, EOGlobalID gid) {
        String gidString;
        EOEditingContext ec;
        String tolerantEntityPattern = ERXProperties.stringForKey("er.extensions.ERXDatabaseContextDelegate.tolerantEntityPattern");
        boolean raiseException = true;
        if (tolerantEntityPattern != null && gid instanceof EOKeyGlobalID && ((EOKeyGlobalID)gid).entityName().matches(tolerantEntityPattern)) {
            raiseException = false;
        }
        if (object != null && !((ec = ((EOEnterpriseObject)object).editingContext()) instanceof EOSharedEditingContext) && raiseException) {
            context.refaultObject((EOEnterpriseObject)object, gid, ec);
        }
        if (gid instanceof EOKeyGlobalID) {
            EOKeyGlobalID kgid = (EOKeyGlobalID)gid;
            gidString = "<" + kgid.entityName() + ": [";
            EOEntity entity = ERXEOAccessUtilities.entityNamed(null, kgid.entityName());
            NSArray pks = entity.primaryKeyAttributes();
            NSArray values = kgid.keyValuesArray();
            EOSQLExpressionFactory expressionFactory = context.database().adaptor().expressionFactory();
            EOSQLExpression expression = null;
            if (expressionFactory != null) {
                expression = expressionFactory.expressionForEntity(entity);
            }
            for (int i = 0; i < pks.count(); ++i) {
                Object value = values.objectAtIndex(i);
                EOAttribute attribute = (EOAttribute)pks.objectAtIndex(i);
                String stringValue = "" + value;
                if (expression != null) {
                    stringValue = expression.formatValueForAttribute(value, attribute);
                }
                if ("NULL".equals(stringValue)) {
                    stringValue = "" + value;
                }
                gidString = gidString + attribute.name() + ": '" + stringValue + "'" + (i == pks.count() - 1 ? "" : ", ");
            }
            gidString = gidString + "] >";
        } else {
            gidString = gid.toString();
        }
        NSNotificationCenter.defaultCenter().postNotification(DatabaseContextFailedToFetchObject, object);
        if (raiseException) {
            throw new ObjectNotAvailableException("No " + (object != null ? object.getClass().getName() : "N/A") + " found with globalID: " + gidString, gid);
        }
        if (ERXProperties.booleanForKeyWithDefault("er.extensions.ERXDatabaseContextDelegate.logTolerantEntityNotAvailable", true)) {
            log.error((Object)("No " + (object != null ? object.getClass().getName() : "N/A") + " found with globalID: " + gidString + "\n" + ERXUtilities.stackTrace()));
        }
        return false;
    }

    public void databaseContextDidSelectObjects(EODatabaseContext dc, EOFetchSpecification fs, EODatabaseChannel channel) {
        if (dbLog.isDebugEnabled()) {
            dbLog.debug((Object)("databaseContextDidSelectObjects " + fs), (Throwable)new Exception());
        }
    }

    public boolean databaseContextShouldFetchArrayFault(EODatabaseContext dbc, Object obj) {
        if (this._arrayFaultCache != null) {
            this._arrayFaultCache.clearFault(obj);
            if (!EOFaultHandler.isFault((Object)obj)) {
                return false;
            }
        }
        if (ERXDatabaseContextDelegate.autoBatchFetchSize() > 0) {
            return this.batchFetchToManyFault(dbc, obj);
        }
        return true;
    }

    public boolean databaseContextShouldFetchObjectFault(EODatabaseContext dbc, Object obj) {
        if (ERXDatabaseContextDelegate.autoBatchFetchSize() > 0 && obj instanceof AutoBatchFaultingEnterpriseObject) {
            return this.batchFetchToOneFault(dbc, (AutoBatchFaultingEnterpriseObject)obj);
        }
        return true;
    }

    public NSArray databaseContextWillPerformAdaptorOperations(EODatabaseContext dbCtxt, NSArray adaptorOps, EOAdaptorChannel adChannel) {
        NSMutableArray<EOAdaptorOperation> result = new NSMutableArray<EOAdaptorOperation>();
        NSDictionary groupedOps = ERXArrayUtilities.arrayGroupedByKeyPath(adaptorOps, "adaptorOperator");
        Integer insertKey = ERXConstant.integerForInt(1);
        NSArray insertOps = groupedOps.objectForKey(insertKey);
        Integer deleteKey = ERXConstant.integerForInt(3);
        NSArray deleteOps = groupedOps.objectForKey(deleteKey);
        if (insertOps != null && deleteOps != null) {
            NSMutableSet<EOAdaptorOperation> skippedOps = new NSMutableSet<EOAdaptorOperation>();
            Enumeration<Object> e = insertOps.objectEnumerator();
            while (e.hasMoreElements()) {
                EOAdaptorOperation insertOp = (EOAdaptorOperation)e.nextElement();
                Enumeration e1 = deleteOps.objectEnumerator();
                while (e1.hasMoreElements()) {
                    EOAdaptorOperation deleteOp = (EOAdaptorOperation)e1.nextElement();
                    if (skippedOps.containsObject(deleteOp) || insertOp.entity() != deleteOp.entity() || !deleteOp.qualifier().evaluateWithObject((Object)insertOp.changedValues())) continue;
                    result.addObject(deleteOp);
                    skippedOps.addObject(deleteOp);
                    log.warn((Object)("Skipped: " + insertOp + "\n" + deleteOp));
                }
            }
            e = adaptorOps.objectEnumerator();
            while (e.hasMoreElements()) {
                EOAdaptorOperation op = (EOAdaptorOperation)e.nextElement();
                if (skippedOps.containsObject(op)) continue;
                result.addObject(op);
            }
        } else {
            result.addObjectsFromArray(adaptorOps);
        }
        return result;
    }

    private void freshenFetchTimestamps(NSArray eos, long timestamp) {
        for (Object eo : eos) {
            if (!(eo instanceof AutoBatchFaultingEnterpriseObject)) continue;
            AutoBatchFaultingEnterpriseObject ft = (AutoBatchFaultingEnterpriseObject)eo;
            ft.setBatchFaultingTimestamp(timestamp);
        }
    }

    private void markStart(String type, EOEnterpriseObject eo, String key) {
        if (ERXStats.isTrackingStatistics()) {
            ERXStats.markStart("Batching", type + "." + eo.entityName() + "." + key);
        }
    }

    private void markEnd(String type, EOEnterpriseObject eo, String key) {
        if (ERXStats.isTrackingStatistics()) {
            ERXStats.markEnd("Batching", type + "." + eo.entityName() + "." + key);
        }
    }

    public static int autoBatchFetchSize() {
        if (autoBatchFetchSize == -1) {
            autoBatchFetchSize = ERXProperties.intForKeyWithDefault("er.extensions.ERXDatabaseContextDelegate.autoBatchFetchSize", 0);
        }
        return autoBatchFetchSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean batchFetchToManyFault(EODatabaseContext dbc, Object obj) {
        if (this.fetchingToMany.canEnter(dbc)) {
            block9: {
                try {
                    EOAccessArrayFaultHandler handler = (EOAccessArrayFaultHandler)EOFaultHandler.handlerForFault((Object)obj);
                    EOEditingContext ec = handler.editingContext();
                    EOEnterpriseObject source = ec.faultForGlobalID((EOGlobalID)handler.sourceGlobalID(), ec);
                    if (!(source instanceof AutoBatchFaultingEnterpriseObject)) break block9;
                    String key = handler.relationshipName();
                    EOEntityClassDescription cd = (EOEntityClassDescription)source.classDescription();
                    EORelationship relationship = cd.entity().relationshipNamed(key);
                    if (this._handler.batchSizeForRelationship(ec, relationship) <= 0) break block9;
                    this.markStart("ToMany.Calculation", source, key);
                    NSArray candidates = null;
                    NSArray currentObjects = (NSArray)ERXThreadStorage.valueForKey(THREAD_KEY);
                    boolean fromThreadStorage = false;
                    if (currentObjects != null && currentObjects.lastObject() instanceof AutoBatchFaultingEnterpriseObject) {
                        candidates = currentObjects;
                        fromThreadStorage = true;
                    } else {
                        candidates = ec.registeredObjects();
                    }
                    long timestamp = ((AutoBatchFaultingEnterpriseObject)source).batchFaultingTimeStamp();
                    NSMutableArray<AutoBatchFaultingEnterpriseObject> eos = new NSMutableArray<AutoBatchFaultingEnterpriseObject>();
                    NSMutableArray<Object> faults = new NSMutableArray<Object>();
                    for (EOEnterpriseObject o : candidates) {
                        Object fault;
                        AutoBatchFaultingEnterpriseObject autoBatchFaultingEnterpriseObject;
                        if (!(o instanceof AutoBatchFaultingEnterpriseObject) || (autoBatchFaultingEnterpriseObject = (AutoBatchFaultingEnterpriseObject)o).batchFaultingTimeStamp() != timestamp && !fromThreadStorage || EOFaultHandler.isFault((Object)autoBatchFaultingEnterpriseObject) || autoBatchFaultingEnterpriseObject.classDescription() != source.classDescription() || !EOFaultHandler.isFault((Object)(fault = autoBatchFaultingEnterpriseObject.storedValueForKey(key)))) continue;
                        faults.addObject(fault);
                        eos.addObject(autoBatchFaultingEnterpriseObject);
                        if (eos.count() != ERXDatabaseContextDelegate.autoBatchFetchSize()) continue;
                        break;
                    }
                    this.markEnd("ToMany.Calculation", source, key);
                    if (eos.count() <= 1) break block9;
                    this.markStart("ToMany.Fetching", source, key);
                    this.doFetch(dbc, ec, relationship, eos);
                    int cnt = 0;
                    for (Object e : faults) {
                        if (EOFaultHandler.isFault(e)) continue;
                        NSArray array = (NSArray)e;
                        this.freshenFetchTimestamps(array, timestamp);
                        cnt += array.count();
                    }
                    this.markEnd("ToMany.Fetching", source, key);
                    if (batchLog.isDebugEnabled()) {
                        batchLog.debug((Object)("Fetched " + cnt + " to-many " + relationship.destinationEntity().name() + " from " + eos.count() + " " + source.entityName() + " for " + key));
                    }
                    boolean bl = EOFaultHandler.isFault((Object)obj);
                    Object var21_23 = null;
                    this.fetchingToMany.leave(dbc);
                    return bl;
                }
                catch (Throwable throwable) {
                    Object var21_25 = null;
                    this.fetchingToMany.leave(dbc);
                    throw throwable;
                }
            }
            Object var21_24 = null;
            this.fetchingToMany.leave(dbc);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean batchFetchToOneFault(EODatabaseContext dbc, AutoBatchFaultingEnterpriseObject eo) {
        if (this.fetchingToOne.canEnter(dbc)) {
            block8: {
                try {
                    AutoBatchFaultingEnterpriseObject source;
                    EOEntityClassDescription cd;
                    EORelationship relationship;
                    EOEditingContext ec;
                    EOGlobalID sourceGID = eo.batchFaultingSourceGlobalID();
                    String key = eo.batchFaultingRelationshipName();
                    if (sourceGID == null || key == null || this._handler.batchSizeForRelationship(ec = eo.editingContext(), relationship = (cd = (EOEntityClassDescription)(source = (AutoBatchFaultingEnterpriseObject)ec.faultForGlobalID(sourceGID, ec)).classDescription()).entity().relationshipNamed(key)) <= 0 || relationship.isToMany()) break block8;
                    this.markStart("ToOne.Calculation", source, key);
                    long timestamp = source.batchFaultingTimeStamp();
                    boolean fromThreadStorage = false;
                    NSMutableArray<AutoBatchFaultingEnterpriseObject> eos = new NSMutableArray<AutoBatchFaultingEnterpriseObject>();
                    NSMutableSet<Object> faults = new NSMutableSet<Object>();
                    NSArray candidates = null;
                    NSArray currentObjects = (NSArray)ERXThreadStorage.valueForKey(THREAD_KEY);
                    if (currentObjects != null && currentObjects.lastObject() instanceof AutoBatchFaultingEnterpriseObject) {
                        candidates = currentObjects;
                        fromThreadStorage = true;
                    } else {
                        candidates = ec.registeredObjects();
                    }
                    for (EOEnterpriseObject current : candidates) {
                        Object fault;
                        AutoBatchFaultingEnterpriseObject currentEO;
                        if (!(current instanceof AutoBatchFaultingEnterpriseObject) || (currentEO = (AutoBatchFaultingEnterpriseObject)current).batchFaultingTimeStamp() != timestamp && !fromThreadStorage || source.classDescription() != currentEO.classDescription() || EOFaultHandler.isFault((Object)currentEO) || !EOFaultHandler.isFault((Object)(fault = currentEO.storedValueForKey(key)))) continue;
                        faults.addObject(fault);
                        eos.addObject(currentEO);
                        if (eos.count() != ERXDatabaseContextDelegate.autoBatchFetchSize()) continue;
                        break;
                    }
                    this.markEnd("ToOne.Calculation", source, key);
                    if (eos.count() <= 1) break block8;
                    this.markStart("ToOne.Fetching", source, key);
                    this.doFetch(dbc, ec, relationship, eos);
                    this.freshenFetchTimestamps(faults.allObjects(), timestamp);
                    this.markEnd("ToOne.Fetching", source, key);
                    if (batchLog.isDebugEnabled()) {
                        batchLog.debug((Object)("Fetched " + faults.count() + " to-one " + relationship.destinationEntity().name() + " from " + eos.count() + " " + source.entityName() + " for " + key));
                    }
                    boolean bl = EOFaultHandler.isFault((Object)eo);
                    Object var21_20 = null;
                    this.fetchingToOne.leave(dbc);
                    return bl;
                }
                catch (Throwable throwable) {
                    Object var21_22 = null;
                    this.fetchingToOne.leave(dbc);
                    throw throwable;
                }
            }
            Object var21_21 = null;
            this.fetchingToOne.leave(dbc);
        }
        return true;
    }

    private void doFetch(EODatabaseContext dbc, EOEditingContext ec, EORelationship relationship, NSArray eos) {
        ERXEOAccessUtilities.batchFetchRelationship(dbc, relationship, eos, ec, true);
    }

    public void setBatchHandler(BatchHandler handler) {
        if (handler == null) {
            handler = this.DEFAULT;
        }
        this._handler = handler;
    }

    public static void setCurrentBatchObjects(NSArray arr) {
        if (ERXDatabaseContextDelegate.autoBatchFetchSize() > 0 && (arr == null || arr.lastObject() instanceof EOEnterpriseObject)) {
            ERXThreadStorage.takeValueForKey(arr, THREAD_KEY);
        }
    }

    public static interface BatchHandler {
        public int batchSizeForRelationship(EOEditingContext var1, EORelationship var2);
    }

    private class ReentranceProtector {
        private NSMutableArray<EODatabaseContext> _accessing = new NSMutableArray();

        private ReentranceProtector() {
        }

        public synchronized boolean canEnter(EODatabaseContext dbc) {
            if (this._accessing.containsObject(dbc)) {
                return false;
            }
            this._accessing.addObject(dbc);
            return true;
        }

        public synchronized void leave(EODatabaseContext dbc) {
            this._accessing.removeObject(dbc);
        }
    }

    public static interface AutoBatchFaultingEnterpriseObject
    extends EOEnterpriseObject {
        public long batchFaultingTimeStamp();

        public void setBatchFaultingTimestamp(long var1);

        public void touchFromBatchFaultingSource(AutoBatchFaultingEnterpriseObject var1, String var2);

        public EOGlobalID batchFaultingSourceGlobalID();

        public String batchFaultingRelationshipName();
    }

    public static class ObjectNotAvailableException
    extends EOObjectNotAvailableException {
        private EOGlobalID globalID;

        public ObjectNotAvailableException(String message) {
            this(message, null);
        }

        public ObjectNotAvailableException(String message, EOGlobalID gid) {
            super(message);
            this.globalID = gid;
        }

        public EOGlobalID globalID() {
            return this.globalID;
        }
    }
}

