/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.eof;

import com.webobjects.eoaccess.EOAdaptorChannel;
import com.webobjects.eoaccess.EOAttribute;
import com.webobjects.eoaccess.EODatabase;
import com.webobjects.eoaccess.EODatabaseContext;
import com.webobjects.eoaccess.EOEntity;
import com.webobjects.eoaccess.EOModel;
import com.webobjects.eoaccess.EOModelGroup;
import com.webobjects.eoaccess.EOObjectNotAvailableException;
import com.webobjects.eoaccess.EOSQLExpression;
import com.webobjects.eoaccess.EOSQLExpressionFactory;
import com.webobjects.eoaccess.EOUtilities;
import com.webobjects.eocontrol.EOAndQualifier;
import com.webobjects.eocontrol.EOArrayDataSource;
import com.webobjects.eocontrol.EOClassDescription;
import com.webobjects.eocontrol.EODataSource;
import com.webobjects.eocontrol.EODetailDataSource;
import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOEnterpriseObject;
import com.webobjects.eocontrol.EOFaultHandler;
import com.webobjects.eocontrol.EOFaulting;
import com.webobjects.eocontrol.EOFetchSpecification;
import com.webobjects.eocontrol.EOGlobalID;
import com.webobjects.eocontrol.EOKeyComparisonQualifier;
import com.webobjects.eocontrol.EOKeyGlobalID;
import com.webobjects.eocontrol.EOKeyValueQualifier;
import com.webobjects.eocontrol.EONotQualifier;
import com.webobjects.eocontrol.EOObjectStore;
import com.webobjects.eocontrol.EOObjectStoreCoordinator;
import com.webobjects.eocontrol.EOOrQualifier;
import com.webobjects.eocontrol.EOQualifier;
import com.webobjects.eocontrol.EORelationshipManipulation;
import com.webobjects.eocontrol.EOSharedEditingContext;
import com.webobjects.eocontrol.EOSortOrdering;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSCoding;
import com.webobjects.foundation.NSData;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation.NSKeyValueCodingAdditions;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableData;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSMutableSet;
import com.webobjects.foundation.NSPropertyListSerialization;
import com.webobjects.foundation.NSSelector;
import com.webobjects.foundation.NSSet;
import com.webobjects.foundation.NSTimestamp;
import com.webobjects.foundation.NSTimestampFormatter;
import er.extensions.eof.EOEnterpriseObjectClazz;
import er.extensions.eof.ERXBatchFetchUtilities;
import er.extensions.eof.ERXEC;
import er.extensions.eof.ERXEOAccessUtilities;
import er.extensions.eof.ERXEOGlobalIDUtilities;
import er.extensions.eof.ERXEnterpriseObject;
import er.extensions.eof.ERXS;
import er.extensions.eof.IERXEOContainer;
import er.extensions.eof.IERXGIDContainer;
import er.extensions.foundation.ERXArrayUtilities;
import er.extensions.foundation.ERXDictionaryUtilities;
import er.extensions.foundation.ERXKeyValueCodingUtilities;
import er.extensions.foundation.ERXProperties;
import er.extensions.jdbc.ERXSQLHelper;
import er.extensions.validation.ERXValidationFactory;
import java.util.Enumeration;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERXEOControlUtilities {
    public static final Logger log = Logger.getLogger(ERXEOControlUtilities.class);
    private static NSMutableDictionary _attributeKeysPerEntityName = new NSMutableDictionary();

    public static <T extends EOEnterpriseObject> NSArray<T> localInstancesOfObjects(EOEditingContext ec, NSArray<T> eos) {
        if (eos == null) {
            throw new RuntimeException("ERXUtilites: localInstancesOfObjects: Array is null");
        }
        if (ec == null) {
            throw new RuntimeException("ERXUtilites: localInstancesOfObjects: EditingContext is null");
        }
        NSMutableArray<EOEnterpriseObject> localEos = new NSMutableArray<EOEnterpriseObject>();
        Enumeration<T> e = eos.objectEnumerator();
        while (e.hasMoreElements()) {
            localEos.addObject(ERXEOControlUtilities.localInstanceOfObject(ec, (EOEnterpriseObject)e.nextElement()));
        }
        return localEos;
    }

    public static EOArrayDataSource dataSourceForArray(NSArray<? extends EOEnterpriseObject> array) {
        EOArrayDataSource dataSource = null;
        if (array != null && array.count() > 0) {
            EOEnterpriseObject eo = array.objectAtIndex(0);
            dataSource = new EOArrayDataSource(eo.classDescription(), eo.editingContext());
            dataSource.setArray(array);
        }
        return dataSource;
    }

    public static EOArrayDataSource dataSourceForArray(EOEditingContext ec, String entityName, NSArray array) {
        EOArrayDataSource dataSource = new EOArrayDataSource(EOClassDescription.classDescriptionForEntityName((String)entityName), ec);
        if (array != null && array.count() > 0) {
            dataSource.setArray(array);
        }
        return dataSource;
    }

    public static NSArray arrayFromDataSource(EODataSource dataSource) {
        return dataSource.fetchObjects();
    }

    public static EODetailDataSource dataSourceForObjectAndKey(EOEnterpriseObject object, String key) {
        EODetailDataSource eodetaildatasource = new EODetailDataSource(EOClassDescription.classDescriptionForEntityName((String)object.entityName()), key);
        eodetaildatasource.qualifyWithRelationshipKey(key, (Object)object);
        return eodetaildatasource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends EOEnterpriseObject> T editableInstanceOfObject(T eo, boolean createNestedContext) {
        if (eo == null) {
            throw new IllegalArgumentException("EO can't be null");
        }
        EOEditingContext ec = eo.editingContext();
        if (ec == null) {
            throw new IllegalArgumentException("EO must live in an EC");
        }
        boolean isNewObject = ERXEOControlUtilities.isNewObject(eo);
        if (ERXProperties.webObjectsVersionAsDouble() < 5.21 && isNewObject) {
            return eo;
        }
        Object localObject = eo;
        if (isNewObject && createNestedContext || !isNewObject) {
            EOEditingContext newEc = ERXEC.newEditingContext((EOObjectStore)(createNestedContext ? ec : ec.parentObjectStore()));
            ec.lock();
            try {
                newEc.lock();
                try {
                    if (ec instanceof EOSharedEditingContext || ec.sharedEditingContext() == null) {
                        newEc.setSharedEditingContext(null);
                    }
                    localObject = EOUtilities.localInstanceOfObject((EOEditingContext)newEc, eo);
                    localObject.willRead();
                    Object var7_6 = null;
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    newEc.unlock();
                    throw throwable;
                }
                newEc.unlock();
                Object var9_9 = null;
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                ec.unlock();
                throw throwable;
            }
            ec.unlock();
            {
            }
        }
        return localObject;
    }

    public static <T extends EOEnterpriseObject> T localInstanceOfObject(EOEditingContext ec, T eo) {
        return (T)(eo != null && ec != null && eo.editingContext() != null && !ec.equals(eo.editingContext()) ? EOUtilities.localInstanceOfObject((EOEditingContext)ec, eo) : eo);
    }

    public static boolean eoEquals(EOEnterpriseObject firstEO, EOEnterpriseObject secondEO) {
        boolean result = false;
        if (firstEO == secondEO) {
            result = true;
        } else if (firstEO != null && secondEO != null) {
            EOEditingContext firstContext = firstEO.editingContext();
            EOEditingContext secondContext = secondEO.editingContext();
            if (firstContext != null && secondContext != null) {
                EOGlobalID firstGID = firstContext.globalIDForObject(firstEO);
                EOGlobalID secondGID = secondContext.globalIDForObject(secondEO);
                result = firstGID.equals((Object)secondGID);
            }
        }
        return result;
    }

    public static <T extends EOEnterpriseObject> T createAndInsertObject(EOEditingContext ec, Class<T> eoClass) {
        return (T)ERXEOControlUtilities.createAndInsertObject(ec, eoClass.getSimpleName());
    }

    public static EOEnterpriseObject createAndInsertObject(EOEditingContext editingContext, String entityName) {
        return ERXEOControlUtilities.createAndInsertObject(editingContext, entityName, null);
    }

    public static EOEnterpriseObject createAndInsertObject(EOEditingContext editingContext, String entityName, NSDictionary objectInfo) {
        EOClassDescription cd;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating object of type: " + entityName));
        }
        if ((cd = EOClassDescription.classDescriptionForEntityName((String)entityName)) == null) {
            throw new RuntimeException("Could not find class description for entity named " + entityName);
        }
        EOEnterpriseObject newEO = cd.createInstanceWithEditingContext(editingContext, null);
        editingContext.insertObject(newEO);
        if (objectInfo != null) {
            newEO.takeValuesFromDictionary(objectInfo);
        }
        return newEO;
    }

    public static EOEnterpriseObject createAndAddObjectToRelationship(EOEditingContext editingContext, EOEnterpriseObject source, String relationshipName, String destinationEntityName, NSDictionary objectInfo) {
        EOEnterpriseObject newEO = ERXEOControlUtilities.createAndInsertObject(editingContext, destinationEntityName, objectInfo);
        EOEnterpriseObject eoBis = editingContext != source.editingContext() ? EOUtilities.localInstanceOfObject((EOEditingContext)editingContext, (EOEnterpriseObject)source) : source;
        eoBis.addObjectToBothSidesOfRelationshipWithKey((EORelationshipManipulation)newEO, relationshipName);
        return newEO;
    }

    public static void addObjectToObjectOnBothSidesOfRelationshipWithKey(EOEnterpriseObject addedObject, EOEnterpriseObject referenceObject, String key) {
        EOEditingContext referenceEc = referenceObject.editingContext();
        EOEditingContext ec = addedObject.editingContext();
        EOEnterpriseObject copy = addedObject;
        if (referenceEc != ec) {
            copy = EOUtilities.localInstanceOfObject((EOEditingContext)referenceEc, (EOEnterpriseObject)addedObject);
        }
        referenceObject.addObjectToBothSidesOfRelationshipWithKey((EORelationshipManipulation)copy, key);
    }

    public static void refaultObject(EOEnterpriseObject eo) {
        if (eo != null && !eo.isFault()) {
            EOEditingContext ec = eo.editingContext();
            NSArray<EOGlobalID> gids = new NSArray<EOGlobalID>(ec.globalIDForObject(eo));
            ec.invalidateObjectsWithGlobalIDs(gids);
        }
    }

    public static void refreshObject(EOEnterpriseObject eo) {
        eo.editingContext().setFetchTimestamp(System.currentTimeMillis());
        eo.editingContext().refreshObject(eo);
    }

    public static void clearSnapshotForRelationshipNamed(EOEnterpriseObject eo, String relationshipName) {
        EOEditingContext ec = eo.editingContext();
        EOModel model = EOUtilities.entityForObject((EOEditingContext)ec, (EOEnterpriseObject)eo).model();
        EOGlobalID gid = ec.globalIDForObject(eo);
        EODatabaseContext dbc = EODatabaseContext.registeredDatabaseContextForModel((EOModel)model, (EOEditingContext)ec);
        EODatabase database = dbc.database();
        ERXEOControlUtilities.clearSnapshotForRelationshipNamedInDatabase(eo, relationshipName, database);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearSnapshotForRelationshipNamedInDatabase(EOEnterpriseObject eo, String relationshipName, EODatabase database) {
        EOEditingContext ec = eo.editingContext();
        EOObjectStoreCoordinator osc = (EOObjectStoreCoordinator)ec.rootObjectStore();
        osc.lock();
        try {
            EOGlobalID gid = ec.globalIDForObject(eo);
            database.recordSnapshotForSourceGlobalID(null, gid, relationshipName);
            Object o = eo.storedValueForKey(relationshipName);
            boolean needRefresh = false;
            if (o instanceof EOFaulting) {
                EOFaulting toManyArray = (EOFaulting)o;
                if (!toManyArray.isFault()) {
                    EOFaulting tmpToManyArray = (EOFaulting)((EOObjectStoreCoordinator)ec.rootObjectStore()).arrayFaultWithSourceGlobalID(gid, relationshipName, ec);
                    toManyArray.turnIntoFault(tmpToManyArray.faultHandler());
                    needRefresh = true;
                }
            } else {
                EOFaulting tmpToManyArray = (EOFaulting)((EOObjectStoreCoordinator)ec.rootObjectStore()).arrayFaultWithSourceGlobalID(gid, relationshipName, ec);
                eo.takeStoredValueForKey((Object)tmpToManyArray, relationshipName);
                needRefresh = true;
            }
            if (needRefresh && eo instanceof ERXEnterpriseObject) {
                ((ERXEnterpriseObject)eo).flushCaches();
            }
            Object var11_11 = null;
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            osc.unlock();
            throw throwable;
        }
        osc.unlock();
    }

    public static EOFetchSpecification primaryKeyFetchSpecificationForEntity(EOEditingContext ec, String entityName, EOQualifier eoqualifier, NSArray<EOSortOrdering> sortOrderings, NSArray<String> additionalKeys) {
        EOEntity entity = ERXEOAccessUtilities.entityNamed(ec, entityName);
        EOFetchSpecification fs = new EOFetchSpecification(entityName, eoqualifier, sortOrderings);
        fs.setFetchesRawRows(true);
        NSMutableArray<String> keys = new NSMutableArray<String>(entity.primaryKeyAttributeNames());
        if (additionalKeys != null) {
            keys.addObjectsFromArray(additionalKeys);
        }
        fs.setRawRowKeyPaths(keys);
        return fs;
    }

    public static NSArray primaryKeysMatchingQualifier(EOEditingContext ec, String entityName, EOQualifier eoqualifier, NSArray<EOSortOrdering> sortOrderings) {
        EOFetchSpecification fs = ERXEOControlUtilities.primaryKeyFetchSpecificationForEntity(ec, entityName, eoqualifier, sortOrderings, null);
        return ec.objectsWithFetchSpecification(fs);
    }

    public static EOEnterpriseObject objectWithPrimaryKeyValue(EOEditingContext ec, String entityName, Object primaryKeyValue, NSArray prefetchingKeyPaths) {
        return ERXEOControlUtilities.objectWithPrimaryKeyValue(ec, entityName, primaryKeyValue, prefetchingKeyPaths, true);
    }

    public static EOEnterpriseObject objectWithPrimaryKeyValue(EOEditingContext ec, String entityName, Object primaryKeyValue, NSArray prefetchingKeyPaths, boolean refreshRefetchedObjects) {
        NSArray eos;
        NSDictionary<String, Object> values;
        EOEntity entity = EOUtilities.entityNamed((EOEditingContext)ec, (String)entityName);
        if (primaryKeyValue instanceof NSDictionary) {
            values = (NSDictionary<String, Object>)primaryKeyValue;
        } else {
            if (entity.primaryKeyAttributes().count() != 1) {
                throw new IllegalStateException("The entity '" + entity.name() + "' has a compound primary key and cannot be used with a single primary key value.");
            }
            values = new NSDictionary<String, Object>(primaryKeyValue, ((EOAttribute)entity.primaryKeyAttributes().lastObject()).name());
        }
        if (prefetchingKeyPaths == null && !refreshRefetchedObjects) {
            EOGlobalID gid = entity.globalIDForRow((NSDictionary)values);
            eos = new NSArray(ec.faultForGlobalID(gid, ec));
        } else {
            EOQualifier qualfier = EOQualifier.qualifierToMatchAllValues((NSDictionary)values);
            EOFetchSpecification fs = new EOFetchSpecification(entityName, qualfier, null);
            fs.setRefreshesRefetchedObjects(refreshRefetchedObjects);
            if (prefetchingKeyPaths != null) {
                fs.setPrefetchingRelationshipKeyPaths(prefetchingKeyPaths);
            }
            eos = ec.objectsWithFetchSpecification(fs);
        }
        if (eos.count() > 1) {
            throw new IllegalStateException("Found multiple objects for the entity '" + entity.name() + "' with primary key value: " + primaryKeyValue);
        }
        return eos.count() == 1 ? (EOEnterpriseObject)eos.lastObject() : null;
    }

    public static <T extends EOEnterpriseObject> NSArray<T> objectsInRange(EOEditingContext ec, EOFetchSpecification spec, int start, int end) {
        return ERXEOControlUtilities.objectsInRange(ec, spec, start, end, true);
    }

    public static <T extends EOEnterpriseObject> NSArray<T> objectsInRange(EOEditingContext ec, EOFetchSpecification spec, int start, int end, boolean rawRowsForCustomQueries) {
        NSArray result;
        if (spec.hints() == null || spec.hints().isEmpty() || spec.hints().valueForKey("EOCustomQueryExpressionHintKey") == null) {
            NSArray primKeys = ERXEOControlUtilities.primaryKeyValuesInRange(ec, spec, start, end);
            EOEntity entity = ERXEOAccessUtilities.entityNamed(ec, spec.entityName());
            NSMutableArray<EOGlobalID> gids = new NSMutableArray<EOGlobalID>();
            for (Object obj : primKeys) {
                NSDictionary pkDict = (NSDictionary)obj;
                EOGlobalID gid = entity.globalIDForRow(pkDict);
                gids.addObject(gid);
            }
            NSMutableArray objects = ERXEOGlobalIDUtilities.fetchObjectsWithGlobalIDs(ec, gids, spec.refreshesRefetchedObjects());
            if (spec.prefetchingRelationshipKeyPaths() != null && spec.prefetchingRelationshipKeyPaths().count() > 0) {
                ERXBatchFetchUtilities.batchFetch((NSArray)objects, spec.prefetchingRelationshipKeyPaths(), !spec.refreshesRefetchedObjects());
            }
            ERXEOControlUtilities.ensureSortOrdering(ec, gids, objects);
            result = objects.immutableClone();
        } else {
            EOModel model = EOModelGroup.defaultGroup().entityNamed(spec.entityName()).model();
            ERXSQLHelper sqlHelper = ERXSQLHelper.newSQLHelper(ec, model.name());
            Object hint = spec.hints().valueForKey("EOCustomQueryExpressionHintKey");
            String sql = sqlHelper.customQueryExpressionHintAsString(hint);
            sql = sqlHelper.limitExpressionForSQL(null, spec, sql, start, end);
            if (rawRowsForCustomQueries) {
                result = EOUtilities.rawRowsForSQL((EOEditingContext)ec, (String)model.name(), (String)sql, null);
            } else {
                EOFetchSpecification fs = new EOFetchSpecification(spec.entityName(), null, null);
                fs.setHints(new NSDictionary<String, String>(sql, "EOCustomQueryExpressionHintKey"));
                result = ec.objectsWithFetchSpecification(fs);
            }
        }
        return result;
    }

    public static NSArray primaryKeyValuesInRange(EOEditingContext ec, EOFetchSpecification spec, int start, int end) {
        EOEntity entity = ERXEOAccessUtilities.entityNamed(ec, spec.entityName());
        NSArray pkNames = (NSArray)entity.primaryKeyAttributes().valueForKey("name");
        spec.setFetchesRawRows(true);
        spec.setRawRowKeyPaths(pkNames);
        EOFetchSpecification clonedFetchSpec = (EOFetchSpecification)spec.clone();
        EOSQLExpression sql = ERXEOAccessUtilities.sqlExpressionForFetchSpecification(ec, clonedFetchSpec, start, end);
        NSDictionary<String, EOSQLExpression> hints = new NSDictionary<String, EOSQLExpression>(sql, "EOCustomQueryExpressionHintKey");
        clonedFetchSpec.setHints(hints);
        return ec.objectsWithFetchSpecification(clonedFetchSpec);
    }

    public static Integer objectCountWithQualifier(EOEditingContext ec, String entityName, EOQualifier qualifier) {
        EOAttribute attribute = EOEnterpriseObjectClazz.objectCountAttribute();
        return (Integer)ERXEOControlUtilities._aggregateFunctionWithQualifierAndAggregateAttribute(ec, entityName, qualifier, attribute);
    }

    public static Integer objectCountUniqueWithQualifierAndAttribute(EOEditingContext ec, String entityName, EOQualifier qualifier, String attributeName) {
        EOEntity entity = EOUtilities.entityNamed((EOEditingContext)ec, (String)entityName);
        EOAttribute attribute = entity.attributeNamed(attributeName);
        EOAttribute aggregateAttribute = EOEnterpriseObjectClazz.objectCountUniqueAttribute(attribute);
        return (Integer)ERXEOControlUtilities._aggregateFunctionWithQualifierAndAggregateAttribute(ec, entityName, qualifier, aggregateAttribute);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object _aggregateFunctionWithQualifierAndAggregateAttribute(EOEditingContext ec, String entityName, EOQualifier qualifier, EOAttribute aggregateAttribute) {
        EOEntity entity = ERXEOAccessUtilities.entityNamed(ec, entityName);
        EOModel model = entity.model();
        EODatabaseContext dbc = EODatabaseContext.registeredDatabaseContextForModel((EOModel)model, (EOEditingContext)ec);
        Object aggregateValue = null;
        dbc.lock();
        try {
            try {
                aggregateValue = ERXEOControlUtilities.__aggregateFunctionWithQualifierAndAggregateAttribute(dbc, ec, entityName, qualifier, aggregateAttribute);
            }
            catch (Exception localException) {
                if (!dbc._isDroppedConnectionException(localException)) throw NSForwardException._runtimeExceptionForThrowable((Throwable)localException);
                try {
                    dbc.database().handleDroppedConnection();
                    aggregateValue = ERXEOControlUtilities.__aggregateFunctionWithQualifierAndAggregateAttribute(dbc, ec, entityName, qualifier, aggregateAttribute);
                }
                catch (Exception ex) {
                    throw NSForwardException._runtimeExceptionForThrowable((Throwable)ex);
                }
                Object var11_9 = null;
                dbc.unlock();
                return aggregateValue;
            }
            Object var11_8 = null;
        }
        catch (Throwable throwable) {
            Object var11_10 = null;
            dbc.unlock();
            throw throwable;
        }
        dbc.unlock();
        return aggregateValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object __aggregateFunctionWithQualifierAndAggregateAttribute(EODatabaseContext databaseContext, EOEditingContext ec, String entityName, EOQualifier qualifier, EOAttribute aggregateAttribute) {
        EOEntity entity = ERXEOAccessUtilities.entityNamed(ec, entityName);
        EOModel model = entity.model();
        EOSQLExpressionFactory sqlFactory = databaseContext.adaptorContext().adaptor().expressionFactory();
        EOQualifier schemaBasedQualifier = entity.schemaBasedQualifier(qualifier);
        EOFetchSpecification fetchSpec = new EOFetchSpecification(entity.name(), schemaBasedQualifier, null);
        fetchSpec.setFetchesRawRows(true);
        if (sqlFactory == null) {
            NSArray array = ec.objectsWithFetchSpecification(fetchSpec);
            if (aggregateAttribute == EOEnterpriseObjectClazz.objectCountAttribute()) {
                return array.count();
            }
            if (aggregateAttribute.name().startsWith("p_objectCountUnique")) {
                String attributeName = aggregateAttribute.name().substring("p_objectCountUnique".length());
                return ERXArrayUtilities.arrayWithoutDuplicateKeyValue(array, attributeName).count();
            }
            throw new UnsupportedOperationException("Unable to perform aggregate function for attribute " + aggregateAttribute.name());
        }
        EOSQLExpression sqlExpr = sqlFactory.expressionForEntity(entity);
        sqlExpr.prepareSelectExpressionWithAttributes(new NSArray<EOAttribute>(aggregateAttribute), false, fetchSpec);
        EOAdaptorChannel adaptorChannel = databaseContext.availableChannel().adaptorChannel();
        if (!adaptorChannel.isOpen()) {
            adaptorChannel.openChannel();
        }
        Object aggregateValue = null;
        NSArray<EOAttribute> attributes = new NSArray<EOAttribute>(aggregateAttribute);
        adaptorChannel.evaluateExpression(sqlExpr);
        try {
            adaptorChannel.setAttributesToFetch(attributes);
            NSMutableDictionary row = adaptorChannel.fetchRow();
            if (row != null) {
                aggregateValue = row.objectForKey(aggregateAttribute.name());
            }
            Object var16_17 = null;
        }
        catch (Throwable throwable) {
            Object var16_18 = null;
            adaptorChannel.cancelFetch();
            throw throwable;
        }
        adaptorChannel.cancelFetch();
        return aggregateValue;
    }

    public static Number aggregateFunctionWithQualifier(EOEditingContext ec, String entityName, String attributeName, String function, String fetchSpecificationName, NSDictionary bindings) {
        EOFetchSpecification fs = ERXEOControlUtilities.fetchSpecificationNamedWithBindings(entityName, fetchSpecificationName, bindings);
        return ERXEOControlUtilities.aggregateFunctionWithQualifier(ec, entityName, attributeName, function, fs.qualifier());
    }

    public static Number aggregateFunctionWithQualifier(EOEditingContext ec, String entityName, String attributeName, String function, EOQualifier qualifier) {
        Number number = null;
        Object obj = ERXEOControlUtilities._aggregateFunctionWithQualifier(ec, entityName, attributeName, function, Number.class, "i", qualifier);
        if (obj instanceof Number) {
            number = (Number)obj;
        }
        return number;
    }

    public static NSTimestamp aggregateTimestampWithQualifier(EOEditingContext ec, String entityName, String attributeName, String function, EOQualifier qualifier) {
        NSTimestamp timestamp = null;
        Object obj = ERXEOControlUtilities._aggregateFunctionWithQualifier(ec, entityName, attributeName, function, NSTimestamp.class, null, qualifier);
        if (obj instanceof NSTimestamp) {
            timestamp = (NSTimestamp)obj;
        }
        return timestamp;
    }

    public static Object _aggregateFunctionWithQualifier(EOEditingContext ec, String entityName, String attributeName, String function, Class valueClass, String valueType, EOQualifier qualifier) {
        EOAttribute attribute = ERXEOAccessUtilities.createAggregateAttribute(ec, function, attributeName, entityName, valueClass, valueType);
        return ERXEOControlUtilities._aggregateFunctionWithQualifierAndAggregateAttribute(ec, entityName, qualifier, attribute);
    }

    public static EOEnterpriseObject sharedObjectMatchingKeyAndValue(String entityName, String key, Object value) {
        NSArray filtered = ERXEOControlUtilities.sharedObjectsMatchingKeyAndValue(entityName, key, value);
        if (filtered.count() > 1) {
            log.warn((Object)("Found multiple shared objects for entityName: " + entityName + " matching key: " + key + " value: " + value + " matched against: " + filtered));
        }
        return filtered.count() > 0 ? (EOEnterpriseObject)filtered.lastObject() : null;
    }

    public static NSArray sharedObjectsMatchingKeyAndValue(String entityName, String key, Object value) {
        NSArray filtered = null;
        EOKeyValueQualifier qualifier = new EOKeyValueQualifier(key, EOQualifier.QualifierOperatorEqual, value);
        NSArray sharedEos = ERXEOControlUtilities.sharedObjectsForEntityNamed(entityName);
        if (sharedEos != null) {
            filtered = EOQualifier.filteredArrayWithQualifier((NSArray)sharedEos, (EOQualifier)qualifier);
        } else {
            log.warn((Object)("Unable to find any shared objects for entity name: " + entityName));
        }
        return filtered != null ? filtered : NSArray.EmptyArray;
    }

    public static NSArray sharedObjectsForEntityNamed(String entityName) {
        EOSharedEditingContext sharedEC = EOSharedEditingContext.defaultSharedEditingContext();
        NSArray sharedEos = (NSArray)sharedEC.objectsByEntityName().objectForKey(entityName);
        if (sharedEos == null) {
            EOEntity entity = ERXEOAccessUtilities.entityNamed((EOEditingContext)sharedEC, entityName);
            EODatabaseContext.registeredDatabaseContextForModel((EOModel)entity.model(), (EOEditingContext)sharedEC);
            sharedEos = (NSArray)sharedEC.objectsByEntityName().objectForKey(entityName);
        }
        if (sharedEos == null) {
            log.warn((Object)("Unable to find any shared objects for the entity named: " + entityName));
        }
        return sharedEos != null ? sharedEos : NSArray.EmptyArray;
    }

    public static EOEnterpriseObject sharedObjectWithFetchSpec(String entityName, String fetchSpec) {
        return EOUtilities.objectWithFetchSpecificationAndBindings((EOEditingContext)EOSharedEditingContext.defaultSharedEditingContext(), (String)entityName, (String)fetchSpec, null);
    }

    public static NSArray sharedObjectsWithFetchSpecificationNamed(String entityName, String fetchSpecName) {
        NSArray result = null;
        EOSharedEditingContext sharedEditingContext = EOSharedEditingContext.defaultSharedEditingContext();
        NSDictionary objectsByFetchSpecName = (NSDictionary)sharedEditingContext.objectsByEntityNameAndFetchSpecificationName().objectForKey(entityName);
        if (objectsByFetchSpecName != null) {
            result = (NSArray)objectsByFetchSpecName.objectForKey(fetchSpecName);
        }
        if (result == null) {
            EOEntity entity = EOUtilities.entityNamed((EOEditingContext)sharedEditingContext, (String)entityName);
            EOFetchSpecification fetchSpecification = entity.fetchSpecificationNamed(fetchSpecName);
            sharedEditingContext.bindObjectsWithFetchSpecification(fetchSpecification, fetchSpecName);
            objectsByFetchSpecName = (NSDictionary)sharedEditingContext.objectsByEntityNameAndFetchSpecificationName().objectForKey(entityName);
            if (objectsByFetchSpecName != null) {
                result = (NSArray)objectsByFetchSpecName.objectForKey(fetchSpecName);
            }
        }
        if (result == null) {
            result = NSArray.EmptyArray;
        }
        return result;
    }

    public static EOEnterpriseObject sharedObjectWithPrimaryKey(String entityName, Object primaryKey) {
        EOKeyGlobalID gid = EOKeyGlobalID.globalIDWithEntityName((String)entityName, (Object[])new Object[]{primaryKey});
        EOSharedEditingContext sharedEditingContext = EOSharedEditingContext.defaultSharedEditingContext();
        EOEnterpriseObject eo = sharedEditingContext.objectForGlobalID((EOGlobalID)gid);
        return eo != null ? eo : EOUtilities.objectWithPrimaryKeyValue((EOEditingContext)sharedEditingContext, (String)entityName, (Object)primaryKey);
    }

    public static EOFetchSpecification fetchSpecificationNamedWithBindings(String entityName, String fetchSpecificationName, NSDictionary bindings) {
        EOFetchSpecification fetchSpec = EOFetchSpecification.fetchSpecificationNamed((String)fetchSpecificationName, (String)entityName);
        return fetchSpec != null && bindings != null ? fetchSpec.fetchSpecificationWithQualifierBindings(bindings) : fetchSpec;
    }

    public static NSDictionary<String, Object> newPrimaryKeyDictionaryForObjectFromClassProperties(EOEnterpriseObject eo) {
        EOEditingContext ec = eo.editingContext();
        EOEntity entity = EOUtilities.entityNamed((EOEditingContext)ec, (String)eo.entityName());
        NSArray pkAttributes = entity.primaryKeyAttributeNames();
        int count = pkAttributes.count();
        NSMutableDictionary<String, Object> nsmutabledictionary = new NSMutableDictionary<String, Object>(count);
        NSArray classPropertyNames = entity.classPropertyNames();
        while (count-- != 0) {
            String key = (String)pkAttributes.objectAtIndex(count);
            if (!classPropertyNames.containsObject(key)) {
                return null;
            }
            Object value = eo.valueForKey(key);
            if (value == null) {
                return null;
            }
            nsmutabledictionary.setObjectForKey(value, key);
        }
        return nsmutabledictionary;
    }

    public static NSDictionary<String, Object> newPrimaryKeyDictionaryForObject(EOEnterpriseObject eo) {
        NSDictionary<String, Object> dict = ERXEOControlUtilities.newPrimaryKeyDictionaryForObjectFromClassProperties(eo);
        if (dict == null) {
            dict = ERXEOControlUtilities.newPrimaryKeyDictionaryForEntityNamed(eo.editingContext(), eo.entityName());
        }
        return dict;
    }

    public static NSDictionary<String, Object> newPrimaryKeyDictionaryForEntityNamed(EOEditingContext ec, String entityName) {
        EOEntity entity = ERXEOAccessUtilities.entityNamed(ec, entityName);
        EODatabaseContext dbContext = EODatabaseContext.registeredDatabaseContextForModel((EOModel)entity.model(), (EOEditingContext)ec);
        NSDictionary primaryKey = null;
        try {
            try {
                dbContext.lock();
                boolean willRetryAfterHandlingDroppedConnection = true;
                while (willRetryAfterHandlingDroppedConnection) {
                    try {
                        NSArray arr;
                        EOAdaptorChannel adaptorChannel = dbContext.availableChannel().adaptorChannel();
                        if (!adaptorChannel.isOpen()) {
                            adaptorChannel.openChannel();
                        }
                        if ((arr = adaptorChannel.primaryKeysForNewRowsWithEntity(1, entity)) != null) {
                            primaryKey = (NSDictionary)arr.lastObject();
                        } else {
                            log.warn((Object)("Could not get primary key array for entity: " + entityName));
                        }
                        willRetryAfterHandlingDroppedConnection = false;
                    }
                    catch (Exception localException) {
                        if (willRetryAfterHandlingDroppedConnection && dbContext._isDroppedConnectionException(localException)) {
                            try {
                                dbContext.database().handleDroppedConnection();
                                continue;
                            }
                            catch (Exception ex) {
                                throw NSForwardException._runtimeExceptionForThrowable((Throwable)ex);
                            }
                        }
                        throw NSForwardException._runtimeExceptionForThrowable((Throwable)localException);
                    }
                }
                Object var9_11 = null;
            }
            catch (Exception e) {
                log.error((Object)("Caught exception when generating primary key for entity: " + entityName), (Throwable)e);
                throw new NSForwardException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            dbContext.unlock();
            throw throwable;
        }
        dbContext.unlock();
        return primaryKey;
    }

    public static String primaryKeyStringForObject(EOEnterpriseObject eo) {
        return ERXEOControlUtilities._stringForPrimaryKey(ERXEOControlUtilities.primaryKeyObjectForObject(eo));
    }

    public static String primaryKeyStringForGlobalID(EOKeyGlobalID gid) {
        if (gid.keyValuesArray().count() > 1) {
            return ERXEOControlUtilities._stringForPrimaryKey(gid.keyValuesArray());
        }
        return ERXEOControlUtilities._stringForPrimaryKey(gid.keyValuesArray().lastObject());
    }

    public static String _stringForPrimaryKey(Object pk) {
        if (pk == null) {
            return null;
        }
        if (pk instanceof String || pk instanceof Number) {
            return pk.toString();
        }
        return NSPropertyListSerialization.stringFromPropertyList((Object)pk);
    }

    public static NSDictionary<String, Object> primaryKeyDictionaryForString(EOEditingContext ec, String entityName, String string) {
        if (string == null) {
            return null;
        }
        if (string.trim().length() == 0) {
            return NSDictionary.EmptyDictionary;
        }
        EOEntity entity = ERXEOAccessUtilities.entityNamed(ec, entityName);
        NSArray pks = entity.primaryKeyAttributes();
        NSMutableDictionary<String, Object> pk = new NSMutableDictionary<String, Object>();
        try {
            Object rawValue = NSPropertyListSerialization.propertyListFromString((String)string);
            if (rawValue instanceof NSArray) {
                int index = 0;
                Enumeration e = ((NSArray)rawValue).objectEnumerator();
                while (e.hasMoreElements()) {
                    EOAttribute attribute = (EOAttribute)pks.objectAtIndex(index++);
                    Object value = e.nextElement();
                    if (attribute.adaptorValueType() == 3 && !(value instanceof NSTimestamp)) {
                        value = new NSTimestampFormatter("%Y-%m-%d %H:%M:%S %Z").parseObject((String)value);
                    }
                    value = attribute.validateValue(value);
                    pk.setObjectForKey(value, attribute.name());
                    if (pks.count() != 1) continue;
                    break;
                }
            } else {
                if (rawValue instanceof NSMutableData) {
                    rawValue = new NSData((NSData)((NSMutableData)rawValue));
                }
                EOAttribute attribute = (EOAttribute)pks.objectAtIndex(0);
                Object value = rawValue;
                value = attribute.validateValue(value);
                pk.setObjectForKey(value, attribute.name());
            }
            return pk;
        }
        catch (Exception ex) {
            throw new NSForwardException((Throwable)ex, "Error while parsing primary key: " + string);
        }
    }

    public static EOGlobalID globalIDForString(EOEditingContext ec, String entityName, String string) {
        NSDictionary<String, Object> values = ERXEOControlUtilities.primaryKeyDictionaryForString(ec, entityName, string);
        EOEntity entity = ERXEOAccessUtilities.entityNamed(ec, entityName);
        NSArray pks = entity.primaryKeyAttributeNames();
        EOKeyGlobalID gid = EOKeyGlobalID.globalIDWithEntityName((String)entityName, (Object[])values.objectsForKeys(pks, null).objects());
        return gid;
    }

    public static Object primaryKeyObjectForObject(EOEnterpriseObject eo) {
        NSArray arr = ERXEOControlUtilities.primaryKeyArrayForObject(eo);
        if (arr != null && arr.count() == 1) {
            return arr.lastObject();
        }
        return arr;
    }

    public static NSArray primaryKeyArrayForObject(EOEnterpriseObject obj) {
        EOEditingContext ec = obj.editingContext();
        if (ec == null) {
            return null;
        }
        EOGlobalID gid = ec.globalIDForObject(obj);
        if (gid.isTemporary()) {
            return null;
        }
        EOKeyGlobalID kGid = (EOKeyGlobalID)gid;
        return kGid.keyValuesArray();
    }

    public static NSArray objectsWithQualifierFormat(EOEditingContext ec, String entityName, String qualifierFormat, NSArray args, NSArray prefetchKeyPaths, boolean includeNewObjects) {
        return ERXEOControlUtilities.objectsWithQualifierFormat(ec, entityName, qualifierFormat, args, prefetchKeyPaths, includeNewObjects, false);
    }

    public static NSArray objectsWithQualifierFormat(EOEditingContext ec, String entityName, String qualifierFormat, NSArray args, NSArray prefetchKeyPaths, boolean includeNewObjects, boolean includeNewObjectsInParentEditingContexts) {
        EOQualifier qual = EOQualifier.qualifierWithQualifierFormat((String)qualifierFormat, (NSArray)args);
        return ERXEOControlUtilities.objectsWithQualifier(ec, entityName, qual, prefetchKeyPaths, includeNewObjects, includeNewObjectsInParentEditingContexts);
    }

    public static NSArray objectsWithQualifier(EOEditingContext ec, String entityName, EOQualifier qualifier, NSArray prefetchKeyPaths, boolean includeNewObjects) {
        return ERXEOControlUtilities.objectsWithQualifier(ec, entityName, qualifier, prefetchKeyPaths, includeNewObjects, false);
    }

    public static NSArray objectsWithQualifier(EOEditingContext _editingContext, String _entityName, EOQualifier _qualifier, NSArray _prefetchKeyPaths, boolean _includeNewObjects, boolean _includeNewObjectsInParentEditingContext) {
        return ERXEOControlUtilities.objectsWithQualifier(_editingContext, _entityName, _qualifier, _prefetchKeyPaths, _includeNewObjects, _includeNewObjectsInParentEditingContext, false, false);
    }

    public static NSArray objectsWithQualifier(EOEditingContext editingContext, String entityName, EOQualifier qualifier, NSArray prefetchKeyPaths, boolean includeNewObjects, boolean includeNewObjectsInParentEditingContext, boolean filterUpdatedObjects, boolean removeDeletedObjects) {
        return ERXEOControlUtilities.objectsWithQualifier(editingContext, entityName, qualifier, prefetchKeyPaths, null, 0, false, true, null, includeNewObjects, includeNewObjectsInParentEditingContext, filterUpdatedObjects, removeDeletedObjects);
    }

    public static NSArray objectsWithQualifier(EOEditingContext editingContext, String entityName, EOQualifier qualifier, NSArray prefetchKeyPaths, NSArray sortOrderings, boolean usesDistinct, boolean isDeep, NSDictionary hints, boolean includeNewObjects, boolean includeNewObjectsInParentEditingContext, boolean filterUpdatedObjects, boolean removeDeletedObjects) {
        return ERXEOControlUtilities.objectsWithQualifier(editingContext, entityName, qualifier, prefetchKeyPaths, sortOrderings, 0, usesDistinct, isDeep, hints, includeNewObjects, includeNewObjectsInParentEditingContext, filterUpdatedObjects, removeDeletedObjects);
    }

    public static NSArray objectsWithQualifier(EOEditingContext editingContext, String entityName, EOQualifier qualifier, NSArray prefetchKeyPaths, NSArray sortOrderings, int fetchLimit, boolean usesDistinct, boolean isDeep, NSDictionary hints, boolean includeNewObjects, boolean includeNewObjectsInParentEditingContext, boolean filterUpdatedObjects, boolean removeDeletedObjects) {
        boolean objectsMayGetAdded = includeNewObjects || includeNewObjectsInParentEditingContext || filterUpdatedObjects;
        NSArray fetchSortOrderings = sortOrderings;
        if (objectsMayGetAdded) {
            fetchSortOrderings = null;
        }
        EOFetchSpecification fs = new EOFetchSpecification(entityName, qualifier, fetchSortOrderings);
        fs.setFetchLimit(fetchLimit);
        fs.setPrefetchingRelationshipKeyPaths(prefetchKeyPaths);
        fs.setIsDeep(isDeep);
        fs.setUsesDistinct(usesDistinct);
        fs.setHints(hints);
        NSArray matchingObjects = editingContext.objectsWithFetchSpecification(fs);
        matchingObjects = ERXEOControlUtilities.filteredObjectsWithQualifier(editingContext, matchingObjects, entityName, qualifier, sortOrderings, usesDistinct, isDeep, includeNewObjects, includeNewObjectsInParentEditingContext, filterUpdatedObjects, removeDeletedObjects);
        return matchingObjects;
    }

    public static NSArray filteredObjectsWithQualifier(EOEditingContext editingContext, NSArray objectsToFilter, String entityName, EOQualifier qualifier, NSArray sortOrderings, boolean usesDistinct, boolean isDeep, boolean includeNewObjects, boolean includeNewObjectsInParentEditingContext, boolean filterUpdatedObjects, boolean removeDeletedObjects) {
        NSMutableArray deletedObjects;
        NSMutableArray insertedObjects;
        boolean objectsMayGetAdded = includeNewObjects || includeNewObjectsInParentEditingContext || filterUpdatedObjects;
        NSMutableArray cloneMatchingObjects = null;
        NSMutableArray<String> entityNames = new NSMutableArray<String>();
        entityNames.addObject(entityName);
        if (isDeep) {
            EOModelGroup modelGroup = ERXEOAccessUtilities.modelGroup(editingContext);
            EOEntity rootEntity = modelGroup.entityNamed(entityName);
            for (EOEntity subEntity : rootEntity.subEntities()) {
                entityNames.addObject(subEntity.name());
            }
        }
        if (filterUpdatedObjects) {
            objectsToFilter = EOQualifier.filteredArrayWithQualifier((NSArray)objectsToFilter, (EOQualifier)qualifier);
            NSMutableArray updatedObjects = ERXEOControlUtilities.updatedObjects(editingContext, entityNames, qualifier);
            if (((NSArray)updatedObjects).count() > 0) {
                Enumeration updatedObjectsEnum = updatedObjects.objectEnumerator();
                while (updatedObjectsEnum.hasMoreElements()) {
                    Object obj = updatedObjectsEnum.nextElement();
                    if (objectsToFilter.containsObject(obj)) continue;
                    if (cloneMatchingObjects == null) {
                        cloneMatchingObjects = objectsToFilter.mutableClone();
                    }
                    cloneMatchingObjects.addObject(obj);
                }
                if (cloneMatchingObjects != null) {
                    objectsToFilter = cloneMatchingObjects;
                }
            }
        }
        if (includeNewObjects && (insertedObjects = ERXEOControlUtilities.insertedObjects(editingContext, entityNames, qualifier)).count() > 0) {
            if (cloneMatchingObjects != null) {
                cloneMatchingObjects.addObjectsFromArray(insertedObjects);
            } else {
                insertedObjects.addObjectsFromArray(objectsToFilter);
                objectsToFilter = insertedObjects;
            }
        }
        if (includeNewObjectsInParentEditingContext && !(editingContext.parentObjectStore() instanceof EOObjectStoreCoordinator)) {
            EOEditingContext theEC;
            NSMutableArray<EOEditingContext> parentEditingContexts = new NSMutableArray<EOEditingContext>();
            EOObjectStore objectStore = editingContext.parentObjectStore();
            NSArray objects = NSArray.EmptyArray;
            while (!(objectStore instanceof EOObjectStoreCoordinator)) {
                theEC = (EOEditingContext)objectStore;
                parentEditingContexts.addObject(theEC);
                objectStore = theEC.parentObjectStore();
            }
            int i = parentEditingContexts.count();
            while (i-- > 0) {
                theEC = (EOEditingContext)parentEditingContexts.objectAtIndex(i);
                NSMutableArray objectsMatchingQualifier = ERXEOControlUtilities.insertedObjects(theEC, entityNames, qualifier);
                if (((NSArray)objectsMatchingQualifier).count() <= 0) continue;
                objects = EOUtilities.localInstancesOfObjects((EOEditingContext)theEC, (NSArray)objects);
                if (((NSArray)objectsMatchingQualifier).count() <= 0) continue;
                objects = objects.arrayByAddingObjectsFromArray(objectsMatchingQualifier);
            }
            if (objects.count() > 0) {
                objects = EOUtilities.localInstancesOfObjects((EOEditingContext)editingContext, (NSArray)objects);
                if (cloneMatchingObjects != null) {
                    cloneMatchingObjects.addObjectsFromArray(objects);
                } else {
                    NSMutableArray newMatchingObjects = objectsToFilter.mutableClone();
                    newMatchingObjects.addObjectsFromArray(objects);
                    objectsToFilter = newMatchingObjects;
                }
            }
        }
        if (removeDeletedObjects && ((NSArray)(deletedObjects = ERXEOControlUtilities.deletedObjects(editingContext, entityNames, qualifier))).count() > 0) {
            if (cloneMatchingObjects == null) {
                cloneMatchingObjects = objectsToFilter.mutableClone();
                objectsToFilter = cloneMatchingObjects;
            }
            cloneMatchingObjects.removeObjectsInArray(deletedObjects);
        }
        if (objectsMayGetAdded && usesDistinct) {
            objectsToFilter = ERXArrayUtilities.arrayWithoutDuplicates(objectsToFilter);
        }
        if (objectsMayGetAdded && sortOrderings != null && sortOrderings.count() > 0) {
            if (cloneMatchingObjects != null) {
                ERXS.sort(cloneMatchingObjects, sortOrderings);
            } else {
                objectsToFilter = ERXS.sorted(objectsToFilter, sortOrderings);
            }
        }
        return objectsToFilter;
    }

    public static EOEnterpriseObject objectWithQualifier(EOEditingContext editingContext, String entityName, EOQualifier qualifier) {
        EOFetchSpecification fetchSpec = new EOFetchSpecification(entityName, qualifier, null);
        NSArray results = editingContext.objectsWithFetchSpecification(fetchSpec);
        if (results.count() > 1) {
            throw new EOUtilities.MoreThanOneException("objectMatchingValueForKeyEntityNamed: Matched more than one object with " + qualifier);
        }
        return results.count() == 0 ? null : (EOEnterpriseObject)results.objectAtIndex(0);
    }

    public static EOEnterpriseObject requiredObjectWithQualifier(EOEditingContext editingContext, String entityName, EOQualifier qualifier) {
        EOEnterpriseObject result = ERXEOControlUtilities.objectWithQualifier(editingContext, entityName, qualifier);
        if (result == null) {
            throw new EOObjectNotAvailableException("objectWithQualifier: No objects match qualifier " + qualifier);
        }
        return result;
    }

    public static NSMutableArray insertedObjects(EOEditingContext editingContext, NSArray<String> entityNames, EOQualifier qualifier) {
        NSMutableArray result = new NSMutableArray();
        NSDictionary insertedObjects = ERXArrayUtilities.arrayGroupedByKeyPath(editingContext.insertedObjects(), "entityName");
        for (String entityName : entityNames) {
            NSArray inMemory;
            NSArray insertedObjectsForEntity = insertedObjects.objectForKey(entityName);
            if (insertedObjectsForEntity == null || insertedObjectsForEntity.count() <= 0 || (inMemory = EOQualifier.filteredArrayWithQualifier(insertedObjectsForEntity, (EOQualifier)qualifier)).count() <= 0) continue;
            result.addObjectsFromArray(inMemory);
        }
        return result;
    }

    public static NSMutableArray updatedObjects(EOEditingContext editingContext, NSArray<String> entityNames, EOQualifier qualifier) {
        NSMutableArray result = new NSMutableArray();
        NSDictionary updatedObjects = ERXArrayUtilities.arrayGroupedByKeyPath(editingContext.updatedObjects(), "entityName");
        for (String entityName : entityNames) {
            NSArray inMemory;
            NSArray updatedObjectsForEntity = updatedObjects.objectForKey(entityName);
            if (updatedObjectsForEntity == null || updatedObjectsForEntity.count() <= 0 || (inMemory = EOQualifier.filteredArrayWithQualifier(updatedObjectsForEntity, (EOQualifier)qualifier)).count() <= 0) continue;
            result.addObjectsFromArray(inMemory);
        }
        return result;
    }

    public static NSMutableArray deletedObjects(EOEditingContext editingContext, NSArray<String> entityNames, EOQualifier qualifier) {
        NSMutableArray result = new NSMutableArray();
        NSDictionary deletedObjects = ERXArrayUtilities.arrayGroupedByKeyPath(editingContext.deletedObjects(), "entityName");
        for (String entityName : entityNames) {
            NSArray inMemory;
            NSArray deletedObjectsForEntity = deletedObjects.objectForKey(entityName);
            if (deletedObjectsForEntity == null || deletedObjectsForEntity.count() <= 0 || (inMemory = EOQualifier.filteredArrayWithQualifier(deletedObjectsForEntity, (EOQualifier)qualifier)).count() <= 0 || inMemory.count() <= 0) continue;
            result.addObjectsFromArray(inMemory);
        }
        return result;
    }

    public static EOQualifier localInstancesInQualifier(EOEditingContext ec, EOQualifier q) {
        if (q instanceof EOKeyValueQualifier) {
            EOEnterpriseObject eo;
            EOKeyValueQualifier q1 = (EOKeyValueQualifier)q;
            if (q1.value() instanceof EOEnterpriseObject && (eo = (EOEnterpriseObject)q1.value()).editingContext() != ec && !ERXEOControlUtilities.isNewObject(eo)) {
                eo = EOUtilities.localInstanceOfObject((EOEditingContext)ec, (EOEnterpriseObject)eo);
                EOKeyValueQualifier qual = new EOKeyValueQualifier(q1.key(), q1.selector(), (Object)eo);
                return qual;
            }
        } else {
            if (q instanceof EOAndQualifier || q instanceof EOOrQualifier) {
                NSArray oriQualifiers = (NSArray)NSKeyValueCoding.Utility.valueForKey((Object)q, (String)"qualifiers");
                NSMutableArray<EOQualifier> qualifiers = new NSMutableArray<EOQualifier>();
                int i = oriQualifiers.count();
                while (i-- > 0) {
                    EOQualifier qual = (EOQualifier)oriQualifiers.objectAtIndex(i);
                    qualifiers.addObject(ERXEOControlUtilities.localInstancesInQualifier(ec, qual));
                }
                return new EOAndQualifier(qualifiers);
            }
            if (q instanceof EONotQualifier) {
                EONotQualifier qNot = (EONotQualifier)q;
                EOQualifier qual = ERXEOControlUtilities.localInstancesInQualifier(ec, qNot.qualifier());
                return new EONotQualifier(qual);
            }
        }
        return q;
    }

    public static NSArray globalIDsForObjects(NSArray eos) {
        int c = eos != null ? eos.count() : 0;
        NSMutableArray<int> ids = new NSMutableArray<int>(c);
        for (int i = 0; i < c; ++i) {
            EOEnterpriseObject eo = (EOEnterpriseObject)eos.objectAtIndex(i);
            EOEditingContext ec = eo.editingContext();
            EOGlobalID gid = ec.globalIDForObject(eo);
            ids.addObject((int)gid);
        }
        return ids;
    }

    public static NSArray objectsForGlobalIDs(EOEditingContext ec, NSArray globalIDs) {
        NSArray result = null;
        if (globalIDs != null && globalIDs.count() > 0) {
            NSMutableArray<EOEnterpriseObject> a = new NSMutableArray<EOEnterpriseObject>();
            Enumeration e = globalIDs.objectEnumerator();
            while (e.hasMoreElements()) {
                EOGlobalID theGID = (EOGlobalID)e.nextElement();
                EOEnterpriseObject theObject = ec.faultForGlobalID(theGID, ec);
                if (theObject == null) continue;
                a.addObject(theObject);
            }
            result = a.immutableClone();
        }
        return result != null ? result : NSArray.EmptyArray;
    }

    public static NSArray faultsForGlobalIDs(EOEditingContext ec, NSArray gids) {
        int c = gids.count();
        NSMutableArray<int> a = new NSMutableArray<int>(c);
        for (int i = 0; i < c; ++i) {
            EOGlobalID gid = (EOGlobalID)gids.objectAtIndex(i);
            EOEnterpriseObject eo = ec.faultForGlobalID(gid, ec);
            a.addObject((int)eo);
        }
        return a;
    }

    public static NSArray faultsForRawRowsFromEntity(EOEditingContext ec, NSArray primKeys, String entityName) {
        int c = primKeys.count();
        NSMutableArray<int> a = new NSMutableArray<int>(c);
        for (int i = 0; i < c; ++i) {
            NSDictionary pkDict = (NSDictionary)primKeys.objectAtIndex(i);
            EOEnterpriseObject eo = ec.faultForRawRow(pkDict, entityName);
            a.addObject((int)eo);
        }
        return a;
    }

    public static boolean isNewObject(EOEnterpriseObject eo) {
        if (eo.editingContext() == null) {
            return true;
        }
        EOGlobalID gid = eo.editingContext().globalIDForObject(eo);
        return gid.isTemporary();
    }

    public static EOQualifier qualifierMatchingAnyKey(NSArray keys, NSSelector selector, Object value) {
        NSMutableArray<EOKeyValueQualifier> qualifiers = new NSMutableArray<EOKeyValueQualifier>();
        EOOrQualifier result = null;
        if (keys.count() > 0) {
            Enumeration i = keys.objectEnumerator();
            while (i.hasMoreElements()) {
                String key = (String)i.nextElement();
                qualifiers.addObject(new EOKeyValueQualifier(key, selector, value));
            }
            result = new EOOrQualifier(qualifiers);
        }
        return result;
    }

    public static NSArray objectsForFaultWithSortOrderings(EOEditingContext ec, NSArray possibleFaults, NSArray sortOrderings) {
        if (sortOrderings != null) {
            return EOSortOrdering.sortedArrayUsingKeyOrderArray((NSArray)ERXEOControlUtilities.objectsForFaults(ec, possibleFaults), (NSArray)sortOrderings);
        }
        return ERXEOControlUtilities.objectsForFaults(ec, possibleFaults);
    }

    public static NSArray objectsForFaults(EOEditingContext ec, NSArray possibleFaults) {
        NSMutableArray<EOEnterpriseObject> result = new NSMutableArray<EOEnterpriseObject>();
        NSMutableArray<EOGlobalID> faultGIDs = new NSMutableArray<EOGlobalID>();
        Enumeration objects = possibleFaults.objectEnumerator();
        while (objects.hasMoreElements()) {
            EOEnterpriseObject eo = (EOEnterpriseObject)objects.nextElement();
            if (EOFaultHandler.isFault((Object)eo)) {
                EOGlobalID gid = ec.globalIDForObject(eo);
                faultGIDs.addObject(gid);
                continue;
            }
            result.addObject(eo);
        }
        NSMutableArray loadedObjects = ERXEOGlobalIDUtilities.fetchObjectsWithGlobalIDs(ec, faultGIDs);
        result.addObjectsFromArray(loadedObjects);
        return result;
    }

    public static String rootEntityName(EOEnterpriseObject eo) {
        EOEntity entity = ERXEOControlUtilities.rootEntity(eo);
        return entity.name();
    }

    public static EOEntity rootEntity(EOEnterpriseObject eo) {
        EOEntity entity = ERXEOAccessUtilities.entityForEo(eo);
        while (entity.parentEntity() != null) {
            entity = entity.parentEntity();
        }
        return entity;
    }

    public static synchronized NSArray stringAttributeListForEntityNamed(EOEditingContext ec, String entityName) {
        NSMutableArray<String> result = (NSMutableArray<String>)_attributeKeysPerEntityName.objectForKey(entityName);
        if (result == null) {
            EOEntity entity = ERXEOAccessUtilities.entityNamed(ec, entityName);
            NSMutableArray<String> attList = new NSMutableArray<String>();
            _attributeKeysPerEntityName.setObjectForKey(attList, entityName);
            result = attList;
            Enumeration e = entity.classProperties().objectEnumerator();
            while (e.hasMoreElements()) {
                EOAttribute a;
                Object property = e.nextElement();
                if (!(property instanceof EOAttribute) || !(a = (EOAttribute)property).className().equals("java.lang.String")) continue;
                attList.addObject(a.name());
            }
        }
        return result;
    }

    public static void trimSpaces(EOEnterpriseObject object) {
        Enumeration e = ERXEOControlUtilities.stringAttributeListForEntityNamed(object.editingContext(), object.entityName()).objectEnumerator();
        while (e.hasMoreElements()) {
            String trimmedValue;
            String key = (String)e.nextElement();
            String value = (String)object.storedValueForKey(key);
            if (value == null || (trimmedValue = value.trim()).length() == value.length()) continue;
            object.takeStoredValueForKey((Object)trimmedValue, key);
        }
    }

    public static String destinationEntityNameForKeyPath(EOEnterpriseObject eo, String keyPath) {
        EOEntity entity = ERXEOAccessUtilities.entityForEo(eo);
        EOEntity destination = ERXEOAccessUtilities.destinationEntityForKeyPath(entity, keyPath);
        if (destination != null) {
            return destination.name();
        }
        return null;
    }

    public static EOQualifier orQualifierForKeyPaths(NSArray keyPaths, NSSelector selector, Object value) {
        NSMutableArray<int> qualifiers = new NSMutableArray<int>(keyPaths.count());
        Enumeration e = keyPaths.objectEnumerator();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            EOKeyValueQualifier qualifier = new EOKeyValueQualifier(key, selector, value);
            qualifiers.addObject((int)qualifier);
        }
        return new EOOrQualifier(qualifiers);
    }

    public static EOQualifier orQualifierForKeyPaths(NSArray keyPaths, NSSelector selector, NSArray values) {
        NSMutableArray<int> qualifiers = new NSMutableArray<int>(values.count());
        Enumeration e = values.objectEnumerator();
        while (e.hasMoreElements()) {
            Object value = e.nextElement();
            EOQualifier qualifier = ERXEOControlUtilities.orQualifierForKeyPaths(keyPaths, selector, value);
            qualifiers.addObject((int)qualifier);
        }
        return new EOOrQualifier(qualifiers);
    }

    public static EOQualifier andQualifier(EOQualifier q1, EOQualifier q2) {
        if (q1 == null) {
            return q2;
        }
        if (q2 == null) {
            return q1;
        }
        return new EOAndQualifier(new NSArray<Object>(new Object[]{q1, q2}));
    }

    public static EOQualifier orQualifier(EOQualifier q1, EOQualifier q2) {
        if (q1 == null) {
            return q2;
        }
        if (q2 == null) {
            return q1;
        }
        return new EOOrQualifier(new NSArray<Object>(new Object[]{q1, q2}));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void makeQualifierTrue(EOQualifier qualifier, Object obj) {
        if (qualifier instanceof EOAndQualifier) {
            Enumeration qualifiersEnum = ((EOAndQualifier)qualifier).qualifiers().objectEnumerator();
            while (qualifiersEnum.hasMoreElements()) {
                EOQualifier nestedQualifier = (EOQualifier)qualifiersEnum.nextElement();
                ERXEOControlUtilities.makeQualifierTrue(nestedQualifier, obj);
            }
            return;
        } else if (qualifier instanceof EOKeyValueQualifier) {
            EOKeyValueQualifier kvQualifier = (EOKeyValueQualifier)qualifier;
            String keypath = kvQualifier.key();
            Object value = kvQualifier.value();
            NSKeyValueCoding.Utility.takeValueForKey((Object)obj, (Object)value, (String)keypath);
            return;
        } else {
            if (!(qualifier instanceof EOKeyComparisonQualifier)) throw new IllegalArgumentException("Unable to make " + qualifier + " true for " + obj + " in a consistent way.");
            EOKeyComparisonQualifier comparisonQualifier = (EOKeyComparisonQualifier)qualifier;
            String leftKey = comparisonQualifier.leftKey();
            String rightKey = comparisonQualifier.rightKey();
            if ("true".equalsIgnoreCase(rightKey) || "yes".equalsIgnoreCase(rightKey)) {
                NSKeyValueCodingAdditions.Utility.takeValueForKeyPath((Object)obj, (Object)Boolean.TRUE, (String)leftKey);
                return;
            } else {
                if (!"false".equalsIgnoreCase(rightKey) && !"no".equalsIgnoreCase(rightKey)) throw new IllegalArgumentException("Unable to make " + qualifier + " true for " + obj + " in a consistent way.");
                NSKeyValueCodingAdditions.Utility.takeValueForKeyPath((Object)obj, (Object)Boolean.FALSE, (String)leftKey);
            }
        }
    }

    public static Object convertEOtoGID(Object obj) {
        Cloneable result;
        if (obj instanceof EOEnterpriseObject) {
            EOEnterpriseObject eoful = (EOEnterpriseObject)obj;
            EOGlobalID gidful = eoful.editingContext().globalIDForObject(eoful);
            result = gidful;
        } else if (obj instanceof IERXEOContainer) {
            result = ((IERXEOContainer)obj).toGIDContainer();
        } else if (obj instanceof NSArray) {
            NSArray eoful = (NSArray)obj;
            NSMutableArray<Object> gidful = new NSMutableArray<Object>();
            Enumeration objEnum = eoful.objectEnumerator();
            while (objEnum.hasMoreElements()) {
                gidful.addObject(ERXEOControlUtilities.convertEOtoGID(objEnum.nextElement()));
            }
            result = gidful;
        } else if (obj instanceof NSSet) {
            NSSet eoful = (NSSet)obj;
            NSMutableSet<Object> gidful = new NSMutableSet<Object>();
            Enumeration objEnum = eoful.objectEnumerator();
            while (objEnum.hasMoreElements()) {
                gidful.addObject(ERXEOControlUtilities.convertEOtoGID(objEnum.nextElement()));
            }
            result = gidful;
        } else if (obj instanceof NSDictionary) {
            NSDictionary eoful = (NSDictionary)obj;
            NSMutableDictionary<Object, Object> gidful = new NSMutableDictionary<Object, Object>();
            Enumeration keyEnum = eoful.keyEnumerator();
            while (keyEnum.hasMoreElements()) {
                Object eofulKey = keyEnum.nextElement();
                Object gidfulKey = ERXEOControlUtilities.convertEOtoGID(eofulKey);
                Object gidfulValue = ERXEOControlUtilities.convertEOtoGID(eoful.objectForKey(eofulKey));
                gidful.setObjectForKey(gidfulValue, gidfulKey);
            }
            result = gidful;
        } else {
            result = obj;
        }
        return result;
    }

    public static Object convertGIDtoEO(EOEditingContext editingContext, Object obj) {
        NSCoding result;
        if (obj instanceof EOGlobalID) {
            EOGlobalID gidful = (EOGlobalID)obj;
            EOEnterpriseObject eoful = ERXEOGlobalIDUtilities.fetchObjectWithGlobalID(editingContext, gidful);
            result = eoful;
        } else if (obj instanceof IERXGIDContainer) {
            result = ((IERXGIDContainer)obj).toEOContainer(editingContext);
        } else if (obj instanceof NSArray) {
            NSArray gidful = (NSArray)obj;
            boolean allGIDs = true;
            Enumeration objEnum = gidful.objectEnumerator();
            while (allGIDs && objEnum.hasMoreElements()) {
                allGIDs = objEnum.nextElement() instanceof EOGlobalID;
            }
            if (allGIDs) {
                result = ERXEOGlobalIDUtilities.fetchObjectsWithGlobalIDs(editingContext, gidful);
            } else {
                NSMutableArray<Object> eoful = new NSMutableArray<Object>();
                objEnum = gidful.objectEnumerator();
                while (objEnum.hasMoreElements()) {
                    eoful.addObject(ERXEOControlUtilities.convertGIDtoEO(editingContext, objEnum.nextElement()));
                }
                result = eoful;
            }
        } else if (obj instanceof NSSet) {
            NSSet gidful = (NSSet)obj;
            boolean allGIDs = true;
            Enumeration objEnum = gidful.objectEnumerator();
            while (allGIDs && objEnum.hasMoreElements()) {
                allGIDs = objEnum.nextElement() instanceof EOGlobalID;
            }
            if (allGIDs) {
                result = new NSSet<NSMutableArray>(ERXEOGlobalIDUtilities.fetchObjectsWithGlobalIDs(editingContext, gidful.allObjects()));
            } else {
                NSMutableSet<Object> eoful = new NSMutableSet<Object>();
                objEnum = gidful.objectEnumerator();
                while (objEnum.hasMoreElements()) {
                    eoful.addObject(ERXEOControlUtilities.convertGIDtoEO(editingContext, objEnum.nextElement()));
                }
                result = eoful;
            }
        } else if (obj instanceof NSDictionary) {
            NSDictionary gidful = (NSDictionary)obj;
            NSMutableDictionary<Object, Object> eoful = new NSMutableDictionary<Object, Object>();
            Enumeration keyEnum = gidful.keyEnumerator();
            while (keyEnum.hasMoreElements()) {
                Object gidfulKey = keyEnum.nextElement();
                Object eofulKey = ERXEOControlUtilities.convertGIDtoEO(editingContext, gidfulKey);
                Object eofulValue = ERXEOControlUtilities.convertGIDtoEO(editingContext, gidful.objectForKey(gidfulKey));
                eoful.setObjectForKey(eofulValue, eofulKey);
            }
            result = eoful;
        } else {
            result = obj;
        }
        return result;
    }

    public static void validateUniquenessOf(String entityName, EOEnterpriseObject eo, EOQualifier restrictingQualifier, String ... keys) {
        if (restrictingQualifier != null && !restrictingQualifier.evaluateWithObject((Object)eo)) {
            return;
        }
        if (entityName == null) {
            entityName = eo.entityName();
        }
        NSArray<String> keyPaths = new NSArray<String>(keys);
        NSDictionary<String, Object> dict = ERXDictionaryUtilities.dictionaryFromObjectWithKeys(eo, keyPaths);
        EOQualifier qualifier = EOKeyValueQualifier.qualifierToMatchAllValues(dict);
        if (restrictingQualifier != null) {
            qualifier = ERXEOControlUtilities.andQualifier(qualifier, restrictingQualifier);
        }
        NSArray objects = ERXEOControlUtilities.objectsWithQualifier(eo.editingContext(), entityName, qualifier, null, true, false, true, true);
        int count = (objects = ERXArrayUtilities.arrayMinusObject(objects, eo)).count();
        if (count != 0) {
            String keyPathsString = keyPaths.componentsJoinedByString(",");
            if (count == 1) {
                if (ERXEOControlUtilities.isNewObject(eo)) {
                    throw ERXValidationFactory.defaultFactory().createException(eo, keyPathsString, dict, "UniquenessViolationNewObject");
                }
                throw ERXValidationFactory.defaultFactory().createException(eo, keyPathsString, dict, "UniquenessViolationExistingObject");
            }
            throw ERXValidationFactory.defaultFactory().createException(eo, keyPathsString, dict, "UniquenessViolationDatabaseInconsistent");
        }
    }

    public static void validateUniquenessOf(EOEnterpriseObject eo, EOQualifier restrictingQualifier, String ... keys) {
        ERXEOControlUtilities.validateUniquenessOf(null, eo, restrictingQualifier, keys);
    }

    public static void validateUniquenessOf(EOEnterpriseObject eo, String ... keys) {
        ERXEOControlUtilities.validateUniquenessOf(null, eo, null, keys);
    }

    public static void validateUniquenessOf(String entityName, EOEnterpriseObject eo, String ... keys) {
        ERXEOControlUtilities.validateUniquenessOf(entityName, eo, null, keys);
    }

    public static <T> NSArray<T> distinctValuesForKeyPath(EOEditingContext editingContext, String entityName, String keyPath, EOQualifier qualifier, NSArray<EOSortOrdering> sortOrderings) {
        if (editingContext == null || entityName == null || keyPath == null) {
            throw new IllegalArgumentException("The editingContext, entityName and keyPath parameters must not be null");
        }
        EOFetchSpecification fs = new EOFetchSpecification(entityName, qualifier, sortOrderings);
        fs.setUsesDistinct(true);
        fs.setFetchesRawRows(true);
        fs.setRawRowKeyPaths(new NSArray<String>(keyPath));
        NSArray rawRows = editingContext.objectsWithFetchSpecification(fs);
        NSArray values = (NSArray)rawRows.valueForKey(keyPath);
        values = ERXArrayUtilities.arrayWithoutDuplicates(values);
        return values;
    }

    public static NSDictionary<String, Integer> registeredObjectCount(EOEditingContext ec) {
        NSMutableDictionary<String, Integer> counts = new NSMutableDictionary<String, Integer>();
        ERXEC erxec = (ERXEC)ec;
        NSArray gids = (NSArray)ERXKeyValueCodingUtilities.privateValueForKey((Object)erxec, "_globalIDsForRegisteredObjects");
        for (EOGlobalID gid : gids) {
            if (!(gid instanceof EOKeyGlobalID)) continue;
            EOKeyGlobalID kgid = (EOKeyGlobalID)gid;
            String entityName = kgid.entityName();
            Integer count = (Integer)counts.objectForKey(entityName);
            if (count == null) {
                count = new Integer(0);
                counts.setObjectForKey(count, entityName);
            }
            counts.setObjectForKey(count + 1, entityName);
        }
        return counts;
    }

    public static NSDictionary<String, Integer> changedRegisteredObjectCount(NSDictionary<String, Integer> currentCounts, NSDictionary<String, Integer> oldCounts) {
        NSMutableDictionary<String, Integer> counts = currentCounts.mutableClone();
        if (oldCounts != null) {
            for (String entityName : counts.allKeys()) {
                Integer count = oldCounts.objectForKey(entityName);
                if (count == null) continue;
                int changes = (Integer)counts.objectForKey(entityName) - count;
                if (changes == 0) {
                    counts.removeObjectForKey(entityName);
                    continue;
                }
                counts.setObjectForKey(changes, entityName);
            }
        }
        return counts;
    }

    private static void ensureSortOrdering(EOEditingContext ec, NSArray<? extends EOGlobalID> gids, NSMutableArray<? extends EOEnterpriseObject> objects) {
        block0: for (int i = 0; i < objects.size(); ++i) {
            EOEnterpriseObject object = (EOEnterpriseObject)objects.objectAtIndex(i);
            EOGlobalID gid = gids.objectAtIndex(i);
            if (gid.equals((Object)ec.globalIDForObject(object))) continue;
            for (int j = i + 1; j < objects.size(); ++j) {
                if (!gid.equals((Object)ec.globalIDForObject((EOEnterpriseObject)objects.objectAtIndex(j)))) continue;
                ERXArrayUtilities.swapObjectsAtIndexesInArray(objects, i, j);
                continue block0;
            }
        }
    }

    public static EOFetchSpecification schemaBasedFetchSpecification(EOEditingContext ec, EOFetchSpecification fetchSpecification) {
        EOQualifier q = fetchSpecification.qualifier();
        if (q != null) {
            fetchSpecification = (EOFetchSpecification)fetchSpecification.clone();
            q = ERXEOControlUtilities.schemaBasedQualifier(ec, fetchSpecification.entityName(), q);
            fetchSpecification.setQualifier(q);
        }
        return fetchSpecification;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EOQualifier schemaBasedQualifier(EOEditingContext ec, String entityName, EOQualifier qualifier) {
        EOQualifier eOQualifier;
        EOEntity entity = ERXEOAccessUtilities.entityMatchingString(ec, entityName);
        ec.rootObjectStore().lock();
        try {
            eOQualifier = entity.schemaBasedQualifier(qualifier);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            ec.rootObjectStore().unlock();
            throw throwable;
        }
        ec.rootObjectStore().unlock();
        return eOQualifier;
    }
}

