/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.eof;

import com.webobjects.eoaccess.EOAttribute;
import com.webobjects.eoaccess.EOEntity;
import com.webobjects.eoaccess.EOModel;
import com.webobjects.eoaccess.EOModelGroup;
import com.webobjects.eoaccess.EOUtilities;
import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOEnterpriseObject;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSComparator;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSPropertyListSerialization;
import com.webobjects.foundation.NSTimestampFormatter;
import er.extensions.crypting.ERXCrypto;
import er.extensions.eof.ERXEOAccessUtilities;
import er.extensions.eof.ERXEOControlUtilities;
import er.extensions.eof.ERXGeneratesPrimaryKeyInterface;
import er.extensions.foundation.ERXArrayUtilities;
import er.extensions.foundation.ERXProperties;
import er.extensions.foundation.ERXUtilities;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.Enumeration;
import org.apache.log4j.Logger;

public class ERXEOEncodingUtilities {
    public static final Logger log = Logger.getLogger(ERXEOEncodingUtilities.class);
    private static String EntityNameSeparator = "_";
    private static String AttributeValueSeparator = ".";
    public static final String EncodedEntityNameKey = "EncodedEntityName";
    protected static NSMutableDictionary _encodedEntityNames = null;
    private static boolean SpecifySeparatorInURL = true;
    private static boolean initialized;

    public static synchronized void init() {
        String entityNameSep = System.getProperty("er.extensions.ERXEOEncodingUtilities.EntityNameSeparator");
        if (entityNameSep != null && entityNameSep.length() > 0 && !entityNameSep.equals(AttributeValueSeparator)) {
            ERXEOEncodingUtilities.setEntityNameSeparator(entityNameSep);
        }
        ERXEOEncodingUtilities.setSpecifySeparatorInURL(ERXProperties.booleanForKeyWithDefault("er.extensions.ERXEOEncodingUtilities.SpecifySeparatorInURL", true));
        initialized = true;
    }

    public static void setSpecifySeparatorInURL(boolean specifySeparatorInURL) {
        SpecifySeparatorInURL = specifySeparatorInURL;
    }

    public static boolean isSpecifySeparatorInURL() {
        return SpecifySeparatorInURL;
    }

    public static void setEntityNameSeparator(String entityNameSeparator) {
        EntityNameSeparator = entityNameSeparator;
    }

    public static String entityNameSeparator() {
        if (!initialized) {
            ERXEOEncodingUtilities.init();
        }
        return EntityNameSeparator;
    }

    public static NSArray enterpriseObjectsFromFormValues(EOEditingContext ec, NSDictionary formValues) {
        return ERXEOEncodingUtilities.decodeEnterpriseObjectsFromFormValues(ec, formValues);
    }

    public static NSDictionary groupedEnterpriseObjectsFromFormValues(EOEditingContext ec, NSDictionary formValues) {
        NSArray formValueObjects = ERXEOEncodingUtilities.decodeEnterpriseObjectsFromFormValues(ec, formValues);
        return ERXArrayUtilities.arrayGroupedByKeyPath(formValueObjects, "entityName");
    }

    public static EOEnterpriseObject enterpriseObjectForEntityNamedFromFormValues(EOEditingContext ec, String entityName, NSDictionary formValues) {
        NSArray entityGroup = ERXEOEncodingUtilities.enterpriseObjectsForEntityNamedFromFormValues(ec, entityName, formValues);
        if (entityGroup.count() > 1) {
            log.warn((Object)("Multiple objects for entity name: " + entityName + " expecting one. objects: " + entityGroup));
        }
        return entityGroup.count() > 0 ? (EOEnterpriseObject)entityGroup.lastObject() : null;
    }

    public static NSArray enterpriseObjectsForEntityNamedFromFormValues(EOEditingContext ec, String entityName, NSDictionary formValues) {
        NSArray formValueObjects = ERXEOEncodingUtilities.decodeEnterpriseObjectsFromFormValues(ec, formValues);
        NSDictionary groups = ERXArrayUtilities.arrayGroupedByKeyPath(formValueObjects, "entityName");
        EOEntity entity = ERXEOAccessUtilities.entityNamed(ec, entityName);
        NSMutableArray entityGroup = new NSMutableArray();
        if (entity != null && entity.isAbstractEntity()) {
            Enumeration e = ERXUtilities.allSubEntitiesForEntity(entity, false).objectEnumerator();
            while (e.hasMoreElements()) {
                EOEntity subEntity = (EOEntity)e.nextElement();
                NSArray aGroup = groups.objectForKey(subEntity.name());
                if (aGroup == null) continue;
                entityGroup.addObjectsFromArray(aGroup);
            }
        } else {
            entityGroup.addObjectsFromArray(groups.objectForKey(entityName));
        }
        return entityGroup != null ? entityGroup : NSArray.EmptyArray;
    }

    public static String entityNameEncode(EOEnterpriseObject eo) {
        String encodedEntityName = eo.entityName();
        EOEntity entity = EOModelGroup.defaultGroup().entityNamed(eo.entityName());
        NSDictionary userInfo = entity.userInfo();
        if (userInfo != null && userInfo.objectForKey(EncodedEntityNameKey) != null) {
            encodedEntityName = (String)userInfo.objectForKey(EncodedEntityNameKey);
        }
        return encodedEntityName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static final NSDictionary encodedEntityNames() {
        if (_encodedEntityNames != null) return _encodedEntityNames;
        Class<ERXEOEncodingUtilities> clazz = ERXEOEncodingUtilities.class;
        synchronized (ERXEOEncodingUtilities.class) {
            if (_encodedEntityNames != null) return _encodedEntityNames;
            _encodedEntityNames = new NSMutableDictionary();
            NSArray models = EOModelGroup.defaultGroup().models();
            Enumeration en = models.objectEnumerator();
            while (en.hasMoreElements()) {
                NSArray entities = ((EOModel)en.nextElement()).entities();
                Enumeration entEn = entities.objectEnumerator();
                while (entEn.hasMoreElements()) {
                    String encodedEntityName;
                    EOEntity entity = (EOEntity)entEn.nextElement();
                    NSDictionary userInfo = entity.userInfo();
                    if (userInfo == null || (encodedEntityName = (String)userInfo.objectForKey(EncodedEntityNameKey)) == null) continue;
                    _encodedEntityNames.setObjectForKey(entity.name(), encodedEntityName);
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return _encodedEntityNames;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String entityNameDecode(String encodedName) {
        NSDictionary entityNames;
        String entityName = encodedName;
        NSDictionary nSDictionary = entityNames = ERXEOEncodingUtilities.encodedEntityNames();
        synchronized (nSDictionary) {
            entityName = (String)entityNames.objectForKey(encodedName);
        }
        return entityName;
    }

    public static NSDictionary dictionaryOfFormValuesForEnterpriseObjects(NSArray eos, String separator, boolean encrypt) {
        String base = ERXEOEncodingUtilities.encodeEnterpriseObjectsPrimaryKeyForUrl(eos, separator, encrypt);
        NSArray<String> elements = NSArray.componentsSeparatedByString(base, "&");
        return (NSDictionary)NSPropertyListSerialization.propertyListFromString((String)("{" + elements.componentsJoinedByString(";") + ";}"));
    }

    public static String encodeEnterpriseObjectPrimaryKeyForUrl(EOEnterpriseObject eo, String seperator, boolean encrypt) {
        return ERXEOEncodingUtilities.encodeEnterpriseObjectsPrimaryKeyForUrl(new NSArray<EOEnterpriseObject>(eo), seperator, encrypt);
    }

    public static String encodeEnterpriseObjectsPrimaryKeyForUrl(NSArray eos, String separator, boolean encrypt) {
        NSMutableArray<String> encoded = new NSMutableArray<String>();
        if (separator == null) {
            separator = ERXEOEncodingUtilities.entityNameSeparator();
        }
        if (ERXEOEncodingUtilities.isSpecifySeparatorInURL()) {
            encoded.addObject("sep=" + separator);
        }
        int c = 1;
        Enumeration e = eos.objectEnumerator();
        while (e.hasMoreElements()) {
            NSDictionary pkDict;
            EOEnterpriseObject eo = (EOEnterpriseObject)e.nextElement();
            NSArray pkValues = ERXEOControlUtilities.primaryKeyArrayForObject(eo);
            if (pkValues == null && eo instanceof ERXGeneratesPrimaryKeyInterface && (pkDict = ((ERXGeneratesPrimaryKeyInterface)eo).primaryKeyDictionary(false)) != null) {
                pkValues = pkDict.allValues();
            }
            if (pkValues == null) {
                throw new RuntimeException("Primary key is null for object: " + eo);
            }
            String pk = pkValues.componentsJoinedByString(AttributeValueSeparator);
            String encodedEntityName = ERXEOEncodingUtilities.entityNameEncode(eo);
            encoded.addObject(encodedEntityName + separator + (encrypt ? "E" : "") + c++ + "=" + (encrypt ? ERXCrypto.blowfishEncode(pk) : pk));
        }
        return encoded.componentsJoinedByString("&");
    }

    public static NSArray decodeEnterpriseObjectsFromFormValues(EOEditingContext ec, NSDictionary values) {
        if (ec == null) {
            throw new IllegalArgumentException("Attempting to decode enterprise objects with null editing context.");
        }
        if (values == null) {
            throw new IllegalArgumentException("Attempting to decode enterprise objects with null form values.");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("values = " + values));
        }
        NSMutableArray<EOEnterpriseObject> result = new NSMutableArray<EOEnterpriseObject>();
        String separator = values.objectForKey("sep") != null ? (String)values.objectForKey("sep") : ERXEOEncodingUtilities.entityNameSeparator();
        Enumeration e = values.keyEnumerator();
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            String key = (String)o;
            if (key.indexOf(separator) == -1) continue;
            boolean isEncrypted = key.indexOf(separator + "E") != -1;
            String encodedEntityName = key.substring(0, key.indexOf(separator));
            String entityName = ERXEOEncodingUtilities.entityNameDecode(encodedEntityName);
            EOEntity entity = ERXEOAccessUtilities.entityNamed(ec, entityName = entityName == null ? encodedEntityName : entityName);
            if (entity != null) {
                NSDictionary pk = ERXEOEncodingUtilities.processPrimaryKeyValue((String)values.objectForKey(key), entity, isEncrypted);
                result.addObject(EOUtilities.objectWithPrimaryKey((EOEditingContext)ec, (String)entity.name(), (NSDictionary)pk));
                continue;
            }
            log.warn((Object)("Unable to find entity for name: " + entityName));
        }
        return result;
    }

    private static NSDictionary processPrimaryKeyValue(String value, EOEntity entity, boolean isEncrypted) {
        NSArray pkAttributeNames = entity.primaryKeyAttributeNames();
        try {
            pkAttributeNames = pkAttributeNames.sortedArrayUsingComparator(NSComparator.AscendingStringComparator);
        }
        catch (NSComparator.ComparisonException ex) {
            log.error((Object)("Unable to sort attribute names: " + (Object)((Object)ex)));
            throw new NSForwardException((Throwable)ex);
        }
        NSArray<String> values = isEncrypted ? NSArray.componentsSeparatedByString(ERXCrypto.blowfishDecode(value).trim(), AttributeValueSeparator) : NSArray.componentsSeparatedByString(value, AttributeValueSeparator);
        int attrCount = pkAttributeNames.count();
        NSMutableDictionary<String, String> result = new NSMutableDictionary<String, String>(attrCount);
        for (int i = 0; i < attrCount; ++i) {
            String currentAttributeName = (String)pkAttributeNames.objectAtIndex(i);
            EOAttribute currentAttribute = entity.attributeNamed(currentAttributeName);
            Object currentValue = values.objectAtIndex(i);
            switch (currentAttribute.adaptorValueType()) {
                case 3: {
                    NSTimestampFormatter tsf = new NSTimestampFormatter();
                    try {
                        currentValue = tsf.parseObject((String)currentValue);
                    }
                    catch (ParseException ex) {
                        log.error((Object)("Error while trying to parse: " + currentValue));
                        throw new NSForwardException((Throwable)ex);
                    }
                }
                case 1: {
                    if (currentAttribute.valueFactoryMethodName() != null) {
                        currentValue = currentAttribute.newValueForString((String)currentValue);
                    }
                }
                case 0: {
                    currentValue = new BigDecimal((String)currentValue);
                }
            }
            result.setObjectForKey((String)currentValue, currentAttributeName);
        }
        return result;
    }
}

