/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.eof;

import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOEnterpriseObject;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSNotification;
import com.webobjects.foundation.NSNotificationCenter;
import com.webobjects.foundation.NSValidation;
import er.extensions.eof.ERXEOControlUtilities;
import er.extensions.foundation.ERXPatcher;
import er.extensions.foundation.ERXProperties;
import er.extensions.foundation.ERXSelectorUtilities;
import er.extensions.foundation.ERXSystem;
import java.util.Enumeration;
import org.apache.log4j.Logger;

public interface ERXEnterpriseObject
extends EOEnterpriseObject {
    public static final Logger logMod = Logger.getLogger((String)"er.transaction.delegate.EREditingContextDelegate.modifiedObjects");
    public static final boolean applyRestrictingQualifierOnInsert = ERXProperties.booleanForKey("er.extensions.ERXEnterpriseObject.applyRestrictingQualifierOnInsert");
    public static final Processor FlushCachesProcessor = new Processor(){

        protected void perform(EOEditingContext ec, ERXEnterpriseObject eo) {
            eo.flushCaches();
        }
    };
    public static final Processor WillInsertProcessor = new Processor(){

        protected void perform(EOEditingContext ec, ERXEnterpriseObject eo) {
            eo.willInsert();
        }
    };
    public static final Processor DidInsertProcessor = new Processor(){

        protected void perform(EOEditingContext ec, ERXEnterpriseObject eo) {
            eo.didInsert();
        }
    };
    public static final Processor WillUpdateProcessor = new Processor(){

        protected void perform(EOEditingContext ec, ERXEnterpriseObject eo) {
            eo.willUpdate();
        }
    };
    public static final Processor DidUpdateProcessor = new Processor(){

        protected void perform(EOEditingContext ec, ERXEnterpriseObject eo) {
            eo.didUpdate();
        }
    };
    public static final Processor WillDeleteProcessor = new Processor(){

        protected void perform(EOEditingContext ec, ERXEnterpriseObject eo) {
            eo.willDelete();
        }
    };
    public static final Processor DidDeleteProcessor = new Processor(){

        protected void perform(EOEditingContext ec, ERXEnterpriseObject eo) {
            eo.didDelete(ec);
        }
    };
    public static final Processor WillRevertProcessor = new Processor(){

        protected void perform(EOEditingContext ec, ERXEnterpriseObject eo) {
            eo.willRevert();
        }
    };
    public static final Processor DidRevertProcessor = new Processor(){

        protected void perform(EOEditingContext ec, ERXEnterpriseObject eo) {
            eo.didRevert(ec);
        }
    };
    public static final Logger tranLogDidInsert = Logger.getLogger((String)"er.transaction.eo.did.insert.ERXGenericRecord");
    public static final Logger tranLogDidDelete = Logger.getLogger((String)"er.transaction.eo.did.delete.ERXGenericRecord");
    public static final Logger tranLogDidUpdate = Logger.getLogger((String)"er.transaction.eo.did.update.ERXGenericRecord");
    public static final Logger tranLogDidRevert = Logger.getLogger((String)"er.transaction.eo.did.revert.ERXGenericRecord");
    public static final Logger tranLogMightDelete = Logger.getLogger((String)"er.transaction.eo.might.delete.ERXGenericRecord");
    public static final Logger tranLogWillInsert = Logger.getLogger((String)"er.transaction.eo.will.insert.ERXGenericRecord");
    public static final Logger tranLogWillDelete = Logger.getLogger((String)"er.transaction.eo.will.delete.ERXGenericRecord");
    public static final Logger tranLogWillUpdate = Logger.getLogger((String)"er.transaction.eo.will.update.ERXGenericRecord");
    public static final Logger tranLogWillRevert = Logger.getLogger((String)"er.transaction.eo.will.revert.ERXGenericRecord");
    public static final Logger validation = Logger.getLogger((String)"er.eo.validation.ERXGenericRecord");
    public static final Logger validationException = Logger.getLogger((String)"er.eo.validationException.ERXGenericRecord");
    public static final Logger insertionTrackingLog = Logger.getLogger((String)"er.extensions.ERXGenericRecord.insertion");
    public static final Logger log = Logger.getLogger((String)"er.eo.ERXGenericRecord");
    public static final String KEY_MARKER = "** KEY_MARKER **";

    public Logger getClassLog();

    public ERXEnterpriseObject self();

    public void mightDelete();

    public void willDelete() throws NSValidation.ValidationException;

    public void willInsert();

    public void willUpdate();

    public void flushCaches();

    public void didDelete(EOEditingContext var1);

    public void didUpdate();

    public void didInsert();

    public void willRevert();

    public void didRevert(EOEditingContext var1);

    public void addObjectsToBothSidesOfRelationshipWithKey(NSArray var1, String var2);

    public void removeObjectsFromBothSidesOfRelationshipWithKey(NSArray var1, String var2);

    public void removeObjectsFromPropertyWithKey(NSArray var1, String var2);

    public String primaryKey();

    public Object rawPrimaryKeyInTransaction();

    public String primaryKeyInTransaction();

    public Object rawPrimaryKey();

    public String encryptedPrimaryKey();

    public Object foreignKeyForRelationshipWithKey(String var1);

    public NSArray primaryKeyAttributeNames();

    public Object committedSnapshotValueForKey(String var1);

    public EOEnterpriseObject localInstanceOf(EOEnterpriseObject var1);

    public EOEnterpriseObject localInstanceIn(EOEditingContext var1);

    public NSArray localInstancesOf(NSArray var1);

    public NSDictionary changesFromCommittedSnapshot();

    public boolean parentObjectStoreIsObjectStoreCoordinator();

    public ERXEnterpriseObject refetchObjectFromDBinEditingContext(EOEditingContext var1);

    public String description();

    public String toLongString();

    public void trimSpaces();

    public boolean isDeletedEO();

    public boolean isNewObject();

    public void checkConsistency() throws NSValidation.ValidationException;

    public void batchCheckConsistency() throws NSValidation.ValidationException;

    public boolean _setUpdateInverseRelationships(boolean var1);

    public static abstract class Processor {
        protected abstract void perform(EOEditingContext var1, ERXEnterpriseObject var2);

        public void perform(EOEditingContext ec, NSArray eos) {
            if (eos != null && eos.count() > 0) {
                Enumeration enumerator = eos.objectEnumerator();
                while (enumerator.hasMoreElements()) {
                    EOEnterpriseObject eo = (EOEnterpriseObject)enumerator.nextElement();
                    if (!(eo instanceof ERXEnterpriseObject)) continue;
                    this.perform(ec, (ERXEnterpriseObject)eo);
                }
            }
        }

        public void perform(EOEditingContext ec, EOEnterpriseObject eo) {
            if (eo instanceof ERXEnterpriseObject) {
                this.perform(ec, (ERXEnterpriseObject)eo);
            }
        }
    }

    public static class Observer {
        private static Observer observer;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void editingContextWillSaveChanges(NSNotification n) {
            EOEditingContext ec = (EOEditingContext)n.object();
            boolean isNestedEditingContext = ec.parentObjectStore() instanceof EOEditingContext;
            ec.processRecentChanges();
            if (ec.hasChanges()) {
                NSNotificationCenter.defaultCenter().postNotification("ObjectsWillChangeInEditingContext", (Object)ec);
                if (isNestedEditingContext) {
                    EOEditingContext parentEC = (EOEditingContext)ec.parentObjectStore();
                    parentEC.lock();
                    try {
                        if (ec.deletedObjects().count() > 0) {
                            NSArray deletedObjectsToFlushInParent = ERXEOControlUtilities.localInstancesOfObjects(parentEC, ec.deletedObjects());
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("saveChanges: before save to child context " + ec + ", need to flush caches on deleted objects in parent context " + parentEC + ": " + deletedObjectsToFlushInParent));
                            }
                            FlushCachesProcessor.perform(parentEC, deletedObjectsToFlushInParent);
                        }
                        Object var7_6 = null;
                    }
                    catch (Throwable throwable) {
                        Object var7_7 = null;
                        parentEC.unlock();
                        throw throwable;
                    }
                    parentEC.unlock();
                    {
                    }
                }
                WillUpdateProcessor.perform(ec, ec.updatedObjects());
                WillDeleteProcessor.perform(ec, ec.deletedObjects());
                WillInsertProcessor.perform(ec, ec.insertedObjects());
                if (log.isDebugEnabled()) {
                    log.debug((Object)"EditingContextWillSaveChanges: done calling will*");
                }
                if (logMod.isDebugEnabled()) {
                    if (ec.updatedObjects() != null) {
                        logMod.debug((Object)("** Updated Objects " + ec.updatedObjects().count() + " - " + ec.updatedObjects()));
                    }
                    if (ec.insertedObjects() != null) {
                        logMod.debug((Object)("** Inserted Objects " + ec.insertedObjects().count() + " - " + ec.insertedObjects()));
                    }
                    if (ec.deletedObjects() != null) {
                        logMod.debug((Object)("** Deleted Objects " + ec.deletedObjects().count() + " - " + ec.deletedObjects()));
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void editingContextDidSaveChanges(NSNotification n) {
            EOEditingContext ec = (EOEditingContext)n.object();
            boolean isNestedEditingContext = ec.parentObjectStore() instanceof EOEditingContext;
            NSArray insertedObjects = (NSArray)n.userInfo().objectForKey("inserted");
            NSArray updatedObjects = (NSArray)n.userInfo().objectForKey("updated");
            NSArray deletedObjects = (NSArray)n.userInfo().objectForKey("deleted");
            DidUpdateProcessor.perform(ec, updatedObjects);
            DidDeleteProcessor.perform(ec, deletedObjects);
            DidInsertProcessor.perform(ec, insertedObjects);
            if (isNestedEditingContext) {
                EOEditingContext parentEC = (EOEditingContext)ec.parentObjectStore();
                if (insertedObjects.count() > 0 || updatedObjects.count() > 0) {
                    NSMutableArray flushableObjects = new NSMutableArray();
                    flushableObjects.addObjectsFromArray(insertedObjects);
                    flushableObjects.addObjectsFromArray(updatedObjects);
                    parentEC.lock();
                    try {
                        NSArray flushableObjectsInParent = ERXEOControlUtilities.localInstancesOfObjects(parentEC, flushableObjects);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("saveChanges: before save to child context " + ec + ", need to flush caches on objects in parent context " + parentEC + ": " + flushableObjectsInParent));
                        }
                        FlushCachesProcessor.perform(parentEC, flushableObjectsInParent);
                        Object var11_10 = null;
                    }
                    catch (Throwable throwable) {
                        Object var11_11 = null;
                        parentEC.unlock();
                        throw throwable;
                    }
                    parentEC.unlock();
                    {
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static void install() {
            if (observer != null) return;
            Class<Observer> clazz = Observer.class;
            synchronized (Observer.class) {
                if (observer != null) return;
                String name = ERXSystem.getProperty("er.extensions.ERXEnterpriseObject.Observer.className", Observer.class.getName());
                Class c = ERXPatcher.classForName(name);
                try {
                    observer = (Observer)c.newInstance();
                    NSNotificationCenter.defaultCenter().addObserver((Object)observer, ERXSelectorUtilities.notificationSelector("editingContextWillSaveChanges"), "EOEditingContextWillSaveChanges", null);
                    NSNotificationCenter.defaultCenter().addObserver((Object)observer, ERXSelectorUtilities.notificationSelector("editingContextDidSaveChanges"), "EOEditingContextDidSaveChangesNotification", null);
                }
                catch (InstantiationException e) {
                    throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
                }
                catch (IllegalAccessException e) {
                    throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
                }
                return;
            }
        }
    }
}

