/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.eof;

import com.webobjects.eoaccess.EOAttribute;
import com.webobjects.eoaccess.EOEntity;
import com.webobjects.eoaccess.EOUtilities;
import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOFetchSpecification;
import com.webobjects.eocontrol.EOQualifier;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSRange;
import er.extensions.eof.ERXEC;
import er.extensions.eof.ERXEOAccessUtilities;
import er.extensions.eof.ERXEOControlUtilities;
import er.extensions.eof.qualifiers.ERXInQualifier;
import er.extensions.foundation.ERXArrayUtilities;
import er.extensions.jdbc.ERXSQLHelper;
import java.util.Enumeration;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class ERXFetchSpecificationBatchIterator
implements Iterator,
Enumeration {
    public static final int DefaultBatchSize = 250;
    public static final Logger log = Logger.getLogger(ERXFetchSpecificationBatchIterator.class);
    protected int batchSize;
    protected EOEditingContext editingContext;
    protected EOFetchSpecification fetchSpecification;
    protected String primaryKeyAttributeName;
    protected NSArray primaryKeys;
    protected NSMutableArray cachedBatch;
    protected int currentObjectFetchCount;
    protected boolean shouldFilterBatches;

    public ERXFetchSpecificationBatchIterator(EOFetchSpecification fetchSpecification) {
        this(fetchSpecification, null);
    }

    public ERXFetchSpecificationBatchIterator(EOFetchSpecification fetchSpecification, EOEditingContext ec) {
        this(fetchSpecification, ec, 250);
    }

    public ERXFetchSpecificationBatchIterator(EOFetchSpecification fetchSpecification, EOEditingContext ec, int batchSize) {
        this(fetchSpecification, null, ec, batchSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ERXFetchSpecificationBatchIterator(EOFetchSpecification fetchSpecification, NSArray pkeys, EOEditingContext ec, int batchSize) {
        EOEntity entity = ERXEOAccessUtilities.entityNamed(ec, fetchSpecification.entityName());
        NSArray primaryKeyAttributes = entity.primaryKeyAttributes();
        if (primaryKeyAttributes.count() > 1) {
            throw new RuntimeException("ERXFetchSpecificationBatchIterator: Currently only single primary key entities are supported.");
        }
        this.primaryKeyAttributeName = ((EOAttribute)primaryKeyAttributes.lastObject()).name();
        this.fetchSpecification = (EOFetchSpecification)fetchSpecification.clone();
        this.primaryKeys = pkeys;
        this.setEditingContext(ec != null ? ec : ERXEC.newEditingContext());
        this.setBatchSize(batchSize);
        this.setFiltersBatches(false);
        EOQualifier qualifier = this.fetchSpecification.qualifier();
        if (qualifier != null) {
            this.editingContext().rootObjectStore().lock();
            try {
                this.fetchSpecification.setQualifier(entity.schemaBasedQualifier(qualifier));
                Object var9_8 = null;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                this.editingContext().rootObjectStore().unlock();
                throw throwable;
            }
            this.editingContext().rootObjectStore().unlock();
            {
            }
        }
    }

    public int batchSize() {
        return this.batchSize;
    }

    public int currentBatchIndex() {
        return (int)Math.ceil((double)this.currentObjectFetchCount() * 1.0 / ((double)this.batchSize() * 1.0));
    }

    public int batchCount() {
        return (int)Math.ceil((double)this.count() * 1.0 / ((double)this.batchSize() * 1.0));
    }

    public int count() {
        return this.primaryKeys().count();
    }

    public int currentObjectFetchCount() {
        return this.currentObjectFetchCount;
    }

    public void setBatchSize(int batchSize) {
        if (batchSize <= 0) {
            throw new RuntimeException("Attempting to set a batch size of negative value.");
        }
        if (batchSize > 250) {
            log.warn((Object)"Batches larger than the the default batch size of 250 might cause JDBC issues.");
        }
        this.batchSize = batchSize;
    }

    public boolean filtersBatches() {
        return this.shouldFilterBatches;
    }

    public void setFiltersBatches(boolean newValue) {
        if (!newValue && this.shouldFilterBatches && this.cachedBatch != null) {
            log.warn((Object)"Setting filtersBatches from true to false while there is a cached batch--some objects may already have been discarded!");
        }
        this.shouldFilterBatches = newValue;
    }

    public EOEditingContext editingContext() {
        return this.editingContext;
    }

    public void setEditingContext(EOEditingContext ec) {
        this.editingContext = ec;
    }

    public boolean hasNextBatch() {
        return this.cachedBatch != null || this._hasMoreToFetch();
    }

    protected boolean _hasMoreToFetch() {
        return this.currentObjectFetchCount() < this.count();
    }

    public NSArray nextBatch() {
        if (this.cachedBatch != null) {
            NSMutableArray nextBatch = this.cachedBatch;
            this.cachedBatch = null;
            return nextBatch;
        }
        return this._fetchNextBatch();
    }

    protected NSArray _fetchNextBatch() {
        if (this.hasNextBatch()) {
            NSRange range = this._rangeForOffset(this.currentObjectFetchCount);
            NSArray nextBatch = this.batchWithRange(range);
            this.currentObjectFetchCount += range.length();
            return nextBatch;
        }
        throw new IllegalStateException("Iterator is exhausted");
    }

    private NSRange _rangeForBatchIndex(int index) {
        int start = this.batchSize * index;
        return this._rangeForOffset(start);
    }

    private NSRange _rangeForOffset(int start) {
        int length;
        int batchSize = this.batchSize();
        int totalCountMinusStart = this.count() - start;
        int n = length = totalCountMinusStart > batchSize ? batchSize : totalCountMinusStart;
        if (length < 0) {
            length = 0;
        }
        return new NSRange(start, length);
    }

    public NSArray batchWithIndex(int index) {
        NSRange range = this._rangeForBatchIndex(index);
        return this.batchWithRange(range);
    }

    public NSArray batchWithRange(NSRange requestedRange) {
        EOEditingContext ec = this.editingContext();
        if (ec == null) {
            throw new IllegalStateException("ERXFetchSpecificationBatchIterator: Calling nextBatch with a null editing context!");
        }
        NSArray nextBatch = null;
        NSRange range = requestedRange.rangeByIntersectingRange(new NSRange(0, this.count()));
        if (range.length() > 0) {
            EOQualifier originalQualifier;
            NSArray primaryKeys = this.primaryKeys();
            NSArray primaryKeysToFetch = primaryKeys.subarrayWithRange(range);
            log.debug((Object)("Of primaryKey count: " + primaryKeys.count() + " fetching range: " + range + " which is: " + primaryKeysToFetch.count()));
            ERXInQualifier qual = new ERXInQualifier(this.primaryKeyAttributeName, primaryKeysToFetch);
            EOFetchSpecification batchFS = new EOFetchSpecification(this.fetchSpecification.entityName(), (EOQualifier)qual, this.fetchSpecification.sortOrderings());
            if (this.fetchSpecification.prefetchingRelationshipKeyPaths() != null) {
                batchFS.setPrefetchingRelationshipKeyPaths(this.fetchSpecification.prefetchingRelationshipKeyPaths());
            }
            batchFS.setRawRowKeyPaths(this.fetchSpecification.rawRowKeyPaths());
            nextBatch = ec.objectsWithFetchSpecification(batchFS);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Actually fetched: " + nextBatch.count() + " with fetch specification: " + batchFS));
                if (primaryKeysToFetch.count() > nextBatch.count()) {
                    NSArray missedKeys = ERXArrayUtilities.arrayMinusArray(primaryKeysToFetch, (NSArray)nextBatch.valueForKey(this.primaryKeyAttributeName));
                    log.debug((Object)("Primary Keys that were not found for this batch: " + missedKeys));
                }
            }
            if (this.shouldFilterBatches && (originalQualifier = this.fetchSpecification.qualifier()) != null) {
                nextBatch = EOQualifier.filteredArrayWithQualifier((NSArray)nextBatch, (EOQualifier)originalQualifier);
                log.debug((Object)("Filtered batch to: " + nextBatch.count()));
            }
        }
        return nextBatch != null ? nextBatch : NSArray.EmptyArray;
    }

    protected EOFetchSpecification batchFetchSpecificationForQualifier(EOQualifier qualifier) {
        EOFetchSpecification fetchSpec = (EOFetchSpecification)this.fetchSpecification.clone();
        fetchSpec.setQualifier(qualifier);
        fetchSpec.setRequiresAllQualifierBindingVariables(false);
        fetchSpec.setLocksObjects(false);
        fetchSpec.setPromptsAfterFetchLimit(false);
        return fetchSpec;
    }

    protected NSArray primaryKeys() {
        if (this.primaryKeys == null) {
            if (this.editingContext() == null) {
                throw new RuntimeException("Attempting to fetch the primary keys for a null editingContext");
            }
            EOEntity entity = EOUtilities.entityNamed((EOEditingContext)this.editingContext(), (String)this.fetchSpecification.entityName());
            if (entity.primaryKeyAttributes().count() > 1) {
                throw new RuntimeException("ERXFetchSpecificationBatchIterator: Currently only single primary key entities are supported.");
            }
            EOFetchSpecification pkFetchSpec = ERXEOControlUtilities.primaryKeyFetchSpecificationForEntity(this.editingContext(), this.fetchSpecification.entityName(), this.fetchSpecification.qualifier(), this.fetchSpecification.sortOrderings(), null);
            pkFetchSpec.setFetchLimit(this.fetchSpecification.fetchLimit());
            pkFetchSpec.setUsesDistinct(this.fetchSpecification.usesDistinct());
            boolean performDistinctInMemory = ERXSQLHelper.newSQLHelper(entity).shouldPerformDistinctInMemory(pkFetchSpec);
            if (performDistinctInMemory) {
                pkFetchSpec.setUsesDistinct(false);
            }
            log.debug((Object)"Fetching primary keys.");
            NSArray primaryKeyDictionaries = this.editingContext().objectsWithFetchSpecification(pkFetchSpec);
            String pkAttributeName = ((EOAttribute)entity.primaryKeyAttributes().lastObject()).name();
            this.primaryKeys = (NSArray)primaryKeyDictionaries.valueForKey(pkAttributeName);
            if (performDistinctInMemory) {
                this.primaryKeys = ERXArrayUtilities.arrayWithoutDuplicates(this.primaryKeys);
            }
        }
        return this.primaryKeys;
    }

    public void reset() {
        this.primaryKeys = null;
        this.cachedBatch = null;
    }

    public boolean hasNext() {
        return this.hasNextBatch();
    }

    public Object next() {
        if (this.cachedBatch == null) {
            NSArray nextBatch = this._fetchNextBatch();
            while (nextBatch.count() == 0 && this.hasNextBatch()) {
                nextBatch = this._fetchNextBatch();
            }
            this.cachedBatch = nextBatch.mutableClone();
        }
        Object nextObject = null;
        if (this.cachedBatch.count() > 0) {
            nextObject = this.cachedBatch.removeObjectAtIndex(0);
        }
        if (this.cachedBatch.count() == 0) {
            this.cachedBatch = null;
        }
        return nextObject;
    }

    public void remove() {
        throw new UnsupportedOperationException("Can't remove, not implemented");
    }

    public boolean hasMoreElements() {
        return this.hasNext();
    }

    public Object nextElement() {
        return this.next();
    }
}

