/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.eof;

import com.webobjects.eocontrol.EOCooperatingObjectStore;
import com.webobjects.eocontrol.EOObjectStoreCoordinator;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import er.extensions.eof.ERXEC;
import er.extensions.eof.ERXEOAccessUtilities;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.log4j.Logger;
import sun.misc.Signal;
import sun.misc.SignalHandler;

public class ERXObjectStoreCoordinator
extends EOObjectStoreCoordinator {
    public static Logger log = Logger.getLogger(ERXObjectStoreCoordinator.class);
    NSMutableDictionary<Thread, NSMutableArray<Exception>> openLockTraces;
    Thread lockingThread;
    String lockingThreadName;
    protected static Map<ERXObjectStoreCoordinator, String> activeDatabaseContexts = Collections.synchronizedMap(new WeakHashMap());
    private long lockCount = 0L;
    public boolean _didClose = false;
    public boolean _shouldClose = false;
    private static Exception defaultTrace = new Exception("DefaultTrace");
    protected String _name = "unnamed";

    public ERXObjectStoreCoordinator() {
        if (ERXEC.markOpenLocks()) {
            activeDatabaseContexts.put(this, Thread.currentThread().getName());
        }
    }

    public ERXObjectStoreCoordinator(boolean shouldClose) {
        this._shouldClose = shouldClose;
    }

    private synchronized void traceLock() {
        Thread currentThread;
        NSMutableArray<Exception> currentTraces;
        if (this.openLockTraces == null) {
            this.openLockTraces = new NSMutableDictionary();
        }
        Exception openLockTrace = defaultTrace;
        if (ERXEC.traceOpenLocks()) {
            openLockTrace = new Exception("Locked");
        }
        if ((currentTraces = (NSMutableArray<Exception>)this.openLockTraces.objectForKey(currentThread = Thread.currentThread())) == null) {
            currentTraces = new NSMutableArray<Exception>();
            this.openLockTraces.setObjectForKey(currentTraces, currentThread);
        }
        currentTraces.addObject(openLockTrace);
    }

    private synchronized void traceUnlock() {
        if (this.openLockTraces != null) {
            NSMutableArray traces = (NSMutableArray)this.openLockTraces.objectForKey(this.lockingThread);
            if (traces != null) {
                traces.removeLastObject();
                if (traces.count() == 0) {
                    this.openLockTraces.removeObjectForKey(this.lockingThread);
                }
            } else {
                log.error((Object)("Missing lock: " + this.lockingThread));
            }
            if (this.openLockTraces.count() == 0) {
                this.openLockTraces = null;
            }
        }
        if (this.lockCount == 0L) {
            this.lockingThread = null;
            this.lockingThreadName = null;
        }
    }

    public void lock() {
        boolean tracing = ERXEC.markOpenLocks();
        if (tracing) {
            this.traceLock();
        }
        super.lock();
        ++this.lockCount;
        this.lockingThread = Thread.currentThread();
        this.lockingThreadName = this.lockingThread.getName();
    }

    public void unlock() {
        boolean tracing = ERXEC.markOpenLocks();
        if (this.lockingThread != null && this.lockingThread != Thread.currentThread()) {
            log.fatal((Object)("Unlocking thread is not locking thread: LOCKING " + this.lockingThread + " vs UNLOCKING " + Thread.currentThread()), (Throwable)new RuntimeException("UnlockingTrace"));
            if (tracing) {
                NSMutableArray traces = (NSMutableArray)this.openLockTraces.objectForKey(this.lockingThread);
                if (traces != null) {
                    for (Exception trace : traces) {
                        log.fatal((Object)("Currenty locking threads: " + this.lockingThread), (Throwable)trace);
                    }
                } else {
                    log.fatal((Object)"Trace for locking thread is MISSING");
                }
            }
        }
        --this.lockCount;
        if (tracing) {
            this.traceUnlock();
        }
        super.unlock();
    }

    public void addCooperatingObjectStore(EOCooperatingObjectStore objectStore) {
        if (this.cooperatingObjectStores().indexOfIdenticalObject(objectStore) < 0) {
            if (objectStore.coordinator() != null) {
                throw new IllegalStateException("Cannot add " + objectStore + " to this EOObjectStoreCoordinator because it already has another.");
            }
            super.addCooperatingObjectStore(objectStore);
        }
    }

    public void dispose() {
        if (this._shouldClose) {
            this._didClose = ERXEOAccessUtilities.closeDatabaseConnections(this);
            if (!this._didClose && this._shouldClose) {
                log.error((Object)"shouldClose was true but could not close all Connections!");
            }
        }
        super.dispose();
    }

    public static String outstandingLockDescription() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        boolean hadLocks = false;
        pw.print(activeDatabaseContexts.size() + " active ObjectStoreCoordinators : " + activeDatabaseContexts + ")");
        for (ERXObjectStoreCoordinator ec : activeDatabaseContexts.keySet()) {
            NSMutableDictionary<Thread, NSMutableArray<Exception>> traces = ec.openLockTraces;
            if (traces == null || traces.count() <= 0) continue;
            hadLocks = true;
            pw.println("\n------------------------");
            pw.println("ObjectStoreCoordinator: " + (Object)((Object)ec) + " Locking thread: " + ec.lockingThreadName + "->" + ec.lockingThread);
            for (Thread thread : traces.keySet()) {
                pw.println("Outstanding at @" + thread);
                for (Exception ex : (NSMutableArray)traces.objectForKey(thread)) {
                    if (ex == defaultTrace) {
                        pw.println("Stack tracing is disabled");
                        continue;
                    }
                    ex.printStackTrace(pw);
                }
            }
        }
        if (!hadLocks) {
            pw.print("No open ObjectStoreCoordinator (of " + activeDatabaseContexts.size() + ")");
        }
        pw.close();
        return sw.toString();
    }

    public static EOObjectStoreCoordinator create() {
        return new ERXObjectStoreCoordinator();
    }

    public static EOObjectStoreCoordinator create(boolean shouldClose) {
        return new ERXObjectStoreCoordinator(shouldClose);
    }

    public String name() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this);
        b.append("name", (Object)this.name());
        return b.toString();
    }

    public static class DumpLocksSignalHandler
    implements SignalHandler {
        public void handle(Signal signal) {
            log.info((Object)ERXObjectStoreCoordinator.outstandingLockDescription());
        }
    }
}

