/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.eof;

import com.webobjects.eoaccess.EODatabase;
import com.webobjects.eoaccess.EODatabaseContext;
import com.webobjects.eoaccess.EOEntity;
import com.webobjects.eoaccess.EOModelGroup;
import com.webobjects.eoaccess.EORelationship;
import com.webobjects.eocontrol.EOCooperatingObjectStore;
import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOGlobalID;
import com.webobjects.eocontrol.EOKeyGlobalID;
import com.webobjects.eocontrol.EOObjectStoreCoordinator;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSNotification;
import com.webobjects.foundation.NSNotificationCenter;
import com.webobjects.foundation.NSSelector;
import er.extensions.eof.ERXConstant;
import er.extensions.eof.ERXDatabase;
import er.extensions.eof.ERXDatabaseContext;
import er.extensions.eof.ERXEC;
import er.extensions.eof.ERXEOAccessUtilities;
import er.extensions.eof.ERXEOGlobalIDUtilities;
import er.extensions.remoteSynchronizer.ERXRemoteSynchronizer;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;

public class ERXObjectStoreCoordinatorSynchronizer {
    public static Logger log = Logger.getLogger(ERXObjectStoreCoordinatorSynchronizer.class);
    public static final String SYNCHRONIZER_KEY = "_synchronizer";
    private static ERXObjectStoreCoordinatorSynchronizer _synchronizer;
    private static ThreadLocal _processingRemoteNotifications;
    private static NSMutableDictionary _cacheChanges;
    private NSMutableArray _coordinators = new NSMutableArray();
    private ProcessChangesQueue _queue = new ProcessChangesQueue();
    protected Thread _queueThread;
    private ERXRemoteSynchronizer _remoteSynchronizer;
    private SynchronizerSettings _defaultSettings = new SynchronizerSettings(true, true, true, true);
    private NSMutableDictionary<EOObjectStoreCoordinator, SynchronizerSettings> _settings = new NSMutableDictionary();

    public static void initialize() {
        if (_synchronizer == null) {
            _synchronizer = new ERXObjectStoreCoordinatorSynchronizer();
        }
    }

    public static ERXObjectStoreCoordinatorSynchronizer synchronizer() {
        if (_synchronizer == null) {
            ERXObjectStoreCoordinatorSynchronizer.initialize();
        }
        return _synchronizer;
    }

    private ERXObjectStoreCoordinatorSynchronizer() {
        this._queueThread = new Thread(this._queue);
        this._queueThread.setName("ERXOSCProcessChanges");
        this._queueThread.setDaemon(true);
        this._queueThread.start();
        NSNotificationCenter.defaultCenter().addObserver((Object)this, new NSSelector("objectStoreWasAdded", ERXConstant.NotificationClassArray), "EOCooperatingObjectStoreWasAddedNotification", null);
        NSNotificationCenter.defaultCenter().addObserver((Object)this, new NSSelector("objectStoreWasRemoved", ERXConstant.NotificationClassArray), "EOCooperatingObjectStoreWasRemovedNotification", null);
        NSNotificationCenter.defaultCenter().addObserver((Object)this, new NSSelector("startRemoteSynchronizer", ERXConstant.NotificationClassArray), "ApplicationDidFinishLaunchingNotification", null);
        NSNotificationCenter.defaultCenter().addObserver((Object)this, new NSSelector("stopRemoteSynchronizer", ERXConstant.NotificationClassArray), "ApplicationWillTerminateNotification", null);
    }

    public void setDefaultSettings(SynchronizerSettings defaultSettings) {
        this._defaultSettings = defaultSettings;
    }

    public void setSettingsForCoordinator(SynchronizerSettings settings, EOObjectStoreCoordinator coordinator) {
        if (settings == null) {
            this._settings.removeObjectForKey(coordinator);
        } else {
            this._settings.setObjectForKey(settings, coordinator);
        }
    }

    public SynchronizerSettings settingsForCoordinator(EOObjectStoreCoordinator coordinator) {
        SynchronizerSettings settings = (SynchronizerSettings)this._settings.objectForKey(coordinator);
        if (settings == null) {
            settings = this._defaultSettings;
        }
        return settings;
    }

    public void initializeRemoteSynchronizer() {
        boolean remoteSynchronizerEnabled = ERXRemoteSynchronizer.remoteSynchronizerEnabled();
        if (remoteSynchronizerEnabled) {
            try {
                this._remoteSynchronizer = ERXRemoteSynchronizer.newRemoteSynchronizer(this._queue);
                this._remoteSynchronizer.join();
                this._remoteSynchronizer.listen();
            }
            catch (Throwable e) {
                throw new RuntimeException("Failed to configure remote synchronization.", e);
            }
        }
    }

    public void startRemoteSynchronizer(NSNotification n) {
        this.initializeRemoteSynchronizer();
    }

    public void stopRemoteSynchronizer(NSNotification n) {
        this._queue.stop();
    }

    public void objectStoreWasRemoved(NSNotification n) {
        this.removeObjectStore((EOObjectStoreCoordinator)n.object());
    }

    public void objectStoreWasAdded(NSNotification n) {
        this.addObjectStore((EOObjectStoreCoordinator)n.object());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addObjectStore(EOObjectStoreCoordinator osc) {
        NSMutableArray nSMutableArray = this._coordinators;
        synchronized (nSMutableArray) {
            if (!this._coordinators.containsObject(osc)) {
                this._coordinators.addObject(osc);
                NSSelector sel = new NSSelector("publishChange", new Class[]{NSNotification.class});
                NSNotificationCenter.defaultCenter().addObserver((Object)this, sel, "EOObjectsChangedInStoreNotification", (Object)osc);
                NSSelector snapshotCacheChanged = new NSSelector("snapshotCacheChanged", new Class[]{NSNotification.class});
                NSNotificationCenter.defaultCenter().addObserver((Object)this, snapshotCacheChanged, "SnapshotCacheChanged", null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeObjectStore(EOObjectStoreCoordinator osc) {
        NSMutableArray nSMutableArray = this._coordinators;
        synchronized (nSMutableArray) {
            if (this._coordinators.containsObject(osc)) {
                this._coordinators.removeObject(osc);
                NSNotificationCenter.defaultCenter().removeObserver((Object)this, "EOObjectsChangedInStoreNotification", (Object)osc);
            } else {
                log.error((Object)"Coordinator not found!");
            }
        }
    }

    protected static void setProcessingRemoteNotifications(boolean processingRemoteNotifications) {
        _processingRemoteNotifications.set(processingRemoteNotifications);
    }

    protected static boolean isProcessingRemoteNotifications() {
        Boolean processingRemoteNotifications = (Boolean)_processingRemoteNotifications.get();
        return processingRemoteNotifications != null && processingRemoteNotifications != false;
    }

    public void publishChange(NSNotification n) {
        boolean processingMulticastNotifications = ERXObjectStoreCoordinatorSynchronizer.isProcessingRemoteNotifications();
        if (this._coordinators.count() > 1 || this._remoteSynchronizer != null && !processingMulticastNotifications) {
            EOObjectStoreCoordinator osc = (EOObjectStoreCoordinator)n.object();
            NSDictionary userInfo = n.userInfo();
            if (userInfo == null || userInfo.valueForKey(SYNCHRONIZER_KEY) == null) {
                LocalChange changes = new LocalChange(osc, userInfo, processingMulticastNotifications);
                this._queue.addChange(changes);
            }
        }
    }

    public void snapshotCacheChanged(NSNotification n) {
        boolean processingMulticastNotifications = ERXObjectStoreCoordinatorSynchronizer.isProcessingRemoteNotifications();
        if (this._remoteSynchronizer != null && !processingMulticastNotifications) {
            ERXDatabase database = (ERXDatabase)((Object)n.object());
            ERXDatabase.CacheChange cacheChange = (ERXDatabase.CacheChange)n.userInfo().objectForKey("CacheChange");
            if (cacheChange != null) {
                ERXObjectStoreCoordinatorSynchronizer._enqueueCacheChange(database, cacheChange);
            }
        }
    }

    public static synchronized void _enqueueCacheChange(EODatabase database, ERXDatabase.CacheChange cacheChange) {
        NSMutableArray<ERXDatabase.CacheChange> cacheChanges = (NSMutableArray<ERXDatabase.CacheChange>)_cacheChanges.objectForKey(database);
        if (cacheChanges == null) {
            cacheChanges = new NSMutableArray<ERXDatabase.CacheChange>();
            _cacheChanges.setObjectForKey(cacheChanges, database);
        }
        cacheChanges.addObject(cacheChange);
    }

    public static synchronized NSArray dequeueCacheChanges(EODatabase database) {
        NSMutableArray cacheChanges = (NSMutableArray)_cacheChanges.removeObjectForKey(database);
        return cacheChanges;
    }

    private Enumeration coordinators() {
        return this._coordinators.objectEnumerator();
    }

    private NSArray _coordinators() {
        return this._coordinators.immutableClone();
    }

    static {
        _processingRemoteNotifications = new ThreadLocal();
        _cacheChanges = new NSMutableDictionary();
    }

    public static class SynchronizerSettings {
        private boolean _broadcastInserts;
        private boolean _broadcastUpdates;
        private boolean _broadcastDeletes;
        private boolean _broadcastRelationships;

        public SynchronizerSettings(boolean broadcastInserts, boolean broadcastUpdates, boolean broadcastDeletes, boolean broadcastRelationships) {
            this._broadcastInserts = broadcastInserts;
            this._broadcastUpdates = broadcastUpdates;
            this._broadcastDeletes = broadcastDeletes;
            this._broadcastRelationships = broadcastRelationships;
        }

        public boolean broadcastInserts() {
            return this._broadcastInserts;
        }

        public boolean broadcastUpdates() {
            return this._broadcastUpdates;
        }

        public boolean broadcastDeletes() {
            return this._broadcastDeletes;
        }

        public boolean broadcastRelationships() {
            return this._broadcastRelationships;
        }
    }

    public static interface IChangeListener {
        public void addChange(Change var1);
    }

    public static class LocalChange
    extends Change {
        private NSMutableArray _localCacheChanges;
        private EOObjectStoreCoordinator _coordinator;
        private NSDictionary _inserted;
        private NSDictionary _updated;
        private NSDictionary _deleted;
        private NSDictionary _invalidated;
        private NSArray _deletedGIDs;
        private NSArray _updatedGIDs;
        private NSArray _insertedGIDs;
        private NSArray _invalidatedGIDs;
        private boolean _causedByRemoteUpdate;

        public LocalChange(EOObjectStoreCoordinator osc, NSDictionary userInfo, boolean causedByRemoteUpdate) {
            this._coordinator = osc;
            this._deletedGIDs = (NSArray)userInfo.objectForKey("deleted");
            this._updatedGIDs = (NSArray)userInfo.objectForKey("updated");
            this._insertedGIDs = (NSArray)userInfo.objectForKey("inserted");
            this._invalidatedGIDs = (NSArray)userInfo.objectForKey("invalidated");
            this._deleted = this.snapshotsGroupedByEntity(this._deletedGIDs, this._coordinator);
            this._updated = this.snapshotsGroupedByEntity(this._updatedGIDs, this._coordinator);
            this._inserted = this.snapshotsGroupedByEntity(this._insertedGIDs, this._coordinator);
            this._invalidated = this.snapshotsGroupedByEntity(this._invalidatedGIDs, this._coordinator);
            this._causedByRemoteUpdate = causedByRemoteUpdate;
            this._localCacheChanges = new NSMutableArray();
            if (!causedByRemoteUpdate) {
                Enumeration cosEnum = osc.cooperatingObjectStores().objectEnumerator();
                while (cosEnum.hasMoreElements()) {
                    EODatabaseContext dbc;
                    ERXDatabase db;
                    NSArray cacheChanges;
                    EOCooperatingObjectStore cos = (EOCooperatingObjectStore)cosEnum.nextElement();
                    if (!(cos instanceof ERXDatabaseContext) || (cacheChanges = ERXObjectStoreCoordinatorSynchronizer.dequeueCacheChanges(db = (ERXDatabase)(dbc = (EODatabaseContext)cos).database())) == null) continue;
                    this._localCacheChanges.addObjectsFromArray(cacheChanges);
                }
            }
        }

        public boolean causedByRemoteUpdate() {
            return this._causedByRemoteUpdate;
        }

        public NSArray localCacheChanges() {
            return this._localCacheChanges;
        }

        public NSArray deletedGIDs() {
            return this._deletedGIDs;
        }

        public NSArray updatedGIDs() {
            return this._updatedGIDs;
        }

        public NSArray insertedGIDs() {
            return this._insertedGIDs;
        }

        public NSArray invalidatedGIDs() {
            return this._invalidatedGIDs;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected NSDictionary snapshotsGroupedByEntity(NSArray objects, EOObjectStoreCoordinator osc) {
            if (objects == null || objects.count() == 0) {
                return NSDictionary.EmptyDictionary;
            }
            NSMutableDictionary result = new NSMutableDictionary();
            NSMutableDictionary<String, EODatabaseContext> dbcs = new NSMutableDictionary<String, EODatabaseContext>();
            Enumeration gids = objects.objectEnumerator();
            while (gids.hasMoreElements()) {
                NSMutableArray<NSDictionary> snapshotsForEntity;
                EOGlobalID gid = (EOGlobalID)gids.nextElement();
                if (!(gid instanceof EOKeyGlobalID)) continue;
                EOKeyGlobalID globalID = (EOKeyGlobalID)gid;
                String entityName = globalID.entityName();
                String key = entityName + "/" + System.identityHashCode(osc);
                EODatabaseContext dbc = (EODatabaseContext)dbcs.objectForKey(key);
                if (dbc == null) {
                    dbc = ERXEOAccessUtilities.databaseContextForEntityNamed(osc, entityName);
                    dbcs.setObjectForKey(dbc, key);
                }
                if ((snapshotsForEntity = (NSMutableArray<NSDictionary>)result.objectForKey(entityName)) == null) {
                    snapshotsForEntity = new NSMutableArray<NSDictionary>();
                    result.setObjectForKey(snapshotsForEntity, entityName);
                }
                NSMutableArray<NSDictionary> nSMutableArray = snapshotsForEntity;
                synchronized (nSMutableArray) {
                    NSDictionary o = dbc.snapshotForGlobalID((EOGlobalID)globalID);
                    if (o != null) {
                        snapshotsForEntity.addObject(o);
                    }
                }
            }
            return result;
        }

        public NSDictionary updated() {
            return this._updated;
        }

        public NSDictionary deleted() {
            return this._deleted;
        }

        public NSDictionary inserted() {
            return this._inserted;
        }

        public NSDictionary invalidated() {
            return this._invalidated;
        }

        public EOObjectStoreCoordinator coordinator() {
            return this._coordinator;
        }
    }

    public static class RemoteChange
    extends Change {
        private NSMutableArray _remoteCacheChanges;
        private String _identifier;
        private int _transactionID;
        private int _transactionSize;
        private long _creationDate = System.currentTimeMillis();

        public RemoteChange(String identifier, int transactionID, int transactionSize) {
            this._remoteCacheChanges = new NSMutableArray();
            this._identifier = identifier;
            this._transactionID = transactionID;
            this._transactionSize = transactionSize;
        }

        public String identifier() {
            return this._identifier;
        }

        public NSArray remoteCacheChanges() {
            return this._remoteCacheChanges;
        }

        public void addRemoteCacheChange(ERXDatabase.CacheChange cacheChange) {
            this._remoteCacheChanges.addObject(cacheChange);
        }

        public boolean isComplete() {
            return this._remoteCacheChanges.count() <= this._transactionSize;
        }

        public long creationDate() {
            return this._creationDate;
        }
    }

    public static class Change {
    }

    private class ProcessChangesQueue
    implements Runnable,
    IChangeListener {
        private boolean _running;
        private int _transactionID;
        private List _elements = new LinkedList();
        private SnapshotProcessor _deleteProcessor = new DeleteSnapshotProcessor();
        private SnapshotProcessor _insertProcessor = new InsertSnapshotProcessor();
        private SnapshotProcessor _updateProcessor = new UpdateSnapshotProcessor();
        private SnapshotProcessor _invalidateProcessor = new InvalidateSnapshotProcessor();
        private CacheChangeProcessor _insertCacheChangeProcessor = new InsertCacheChangeProcessor();
        private CacheChangeProcessor _updateCacheChangeProcessor = new UpdateCacheChangeProcessor();
        private CacheChangeProcessor _deleteCacheChangeProcessor = new DeleteCacheChangeProcessor();
        private CacheChangeProcessor _toManyUpdateCacheChangeProcessor = new ToManyUpdateCacheChangeProcessor();

        protected ProcessChangesQueue() {
            Thread.currentThread().setName("ProcessChangesQueue");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addChange(Change changes) {
            List list = this._elements;
            synchronized (list) {
                this._elements.add(changes);
                this._elements.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void _process(EOObjectStoreCoordinator sender, EOObjectStoreCoordinator osc, NSMutableDictionary dbcs, SnapshotProcessor processor, NSDictionary changesByEntity, String userInfoKey) {
            SynchronizerSettings settings = ERXObjectStoreCoordinatorSynchronizer.this.settingsForCoordinator(osc);
            EOModelGroup modelGroup = EOModelGroup.modelGroupForObjectStoreCoordinator((EOObjectStoreCoordinator)sender);
            Enumeration entityNames = changesByEntity.allKeys().objectEnumerator();
            while (entityNames.hasMoreElements()) {
                Object var21_20;
                String entityName = (String)entityNames.nextElement();
                String key = entityName + "/" + System.identityHashCode(osc);
                EOEntity entity = modelGroup.entityNamed(entityName);
                NSArray snapshots = (NSArray)changesByEntity.objectForKey(entityName);
                EODatabaseContext dbc = (EODatabaseContext)dbcs.objectForKey(key);
                if (dbc == null) {
                    dbc = ERXEOAccessUtilities.databaseContextForEntityNamed(osc, entityName);
                    dbcs.setObjectForKey(dbc, key);
                }
                EODatabase database = dbc.database();
                NSMutableDictionary<EOGlobalID, NSDictionary> snapshotsByGlobalID = new NSMutableDictionary<EOGlobalID, NSDictionary>();
                Enumeration snapshotsEnumerator = snapshots.objectEnumerator();
                while (snapshotsEnumerator.hasMoreElements()) {
                    NSDictionary snapshot = (NSDictionary)snapshotsEnumerator.nextElement();
                    EOGlobalID globalID = entity.globalIDForRow(snapshot);
                    snapshotsByGlobalID.setObjectForKey(snapshot, globalID);
                }
                if (snapshotsByGlobalID.count() <= 0) continue;
                dbc.lock();
                try {
                    processor.processSnapshots(dbc, database, snapshotsByGlobalID, settings);
                    var21_20 = null;
                }
                catch (Throwable throwable) {
                    var21_20 = null;
                    dbc.unlock();
                    throw throwable;
                }
                dbc.unlock();
                {
                }
            }
        }

        protected void process(EOObjectStoreCoordinator sender, SnapshotProcessor processor, NSDictionary changesByEntity, String userInfoKey) {
            NSMutableDictionary dbcs = new NSMutableDictionary();
            Enumeration oscs = _synchronizer.coordinators();
            while (oscs.hasMoreElements()) {
                EOObjectStoreCoordinator osc = (EOObjectStoreCoordinator)oscs.nextElement();
                if (osc == sender) continue;
                this._process(sender, osc, dbcs, processor, changesByEntity, userInfoKey);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void processRemoteChange(RemoteChange remoteChange) {
            Enumeration oscs = _synchronizer.coordinators();
            while (oscs.hasMoreElements()) {
                EOObjectStoreCoordinator osc = (EOObjectStoreCoordinator)oscs.nextElement();
                Enumeration cacheChangeEnum = remoteChange.remoteCacheChanges().objectEnumerator();
                while (cacheChangeEnum.hasMoreElements()) {
                    Object var10_9;
                    ERXDatabase.CacheChange cacheChange = (ERXDatabase.CacheChange)cacheChangeEnum.nextElement();
                    EOKeyGlobalID gid = (EOKeyGlobalID)cacheChange.gid();
                    EODatabaseContext dbc = ERXEOAccessUtilities.databaseContextForEntityNamed(osc, gid.entityName());
                    EODatabase database = dbc.database();
                    dbc.lock();
                    try {
                        if (cacheChange instanceof ERXDatabase.SnapshotInserted) {
                            this._insertCacheChangeProcessor.processCacheChange(dbc, database, cacheChange);
                        } else if (cacheChange instanceof ERXDatabase.SnapshotUpdated) {
                            this._updateCacheChangeProcessor.processCacheChange(dbc, database, cacheChange);
                        } else if (cacheChange instanceof ERXDatabase.SnapshotDeleted) {
                            this._deleteCacheChangeProcessor.processCacheChange(dbc, database, cacheChange);
                        } else if (cacheChange instanceof ERXDatabase.ToManySnapshotUpdated) {
                            this._toManyUpdateCacheChangeProcessor.processCacheChange(dbc, database, cacheChange);
                        }
                        var10_9 = null;
                    }
                    catch (Throwable throwable) {
                        var10_9 = null;
                        dbc.unlock();
                        throw throwable;
                    }
                    dbc.unlock();
                    {
                    }
                }
            }
        }

        protected void publishRemoteChanges(int transactionID, LocalChange localChange) {
            if (ERXObjectStoreCoordinatorSynchronizer.this._remoteSynchronizer != null && !localChange.causedByRemoteUpdate()) {
                try {
                    NSArray cacheChanges = localChange.localCacheChanges();
                    if (cacheChanges != null && cacheChanges.count() > 0) {
                        ERXObjectStoreCoordinatorSynchronizer.this._remoteSynchronizer.writeCacheChanges(transactionID, cacheChanges);
                    }
                }
                catch (Throwable e) {
                    log.error((Object)("Failed to send remote changes: " + localChange + "."), e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this._running = true;
                while (this._running) {
                    Change changes = null;
                    List list = this._elements;
                    synchronized (list) {
                        try {
                            if (this._elements.isEmpty()) {
                                this._elements.wait();
                            }
                            if (!this._elements.isEmpty()) {
                                changes = (Change)this._elements.remove(0);
                            }
                        }
                        catch (InterruptedException e) {
                            if (this._running) {
                                log.warn((Object)("Interrupted: " + e), (Throwable)e);
                            }
                            this._running = false;
                        }
                    }
                    if (changes == null) continue;
                    if (changes instanceof LocalChange) {
                        LocalChange localChange = (LocalChange)changes;
                        EOObjectStoreCoordinator sender = localChange.coordinator();
                        this.process(sender, this._deleteProcessor, localChange.deleted(), "deleted");
                        this.process(sender, this._insertProcessor, localChange.inserted(), "inserted");
                        this.process(sender, this._updateProcessor, localChange.updated(), "updated");
                        this.process(sender, this._invalidateProcessor, localChange.invalidated(), "invalidated");
                        this.publishRemoteChanges(this._transactionID++, localChange);
                        continue;
                    }
                    if (!(changes instanceof RemoteChange)) continue;
                    this.processRemoteChange((RemoteChange)changes);
                }
            }
            catch (Throwable e) {
                log.error((Object)e, e);
            }
        }

        public void stop() {
            if (ERXObjectStoreCoordinatorSynchronizer.this._queueThread == null || !ERXObjectStoreCoordinatorSynchronizer.this._queueThread.isAlive()) {
                throw new IllegalStateException("Attempted to stop the " + this.getClass().getSimpleName() + " when it wasn't already running");
            }
            this._running = false;
            ERXObjectStoreCoordinatorSynchronizer.this._queueThread.interrupt();
        }

        private class ToManyUpdateCacheChangeProcessor
        extends CacheChangeProcessor {
            private ToManyUpdateCacheChangeProcessor() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void processCacheChange(EODatabaseContext dbc, EODatabase database, ERXDatabase.CacheChange cacheChange) {
                ERXDatabase.ToManySnapshotUpdated toManyUpdateChange = (ERXDatabase.ToManySnapshotUpdated)cacheChange;
                ERXObjectStoreCoordinatorSynchronizer.setProcessingRemoteNotifications(true);
                try {
                    EOGlobalID sourceGID = toManyUpdateChange.gid();
                    database.recordSnapshotForSourceGlobalID(null, sourceGID, toManyUpdateChange.name());
                    NSMutableDictionary<String, NSArray<EOGlobalID>> userInfo = new NSMutableDictionary<String, NSArray<EOGlobalID>>(new NSArray<EOGlobalID>(sourceGID), "updated");
                    userInfo.setObjectForKey((NSArray<EOGlobalID>)((Object)Boolean.TRUE), ERXObjectStoreCoordinatorSynchronizer.SYNCHRONIZER_KEY);
                    NSNotificationCenter.defaultCenter().postNotification("EOObjectsChangedInStoreNotification", (Object)dbc, userInfo);
                    Object var8_7 = null;
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    ERXObjectStoreCoordinatorSynchronizer.setProcessingRemoteNotifications(false);
                    throw throwable;
                }
                ERXObjectStoreCoordinatorSynchronizer.setProcessingRemoteNotifications(false);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("multicast insert: " + toManyUpdateChange));
                }
            }
        }

        private class InsertCacheChangeProcessor
        extends CacheChangeProcessor {
            private InsertCacheChangeProcessor() {
            }

            public void processCacheChange(EODatabaseContext dbc, EODatabase database, ERXDatabase.CacheChange cacheChange) {
                ERXDatabase.SnapshotInserted insertChange = (ERXDatabase.SnapshotInserted)cacheChange;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("multicast insert: " + insertChange));
                }
            }
        }

        private class UpdateCacheChangeProcessor
        extends CacheChangeProcessor {
            private UpdateCacheChangeProcessor() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void processCacheChange(EODatabaseContext dbc, EODatabase database, ERXDatabase.CacheChange cacheChange) {
                ERXDatabase.SnapshotUpdated updateChange = (ERXDatabase.SnapshotUpdated)cacheChange;
                EOGlobalID gid = updateChange.gid();
                NSDictionary snapshot = database.snapshotForGlobalID(gid);
                if (snapshot != null) {
                    ERXObjectStoreCoordinatorSynchronizer.setProcessingRemoteNotifications(true);
                    try {
                        EOEditingContext editingContext = ERXEC.newEditingContext();
                        editingContext.lock();
                        try {
                            ERXEOGlobalIDUtilities.fetchObjectsWithGlobalIDs(editingContext, new NSArray<EOGlobalID>(gid), true);
                            Object var9_8 = null;
                        }
                        catch (Throwable throwable) {
                            Object var9_9 = null;
                            editingContext.unlock();
                            throw throwable;
                        }
                        editingContext.unlock();
                        Object var11_11 = null;
                    }
                    catch (Throwable throwable) {
                        Object var11_12 = null;
                        ERXObjectStoreCoordinatorSynchronizer.setProcessingRemoteNotifications(false);
                        throw throwable;
                    }
                    ERXObjectStoreCoordinatorSynchronizer.setProcessingRemoteNotifications(false);
                    {
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("multicast update: " + updateChange));
                }
            }
        }

        private class DeleteCacheChangeProcessor
        extends CacheChangeProcessor {
            private DeleteCacheChangeProcessor() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void processCacheChange(EODatabaseContext dbc, EODatabase database, ERXDatabase.CacheChange cacheChange) {
                ERXDatabase.SnapshotDeleted deleteChange = (ERXDatabase.SnapshotDeleted)cacheChange;
                EOGlobalID gid = deleteChange.gid();
                ERXObjectStoreCoordinatorSynchronizer.setProcessingRemoteNotifications(true);
                try {
                    database.forgetSnapshotForGlobalID(gid);
                    Object var7_6 = null;
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    ERXObjectStoreCoordinatorSynchronizer.setProcessingRemoteNotifications(false);
                    throw throwable;
                }
                ERXObjectStoreCoordinatorSynchronizer.setProcessingRemoteNotifications(false);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("multicast delete: " + deleteChange));
                }
            }
        }

        private abstract class CacheChangeProcessor {
            private CacheChangeProcessor() {
            }

            public abstract void processCacheChange(EODatabaseContext var1, EODatabase var2, ERXDatabase.CacheChange var3);
        }

        private class InvalidateSnapshotProcessor
        extends SnapshotProcessor {
            private InvalidateSnapshotProcessor() {
            }

            public void processSnapshots(EODatabaseContext dbc, EODatabase database, NSDictionary snapshots, SynchronizerSettings settings) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("invalidate: " + snapshots));
                }
            }
        }

        private class InsertSnapshotProcessor
        extends RelationshipSnapshotProcessor {
            private InsertSnapshotProcessor() {
            }

            public void processGID(EODatabase database, EOGlobalID sourceGID, Object context, SynchronizerSettings settings) {
            }

            public void processRelationship(EODatabase database, EOGlobalID sourceGID, EORelationship sourceRelationship, EOGlobalID destGID, EORelationship inverseRelationship, Object context, SynchronizerSettings settings) {
                String inverseRelationshipName = inverseRelationship.name();
                NSArray inverseRelationshipGIDs = database.snapshotForSourceGlobalID(destGID, inverseRelationshipName);
                if (inverseRelationshipGIDs != null) {
                    database.recordSnapshotForSourceGlobalID(inverseRelationshipGIDs.arrayByAddingObject(sourceGID), destGID, inverseRelationshipName);
                }
            }

            public void processSnapshots(EODatabaseContext dbc, EODatabase database, NSDictionary snapshots, SynchronizerSettings settings) {
                NSArray gids = snapshots.allKeys();
                if (settings.broadcastInserts()) {
                    database.recordSnapshots(snapshots);
                }
                if (settings.broadcastRelationships()) {
                    this.processRelationships(database, gids, snapshots, null, settings);
                }
                if (settings.broadcastInserts() || settings.broadcastRelationships()) {
                    NSMutableDictionary<String, NSArray<String>> userInfo = new NSMutableDictionary<String, NSArray<String>>(gids, "inserted");
                    userInfo.setObjectForKey((NSArray<String>)((Object)Boolean.TRUE), ERXObjectStoreCoordinatorSynchronizer.SYNCHRONIZER_KEY);
                    NSNotificationCenter.defaultCenter().postNotification("EOObjectsChangedInStoreNotification", (Object)dbc, userInfo);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("insert: " + snapshots));
                    }
                }
            }
        }

        private class UpdateSnapshotProcessor
        extends SnapshotProcessor {
            private UpdateSnapshotProcessor() {
            }

            public void processSnapshots(EODatabaseContext dbc, EODatabase database, NSDictionary snapshots, SynchronizerSettings settings) {
                if (settings.broadcastUpdates()) {
                    NSArray gids = snapshots.allKeys();
                    database.recordSnapshots(snapshots);
                    NSMutableDictionary<String, NSArray<String>> userInfo = new NSMutableDictionary<String, NSArray<String>>(gids, "updated");
                    userInfo.setObjectForKey((NSArray<String>)((Object)Boolean.TRUE), ERXObjectStoreCoordinatorSynchronizer.SYNCHRONIZER_KEY);
                    NSNotificationCenter.defaultCenter().postNotification("EOObjectsChangedInStoreNotification", (Object)dbc, userInfo);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("update: " + snapshots));
                    }
                }
            }
        }

        private class DeleteSnapshotProcessor
        extends SnapshotProcessor {
            private DeleteSnapshotProcessor() {
            }

            public void processSnapshots(EODatabaseContext dbc, EODatabase database, NSDictionary snapshots, SynchronizerSettings settings) {
                if (settings.broadcastDeletes()) {
                    NSArray gids = snapshots.allKeys();
                    database.forgetSnapshotsForGlobalIDs(gids);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("forget: " + snapshots));
                    }
                }
            }
        }

        private abstract class RelationshipSnapshotProcessor
        extends SnapshotProcessor {
            private RelationshipSnapshotProcessor() {
            }

            public void processRelationships(EODatabase database, NSArray gids, NSDictionary snapshots, Object context, SynchronizerSettings settings) {
                Enumeration gidsEnum = gids.objectEnumerator();
                while (gidsEnum.hasMoreElements()) {
                    EOKeyGlobalID gid = (EOKeyGlobalID)gidsEnum.nextElement();
                    this.processGID(database, (EOGlobalID)gid, context, settings);
                    EOEntity entity = database.entityNamed(gid.entityName());
                    NSDictionary snapshot = (NSDictionary)snapshots.objectForKey(gid);
                    Enumeration relationshipsEnum = entity.relationships().objectEnumerator();
                    while (relationshipsEnum.hasMoreElements()) {
                        NSMutableDictionary destPK;
                        EOEntity destEntity;
                        EOGlobalID destGID;
                        EORelationship inverseRelationship;
                        EORelationship relationship = (EORelationship)relationshipsEnum.nextElement();
                        if (relationship.isToMany() || (inverseRelationship = relationship.inverseRelationship()) == null || !inverseRelationship.isToMany() || (destGID = (destEntity = inverseRelationship.entity()).globalIDForRow((NSDictionary)(destPK = relationship._foreignKeyForSourceRow(snapshot)))) == null) continue;
                        this.processRelationship(database, (EOGlobalID)gid, relationship, destGID, inverseRelationship, context, settings);
                    }
                }
            }

            public abstract void processGID(EODatabase var1, EOGlobalID var2, Object var3, SynchronizerSettings var4);

            public abstract void processRelationship(EODatabase var1, EOGlobalID var2, EORelationship var3, EOGlobalID var4, EORelationship var5, Object var6, SynchronizerSettings var7);
        }

        private abstract class SnapshotProcessor {
            private SnapshotProcessor() {
            }

            public abstract void processSnapshots(EODatabaseContext var1, EODatabase var2, NSDictionary var3, SynchronizerSettings var4);
        }
    }
}

