/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.formatters;

import com.webobjects.foundation.NSNumberFormatter;
import er.extensions.foundation.ERXProperties;
import er.extensions.localization.ERXLocalizer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParseException;
import java.util.Hashtable;

public class ERXNumberFormatter
extends NSNumberFormatter {
    private static Hashtable _repository = new Hashtable();
    protected static final String DefaultKey = "ERXNumberFormatter.DefaultKey";
    private String _ignoredChars = ERXProperties.stringForKeyWithDefault("er.extensions.ERXNumberFormatter.ignoredChars", "%$");
    private Integer _scale;
    private BigDecimal _factor;
    private String _operator;

    public static NSNumberFormatter sharedInstance() {
        return ERXNumberFormatter.numberFormatterForPattern(DefaultKey);
    }

    public static Format defaultNumberFormatterForObject(Object object) {
        NSNumberFormatter result = null;
        if (object != null && !(object instanceof String)) {
            if (object instanceof Double || object instanceof BigDecimal || object instanceof Float) {
                result = ERXNumberFormatter.numberFormatterForPattern("#,##0.00;-(#,##0.00)");
            } else if (object instanceof Number) {
                result = ERXNumberFormatter.numberFormatterForPattern("0");
            }
        }
        return result;
    }

    public static NSNumberFormatter numberFormatterForPattern(String pattern) {
        NSNumberFormatter formatter;
        if (ERXLocalizer.useLocalizedFormatters()) {
            ERXLocalizer localizer = ERXLocalizer.currentLocalizer();
            formatter = (NSNumberFormatter)localizer.localizedNumberFormatForKey(pattern);
        } else {
            formatter = (NSNumberFormatter)_repository.get(pattern);
            if (formatter == null) {
                formatter = new ERXNumberFormatter(pattern);
                _repository.put(pattern, formatter);
            }
        }
        return formatter;
    }

    public static void setNumberFormatterForPattern(NSNumberFormatter formatter, String pattern) {
        if (ERXLocalizer.useLocalizedFormatters()) {
            ERXLocalizer localizer = ERXLocalizer.currentLocalizer();
            localizer.setLocalizedNumberFormatForKey((Format)formatter, pattern);
        } else if (formatter == null) {
            _repository.remove(pattern);
        } else {
            _repository.put(pattern, formatter);
        }
    }

    public ERXNumberFormatter(String pattern) {
        super(pattern);
    }

    public ERXNumberFormatter() {
    }

    public void setIgnoredChars(String value) {
        this._ignoredChars = value;
    }

    protected void setFactor(BigDecimal value) {
        this._factor = value;
    }

    protected void setOperator(String value) {
        this._operator = value;
    }

    protected void setScale(Integer value) {
        this._scale = value;
    }

    public void setPattern(String pattern) {
        int offset;
        int n = offset = pattern == null ? -1 : pattern.indexOf("=)");
        if (offset != -1) {
            try {
                String factorString = pattern.substring(2, offset);
                int scaleOffset = factorString.indexOf(";");
                if (scaleOffset >= 0) {
                    String scaleString = factorString.substring(scaleOffset + 1);
                    Integer scale = new Integer(scaleString);
                    this.setScale(scale);
                    factorString = factorString.substring(0, scaleOffset);
                }
                this.setFactor(new BigDecimal(factorString));
                this.setOperator(pattern.substring(1, 2));
                pattern = pattern.substring(offset + 2);
            }
            catch (NumberFormatException e1) {
                throw new IllegalArgumentException("ERXNumberFormatter must have a pattern like '(*1024=)#,##0.00', where 1024 is the factor.");
            }
            catch (IndexOutOfBoundsException e) {
                throw new IllegalArgumentException("ERXNumberFormatter must have a pattern like '(*1024=)#,##0.00', where 1024 is the factor.");
            }
        } else {
            this.setFactor(null);
            this.setOperator(null);
        }
        super.setPattern(pattern);
    }

    protected BigDecimal performFormat(BigDecimal value) {
        if ("*".equals(this._operator)) {
            value = value.multiply(this._factor);
        } else if ("/".equals(this._operator)) {
            int scale = this._scale == null ? value.scale() : this._scale.intValue();
            value = value.divide(this._factor, scale, 6);
        }
        return value;
    }

    protected BigDecimal performParse(BigDecimal value) {
        if ("*".equals(this._operator)) {
            int scale = this._scale == null ? value.scale() : this._scale.intValue();
            value = value.divide(this._factor, scale, 6);
        } else if ("/".equals(this._operator)) {
            value = value.multiply(this._factor);
        }
        return value;
    }

    public Object parseObject(String aString) throws ParseException {
        char[] chars = aString.toCharArray();
        char[] filteredChars = new char[chars.length];
        int count = 0;
        for (int i = 0; i < chars.length; ++i) {
            if (this._ignoredChars.indexOf(chars[i]) >= 0) continue;
            filteredChars[count++] = chars[i];
        }
        String filteredString = new String(filteredChars, 0, count);
        Object result = super.parseObject(filteredString);
        if (result instanceof Number && this._operator != null) {
            BigDecimal newValue = null;
            newValue = result instanceof BigDecimal ? (BigDecimal)result : new BigDecimal(((Number)result).doubleValue());
            newValue = this.performParse(newValue);
            result = result instanceof BigInteger && !(result instanceof BigDecimal) ? new BigInteger("" + newValue.intValue()) : newValue;
        }
        return result;
    }

    public StringBuffer format(Object value, StringBuffer buffer, FieldPosition position) {
        if (value instanceof Number && this._operator != null) {
            BigDecimal newValue = null;
            newValue = value instanceof BigDecimal ? (BigDecimal)value : new BigDecimal(((Number)value).doubleValue());
            if (newValue.scale() == 0) {
                newValue = newValue.setScale(4);
            }
            newValue = this.performFormat(newValue);
            value = newValue;
        }
        return super.format(value, buffer, position);
    }

    static {
        _repository.put(DefaultKey, new ERXNumberFormatter());
    }
}

