/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.formatters;

import er.extensions.foundation.ERXStringUtilities;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import org.apache.log4j.Logger;

public class ERXSimpleHTMLFormatter
extends Format {
    public static final Logger log = Logger.getLogger(ERXSimpleHTMLFormatter.class);
    private static final String HTMLReturn = "<br />";
    private static final String ASCIIReturn = "\n";
    private static final String ASCIITab = "\t";
    private static ERXSimpleHTMLFormatter _formatter;
    private static String _HTMLTab;

    protected static String HTMLTab() {
        if (_HTMLTab == null) {
            _HTMLTab = "<spacer width=\"50\" />";
        }
        return _HTMLTab;
    }

    public static ERXSimpleHTMLFormatter formatter() {
        if (_formatter == null) {
            _formatter = new ERXSimpleHTMLFormatter();
        }
        return _formatter;
    }

    public String htmlStringFromString(String aString) {
        String returnString = "";
        try {
            returnString = ERXSimpleHTMLFormatter.formatter().format(aString);
        }
        catch (IllegalArgumentException e) {
            returnString = aString;
        }
        return returnString;
    }

    public StringBuffer format(Object object, StringBuffer buffer, FieldPosition fp) {
        return buffer.append(this.applyFormat(object));
    }

    public String applyFormat(Object anObject) throws IllegalArgumentException {
        if (anObject == null || !(anObject instanceof String)) {
            return null;
        }
        String newString = ERXStringUtilities.replaceStringByStringInString(ASCIITab, ERXSimpleHTMLFormatter.HTMLTab(), (String)anObject);
        return ERXStringUtilities.replaceStringByStringInString(ASCIIReturn, HTMLReturn, newString);
    }

    public Object parseObject(String inString) throws ParseException {
        if (inString == null) {
            return null;
        }
        String newString = ERXStringUtilities.replaceStringByStringInString(HTMLReturn, ASCIIReturn, inString);
        return ERXStringUtilities.replaceStringByStringInString(ERXSimpleHTMLFormatter.HTMLTab(), ASCIITab, newString);
    }

    public Object parseObject(String string, ParsePosition p) {
        String result;
        int index = p.getIndex();
        String substring = string.substring(index);
        try {
            result = (String)this.parseObject(substring);
            p.setIndex(string.length() + 1);
        }
        catch (ParseException e) {
            result = null;
        }
        return result;
    }

    public String stringForObjectValue(Object anObject) throws IllegalArgumentException {
        return this.applyFormat(anObject);
    }
}

